/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.commands;

import io.fabric8.patch.BundleUpdate;
import io.fabric8.patch.Patch;
import io.fabric8.patch.Result;
import io.fabric8.patch.Service;
import org.apache.karaf.shell.console.AbstractAction;

public abstract class PatchActionSupport
extends AbstractAction {
    protected Service service;

    protected PatchActionSupport(Service service) {
        this.service = service;
    }

    protected Object doExecute() throws Exception {
        this.doExecute(this.service);
        return null;
    }

    protected abstract void doExecute(Service var1) throws Exception;

    protected void display(Result result) {
        System.out.println(String.format("%-40s %-10s %-10s", "[name]", "[old]", "[new]"));
        for (BundleUpdate update : result.getUpdates()) {
            System.out.println(String.format("%-40s %-10s %-10s", update.getSymbolicName(), update.getPreviousVersion(), update.getNewVersion()));
        }
    }

    protected void display(Iterable<Patch> patches, boolean listBundles) {
        System.out.println(String.format("%-40s %-10s %s", "[name]", "[installed]", "[description]"));
        for (Patch patch : patches) {
            String desc = patch.getDescription() != null ? patch.getDescription() : "";
            System.out.println(String.format("%-40s %-10s %s", patch.getId(), patch.isInstalled(), desc));
            if (!listBundles) continue;
            for (String b : patch.getBundles()) {
                System.out.println(String.format("\t%s", b));
            }
        }
    }
}

