/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.FeatureGateTests;
import io.fabric8.openshift.api.model.config.v1.TestDetails;
import io.fabric8.openshift.api.model.config.v1.TestDetailsBuilder;
import io.fabric8.openshift.api.model.config.v1.TestDetailsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class FeatureGateTestsFluent<A extends FeatureGateTestsFluent<A>>
extends BaseFluent<A> {
    private String featureGate;
    private ArrayList<TestDetailsBuilder> tests = new ArrayList();
    private Map<String, Object> additionalProperties;

    public FeatureGateTestsFluent() {
    }

    public FeatureGateTestsFluent(FeatureGateTests instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(FeatureGateTests instance) {
        FeatureGateTests featureGateTests = instance = instance != null ? instance : new FeatureGateTests();
        if (instance != null) {
            this.withFeatureGate(instance.getFeatureGate());
            this.withTests(instance.getTests());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getFeatureGate() {
        return this.featureGate;
    }

    public A withFeatureGate(String featureGate) {
        this.featureGate = featureGate;
        return (A)((Object)this);
    }

    public boolean hasFeatureGate() {
        return this.featureGate != null;
    }

    public A addToTests(int index, TestDetails item) {
        if (this.tests == null) {
            this.tests = new ArrayList();
        }
        TestDetailsBuilder builder = new TestDetailsBuilder(item);
        if (index < 0 || index >= this.tests.size()) {
            this._visitables.get((Object)"tests").add(builder);
            this.tests.add(builder);
        } else {
            this._visitables.get((Object)"tests").add(builder);
            this.tests.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToTests(int index, TestDetails item) {
        if (this.tests == null) {
            this.tests = new ArrayList();
        }
        TestDetailsBuilder builder = new TestDetailsBuilder(item);
        if (index < 0 || index >= this.tests.size()) {
            this._visitables.get((Object)"tests").add(builder);
            this.tests.add(builder);
        } else {
            this._visitables.get((Object)"tests").add(builder);
            this.tests.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToTests(TestDetails ... items) {
        if (this.tests == null) {
            this.tests = new ArrayList();
        }
        for (TestDetails item : items) {
            TestDetailsBuilder builder = new TestDetailsBuilder(item);
            this._visitables.get((Object)"tests").add(builder);
            this.tests.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToTests(Collection<TestDetails> items) {
        if (this.tests == null) {
            this.tests = new ArrayList();
        }
        for (TestDetails item : items) {
            TestDetailsBuilder builder = new TestDetailsBuilder(item);
            this._visitables.get((Object)"tests").add(builder);
            this.tests.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromTests(TestDetails ... items) {
        if (this.tests == null) {
            return (A)((Object)this);
        }
        for (TestDetails item : items) {
            TestDetailsBuilder builder = new TestDetailsBuilder(item);
            this._visitables.get((Object)"tests").remove((Object)builder);
            this.tests.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTests(Collection<TestDetails> items) {
        if (this.tests == null) {
            return (A)((Object)this);
        }
        for (TestDetails item : items) {
            TestDetailsBuilder builder = new TestDetailsBuilder(item);
            this._visitables.get((Object)"tests").remove((Object)builder);
            this.tests.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTests(Predicate<TestDetailsBuilder> predicate) {
        if (this.tests == null) {
            return (A)((Object)this);
        }
        Iterator<TestDetailsBuilder> each = this.tests.iterator();
        List visitables = this._visitables.get((Object)"tests");
        while (each.hasNext()) {
            TestDetailsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<TestDetails> buildTests() {
        return this.tests != null ? FeatureGateTestsFluent.build(this.tests) : null;
    }

    public TestDetails buildTest(int index) {
        return this.tests.get(index).build();
    }

    public TestDetails buildFirstTest() {
        return this.tests.get(0).build();
    }

    public TestDetails buildLastTest() {
        return this.tests.get(this.tests.size() - 1).build();
    }

    public TestDetails buildMatchingTest(Predicate<TestDetailsBuilder> predicate) {
        for (TestDetailsBuilder item : this.tests) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTest(Predicate<TestDetailsBuilder> predicate) {
        for (TestDetailsBuilder item : this.tests) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTests(List<TestDetails> tests) {
        if (this.tests != null) {
            this._visitables.get((Object)"tests").clear();
        }
        if (tests != null) {
            this.tests = new ArrayList();
            for (TestDetails item : tests) {
                this.addToTests(item);
            }
        } else {
            this.tests = null;
        }
        return (A)((Object)this);
    }

    public A withTests(TestDetails ... tests) {
        if (this.tests != null) {
            this.tests.clear();
            this._visitables.remove((Object)"tests");
        }
        if (tests != null) {
            for (TestDetails item : tests) {
                this.addToTests(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTests() {
        return this.tests != null && !this.tests.isEmpty();
    }

    public A addNewTest(String testName) {
        return this.addToTests(new TestDetails(testName));
    }

    public TestsNested<A> addNewTest() {
        return new TestsNested(-1, null);
    }

    public TestsNested<A> addNewTestLike(TestDetails item) {
        return new TestsNested(-1, item);
    }

    public TestsNested<A> setNewTestLike(int index, TestDetails item) {
        return new TestsNested(index, item);
    }

    public TestsNested<A> editTest(int index) {
        if (this.tests.size() <= index) {
            throw new RuntimeException("Can't edit tests. Index exceeds size.");
        }
        return this.setNewTestLike(index, this.buildTest(index));
    }

    public TestsNested<A> editFirstTest() {
        if (this.tests.size() == 0) {
            throw new RuntimeException("Can't edit first tests. The list is empty.");
        }
        return this.setNewTestLike(0, this.buildTest(0));
    }

    public TestsNested<A> editLastTest() {
        int index = this.tests.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tests. The list is empty.");
        }
        return this.setNewTestLike(index, this.buildTest(index));
    }

    public TestsNested<A> editMatchingTest(Predicate<TestDetailsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tests.size(); ++i) {
            if (!predicate.test(this.tests.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tests. No match found.");
        }
        return this.setNewTestLike(index, this.buildTest(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FeatureGateTestsFluent that = (FeatureGateTestsFluent)((Object)o);
        if (!Objects.equals(this.featureGate, that.featureGate)) {
            return false;
        }
        if (!Objects.equals(this.tests, that.tests)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.featureGate, this.tests, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.featureGate != null) {
            sb.append("featureGate:");
            sb.append(this.featureGate + ",");
        }
        if (this.tests != null && !this.tests.isEmpty()) {
            sb.append("tests:");
            sb.append(String.valueOf(this.tests) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TestsNested<N>
    extends TestDetailsFluent<TestsNested<N>>
    implements Nested<N> {
        TestDetailsBuilder builder;
        int index;

        TestsNested(int index, TestDetails item) {
            this.index = index;
            this.builder = new TestDetailsBuilder(this, item);
        }

        public N and() {
            return (N)FeatureGateTestsFluent.this.setToTests(this.index, this.builder.build());
        }

        public N endTest() {
            return this.and();
        }
    }
}

