/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.openshift.api.model.SecretSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SecretSpecFluent<A extends SecretSpecFluent<A>>
extends BaseFluent<A> {
    private String mountPath;
    private LocalObjectReferenceBuilder secretSource;
    private Map<String, Object> additionalProperties;

    public SecretSpecFluent() {
    }

    public SecretSpecFluent(SecretSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(SecretSpec instance) {
        SecretSpec secretSpec = instance = instance != null ? instance : new SecretSpec();
        if (instance != null) {
            this.withMountPath(instance.getMountPath());
            this.withSecretSource(instance.getSecretSource());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getMountPath() {
        return this.mountPath;
    }

    public A withMountPath(String mountPath) {
        this.mountPath = mountPath;
        return (A)((Object)this);
    }

    public boolean hasMountPath() {
        return this.mountPath != null;
    }

    public LocalObjectReference buildSecretSource() {
        return this.secretSource != null ? this.secretSource.build() : null;
    }

    public A withSecretSource(LocalObjectReference secretSource) {
        this._visitables.remove((Object)"secretSource");
        if (secretSource != null) {
            this.secretSource = new LocalObjectReferenceBuilder(secretSource);
            this._visitables.get((Object)"secretSource").add(this.secretSource);
        } else {
            this.secretSource = null;
            this._visitables.get((Object)"secretSource").remove(this.secretSource);
        }
        return (A)((Object)this);
    }

    public boolean hasSecretSource() {
        return this.secretSource != null;
    }

    public A withNewSecretSource(String name) {
        return this.withSecretSource(new LocalObjectReference(name));
    }

    public SecretSourceNested<A> withNewSecretSource() {
        return new SecretSourceNested(null);
    }

    public SecretSourceNested<A> withNewSecretSourceLike(LocalObjectReference item) {
        return new SecretSourceNested(item);
    }

    public SecretSourceNested<A> editSecretSource() {
        return this.withNewSecretSourceLike(Optional.ofNullable(this.buildSecretSource()).orElse(null));
    }

    public SecretSourceNested<A> editOrNewSecretSource() {
        return this.withNewSecretSourceLike(Optional.ofNullable(this.buildSecretSource()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public SecretSourceNested<A> editOrNewSecretSourceLike(LocalObjectReference item) {
        return this.withNewSecretSourceLike(Optional.ofNullable(this.buildSecretSource()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecretSpecFluent that = (SecretSpecFluent)((Object)o);
        if (!Objects.equals(this.mountPath, that.mountPath)) {
            return false;
        }
        if (!Objects.equals(this.secretSource, that.secretSource)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.mountPath, this.secretSource, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.mountPath != null) {
            sb.append("mountPath:");
            sb.append(this.mountPath + ",");
        }
        if (this.secretSource != null) {
            sb.append("secretSource:");
            sb.append(String.valueOf(this.secretSource) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SecretSourceNested<N>
    extends LocalObjectReferenceFluent<SecretSourceNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        SecretSourceNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)SecretSpecFluent.this.withSecretSource(this.builder.build());
        }

        public N endSecretSource() {
            return this.and();
        }
    }
}

