package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TemplateInstanceSpecBuilder extends TemplateInstanceSpecFluent<TemplateInstanceSpecBuilder> implements VisitableBuilder<TemplateInstanceSpec,TemplateInstanceSpecBuilder>{
  public TemplateInstanceSpecBuilder() {
    this(new TemplateInstanceSpec());
  }
  
  public TemplateInstanceSpecBuilder(TemplateInstanceSpecFluent<?> fluent) {
    this(fluent, new TemplateInstanceSpec());
  }
  
  public TemplateInstanceSpecBuilder(TemplateInstanceSpecFluent<?> fluent,TemplateInstanceSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TemplateInstanceSpecBuilder(TemplateInstanceSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TemplateInstanceSpecFluent<?> fluent;
  
  public TemplateInstanceSpec build() {
    TemplateInstanceSpec buildable = new TemplateInstanceSpec(fluent.buildRequester(),fluent.buildSecret(),fluent.buildTemplate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}