package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TagImportPolicyFluent<A extends TagImportPolicyFluent<A>> extends BaseFluent<A>{
  public TagImportPolicyFluent() {
  }
  
  public TagImportPolicyFluent(TagImportPolicy instance) {
    this.copyInstance(instance);
  }
  private String importMode;
  private Boolean insecure;
  private Boolean scheduled;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(TagImportPolicy instance) {
    instance = (instance != null ? instance : new TagImportPolicy());
    if (instance != null) {
          this.withImportMode(instance.getImportMode());
          this.withInsecure(instance.getInsecure());
          this.withScheduled(instance.getScheduled());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getImportMode() {
    return this.importMode;
  }
  
  public A withImportMode(String importMode) {
    this.importMode = importMode;
    return (A) this;
  }
  
  public boolean hasImportMode() {
    return this.importMode != null;
  }
  
  public Boolean getInsecure() {
    return this.insecure;
  }
  
  public A withInsecure(Boolean insecure) {
    this.insecure = insecure;
    return (A) this;
  }
  
  public boolean hasInsecure() {
    return this.insecure != null;
  }
  
  public Boolean getScheduled() {
    return this.scheduled;
  }
  
  public A withScheduled(Boolean scheduled) {
    this.scheduled = scheduled;
    return (A) this;
  }
  
  public boolean hasScheduled() {
    return this.scheduled != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TagImportPolicyFluent that = (TagImportPolicyFluent) o;
    if (!java.util.Objects.equals(importMode, that.importMode)) return false;
    if (!java.util.Objects.equals(insecure, that.insecure)) return false;
    if (!java.util.Objects.equals(scheduled, that.scheduled)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(importMode,  insecure,  scheduled,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (importMode != null) { sb.append("importMode:"); sb.append(importMode + ","); }
    if (insecure != null) { sb.append("insecure:"); sb.append(insecure + ","); }
    if (scheduled != null) { sb.append("scheduled:"); sb.append(scheduled + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withInsecure() {
    return withInsecure(true);
  }
  
  public A withScheduled() {
    return withScheduled(true);
  }
  

}