package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SecretSpecFluent<A extends SecretSpecFluent<A>> extends BaseFluent<A>{
  public SecretSpecFluent() {
  }
  
  public SecretSpecFluent(SecretSpec instance) {
    this.copyInstance(instance);
  }
  private String mountPath;
  private LocalObjectReferenceBuilder secretSource;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(SecretSpec instance) {
    instance = (instance != null ? instance : new SecretSpec());
    if (instance != null) {
          this.withMountPath(instance.getMountPath());
          this.withSecretSource(instance.getSecretSource());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getMountPath() {
    return this.mountPath;
  }
  
  public A withMountPath(String mountPath) {
    this.mountPath = mountPath;
    return (A) this;
  }
  
  public boolean hasMountPath() {
    return this.mountPath != null;
  }
  
  public LocalObjectReference buildSecretSource() {
    return this.secretSource != null ? this.secretSource.build() : null;
  }
  
  public A withSecretSource(LocalObjectReference secretSource) {
    this._visitables.remove("secretSource");
    if (secretSource != null) {
        this.secretSource = new LocalObjectReferenceBuilder(secretSource);
        this._visitables.get("secretSource").add(this.secretSource);
    } else {
        this.secretSource = null;
        this._visitables.get("secretSource").remove(this.secretSource);
    }
    return (A) this;
  }
  
  public boolean hasSecretSource() {
    return this.secretSource != null;
  }
  
  public A withNewSecretSource(String name) {
    return (A)withSecretSource(new LocalObjectReference(name));
  }
  
  public SecretSourceNested<A> withNewSecretSource() {
    return new SecretSourceNested(null);
  }
  
  public SecretSourceNested<A> withNewSecretSourceLike(LocalObjectReference item) {
    return new SecretSourceNested(item);
  }
  
  public SecretSourceNested<A> editSecretSource() {
    return withNewSecretSourceLike(java.util.Optional.ofNullable(buildSecretSource()).orElse(null));
  }
  
  public SecretSourceNested<A> editOrNewSecretSource() {
    return withNewSecretSourceLike(java.util.Optional.ofNullable(buildSecretSource()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  
  public SecretSourceNested<A> editOrNewSecretSourceLike(LocalObjectReference item) {
    return withNewSecretSourceLike(java.util.Optional.ofNullable(buildSecretSource()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SecretSpecFluent that = (SecretSpecFluent) o;
    if (!java.util.Objects.equals(mountPath, that.mountPath)) return false;
    if (!java.util.Objects.equals(secretSource, that.secretSource)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(mountPath,  secretSource,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (mountPath != null) { sb.append("mountPath:"); sb.append(mountPath + ","); }
    if (secretSource != null) { sb.append("secretSource:"); sb.append(secretSource + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class SecretSourceNested<N> extends LocalObjectReferenceFluent<SecretSourceNested<N>> implements Nested<N>{
    SecretSourceNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) SecretSpecFluent.this.withSecretSource(builder.build());
    }
    
    public N endSecretSource() {
      return and();
    }
    
  
  }

}