package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterRoleListBuilder extends ClusterRoleListFluent<ClusterRoleListBuilder> implements VisitableBuilder<ClusterRoleList,ClusterRoleListBuilder>{
  public ClusterRoleListBuilder() {
    this(new ClusterRoleList());
  }
  
  public ClusterRoleListBuilder(ClusterRoleListFluent<?> fluent) {
    this(fluent, new ClusterRoleList());
  }
  
  public ClusterRoleListBuilder(ClusterRoleListFluent<?> fluent,ClusterRoleList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterRoleListBuilder(ClusterRoleList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterRoleListFluent<?> fluent;
  
  public ClusterRoleList build() {
    ClusterRoleList buildable = new ClusterRoleList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}