package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceQuotaSpec;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClusterResourceQuotaSpecFluent<A extends ClusterResourceQuotaSpecFluent<A>> extends BaseFluent<A>{
  public ClusterResourceQuotaSpecFluent() {
  }
  
  public ClusterResourceQuotaSpecFluent(ClusterResourceQuotaSpec instance) {
    this.copyInstance(instance);
  }
  private ResourceQuotaSpec quota;
  private ClusterResourceQuotaSelectorBuilder selector;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ClusterResourceQuotaSpec instance) {
    instance = (instance != null ? instance : new ClusterResourceQuotaSpec());
    if (instance != null) {
          this.withQuota(instance.getQuota());
          this.withSelector(instance.getSelector());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ResourceQuotaSpec getQuota() {
    return this.quota;
  }
  
  public A withQuota(ResourceQuotaSpec quota) {
    this.quota = quota;
    return (A) this;
  }
  
  public boolean hasQuota() {
    return this.quota != null;
  }
  
  public ClusterResourceQuotaSelector buildSelector() {
    return this.selector != null ? this.selector.build() : null;
  }
  
  public A withSelector(ClusterResourceQuotaSelector selector) {
    this._visitables.remove("selector");
    if (selector != null) {
        this.selector = new ClusterResourceQuotaSelectorBuilder(selector);
        this._visitables.get("selector").add(this.selector);
    } else {
        this.selector = null;
        this._visitables.get("selector").remove(this.selector);
    }
    return (A) this;
  }
  
  public boolean hasSelector() {
    return this.selector != null;
  }
  
  public SelectorNested<A> withNewSelector() {
    return new SelectorNested(null);
  }
  
  public SelectorNested<A> withNewSelectorLike(ClusterResourceQuotaSelector item) {
    return new SelectorNested(item);
  }
  
  public SelectorNested<A> editSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(null));
  }
  
  public SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(new ClusterResourceQuotaSelectorBuilder().build()));
  }
  
  public SelectorNested<A> editOrNewSelectorLike(ClusterResourceQuotaSelector item) {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterResourceQuotaSpecFluent that = (ClusterResourceQuotaSpecFluent) o;
    if (!java.util.Objects.equals(quota, that.quota)) return false;
    if (!java.util.Objects.equals(selector, that.selector)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(quota,  selector,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (quota != null) { sb.append("quota:"); sb.append(quota + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class SelectorNested<N> extends ClusterResourceQuotaSelectorFluent<SelectorNested<N>> implements Nested<N>{
    SelectorNested(ClusterResourceQuotaSelector item) {
      this.builder = new ClusterResourceQuotaSelectorBuilder(this, item);
    }
    ClusterResourceQuotaSelectorBuilder builder;
    
    public N and() {
      return (N) ClusterResourceQuotaSpecFluent.this.withSelector(builder.build());
    }
    
    public N endSelector() {
      return and();
    }
    
  
  }

}