package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class WebHookTriggerFluentImpl<A extends WebHookTriggerFluent<A>> extends BaseFluent<A> implements WebHookTriggerFluent<A>{
  public WebHookTriggerFluentImpl() {
  }
  public WebHookTriggerFluentImpl(WebHookTrigger instance) {
    this.withAllowEnv(instance.getAllowEnv()); 
    this.withSecret(instance.getSecret()); 
    this.withSecretReference(instance.getSecretReference()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Boolean allowEnv;
  private String secret;
  private SecretLocalReferenceBuilder secretReference;
  private Map<String,Object> additionalProperties;
  public Boolean getAllowEnv() {
    return this.allowEnv;
  }
  public A withAllowEnv(Boolean allowEnv) {
    this.allowEnv=allowEnv; return (A) this;
  }
  public Boolean hasAllowEnv() {
    return this.allowEnv != null;
  }
  public String getSecret() {
    return this.secret;
  }
  public A withSecret(String secret) {
    this.secret=secret; return (A) this;
  }
  public Boolean hasSecret() {
    return this.secret != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSecretReference instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretLocalReference getSecretReference() {
    return this.secretReference!=null ?this.secretReference.build():null;
  }
  public SecretLocalReference buildSecretReference() {
    return this.secretReference!=null ?this.secretReference.build():null;
  }
  public A withSecretReference(SecretLocalReference secretReference) {
    _visitables.get("secretReference").remove(this.secretReference);
    if (secretReference!=null){ this.secretReference= new SecretLocalReferenceBuilder(secretReference); _visitables.get("secretReference").add(this.secretReference);} else { this.secretReference = null; _visitables.get("secretReference").remove(this.secretReference); } return (A) this;
  }
  public Boolean hasSecretReference() {
    return this.secretReference != null;
  }
  public A withNewSecretReference(String name) {
    return (A)withSecretReference(new SecretLocalReference(name));
  }
  public WebHookTriggerFluent.SecretReferenceNested<A> withNewSecretReference() {
    return new WebHookTriggerFluentImpl.SecretReferenceNestedImpl();
  }
  public WebHookTriggerFluent.SecretReferenceNested<A> withNewSecretReferenceLike(SecretLocalReference item) {
    return new WebHookTriggerFluentImpl.SecretReferenceNestedImpl(item);
  }
  public WebHookTriggerFluent.SecretReferenceNested<A> editSecretReference() {
    return withNewSecretReferenceLike(getSecretReference());
  }
  public WebHookTriggerFluent.SecretReferenceNested<A> editOrNewSecretReference() {
    return withNewSecretReferenceLike(getSecretReference() != null ? getSecretReference(): new SecretLocalReferenceBuilder().build());
  }
  public WebHookTriggerFluent.SecretReferenceNested<A> editOrNewSecretReferenceLike(SecretLocalReference item) {
    return withNewSecretReferenceLike(getSecretReference() != null ? getSecretReference(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebHookTriggerFluentImpl that = (WebHookTriggerFluentImpl) o;
    if (allowEnv != null ? !allowEnv.equals(that.allowEnv) :that.allowEnv != null) return false;
    if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
    if (secretReference != null ? !secretReference.equals(that.secretReference) :that.secretReference != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(allowEnv,  secret,  secretReference,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allowEnv != null) { sb.append("allowEnv:"); sb.append(allowEnv + ","); }
    if (secret != null) { sb.append("secret:"); sb.append(secret + ","); }
    if (secretReference != null) { sb.append("secretReference:"); sb.append(secretReference + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withAllowEnv() {
    return withAllowEnv(true);
  }
  class SecretReferenceNestedImpl<N> extends SecretLocalReferenceFluentImpl<WebHookTriggerFluent.SecretReferenceNested<N>> implements WebHookTriggerFluent.SecretReferenceNested<N>,Nested<N>{
    SecretReferenceNestedImpl(SecretLocalReference item) {
      this.builder = new SecretLocalReferenceBuilder(this, item);
    }
    SecretReferenceNestedImpl() {
      this.builder = new SecretLocalReferenceBuilder(this);
    }
    SecretLocalReferenceBuilder builder;
    public N and() {
      return (N) WebHookTriggerFluentImpl.this.withSecretReference(builder.build());
    }
    public N endSecretReference() {
      return and();
    }
    
  }
  
}