package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class UserRestrictionFluentImpl<A extends UserRestrictionFluent<A>> extends BaseFluent<A> implements UserRestrictionFluent<A>{
  public UserRestrictionFluentImpl() {
  }
  public UserRestrictionFluentImpl(UserRestriction instance) {
    this.withGroups(instance.getGroups()); 
    this.withLabels(instance.getLabels()); 
    this.withUsers(instance.getUsers()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> groups = new ArrayList<String>();
  private ArrayList<LabelSelectorBuilder> labels = new ArrayList<LabelSelectorBuilder>();
  private List<String> users = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public A addToGroups(Integer index,String item) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    this.groups.add(index, item);
    return (A)this;
  }
  public A setToGroups(Integer index,String item) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    this.groups.set(index, item); return (A)this;
  }
  public A addToGroups(java.lang.String... items) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    for (String item : items) {this.groups.add(item);} return (A)this;
  }
  public A addAllToGroups(Collection<String> items) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    for (String item : items) {this.groups.add(item);} return (A)this;
  }
  public A removeFromGroups(java.lang.String... items) {
    for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
  }
  public A removeAllFromGroups(Collection<String> items) {
    for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
  }
  public List<String> getGroups() {
    return this.groups;
  }
  public String getGroup(Integer index) {
    return this.groups.get(index);
  }
  public String getFirstGroup() {
    return this.groups.get(0);
  }
  public String getLastGroup() {
    return this.groups.get(groups.size() - 1);
  }
  public String getMatchingGroup(Predicate<String> predicate) {
    for (String item: groups) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingGroup(Predicate<String> predicate) {
    for (String item: groups) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGroups(List<String> groups) {
    if (groups != null) {this.groups = new ArrayList(); for (String item : groups){this.addToGroups(item);}} else { this.groups = null;} return (A) this;
  }
  public A withGroups(java.lang.String... groups) {
    if (this.groups != null) {this.groups.clear();}
    if (groups != null) {for (String item :groups){ this.addToGroups(item);}} return (A) this;
  }
  public Boolean hasGroups() {
    return groups != null && !groups.isEmpty();
  }
  public A addToLabels(Integer index,LabelSelector item) {
    if (this.labels == null) {this.labels = new ArrayList<LabelSelectorBuilder>();}
    LabelSelectorBuilder builder = new LabelSelectorBuilder(item);_visitables.get("labels").add(index >= 0 ? index : _visitables.get("labels").size(), builder);this.labels.add(index >= 0 ? index : labels.size(), builder); return (A)this;
  }
  public A setToLabels(Integer index,LabelSelector item) {
    if (this.labels == null) {this.labels = new ArrayList<LabelSelectorBuilder>();}
    LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
    if (index < 0 || index >= _visitables.get("labels").size()) { _visitables.get("labels").add(builder); } else { _visitables.get("labels").set(index, builder);}
    if (index < 0 || index >= labels.size()) { labels.add(builder); } else { labels.set(index, builder);}
     return (A)this;
  }
  public A addToLabels(io.fabric8.kubernetes.api.model.LabelSelector... items) {
    if (this.labels == null) {this.labels = new ArrayList<LabelSelectorBuilder>();}
    for (LabelSelector item : items) {LabelSelectorBuilder builder = new LabelSelectorBuilder(item);_visitables.get("labels").add(builder);this.labels.add(builder);} return (A)this;
  }
  public A addAllToLabels(Collection<LabelSelector> items) {
    if (this.labels == null) {this.labels = new ArrayList<LabelSelectorBuilder>();}
    for (LabelSelector item : items) {LabelSelectorBuilder builder = new LabelSelectorBuilder(item);_visitables.get("labels").add(builder);this.labels.add(builder);} return (A)this;
  }
  public A removeFromLabels(io.fabric8.kubernetes.api.model.LabelSelector... items) {
    for (LabelSelector item : items) {LabelSelectorBuilder builder = new LabelSelectorBuilder(item);_visitables.get("labels").remove(builder);if (this.labels != null) {this.labels.remove(builder);}} return (A)this;
  }
  public A removeAllFromLabels(Collection<LabelSelector> items) {
    for (LabelSelector item : items) {LabelSelectorBuilder builder = new LabelSelectorBuilder(item);_visitables.get("labels").remove(builder);if (this.labels != null) {this.labels.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromLabels(Predicate<LabelSelectorBuilder> predicate) {
    if (labels == null) return (A) this;
    final Iterator<LabelSelectorBuilder> each = labels.iterator();
    final List visitables = _visitables.get("labels");
    while (each.hasNext()) {
      LabelSelectorBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildLabels instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<LabelSelector> getLabels() {
    return labels != null ? build(labels) : null;
  }
  public List<LabelSelector> buildLabels() {
    return labels != null ? build(labels) : null;
  }
  public LabelSelector buildLabel(Integer index) {
    return this.labels.get(index).build();
  }
  public LabelSelector buildFirstLabel() {
    return this.labels.get(0).build();
  }
  public LabelSelector buildLastLabel() {
    return this.labels.get(labels.size() - 1).build();
  }
  public LabelSelector buildMatchingLabel(Predicate<LabelSelectorBuilder> predicate) {
    for (LabelSelectorBuilder item: labels) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingLabel(Predicate<LabelSelectorBuilder> predicate) {
    for (LabelSelectorBuilder item: labels) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withLabels(List<LabelSelector> labels) {
    if (this.labels != null) { _visitables.get("labels").removeAll(this.labels);}
    if (labels != null) {this.labels = new ArrayList(); for (LabelSelector item : labels){this.addToLabels(item);}} else { this.labels = null;} return (A) this;
  }
  public A withLabels(io.fabric8.kubernetes.api.model.LabelSelector... labels) {
    if (this.labels != null) {this.labels.clear();}
    if (labels != null) {for (LabelSelector item :labels){ this.addToLabels(item);}} return (A) this;
  }
  public Boolean hasLabels() {
    return labels != null && !labels.isEmpty();
  }
  public UserRestrictionFluent.LabelsNested<A> addNewLabel() {
    return new UserRestrictionFluentImpl.LabelsNestedImpl();
  }
  public UserRestrictionFluent.LabelsNested<A> addNewLabelLike(LabelSelector item) {
    return new UserRestrictionFluentImpl.LabelsNestedImpl(-1, item);
  }
  public UserRestrictionFluent.LabelsNested<A> setNewLabelLike(Integer index,LabelSelector item) {
    return new UserRestrictionFluentImpl.LabelsNestedImpl(index, item);
  }
  public UserRestrictionFluent.LabelsNested<A> editLabel(Integer index) {
    if (labels.size() <= index) throw new RuntimeException("Can't edit labels. Index exceeds size.");
    return setNewLabelLike(index, buildLabel(index));
  }
  public UserRestrictionFluent.LabelsNested<A> editFirstLabel() {
    if (labels.size() == 0) throw new RuntimeException("Can't edit first labels. The list is empty.");
    return setNewLabelLike(0, buildLabel(0));
  }
  public UserRestrictionFluent.LabelsNested<A> editLastLabel() {
    int index = labels.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last labels. The list is empty.");
    return setNewLabelLike(index, buildLabel(index));
  }
  public UserRestrictionFluent.LabelsNested<A> editMatchingLabel(Predicate<LabelSelectorBuilder> predicate) {
    int index = -1;
    for (int i=0;i<labels.size();i++) { 
    if (predicate.test(labels.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching labels. No match found.");
    return setNewLabelLike(index, buildLabel(index));
  }
  public A addToUsers(Integer index,String item) {
    if (this.users == null) {this.users = new ArrayList<String>();}
    this.users.add(index, item);
    return (A)this;
  }
  public A setToUsers(Integer index,String item) {
    if (this.users == null) {this.users = new ArrayList<String>();}
    this.users.set(index, item); return (A)this;
  }
  public A addToUsers(java.lang.String... items) {
    if (this.users == null) {this.users = new ArrayList<String>();}
    for (String item : items) {this.users.add(item);} return (A)this;
  }
  public A addAllToUsers(Collection<String> items) {
    if (this.users == null) {this.users = new ArrayList<String>();}
    for (String item : items) {this.users.add(item);} return (A)this;
  }
  public A removeFromUsers(java.lang.String... items) {
    for (String item : items) {if (this.users!= null){ this.users.remove(item);}} return (A)this;
  }
  public A removeAllFromUsers(Collection<String> items) {
    for (String item : items) {if (this.users!= null){ this.users.remove(item);}} return (A)this;
  }
  public List<String> getUsers() {
    return this.users;
  }
  public String getUser(Integer index) {
    return this.users.get(index);
  }
  public String getFirstUser() {
    return this.users.get(0);
  }
  public String getLastUser() {
    return this.users.get(users.size() - 1);
  }
  public String getMatchingUser(Predicate<String> predicate) {
    for (String item: users) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingUser(Predicate<String> predicate) {
    for (String item: users) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withUsers(List<String> users) {
    if (users != null) {this.users = new ArrayList(); for (String item : users){this.addToUsers(item);}} else { this.users = null;} return (A) this;
  }
  public A withUsers(java.lang.String... users) {
    if (this.users != null) {this.users.clear();}
    if (users != null) {for (String item :users){ this.addToUsers(item);}} return (A) this;
  }
  public Boolean hasUsers() {
    return users != null && !users.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    UserRestrictionFluentImpl that = (UserRestrictionFluentImpl) o;
    if (groups != null ? !groups.equals(that.groups) :that.groups != null) return false;
    if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
    if (users != null ? !users.equals(that.users) :that.users != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(groups,  labels,  users,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (groups != null && !groups.isEmpty()) { sb.append("groups:"); sb.append(groups + ","); }
    if (labels != null && !labels.isEmpty()) { sb.append("labels:"); sb.append(labels + ","); }
    if (users != null && !users.isEmpty()) { sb.append("users:"); sb.append(users + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class LabelsNestedImpl<N> extends LabelSelectorFluentImpl<UserRestrictionFluent.LabelsNested<N>> implements UserRestrictionFluent.LabelsNested<N>,Nested<N>{
    LabelsNestedImpl(Integer index,LabelSelector item) {
      this.index = index;
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelsNestedImpl() {
      this.index = -1;
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    Integer index;
    public N and() {
      return (N) UserRestrictionFluentImpl.this.setToLabels(index,builder.build());
    }
    public N endLabel() {
      return and();
    }
    
  }
  
}