package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface UserFluent<A extends UserFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getFullName();
  public A withFullName(String fullName);
  public Boolean hasFullName();
  public A addToGroups(Integer index,String item);
  public A setToGroups(Integer index,String item);
  public A addToGroups(java.lang.String... items);
  public A addAllToGroups(Collection<String> items);
  public A removeFromGroups(java.lang.String... items);
  public A removeAllFromGroups(Collection<String> items);
  public List<String> getGroups();
  public String getGroup(Integer index);
  public String getFirstGroup();
  public String getLastGroup();
  public String getMatchingGroup(Predicate<String> predicate);
  public Boolean hasMatchingGroup(Predicate<String> predicate);
  public A withGroups(List<String> groups);
  public A withGroups(java.lang.String... groups);
  public Boolean hasGroups();
  public A addToIdentities(Integer index,String item);
  public A setToIdentities(Integer index,String item);
  public A addToIdentities(java.lang.String... items);
  public A addAllToIdentities(Collection<String> items);
  public A removeFromIdentities(java.lang.String... items);
  public A removeAllFromIdentities(Collection<String> items);
  public List<String> getIdentities();
  public String getIdentity(Integer index);
  public String getFirstIdentity();
  public String getLastIdentity();
  public String getMatchingIdentity(Predicate<String> predicate);
  public Boolean hasMatchingIdentity(Predicate<String> predicate);
  public A withIdentities(List<String> identities);
  public A withIdentities(java.lang.String... identities);
  public Boolean hasIdentities();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public UserFluent.MetadataNested<A> withNewMetadata();
  public UserFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public UserFluent.MetadataNested<A> editMetadata();
  public UserFluent.MetadataNested<A> editOrNewMetadata();
  public UserFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<UserFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  
}