package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.lang.Object;
import java.util.Map;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Iterator;
import java.lang.Integer;

 /**
  * Generated
  */
public interface TemplateFluent<A extends TemplateFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  public A addToLabels(String key,String value);
  public A addToLabels(Map<String,String> map);
  public A removeFromLabels(String key);
  public A removeFromLabels(Map<String,String> map);
  public Map<String,String> getLabels();
  public <K,V>A withLabels(Map<String,String> labels);
  public Boolean hasLabels();
  public String getMessage();
  public A withMessage(String message);
  public Boolean hasMessage();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public TemplateFluent.MetadataNested<A> withNewMetadata();
  public TemplateFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public TemplateFluent.MetadataNested<A> editMetadata();
  public TemplateFluent.MetadataNested<A> editOrNewMetadata();
  public TemplateFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  public A addToObjects(VisitableBuilder<? extends HasMetadata,?> builder);
  public A addToObjects(Integer index,VisitableBuilder<? extends HasMetadata,?> builder);
  public A addToObjects(Integer index,HasMetadata item);
  public A setToObjects(Integer index,HasMetadata item);
  public A addToObjects(io.fabric8.kubernetes.api.model.HasMetadata... items);
  public A addAllToObjects(Collection<HasMetadata> items);
  public A removeFromObjects(VisitableBuilder<? extends HasMetadata,?> builder);
  public A removeFromObjects(io.fabric8.kubernetes.api.model.HasMetadata... items);
  public A removeAllFromObjects(Collection<HasMetadata> items);
  
  /**
   * This method has been deprecated, please use method buildObjects instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<HasMetadata> getObjects();
  public List<HasMetadata> buildObjects();
  public HasMetadata buildObject(Integer index);
  public HasMetadata buildFirstObject();
  public HasMetadata buildLastObject();
  public HasMetadata buildMatchingObject(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public Boolean hasMatchingObject(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public A withObjects(List<HasMetadata> objects);
  public A withObjects(io.fabric8.kubernetes.api.model.HasMetadata... objects);
  public Boolean hasObjects();
  public A addToImageStreamImportObjects(Integer index,ImageStreamImport item);
  public A setToImageStreamImportObjects(Integer index,ImageStreamImport item);
  public A addToImageStreamImportObjects(io.fabric8.openshift.api.model.ImageStreamImport... items);
  public A addAllToImageStreamImportObjects(Collection<ImageStreamImport> items);
  public A removeFromImageStreamImportObjects(io.fabric8.openshift.api.model.ImageStreamImport... items);
  public A removeAllFromImageStreamImportObjects(Collection<ImageStreamImport> items);
  public A removeMatchingFromImageStreamImportObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.ImageStreamImportObjectsNested<A> setNewImageStreamImportObjectLike(Integer index,ImageStreamImport item);
  public TemplateFluent.ImageStreamImportObjectsNested<A> addNewImageStreamImportObject();
  public TemplateFluent.ImageStreamImportObjectsNested<A> addNewImageStreamImportObjectLike(ImageStreamImport item);
  public A addToProjectObjects(Integer index,Project item);
  public A setToProjectObjects(Integer index,Project item);
  public A addToProjectObjects(io.fabric8.openshift.api.model.Project... items);
  public A addAllToProjectObjects(Collection<Project> items);
  public A removeFromProjectObjects(io.fabric8.openshift.api.model.Project... items);
  public A removeAllFromProjectObjects(Collection<Project> items);
  public A removeMatchingFromProjectObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.ProjectObjectsNested<A> setNewProjectObjectLike(Integer index,Project item);
  public TemplateFluent.ProjectObjectsNested<A> addNewProjectObject();
  public TemplateFluent.ProjectObjectsNested<A> addNewProjectObjectLike(Project item);
  public A addToBuildConfigObjects(Integer index,BuildConfig item);
  public A setToBuildConfigObjects(Integer index,BuildConfig item);
  public A addToBuildConfigObjects(io.fabric8.openshift.api.model.BuildConfig... items);
  public A addAllToBuildConfigObjects(Collection<BuildConfig> items);
  public A removeFromBuildConfigObjects(io.fabric8.openshift.api.model.BuildConfig... items);
  public A removeAllFromBuildConfigObjects(Collection<BuildConfig> items);
  public A removeMatchingFromBuildConfigObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.BuildConfigObjectsNested<A> setNewBuildConfigObjectLike(Integer index,BuildConfig item);
  public TemplateFluent.BuildConfigObjectsNested<A> addNewBuildConfigObject();
  public TemplateFluent.BuildConfigObjectsNested<A> addNewBuildConfigObjectLike(BuildConfig item);
  public A addToHelmChartRepositoryObjects(Integer index,HelmChartRepository item);
  public A setToHelmChartRepositoryObjects(Integer index,HelmChartRepository item);
  public A addToHelmChartRepositoryObjects(io.fabric8.openshift.api.model.HelmChartRepository... items);
  public A addAllToHelmChartRepositoryObjects(Collection<HelmChartRepository> items);
  public A removeFromHelmChartRepositoryObjects(io.fabric8.openshift.api.model.HelmChartRepository... items);
  public A removeAllFromHelmChartRepositoryObjects(Collection<HelmChartRepository> items);
  public A removeMatchingFromHelmChartRepositoryObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.HelmChartRepositoryObjectsNested<A> setNewHelmChartRepositoryObjectLike(Integer index,HelmChartRepository item);
  public TemplateFluent.HelmChartRepositoryObjectsNested<A> addNewHelmChartRepositoryObject();
  public TemplateFluent.HelmChartRepositoryObjectsNested<A> addNewHelmChartRepositoryObjectLike(HelmChartRepository item);
  public A addToRangeAllocationObjects(Integer index,RangeAllocation item);
  public A setToRangeAllocationObjects(Integer index,RangeAllocation item);
  public A addToRangeAllocationObjects(io.fabric8.openshift.api.model.RangeAllocation... items);
  public A addAllToRangeAllocationObjects(Collection<RangeAllocation> items);
  public A removeFromRangeAllocationObjects(io.fabric8.openshift.api.model.RangeAllocation... items);
  public A removeAllFromRangeAllocationObjects(Collection<RangeAllocation> items);
  public A removeMatchingFromRangeAllocationObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.RangeAllocationObjectsNested<A> setNewRangeAllocationObjectLike(Integer index,RangeAllocation item);
  public TemplateFluent.RangeAllocationObjectsNested<A> addNewRangeAllocationObject();
  public TemplateFluent.RangeAllocationObjectsNested<A> addNewRangeAllocationObjectLike(RangeAllocation item);
  public A addToRouteObjects(Integer index,Route item);
  public A setToRouteObjects(Integer index,Route item);
  public A addToRouteObjects(io.fabric8.openshift.api.model.Route... items);
  public A addAllToRouteObjects(Collection<Route> items);
  public A removeFromRouteObjects(io.fabric8.openshift.api.model.Route... items);
  public A removeAllFromRouteObjects(Collection<Route> items);
  public A removeMatchingFromRouteObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.RouteObjectsNested<A> setNewRouteObjectLike(Integer index,Route item);
  public TemplateFluent.RouteObjectsNested<A> addNewRouteObject();
  public TemplateFluent.RouteObjectsNested<A> addNewRouteObjectLike(Route item);
  public A addToClusterNetworkObjects(Integer index,ClusterNetwork item);
  public A setToClusterNetworkObjects(Integer index,ClusterNetwork item);
  public A addToClusterNetworkObjects(io.fabric8.openshift.api.model.ClusterNetwork... items);
  public A addAllToClusterNetworkObjects(Collection<ClusterNetwork> items);
  public A removeFromClusterNetworkObjects(io.fabric8.openshift.api.model.ClusterNetwork... items);
  public A removeAllFromClusterNetworkObjects(Collection<ClusterNetwork> items);
  public A removeMatchingFromClusterNetworkObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.ClusterNetworkObjectsNested<A> setNewClusterNetworkObjectLike(Integer index,ClusterNetwork item);
  public TemplateFluent.ClusterNetworkObjectsNested<A> addNewClusterNetworkObject();
  public TemplateFluent.ClusterNetworkObjectsNested<A> addNewClusterNetworkObjectLike(ClusterNetwork item);
  public A addToOAuthAuthorizeTokenObjects(Integer index,OAuthAuthorizeToken item);
  public A setToOAuthAuthorizeTokenObjects(Integer index,OAuthAuthorizeToken item);
  public A addToOAuthAuthorizeTokenObjects(io.fabric8.openshift.api.model.OAuthAuthorizeToken... items);
  public A addAllToOAuthAuthorizeTokenObjects(Collection<OAuthAuthorizeToken> items);
  public A removeFromOAuthAuthorizeTokenObjects(io.fabric8.openshift.api.model.OAuthAuthorizeToken... items);
  public A removeAllFromOAuthAuthorizeTokenObjects(Collection<OAuthAuthorizeToken> items);
  public A removeMatchingFromOAuthAuthorizeTokenObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.OAuthAuthorizeTokenObjectsNested<A> setNewOAuthAuthorizeTokenObjectLike(Integer index,OAuthAuthorizeToken item);
  public TemplateFluent.OAuthAuthorizeTokenObjectsNested<A> addNewOAuthAuthorizeTokenObject();
  public TemplateFluent.OAuthAuthorizeTokenObjectsNested<A> addNewOAuthAuthorizeTokenObjectLike(OAuthAuthorizeToken item);
  public A addToUserOAuthAccessTokenObjects(Integer index,UserOAuthAccessToken item);
  public A setToUserOAuthAccessTokenObjects(Integer index,UserOAuthAccessToken item);
  public A addToUserOAuthAccessTokenObjects(io.fabric8.openshift.api.model.UserOAuthAccessToken... items);
  public A addAllToUserOAuthAccessTokenObjects(Collection<UserOAuthAccessToken> items);
  public A removeFromUserOAuthAccessTokenObjects(io.fabric8.openshift.api.model.UserOAuthAccessToken... items);
  public A removeAllFromUserOAuthAccessTokenObjects(Collection<UserOAuthAccessToken> items);
  public A removeMatchingFromUserOAuthAccessTokenObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.UserOAuthAccessTokenObjectsNested<A> setNewUserOAuthAccessTokenObjectLike(Integer index,UserOAuthAccessToken item);
  public TemplateFluent.UserOAuthAccessTokenObjectsNested<A> addNewUserOAuthAccessTokenObject();
  public TemplateFluent.UserOAuthAccessTokenObjectsNested<A> addNewUserOAuthAccessTokenObjectLike(UserOAuthAccessToken item);
  public A addToClusterRoleBindingObjects(Integer index,ClusterRoleBinding item);
  public A setToClusterRoleBindingObjects(Integer index,ClusterRoleBinding item);
  public A addToClusterRoleBindingObjects(io.fabric8.openshift.api.model.ClusterRoleBinding... items);
  public A addAllToClusterRoleBindingObjects(Collection<ClusterRoleBinding> items);
  public A removeFromClusterRoleBindingObjects(io.fabric8.openshift.api.model.ClusterRoleBinding... items);
  public A removeAllFromClusterRoleBindingObjects(Collection<ClusterRoleBinding> items);
  public A removeMatchingFromClusterRoleBindingObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.ClusterRoleBindingObjectsNested<A> setNewClusterRoleBindingObjectLike(Integer index,ClusterRoleBinding item);
  public TemplateFluent.ClusterRoleBindingObjectsNested<A> addNewClusterRoleBindingObject();
  public TemplateFluent.ClusterRoleBindingObjectsNested<A> addNewClusterRoleBindingObjectLike(ClusterRoleBinding item);
  public A addToClusterResourceQuotaObjects(Integer index,ClusterResourceQuota item);
  public A setToClusterResourceQuotaObjects(Integer index,ClusterResourceQuota item);
  public A addToClusterResourceQuotaObjects(io.fabric8.openshift.api.model.ClusterResourceQuota... items);
  public A addAllToClusterResourceQuotaObjects(Collection<ClusterResourceQuota> items);
  public A removeFromClusterResourceQuotaObjects(io.fabric8.openshift.api.model.ClusterResourceQuota... items);
  public A removeAllFromClusterResourceQuotaObjects(Collection<ClusterResourceQuota> items);
  public A removeMatchingFromClusterResourceQuotaObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.ClusterResourceQuotaObjectsNested<A> setNewClusterResourceQuotaObjectLike(Integer index,ClusterResourceQuota item);
  public TemplateFluent.ClusterResourceQuotaObjectsNested<A> addNewClusterResourceQuotaObject();
  public TemplateFluent.ClusterResourceQuotaObjectsNested<A> addNewClusterResourceQuotaObjectLike(ClusterResourceQuota item);
  public A addToProjectRequestObjects(Integer index,ProjectRequest item);
  public A setToProjectRequestObjects(Integer index,ProjectRequest item);
  public A addToProjectRequestObjects(io.fabric8.openshift.api.model.ProjectRequest... items);
  public A addAllToProjectRequestObjects(Collection<ProjectRequest> items);
  public A removeFromProjectRequestObjects(io.fabric8.openshift.api.model.ProjectRequest... items);
  public A removeAllFromProjectRequestObjects(Collection<ProjectRequest> items);
  public A removeMatchingFromProjectRequestObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.ProjectRequestObjectsNested<A> setNewProjectRequestObjectLike(Integer index,ProjectRequest item);
  public TemplateFluent.ProjectRequestObjectsNested<A> addNewProjectRequestObject();
  public TemplateFluent.ProjectRequestObjectsNested<A> addNewProjectRequestObjectLike(ProjectRequest item);
  public A addToTemplateObjects(Integer index,Template item);
  public A setToTemplateObjects(Integer index,Template item);
  public A addToTemplateObjects(io.fabric8.openshift.api.model.Template... items);
  public A addAllToTemplateObjects(Collection<Template> items);
  public A removeFromTemplateObjects(io.fabric8.openshift.api.model.Template... items);
  public A removeAllFromTemplateObjects(Collection<Template> items);
  public A removeMatchingFromTemplateObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.TemplateObjectsNested<A> setNewTemplateObjectLike(Integer index,Template item);
  public TemplateFluent.TemplateObjectsNested<A> addNewTemplateObject();
  public TemplateFluent.TemplateObjectsNested<A> addNewTemplateObjectLike(Template item);
  public A addToOAuthClientAuthorizationObjects(Integer index,OAuthClientAuthorization item);
  public A setToOAuthClientAuthorizationObjects(Integer index,OAuthClientAuthorization item);
  public A addToOAuthClientAuthorizationObjects(io.fabric8.openshift.api.model.OAuthClientAuthorization... items);
  public A addAllToOAuthClientAuthorizationObjects(Collection<OAuthClientAuthorization> items);
  public A removeFromOAuthClientAuthorizationObjects(io.fabric8.openshift.api.model.OAuthClientAuthorization... items);
  public A removeAllFromOAuthClientAuthorizationObjects(Collection<OAuthClientAuthorization> items);
  public A removeMatchingFromOAuthClientAuthorizationObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.OAuthClientAuthorizationObjectsNested<A> setNewOAuthClientAuthorizationObjectLike(Integer index,OAuthClientAuthorization item);
  public TemplateFluent.OAuthClientAuthorizationObjectsNested<A> addNewOAuthClientAuthorizationObject();
  public TemplateFluent.OAuthClientAuthorizationObjectsNested<A> addNewOAuthClientAuthorizationObjectLike(OAuthClientAuthorization item);
  public A addToClusterRoleObjects(Integer index,ClusterRole item);
  public A setToClusterRoleObjects(Integer index,ClusterRole item);
  public A addToClusterRoleObjects(io.fabric8.openshift.api.model.ClusterRole... items);
  public A addAllToClusterRoleObjects(Collection<ClusterRole> items);
  public A removeFromClusterRoleObjects(io.fabric8.openshift.api.model.ClusterRole... items);
  public A removeAllFromClusterRoleObjects(Collection<ClusterRole> items);
  public A removeMatchingFromClusterRoleObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.ClusterRoleObjectsNested<A> setNewClusterRoleObjectLike(Integer index,ClusterRole item);
  public TemplateFluent.ClusterRoleObjectsNested<A> addNewClusterRoleObject();
  public TemplateFluent.ClusterRoleObjectsNested<A> addNewClusterRoleObjectLike(ClusterRole item);
  public A addToImageTagObjects(Integer index,ImageTag item);
  public A setToImageTagObjects(Integer index,ImageTag item);
  public A addToImageTagObjects(io.fabric8.openshift.api.model.ImageTag... items);
  public A addAllToImageTagObjects(Collection<ImageTag> items);
  public A removeFromImageTagObjects(io.fabric8.openshift.api.model.ImageTag... items);
  public A removeAllFromImageTagObjects(Collection<ImageTag> items);
  public A removeMatchingFromImageTagObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.ImageTagObjectsNested<A> setNewImageTagObjectLike(Integer index,ImageTag item);
  public TemplateFluent.ImageTagObjectsNested<A> addNewImageTagObject();
  public TemplateFluent.ImageTagObjectsNested<A> addNewImageTagObjectLike(ImageTag item);
  public A addToOAuthAccessTokenObjects(Integer index,OAuthAccessToken item);
  public A setToOAuthAccessTokenObjects(Integer index,OAuthAccessToken item);
  public A addToOAuthAccessTokenObjects(io.fabric8.openshift.api.model.OAuthAccessToken... items);
  public A addAllToOAuthAccessTokenObjects(Collection<OAuthAccessToken> items);
  public A removeFromOAuthAccessTokenObjects(io.fabric8.openshift.api.model.OAuthAccessToken... items);
  public A removeAllFromOAuthAccessTokenObjects(Collection<OAuthAccessToken> items);
  public A removeMatchingFromOAuthAccessTokenObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.OAuthAccessTokenObjectsNested<A> setNewOAuthAccessTokenObjectLike(Integer index,OAuthAccessToken item);
  public TemplateFluent.OAuthAccessTokenObjectsNested<A> addNewOAuthAccessTokenObject();
  public TemplateFluent.OAuthAccessTokenObjectsNested<A> addNewOAuthAccessTokenObjectLike(OAuthAccessToken item);
  public A addToDeploymentConfigObjects(Integer index,DeploymentConfig item);
  public A setToDeploymentConfigObjects(Integer index,DeploymentConfig item);
  public A addToDeploymentConfigObjects(io.fabric8.openshift.api.model.DeploymentConfig... items);
  public A addAllToDeploymentConfigObjects(Collection<DeploymentConfig> items);
  public A removeFromDeploymentConfigObjects(io.fabric8.openshift.api.model.DeploymentConfig... items);
  public A removeAllFromDeploymentConfigObjects(Collection<DeploymentConfig> items);
  public A removeMatchingFromDeploymentConfigObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.DeploymentConfigObjectsNested<A> setNewDeploymentConfigObjectLike(Integer index,DeploymentConfig item);
  public TemplateFluent.DeploymentConfigObjectsNested<A> addNewDeploymentConfigObject();
  public TemplateFluent.DeploymentConfigObjectsNested<A> addNewDeploymentConfigObjectLike(DeploymentConfig item);
  public A addToRoleBindingObjects(Integer index,RoleBinding item);
  public A setToRoleBindingObjects(Integer index,RoleBinding item);
  public A addToRoleBindingObjects(io.fabric8.openshift.api.model.RoleBinding... items);
  public A addAllToRoleBindingObjects(Collection<RoleBinding> items);
  public A removeFromRoleBindingObjects(io.fabric8.openshift.api.model.RoleBinding... items);
  public A removeAllFromRoleBindingObjects(Collection<RoleBinding> items);
  public A removeMatchingFromRoleBindingObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.RoleBindingObjectsNested<A> setNewRoleBindingObjectLike(Integer index,RoleBinding item);
  public TemplateFluent.RoleBindingObjectsNested<A> addNewRoleBindingObject();
  public TemplateFluent.RoleBindingObjectsNested<A> addNewRoleBindingObjectLike(RoleBinding item);
  public A addToImageObjects(Integer index,Image item);
  public A setToImageObjects(Integer index,Image item);
  public A addToImageObjects(io.fabric8.openshift.api.model.Image... items);
  public A addAllToImageObjects(Collection<Image> items);
  public A removeFromImageObjects(io.fabric8.openshift.api.model.Image... items);
  public A removeAllFromImageObjects(Collection<Image> items);
  public A removeMatchingFromImageObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.ImageObjectsNested<A> setNewImageObjectLike(Integer index,Image item);
  public TemplateFluent.ImageObjectsNested<A> addNewImageObject();
  public TemplateFluent.ImageObjectsNested<A> addNewImageObjectLike(Image item);
  public A addToPersistentVolumeClaimObjects(Integer index,PersistentVolumeClaim item);
  public A setToPersistentVolumeClaimObjects(Integer index,PersistentVolumeClaim item);
  public A addToPersistentVolumeClaimObjects(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items);
  public A addAllToPersistentVolumeClaimObjects(Collection<PersistentVolumeClaim> items);
  public A removeFromPersistentVolumeClaimObjects(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items);
  public A removeAllFromPersistentVolumeClaimObjects(Collection<PersistentVolumeClaim> items);
  public A removeMatchingFromPersistentVolumeClaimObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.PersistentVolumeClaimObjectsNested<A> setNewPersistentVolumeClaimObjectLike(Integer index,PersistentVolumeClaim item);
  public TemplateFluent.PersistentVolumeClaimObjectsNested<A> addNewPersistentVolumeClaimObject();
  public TemplateFluent.PersistentVolumeClaimObjectsNested<A> addNewPersistentVolumeClaimObjectLike(PersistentVolumeClaim item);
  public A addToImageStreamMappingObjects(Integer index,ImageStreamMapping item);
  public A setToImageStreamMappingObjects(Integer index,ImageStreamMapping item);
  public A addToImageStreamMappingObjects(io.fabric8.openshift.api.model.ImageStreamMapping... items);
  public A addAllToImageStreamMappingObjects(Collection<ImageStreamMapping> items);
  public A removeFromImageStreamMappingObjects(io.fabric8.openshift.api.model.ImageStreamMapping... items);
  public A removeAllFromImageStreamMappingObjects(Collection<ImageStreamMapping> items);
  public A removeMatchingFromImageStreamMappingObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.ImageStreamMappingObjectsNested<A> setNewImageStreamMappingObjectLike(Integer index,ImageStreamMapping item);
  public TemplateFluent.ImageStreamMappingObjectsNested<A> addNewImageStreamMappingObject();
  public TemplateFluent.ImageStreamMappingObjectsNested<A> addNewImageStreamMappingObjectLike(ImageStreamMapping item);
  public A addToRoleObjects(Integer index,Role item);
  public A setToRoleObjects(Integer index,Role item);
  public A addToRoleObjects(io.fabric8.openshift.api.model.Role... items);
  public A addAllToRoleObjects(Collection<Role> items);
  public A removeFromRoleObjects(io.fabric8.openshift.api.model.Role... items);
  public A removeAllFromRoleObjects(Collection<Role> items);
  public A removeMatchingFromRoleObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.RoleObjectsNested<A> setNewRoleObjectLike(Integer index,Role item);
  public TemplateFluent.RoleObjectsNested<A> addNewRoleObject();
  public TemplateFluent.RoleObjectsNested<A> addNewRoleObjectLike(Role item);
  public A addToBrokerTemplateInstanceObjects(Integer index,BrokerTemplateInstance item);
  public A setToBrokerTemplateInstanceObjects(Integer index,BrokerTemplateInstance item);
  public A addToBrokerTemplateInstanceObjects(io.fabric8.openshift.api.model.BrokerTemplateInstance... items);
  public A addAllToBrokerTemplateInstanceObjects(Collection<BrokerTemplateInstance> items);
  public A removeFromBrokerTemplateInstanceObjects(io.fabric8.openshift.api.model.BrokerTemplateInstance... items);
  public A removeAllFromBrokerTemplateInstanceObjects(Collection<BrokerTemplateInstance> items);
  public A removeMatchingFromBrokerTemplateInstanceObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.BrokerTemplateInstanceObjectsNested<A> setNewBrokerTemplateInstanceObjectLike(Integer index,BrokerTemplateInstance item);
  public TemplateFluent.BrokerTemplateInstanceObjectsNested<A> addNewBrokerTemplateInstanceObject();
  public TemplateFluent.BrokerTemplateInstanceObjectsNested<A> addNewBrokerTemplateInstanceObjectLike(BrokerTemplateInstance item);
  public A addToUserObjects(Integer index,User item);
  public A setToUserObjects(Integer index,User item);
  public A addToUserObjects(io.fabric8.openshift.api.model.User... items);
  public A addAllToUserObjects(Collection<User> items);
  public A removeFromUserObjects(io.fabric8.openshift.api.model.User... items);
  public A removeAllFromUserObjects(Collection<User> items);
  public A removeMatchingFromUserObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.UserObjectsNested<A> setNewUserObjectLike(Integer index,User item);
  public TemplateFluent.UserObjectsNested<A> addNewUserObject();
  public TemplateFluent.UserObjectsNested<A> addNewUserObjectLike(User item);
  public A addToImageStreamImageObjects(Integer index,ImageStreamImage item);
  public A setToImageStreamImageObjects(Integer index,ImageStreamImage item);
  public A addToImageStreamImageObjects(io.fabric8.openshift.api.model.ImageStreamImage... items);
  public A addAllToImageStreamImageObjects(Collection<ImageStreamImage> items);
  public A removeFromImageStreamImageObjects(io.fabric8.openshift.api.model.ImageStreamImage... items);
  public A removeAllFromImageStreamImageObjects(Collection<ImageStreamImage> items);
  public A removeMatchingFromImageStreamImageObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.ImageStreamImageObjectsNested<A> setNewImageStreamImageObjectLike(Integer index,ImageStreamImage item);
  public TemplateFluent.ImageStreamImageObjectsNested<A> addNewImageStreamImageObject();
  public TemplateFluent.ImageStreamImageObjectsNested<A> addNewImageStreamImageObjectLike(ImageStreamImage item);
  public A addToTemplateInstanceObjects(Integer index,TemplateInstance item);
  public A setToTemplateInstanceObjects(Integer index,TemplateInstance item);
  public A addToTemplateInstanceObjects(io.fabric8.openshift.api.model.TemplateInstance... items);
  public A addAllToTemplateInstanceObjects(Collection<TemplateInstance> items);
  public A removeFromTemplateInstanceObjects(io.fabric8.openshift.api.model.TemplateInstance... items);
  public A removeAllFromTemplateInstanceObjects(Collection<TemplateInstance> items);
  public A removeMatchingFromTemplateInstanceObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.TemplateInstanceObjectsNested<A> setNewTemplateInstanceObjectLike(Integer index,TemplateInstance item);
  public TemplateFluent.TemplateInstanceObjectsNested<A> addNewTemplateInstanceObject();
  public TemplateFluent.TemplateInstanceObjectsNested<A> addNewTemplateInstanceObjectLike(TemplateInstance item);
  public A addToBuildObjects(Integer index,Build item);
  public A setToBuildObjects(Integer index,Build item);
  public A addToBuildObjects(io.fabric8.openshift.api.model.Build... items);
  public A addAllToBuildObjects(Collection<Build> items);
  public A removeFromBuildObjects(io.fabric8.openshift.api.model.Build... items);
  public A removeAllFromBuildObjects(Collection<Build> items);
  public A removeMatchingFromBuildObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.BuildObjectsNested<A> setNewBuildObjectLike(Integer index,Build item);
  public TemplateFluent.BuildObjectsNested<A> addNewBuildObject();
  public TemplateFluent.BuildObjectsNested<A> addNewBuildObjectLike(Build item);
  public A addToRoleBindingRestrictionObjects(Integer index,RoleBindingRestriction item);
  public A setToRoleBindingRestrictionObjects(Integer index,RoleBindingRestriction item);
  public A addToRoleBindingRestrictionObjects(io.fabric8.openshift.api.model.RoleBindingRestriction... items);
  public A addAllToRoleBindingRestrictionObjects(Collection<RoleBindingRestriction> items);
  public A removeFromRoleBindingRestrictionObjects(io.fabric8.openshift.api.model.RoleBindingRestriction... items);
  public A removeAllFromRoleBindingRestrictionObjects(Collection<RoleBindingRestriction> items);
  public A removeMatchingFromRoleBindingRestrictionObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.RoleBindingRestrictionObjectsNested<A> setNewRoleBindingRestrictionObjectLike(Integer index,RoleBindingRestriction item);
  public TemplateFluent.RoleBindingRestrictionObjectsNested<A> addNewRoleBindingRestrictionObject();
  public TemplateFluent.RoleBindingRestrictionObjectsNested<A> addNewRoleBindingRestrictionObjectLike(RoleBindingRestriction item);
  public A addToImageStreamTagObjects(Integer index,ImageStreamTag item);
  public A setToImageStreamTagObjects(Integer index,ImageStreamTag item);
  public A addToImageStreamTagObjects(io.fabric8.openshift.api.model.ImageStreamTag... items);
  public A addAllToImageStreamTagObjects(Collection<ImageStreamTag> items);
  public A removeFromImageStreamTagObjects(io.fabric8.openshift.api.model.ImageStreamTag... items);
  public A removeAllFromImageStreamTagObjects(Collection<ImageStreamTag> items);
  public A removeMatchingFromImageStreamTagObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.ImageStreamTagObjectsNested<A> setNewImageStreamTagObjectLike(Integer index,ImageStreamTag item);
  public TemplateFluent.ImageStreamTagObjectsNested<A> addNewImageStreamTagObject();
  public TemplateFluent.ImageStreamTagObjectsNested<A> addNewImageStreamTagObjectLike(ImageStreamTag item);
  public A addToGroupObjects(Integer index,Group item);
  public A setToGroupObjects(Integer index,Group item);
  public A addToGroupObjects(io.fabric8.openshift.api.model.Group... items);
  public A addAllToGroupObjects(Collection<Group> items);
  public A removeFromGroupObjects(io.fabric8.openshift.api.model.Group... items);
  public A removeAllFromGroupObjects(Collection<Group> items);
  public A removeMatchingFromGroupObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.GroupObjectsNested<A> setNewGroupObjectLike(Integer index,Group item);
  public TemplateFluent.GroupObjectsNested<A> addNewGroupObject();
  public TemplateFluent.GroupObjectsNested<A> addNewGroupObjectLike(Group item);
  public A addToImageSignatureObjects(Integer index,ImageSignature item);
  public A setToImageSignatureObjects(Integer index,ImageSignature item);
  public A addToImageSignatureObjects(io.fabric8.openshift.api.model.ImageSignature... items);
  public A addAllToImageSignatureObjects(Collection<ImageSignature> items);
  public A removeFromImageSignatureObjects(io.fabric8.openshift.api.model.ImageSignature... items);
  public A removeAllFromImageSignatureObjects(Collection<ImageSignature> items);
  public A removeMatchingFromImageSignatureObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.ImageSignatureObjectsNested<A> setNewImageSignatureObjectLike(Integer index,ImageSignature item);
  public TemplateFluent.ImageSignatureObjectsNested<A> addNewImageSignatureObject();
  public TemplateFluent.ImageSignatureObjectsNested<A> addNewImageSignatureObjectLike(ImageSignature item);
  public A addToHostSubnetObjects(Integer index,HostSubnet item);
  public A setToHostSubnetObjects(Integer index,HostSubnet item);
  public A addToHostSubnetObjects(io.fabric8.openshift.api.model.HostSubnet... items);
  public A addAllToHostSubnetObjects(Collection<HostSubnet> items);
  public A removeFromHostSubnetObjects(io.fabric8.openshift.api.model.HostSubnet... items);
  public A removeAllFromHostSubnetObjects(Collection<HostSubnet> items);
  public A removeMatchingFromHostSubnetObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.HostSubnetObjectsNested<A> setNewHostSubnetObjectLike(Integer index,HostSubnet item);
  public TemplateFluent.HostSubnetObjectsNested<A> addNewHostSubnetObject();
  public TemplateFluent.HostSubnetObjectsNested<A> addNewHostSubnetObjectLike(HostSubnet item);
  public A addToAppliedClusterResourceQuotaObjects(Integer index,AppliedClusterResourceQuota item);
  public A setToAppliedClusterResourceQuotaObjects(Integer index,AppliedClusterResourceQuota item);
  public A addToAppliedClusterResourceQuotaObjects(io.fabric8.openshift.api.model.AppliedClusterResourceQuota... items);
  public A addAllToAppliedClusterResourceQuotaObjects(Collection<AppliedClusterResourceQuota> items);
  public A removeFromAppliedClusterResourceQuotaObjects(io.fabric8.openshift.api.model.AppliedClusterResourceQuota... items);
  public A removeAllFromAppliedClusterResourceQuotaObjects(Collection<AppliedClusterResourceQuota> items);
  public A removeMatchingFromAppliedClusterResourceQuotaObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.AppliedClusterResourceQuotaObjectsNested<A> setNewAppliedClusterResourceQuotaObjectLike(Integer index,AppliedClusterResourceQuota item);
  public TemplateFluent.AppliedClusterResourceQuotaObjectsNested<A> addNewAppliedClusterResourceQuotaObject();
  public TemplateFluent.AppliedClusterResourceQuotaObjectsNested<A> addNewAppliedClusterResourceQuotaObjectLike(AppliedClusterResourceQuota item);
  public A addToSecurityContextConstraintsObjects(Integer index,SecurityContextConstraints item);
  public A setToSecurityContextConstraintsObjects(Integer index,SecurityContextConstraints item);
  public A addToSecurityContextConstraintsObjects(io.fabric8.openshift.api.model.SecurityContextConstraints... items);
  public A addAllToSecurityContextConstraintsObjects(Collection<SecurityContextConstraints> items);
  public A removeFromSecurityContextConstraintsObjects(io.fabric8.openshift.api.model.SecurityContextConstraints... items);
  public A removeAllFromSecurityContextConstraintsObjects(Collection<SecurityContextConstraints> items);
  public A removeMatchingFromSecurityContextConstraintsObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.SecurityContextConstraintsObjectsNested<A> setNewSecurityContextConstraintsObjectLike(Integer index,SecurityContextConstraints item);
  public TemplateFluent.SecurityContextConstraintsObjectsNested<A> addNewSecurityContextConstraintsObject();
  public TemplateFluent.SecurityContextConstraintsObjectsNested<A> addNewSecurityContextConstraintsObjectLike(SecurityContextConstraints item);
  public A addToBuildRequestObjects(Integer index,BuildRequest item);
  public A setToBuildRequestObjects(Integer index,BuildRequest item);
  public A addToBuildRequestObjects(io.fabric8.openshift.api.model.BuildRequest... items);
  public A addAllToBuildRequestObjects(Collection<BuildRequest> items);
  public A removeFromBuildRequestObjects(io.fabric8.openshift.api.model.BuildRequest... items);
  public A removeAllFromBuildRequestObjects(Collection<BuildRequest> items);
  public A removeMatchingFromBuildRequestObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.BuildRequestObjectsNested<A> setNewBuildRequestObjectLike(Integer index,BuildRequest item);
  public TemplateFluent.BuildRequestObjectsNested<A> addNewBuildRequestObject();
  public TemplateFluent.BuildRequestObjectsNested<A> addNewBuildRequestObjectLike(BuildRequest item);
  public A addToEgressNetworkPolicyObjects(Integer index,EgressNetworkPolicy item);
  public A setToEgressNetworkPolicyObjects(Integer index,EgressNetworkPolicy item);
  public A addToEgressNetworkPolicyObjects(io.fabric8.openshift.api.model.EgressNetworkPolicy... items);
  public A addAllToEgressNetworkPolicyObjects(Collection<EgressNetworkPolicy> items);
  public A removeFromEgressNetworkPolicyObjects(io.fabric8.openshift.api.model.EgressNetworkPolicy... items);
  public A removeAllFromEgressNetworkPolicyObjects(Collection<EgressNetworkPolicy> items);
  public A removeMatchingFromEgressNetworkPolicyObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.EgressNetworkPolicyObjectsNested<A> setNewEgressNetworkPolicyObjectLike(Integer index,EgressNetworkPolicy item);
  public TemplateFluent.EgressNetworkPolicyObjectsNested<A> addNewEgressNetworkPolicyObject();
  public TemplateFluent.EgressNetworkPolicyObjectsNested<A> addNewEgressNetworkPolicyObjectLike(EgressNetworkPolicy item);
  public A addToNetNamespaceObjects(Integer index,NetNamespace item);
  public A setToNetNamespaceObjects(Integer index,NetNamespace item);
  public A addToNetNamespaceObjects(io.fabric8.openshift.api.model.NetNamespace... items);
  public A addAllToNetNamespaceObjects(Collection<NetNamespace> items);
  public A removeFromNetNamespaceObjects(io.fabric8.openshift.api.model.NetNamespace... items);
  public A removeAllFromNetNamespaceObjects(Collection<NetNamespace> items);
  public A removeMatchingFromNetNamespaceObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.NetNamespaceObjectsNested<A> setNewNetNamespaceObjectLike(Integer index,NetNamespace item);
  public TemplateFluent.NetNamespaceObjectsNested<A> addNewNetNamespaceObject();
  public TemplateFluent.NetNamespaceObjectsNested<A> addNewNetNamespaceObjectLike(NetNamespace item);
  public A addToUserIdentityMappingObjects(Integer index,UserIdentityMapping item);
  public A setToUserIdentityMappingObjects(Integer index,UserIdentityMapping item);
  public A addToUserIdentityMappingObjects(io.fabric8.openshift.api.model.UserIdentityMapping... items);
  public A addAllToUserIdentityMappingObjects(Collection<UserIdentityMapping> items);
  public A removeFromUserIdentityMappingObjects(io.fabric8.openshift.api.model.UserIdentityMapping... items);
  public A removeAllFromUserIdentityMappingObjects(Collection<UserIdentityMapping> items);
  public A removeMatchingFromUserIdentityMappingObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.UserIdentityMappingObjectsNested<A> setNewUserIdentityMappingObjectLike(Integer index,UserIdentityMapping item);
  public TemplateFluent.UserIdentityMappingObjectsNested<A> addNewUserIdentityMappingObject();
  public TemplateFluent.UserIdentityMappingObjectsNested<A> addNewUserIdentityMappingObjectLike(UserIdentityMapping item);
  public A addToImageStreamObjects(Integer index,ImageStream item);
  public A setToImageStreamObjects(Integer index,ImageStream item);
  public A addToImageStreamObjects(io.fabric8.openshift.api.model.ImageStream... items);
  public A addAllToImageStreamObjects(Collection<ImageStream> items);
  public A removeFromImageStreamObjects(io.fabric8.openshift.api.model.ImageStream... items);
  public A removeAllFromImageStreamObjects(Collection<ImageStream> items);
  public A removeMatchingFromImageStreamObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.ImageStreamObjectsNested<A> setNewImageStreamObjectLike(Integer index,ImageStream item);
  public TemplateFluent.ImageStreamObjectsNested<A> addNewImageStreamObject();
  public TemplateFluent.ImageStreamObjectsNested<A> addNewImageStreamObjectLike(ImageStream item);
  public A addToOAuthClientObjects(Integer index,OAuthClient item);
  public A setToOAuthClientObjects(Integer index,OAuthClient item);
  public A addToOAuthClientObjects(io.fabric8.openshift.api.model.OAuthClient... items);
  public A addAllToOAuthClientObjects(Collection<OAuthClient> items);
  public A removeFromOAuthClientObjects(io.fabric8.openshift.api.model.OAuthClient... items);
  public A removeAllFromOAuthClientObjects(Collection<OAuthClient> items);
  public A removeMatchingFromOAuthClientObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.OAuthClientObjectsNested<A> setNewOAuthClientObjectLike(Integer index,OAuthClient item);
  public TemplateFluent.OAuthClientObjectsNested<A> addNewOAuthClientObject();
  public TemplateFluent.OAuthClientObjectsNested<A> addNewOAuthClientObjectLike(OAuthClient item);
  public A addToIdentityObjects(Integer index,Identity item);
  public A setToIdentityObjects(Integer index,Identity item);
  public A addToIdentityObjects(io.fabric8.openshift.api.model.Identity... items);
  public A addAllToIdentityObjects(Collection<Identity> items);
  public A removeFromIdentityObjects(io.fabric8.openshift.api.model.Identity... items);
  public A removeAllFromIdentityObjects(Collection<Identity> items);
  public A removeMatchingFromIdentityObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public TemplateFluent.IdentityObjectsNested<A> setNewIdentityObjectLike(Integer index,Identity item);
  public TemplateFluent.IdentityObjectsNested<A> addNewIdentityObject();
  public TemplateFluent.IdentityObjectsNested<A> addNewIdentityObjectLike(Identity item);
  public A addToParameters(Integer index,Parameter item);
  public A setToParameters(Integer index,Parameter item);
  public A addToParameters(io.fabric8.openshift.api.model.Parameter... items);
  public A addAllToParameters(Collection<Parameter> items);
  public A removeFromParameters(io.fabric8.openshift.api.model.Parameter... items);
  public A removeAllFromParameters(Collection<Parameter> items);
  public A removeMatchingFromParameters(Predicate<ParameterBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildParameters instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Parameter> getParameters();
  public List<Parameter> buildParameters();
  public Parameter buildParameter(Integer index);
  public Parameter buildFirstParameter();
  public Parameter buildLastParameter();
  public Parameter buildMatchingParameter(Predicate<ParameterBuilder> predicate);
  public Boolean hasMatchingParameter(Predicate<ParameterBuilder> predicate);
  public A withParameters(List<Parameter> parameters);
  public A withParameters(io.fabric8.openshift.api.model.Parameter... parameters);
  public Boolean hasParameters();
  public TemplateFluent.ParametersNested<A> addNewParameter();
  public TemplateFluent.ParametersNested<A> addNewParameterLike(Parameter item);
  public TemplateFluent.ParametersNested<A> setNewParameterLike(Integer index,Parameter item);
  public TemplateFluent.ParametersNested<A> editParameter(Integer index);
  public TemplateFluent.ParametersNested<A> editFirstParameter();
  public TemplateFluent.ParametersNested<A> editLastParameter();
  public TemplateFluent.ParametersNested<A> editMatchingParameter(Predicate<ParameterBuilder> predicate);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<TemplateFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface ImageStreamImportObjectsNested<N> extends Nested<N>,ImageStreamImportFluent<TemplateFluent.ImageStreamImportObjectsNested<N>>{
    public N and();
    public N endImageStreamImportObject();
    
  }
  public interface ProjectObjectsNested<N> extends Nested<N>,ProjectFluent<TemplateFluent.ProjectObjectsNested<N>>{
    public N and();
    public N endProjectObject();
    
  }
  public interface BuildConfigObjectsNested<N> extends Nested<N>,BuildConfigFluent<TemplateFluent.BuildConfigObjectsNested<N>>{
    public N and();
    public N endBuildConfigObject();
    
  }
  public interface HelmChartRepositoryObjectsNested<N> extends Nested<N>,HelmChartRepositoryFluent<TemplateFluent.HelmChartRepositoryObjectsNested<N>>{
    public N and();
    public N endHelmChartRepositoryObject();
    
  }
  public interface RangeAllocationObjectsNested<N> extends Nested<N>,RangeAllocationFluent<TemplateFluent.RangeAllocationObjectsNested<N>>{
    public N and();
    public N endRangeAllocationObject();
    
  }
  public interface RouteObjectsNested<N> extends Nested<N>,RouteFluent<TemplateFluent.RouteObjectsNested<N>>{
    public N and();
    public N endRouteObject();
    
  }
  public interface ClusterNetworkObjectsNested<N> extends Nested<N>,ClusterNetworkFluent<TemplateFluent.ClusterNetworkObjectsNested<N>>{
    public N and();
    public N endClusterNetworkObject();
    
  }
  public interface OAuthAuthorizeTokenObjectsNested<N> extends Nested<N>,OAuthAuthorizeTokenFluent<TemplateFluent.OAuthAuthorizeTokenObjectsNested<N>>{
    public N and();
    public N endOAuthAuthorizeTokenObject();
    
  }
  public interface UserOAuthAccessTokenObjectsNested<N> extends Nested<N>,UserOAuthAccessTokenFluent<TemplateFluent.UserOAuthAccessTokenObjectsNested<N>>{
    public N and();
    public N endUserOAuthAccessTokenObject();
    
  }
  public interface ClusterRoleBindingObjectsNested<N> extends Nested<N>,ClusterRoleBindingFluent<TemplateFluent.ClusterRoleBindingObjectsNested<N>>{
    public N and();
    public N endClusterRoleBindingObject();
    
  }
  public interface ClusterResourceQuotaObjectsNested<N> extends Nested<N>,ClusterResourceQuotaFluent<TemplateFluent.ClusterResourceQuotaObjectsNested<N>>{
    public N and();
    public N endClusterResourceQuotaObject();
    
  }
  public interface ProjectRequestObjectsNested<N> extends Nested<N>,ProjectRequestFluent<TemplateFluent.ProjectRequestObjectsNested<N>>{
    public N and();
    public N endProjectRequestObject();
    
  }
  public interface TemplateObjectsNested<N> extends Nested<N>,TemplateFluent<TemplateFluent.TemplateObjectsNested<N>>{
    public N and();
    public N endTemplateObject();
    
  }
  public interface OAuthClientAuthorizationObjectsNested<N> extends Nested<N>,OAuthClientAuthorizationFluent<TemplateFluent.OAuthClientAuthorizationObjectsNested<N>>{
    public N and();
    public N endOAuthClientAuthorizationObject();
    
  }
  public interface ClusterRoleObjectsNested<N> extends Nested<N>,ClusterRoleFluent<TemplateFluent.ClusterRoleObjectsNested<N>>{
    public N and();
    public N endClusterRoleObject();
    
  }
  public interface ImageTagObjectsNested<N> extends Nested<N>,ImageTagFluent<TemplateFluent.ImageTagObjectsNested<N>>{
    public N and();
    public N endImageTagObject();
    
  }
  public interface OAuthAccessTokenObjectsNested<N> extends Nested<N>,OAuthAccessTokenFluent<TemplateFluent.OAuthAccessTokenObjectsNested<N>>{
    public N and();
    public N endOAuthAccessTokenObject();
    
  }
  public interface DeploymentConfigObjectsNested<N> extends Nested<N>,DeploymentConfigFluent<TemplateFluent.DeploymentConfigObjectsNested<N>>{
    public N and();
    public N endDeploymentConfigObject();
    
  }
  public interface RoleBindingObjectsNested<N> extends Nested<N>,RoleBindingFluent<TemplateFluent.RoleBindingObjectsNested<N>>{
    public N and();
    public N endRoleBindingObject();
    
  }
  public interface ImageObjectsNested<N> extends Nested<N>,ImageFluent<TemplateFluent.ImageObjectsNested<N>>{
    public N and();
    public N endImageObject();
    
  }
  public interface PersistentVolumeClaimObjectsNested<N> extends Nested<N>,PersistentVolumeClaimFluent<TemplateFluent.PersistentVolumeClaimObjectsNested<N>>{
    public N and();
    public N endPersistentVolumeClaimObject();
    
  }
  public interface ImageStreamMappingObjectsNested<N> extends Nested<N>,ImageStreamMappingFluent<TemplateFluent.ImageStreamMappingObjectsNested<N>>{
    public N and();
    public N endImageStreamMappingObject();
    
  }
  public interface RoleObjectsNested<N> extends Nested<N>,RoleFluent<TemplateFluent.RoleObjectsNested<N>>{
    public N and();
    public N endRoleObject();
    
  }
  public interface BrokerTemplateInstanceObjectsNested<N> extends Nested<N>,BrokerTemplateInstanceFluent<TemplateFluent.BrokerTemplateInstanceObjectsNested<N>>{
    public N and();
    public N endBrokerTemplateInstanceObject();
    
  }
  public interface UserObjectsNested<N> extends Nested<N>,UserFluent<TemplateFluent.UserObjectsNested<N>>{
    public N and();
    public N endUserObject();
    
  }
  public interface ImageStreamImageObjectsNested<N> extends Nested<N>,ImageStreamImageFluent<TemplateFluent.ImageStreamImageObjectsNested<N>>{
    public N and();
    public N endImageStreamImageObject();
    
  }
  public interface TemplateInstanceObjectsNested<N> extends Nested<N>,TemplateInstanceFluent<TemplateFluent.TemplateInstanceObjectsNested<N>>{
    public N and();
    public N endTemplateInstanceObject();
    
  }
  public interface BuildObjectsNested<N> extends Nested<N>,BuildFluent<TemplateFluent.BuildObjectsNested<N>>{
    public N and();
    public N endBuildObject();
    
  }
  public interface RoleBindingRestrictionObjectsNested<N> extends Nested<N>,RoleBindingRestrictionFluent<TemplateFluent.RoleBindingRestrictionObjectsNested<N>>{
    public N and();
    public N endRoleBindingRestrictionObject();
    
  }
  public interface ImageStreamTagObjectsNested<N> extends Nested<N>,ImageStreamTagFluent<TemplateFluent.ImageStreamTagObjectsNested<N>>{
    public N and();
    public N endImageStreamTagObject();
    
  }
  public interface GroupObjectsNested<N> extends Nested<N>,GroupFluent<TemplateFluent.GroupObjectsNested<N>>{
    public N and();
    public N endGroupObject();
    
  }
  public interface ImageSignatureObjectsNested<N> extends Nested<N>,ImageSignatureFluent<TemplateFluent.ImageSignatureObjectsNested<N>>{
    public N and();
    public N endImageSignatureObject();
    
  }
  public interface HostSubnetObjectsNested<N> extends Nested<N>,HostSubnetFluent<TemplateFluent.HostSubnetObjectsNested<N>>{
    public N and();
    public N endHostSubnetObject();
    
  }
  public interface AppliedClusterResourceQuotaObjectsNested<N> extends Nested<N>,AppliedClusterResourceQuotaFluent<TemplateFluent.AppliedClusterResourceQuotaObjectsNested<N>>{
    public N and();
    public N endAppliedClusterResourceQuotaObject();
    
  }
  public interface SecurityContextConstraintsObjectsNested<N> extends Nested<N>,SecurityContextConstraintsFluent<TemplateFluent.SecurityContextConstraintsObjectsNested<N>>{
    public N and();
    public N endSecurityContextConstraintsObject();
    
  }
  public interface BuildRequestObjectsNested<N> extends Nested<N>,BuildRequestFluent<TemplateFluent.BuildRequestObjectsNested<N>>{
    public N and();
    public N endBuildRequestObject();
    
  }
  public interface EgressNetworkPolicyObjectsNested<N> extends Nested<N>,EgressNetworkPolicyFluent<TemplateFluent.EgressNetworkPolicyObjectsNested<N>>{
    public N and();
    public N endEgressNetworkPolicyObject();
    
  }
  public interface NetNamespaceObjectsNested<N> extends Nested<N>,NetNamespaceFluent<TemplateFluent.NetNamespaceObjectsNested<N>>{
    public N and();
    public N endNetNamespaceObject();
    
  }
  public interface UserIdentityMappingObjectsNested<N> extends Nested<N>,UserIdentityMappingFluent<TemplateFluent.UserIdentityMappingObjectsNested<N>>{
    public N and();
    public N endUserIdentityMappingObject();
    
  }
  public interface ImageStreamObjectsNested<N> extends Nested<N>,ImageStreamFluent<TemplateFluent.ImageStreamObjectsNested<N>>{
    public N and();
    public N endImageStreamObject();
    
  }
  public interface OAuthClientObjectsNested<N> extends Nested<N>,OAuthClientFluent<TemplateFluent.OAuthClientObjectsNested<N>>{
    public N and();
    public N endOAuthClientObject();
    
  }
  public interface IdentityObjectsNested<N> extends Nested<N>,IdentityFluent<TemplateFluent.IdentityObjectsNested<N>>{
    public N and();
    public N endIdentityObject();
    
  }
  public interface ParametersNested<N> extends Nested<N>,ParameterFluent<TemplateFluent.ParametersNested<N>>{
    public N and();
    public N endParameter();
    
  }
  
}