package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SecretSpecFluentImpl<A extends SecretSpecFluent<A>> extends BaseFluent<A> implements SecretSpecFluent<A>{
  public SecretSpecFluentImpl() {
  }
  public SecretSpecFluentImpl(SecretSpec instance) {
    this.withMountPath(instance.getMountPath()); 
    this.withSecretSource(instance.getSecretSource()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String mountPath;
  private LocalObjectReferenceBuilder secretSource;
  private Map<String,Object> additionalProperties;
  public String getMountPath() {
    return this.mountPath;
  }
  public A withMountPath(String mountPath) {
    this.mountPath=mountPath; return (A) this;
  }
  public Boolean hasMountPath() {
    return this.mountPath != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSecretSource instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getSecretSource() {
    return this.secretSource!=null ?this.secretSource.build():null;
  }
  public LocalObjectReference buildSecretSource() {
    return this.secretSource!=null ?this.secretSource.build():null;
  }
  public A withSecretSource(LocalObjectReference secretSource) {
    _visitables.get("secretSource").remove(this.secretSource);
    if (secretSource!=null){ this.secretSource= new LocalObjectReferenceBuilder(secretSource); _visitables.get("secretSource").add(this.secretSource);} else { this.secretSource = null; _visitables.get("secretSource").remove(this.secretSource); } return (A) this;
  }
  public Boolean hasSecretSource() {
    return this.secretSource != null;
  }
  public A withNewSecretSource(String name) {
    return (A)withSecretSource(new LocalObjectReference(name));
  }
  public SecretSpecFluent.SecretSourceNested<A> withNewSecretSource() {
    return new SecretSpecFluentImpl.SecretSourceNestedImpl();
  }
  public SecretSpecFluent.SecretSourceNested<A> withNewSecretSourceLike(LocalObjectReference item) {
    return new SecretSpecFluentImpl.SecretSourceNestedImpl(item);
  }
  public SecretSpecFluent.SecretSourceNested<A> editSecretSource() {
    return withNewSecretSourceLike(getSecretSource());
  }
  public SecretSpecFluent.SecretSourceNested<A> editOrNewSecretSource() {
    return withNewSecretSourceLike(getSecretSource() != null ? getSecretSource(): new LocalObjectReferenceBuilder().build());
  }
  public SecretSpecFluent.SecretSourceNested<A> editOrNewSecretSourceLike(LocalObjectReference item) {
    return withNewSecretSourceLike(getSecretSource() != null ? getSecretSource(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SecretSpecFluentImpl that = (SecretSpecFluentImpl) o;
    if (mountPath != null ? !mountPath.equals(that.mountPath) :that.mountPath != null) return false;
    if (secretSource != null ? !secretSource.equals(that.secretSource) :that.secretSource != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(mountPath,  secretSource,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (mountPath != null) { sb.append("mountPath:"); sb.append(mountPath + ","); }
    if (secretSource != null) { sb.append("secretSource:"); sb.append(secretSource + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class SecretSourceNestedImpl<N> extends LocalObjectReferenceFluentImpl<SecretSpecFluent.SecretSourceNested<N>> implements SecretSpecFluent.SecretSourceNested<N>,Nested<N>{
    SecretSourceNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    SecretSourceNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) SecretSpecFluentImpl.this.withSecretSource(builder.build());
    }
    public N endSecretSource() {
      return and();
    }
    
  }
  
}