package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetNamespaceBuilder extends NetNamespaceFluentImpl<NetNamespaceBuilder> implements VisitableBuilder<NetNamespace,NetNamespaceBuilder>{
  public NetNamespaceBuilder() {
    this(false);
  }
  public NetNamespaceBuilder(Boolean validationEnabled) {
    this(new NetNamespace(), validationEnabled);
  }
  public NetNamespaceBuilder(NetNamespaceFluent<?> fluent) {
    this(fluent, false);
  }
  public NetNamespaceBuilder(NetNamespaceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NetNamespace(), validationEnabled);
  }
  public NetNamespaceBuilder(NetNamespaceFluent<?> fluent,NetNamespace instance) {
    this(fluent, instance, false);
  }
  public NetNamespaceBuilder(NetNamespaceFluent<?> fluent,NetNamespace instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withEgressIPs(instance.getEgressIPs()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withNetid(instance.getNetid()); 
    fluent.withNetname(instance.getNetname()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NetNamespaceBuilder(NetNamespace instance) {
    this(instance,false);
  }
  public NetNamespaceBuilder(NetNamespace instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withEgressIPs(instance.getEgressIPs()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withNetid(instance.getNetid()); 
    this.withNetname(instance.getNetname()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  NetNamespaceFluent<?> fluent;
  Boolean validationEnabled;
  public NetNamespace build() {
    NetNamespace buildable = new NetNamespace(fluent.getApiVersion(),fluent.getEgressIPs(),fluent.getKind(),fluent.getMetadata(),fluent.getNetid(),fluent.getNetname());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}