package io.fabric8.openshift.api.model;

import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.openshift.api.model.runtime.RawExtensionFluentImpl;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.openshift.api.model.runtime.RawExtensionBuilder;
import io.fabric8.kubernetes.api.model.Container;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import java.lang.Boolean;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.SuppressWarnings;
import java.util.Map;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import io.fabric8.openshift.api.model.runtime.RawExtension;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class LocalResourceAccessReviewFluentImpl<A extends LocalResourceAccessReviewFluent<A>> extends BaseFluent<A> implements LocalResourceAccessReviewFluent<A>{
  public LocalResourceAccessReviewFluentImpl() {
  }
  public LocalResourceAccessReviewFluentImpl(LocalResourceAccessReview instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withContent(instance.getContent()); 
    this.withIsNonResourceURL(instance.getIsNonResourceURL()); 
    this.withKind(instance.getKind()); 
    this.withNamespace(instance.getNamespace()); 
    this.withPath(instance.getPath()); 
    this.withResource(instance.getResource()); 
    this.withResourceAPIGroup(instance.getResourceAPIGroup()); 
    this.withResourceAPIVersion(instance.getResourceAPIVersion()); 
    this.withResourceName(instance.getResourceName()); 
    this.withVerb(instance.getVerb()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private VisitableBuilder<? extends KubernetesResource,?> content;
  private Boolean isNonResourceURL;
  private String kind;
  private String namespace;
  private String path;
  private String resource;
  private String resourceAPIGroup;
  private String resourceAPIVersion;
  private String resourceName;
  private String verb;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * This method has been deprecated, please use method buildContent instead.
   * @return The buildable object.
   */
  @Deprecated
  public KubernetesResource getContent() {
    return this.content!=null?this.content.build():null;
  }
  public KubernetesResource buildContent() {
    return this.content!=null?this.content.build():null;
  }
  public A withContent(KubernetesResource content) {
    if (content instanceof GenericWebHookCause){ this.content= new GenericWebHookCauseBuilder((GenericWebHookCause)content); _visitables.get("content").add(this.content);}
    if (content instanceof ServiceAccountRestriction){ this.content= new ServiceAccountRestrictionBuilder((ServiceAccountRestriction)content); _visitables.get("content").add(this.content);}
    if (content instanceof ScopeRestriction){ this.content= new ScopeRestrictionBuilder((ScopeRestriction)content); _visitables.get("content").add(this.content);}
    if (content instanceof SecretLocalReference){ this.content= new SecretLocalReferenceBuilder((SecretLocalReference)content); _visitables.get("content").add(this.content);}
    if (content instanceof StepInfo){ this.content= new StepInfoBuilder((StepInfo)content); _visitables.get("content").add(this.content);}
    if (content instanceof UserRestriction){ this.content= new UserRestrictionBuilder((UserRestriction)content); _visitables.get("content").add(this.content);}
    if (content instanceof PodTemplateSpec){ this.content= new PodTemplateSpecBuilder((PodTemplateSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof TemplateInstanceList){ this.content= new TemplateInstanceListBuilder((TemplateInstanceList)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageStreamImport){ this.content= new ImageStreamImportBuilder((ImageStreamImport)content); _visitables.get("content").add(this.content);}
    if (content instanceof ResourceRequirements){ this.content= new ResourceRequirementsBuilder((ResourceRequirements)content); _visitables.get("content").add(this.content);}
    if (content instanceof GitHubWebHookCause){ this.content= new GitHubWebHookCauseBuilder((GitHubWebHookCause)content); _visitables.get("content").add(this.content);}
    if (content instanceof OAuthClientList){ this.content= new OAuthClientListBuilder((OAuthClientList)content); _visitables.get("content").add(this.content);}
    if (content instanceof PodSecurityPolicyReviewStatus){ this.content= new PodSecurityPolicyReviewStatusBuilder((PodSecurityPolicyReviewStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof TemplateInstanceStatus){ this.content= new TemplateInstanceStatusBuilder((TemplateInstanceStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof HelmChartRepositoryList){ this.content= new HelmChartRepositoryListBuilder((HelmChartRepositoryList)content); _visitables.get("content").add(this.content);}
    if (content instanceof PolicyRule){ this.content= new PolicyRuleBuilder((PolicyRule)content); _visitables.get("content").add(this.content);}
    if (content instanceof DeploymentTriggerPolicy){ this.content= new DeploymentTriggerPolicyBuilder((DeploymentTriggerPolicy)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildStrategy){ this.content= new BuildStrategyBuilder((BuildStrategy)content); _visitables.get("content").add(this.content);}
    if (content instanceof RepositoryImportSpec){ this.content= new RepositoryImportSpecBuilder((RepositoryImportSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof BrokerTemplateInstanceList){ this.content= new BrokerTemplateInstanceListBuilder((BrokerTemplateInstanceList)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageStreamImportStatus){ this.content= new ImageStreamImportStatusBuilder((ImageStreamImportStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof CustomBuildStrategy){ this.content= new CustomBuildStrategyBuilder((CustomBuildStrategy)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterResourceQuotaSelector){ this.content= new ClusterResourceQuotaSelectorBuilder((ClusterResourceQuotaSelector)content); _visitables.get("content").add(this.content);}
    if (content instanceof SubjectAccessReviewResponse){ this.content= new SubjectAccessReviewResponseBuilder((SubjectAccessReviewResponse)content); _visitables.get("content").add(this.content);}
    if (content instanceof DeploymentTriggerImageChangeParams){ this.content= new DeploymentTriggerImageChangeParamsBuilder((DeploymentTriggerImageChangeParams)content); _visitables.get("content").add(this.content);}
    if (content instanceof LocalObjectReference){ this.content= new LocalObjectReferenceBuilder((LocalObjectReference)content); _visitables.get("content").add(this.content);}
    if (content instanceof TagImageHook){ this.content= new TagImageHookBuilder((TagImageHook)content); _visitables.get("content").add(this.content);}
    if (content instanceof RouteTargetReference){ this.content= new RouteTargetReferenceBuilder((RouteTargetReference)content); _visitables.get("content").add(this.content);}
    if (content instanceof RawExtension){ this.content= new RawExtensionBuilder((RawExtension)content); _visitables.get("content").add(this.content);}
    if (content instanceof SubjectRulesReviewSpec){ this.content= new SubjectRulesReviewSpecBuilder((SubjectRulesReviewSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof TagReferencePolicy){ this.content= new TagReferencePolicyBuilder((TagReferencePolicy)content); _visitables.get("content").add(this.content);}
    if (content instanceof RoleList){ this.content= new RoleListBuilder((RoleList)content); _visitables.get("content").add(this.content);}
    if (content instanceof Project){ this.content= new ProjectBuilder((Project)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildVolumeSource){ this.content= new BuildVolumeSourceBuilder((BuildVolumeSource)content); _visitables.get("content").add(this.content);}
    if (content instanceof AppliedClusterResourceQuotaList){ this.content= new AppliedClusterResourceQuotaListBuilder((AppliedClusterResourceQuotaList)content); _visitables.get("content").add(this.content);}
    if (content instanceof DeploymentConfigList){ this.content= new DeploymentConfigListBuilder((DeploymentConfigList)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildStatusOutput){ this.content= new BuildStatusOutputBuilder((BuildStatusOutput)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildConfig){ this.content= new BuildConfigBuilder((BuildConfig)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageImportStatus){ this.content= new ImageImportStatusBuilder((ImageImportStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof PodSecurityPolicySubjectReview){ this.content= new PodSecurityPolicySubjectReviewBuilder((PodSecurityPolicySubjectReview)content); _visitables.get("content").add(this.content);}
    if (content instanceof GitLabWebHookCause){ this.content= new GitLabWebHookCauseBuilder((GitLabWebHookCause)content); _visitables.get("content").add(this.content);}
    if (content instanceof DeploymentConfigStatus){ this.content= new DeploymentConfigStatusBuilder((DeploymentConfigStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof SecretBuildSource){ this.content= new SecretBuildSourceBuilder((SecretBuildSource)content); _visitables.get("content").add(this.content);}
    if (content instanceof EgressNetworkPolicySpec){ this.content= new EgressNetworkPolicySpecBuilder((EgressNetworkPolicySpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof HelmChartRepository){ this.content= new HelmChartRepositoryBuilder((HelmChartRepository)content); _visitables.get("content").add(this.content);}
    if (content instanceof TagEvent){ this.content= new TagEventBuilder((TagEvent)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageStreamTagList){ this.content= new ImageStreamTagListBuilder((ImageStreamTagList)content); _visitables.get("content").add(this.content);}
    if (content instanceof BitbucketWebHookCause){ this.content= new BitbucketWebHookCauseBuilder((BitbucketWebHookCause)content); _visitables.get("content").add(this.content);}
    if (content instanceof ProjectList){ this.content= new ProjectListBuilder((ProjectList)content); _visitables.get("content").add(this.content);}
    if (content instanceof RangeAllocation){ this.content= new RangeAllocationBuilder((RangeAllocation)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterRoleScopeRestriction){ this.content= new ClusterRoleScopeRestrictionBuilder((ClusterRoleScopeRestriction)content); _visitables.get("content").add(this.content);}
    if (content instanceof Route){ this.content= new RouteBuilder((Route)content); _visitables.get("content").add(this.content);}
    if (content instanceof SourceStrategyOptions){ this.content= new SourceStrategyOptionsBuilder((SourceStrategyOptions)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterNetwork){ this.content= new ClusterNetworkBuilder((ClusterNetwork)content); _visitables.get("content").add(this.content);}
    if (content instanceof OAuthAuthorizeToken){ this.content= new OAuthAuthorizeTokenBuilder((OAuthAuthorizeToken)content); _visitables.get("content").add(this.content);}
    if (content instanceof DockerBuildStrategy){ this.content= new DockerBuildStrategyBuilder((DockerBuildStrategy)content); _visitables.get("content").add(this.content);}
    if (content instanceof SignatureCondition){ this.content= new SignatureConditionBuilder((SignatureCondition)content); _visitables.get("content").add(this.content);}
    if (content instanceof UserOAuthAccessToken){ this.content= new UserOAuthAccessTokenBuilder((UserOAuthAccessToken)content); _visitables.get("content").add(this.content);}
    if (content instanceof RoleBindingRestrictionList){ this.content= new RoleBindingRestrictionListBuilder((RoleBindingRestrictionList)content); _visitables.get("content").add(this.content);}
    if (content instanceof SecurityContextConstraintsList){ this.content= new SecurityContextConstraintsListBuilder((SecurityContextConstraintsList)content); _visitables.get("content").add(this.content);}
    if (content instanceof IdentityList){ this.content= new IdentityListBuilder((IdentityList)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildConfigList){ this.content= new BuildConfigListBuilder((BuildConfigList)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterNetworkList){ this.content= new ClusterNetworkListBuilder((ClusterNetworkList)content); _visitables.get("content").add(this.content);}
    if (content instanceof TemplateInstanceCondition){ this.content= new TemplateInstanceConditionBuilder((TemplateInstanceCondition)content); _visitables.get("content").add(this.content);}
    if (content instanceof RepositoryImportStatus){ this.content= new RepositoryImportStatusBuilder((RepositoryImportStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof DeploymentCause){ this.content= new DeploymentCauseBuilder((DeploymentCause)content); _visitables.get("content").add(this.content);}
    if (content instanceof GroupList){ this.content= new GroupListBuilder((GroupList)content); _visitables.get("content").add(this.content);}
    if (content instanceof RunAsUserStrategyOptions){ this.content= new RunAsUserStrategyOptionsBuilder((RunAsUserStrategyOptions)content); _visitables.get("content").add(this.content);}
    if (content instanceof LifecycleHook){ this.content= new LifecycleHookBuilder((LifecycleHook)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageStreamTagReference){ this.content= new ImageStreamTagReferenceBuilder((ImageStreamTagReference)content); _visitables.get("content").add(this.content);}
    if (content instanceof SourceControlUser){ this.content= new SourceControlUserBuilder((SourceControlUser)content); _visitables.get("content").add(this.content);}
    if (content instanceof Container){ this.content= new ContainerBuilder((Container)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageStreamList){ this.content= new ImageStreamListBuilder((ImageStreamList)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterRoleBinding){ this.content= new ClusterRoleBindingBuilder((ClusterRoleBinding)content); _visitables.get("content").add(this.content);}
    if (content instanceof ResourceAccessReview){ this.content= new ResourceAccessReviewBuilder((ResourceAccessReview)content); _visitables.get("content").add(this.content);}
    if (content instanceof SelfSubjectRulesReview){ this.content= new SelfSubjectRulesReviewBuilder((SelfSubjectRulesReview)content); _visitables.get("content").add(this.content);}
    if (content instanceof UserOAuthAccessTokenList){ this.content= new UserOAuthAccessTokenListBuilder((UserOAuthAccessTokenList)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageChangeTriggerStatus){ this.content= new ImageChangeTriggerStatusBuilder((ImageChangeTriggerStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof RouteStatus){ this.content= new RouteStatusBuilder((RouteStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterResourceQuota){ this.content= new ClusterResourceQuotaBuilder((ClusterResourceQuota)content); _visitables.get("content").add(this.content);}
    if (content instanceof NamedTagEventList){ this.content= new NamedTagEventListBuilder((NamedTagEventList)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterResourceQuotaList){ this.content= new ClusterResourceQuotaListBuilder((ClusterResourceQuotaList)content); _visitables.get("content").add(this.content);}
    if (content instanceof RouteSpec){ this.content= new RouteSpecBuilder((RouteSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof ProjectRequest){ this.content= new ProjectRequestBuilder((ProjectRequest)content); _visitables.get("content").add(this.content);}
    if (content instanceof Template){ this.content= new TemplateBuilder((Template)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageLookupPolicy){ this.content= new ImageLookupPolicyBuilder((ImageLookupPolicy)content); _visitables.get("content").add(this.content);}
    if (content instanceof OAuthClientAuthorization){ this.content= new OAuthClientAuthorizationBuilder((OAuthClientAuthorization)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageChangeCause){ this.content= new ImageChangeCauseBuilder((ImageChangeCause)content); _visitables.get("content").add(this.content);}
    if (content instanceof AllowedFlexVolume){ this.content= new AllowedFlexVolumeBuilder((AllowedFlexVolume)content); _visitables.get("content").add(this.content);}
    if (content instanceof SubjectAccessReview){ this.content= new SubjectAccessReviewBuilder((SubjectAccessReview)content); _visitables.get("content").add(this.content);}
    if (content instanceof LocalResourceAccessReview){ this.content= new LocalResourceAccessReviewBuilder((LocalResourceAccessReview)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterRole){ this.content= new ClusterRoleBuilder((ClusterRole)content); _visitables.get("content").add(this.content);}
    if (content instanceof ConnectionConfig){ this.content= new ConnectionConfigBuilder((ConnectionConfig)content); _visitables.get("content").add(this.content);}
    if (content instanceof TagEventCondition){ this.content= new TagEventConditionBuilder((TagEventCondition)content); _visitables.get("content").add(this.content);}
    if (content instanceof LabelSelector){ this.content= new LabelSelectorBuilder((LabelSelector)content); _visitables.get("content").add(this.content);}
    if (content instanceof NetNamespaceList){ this.content= new NetNamespaceListBuilder((NetNamespaceList)content); _visitables.get("content").add(this.content);}
    if (content instanceof BrokerTemplateInstanceSpec){ this.content= new BrokerTemplateInstanceSpecBuilder((BrokerTemplateInstanceSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof BinaryBuildSource){ this.content= new BinaryBuildSourceBuilder((BinaryBuildSource)content); _visitables.get("content").add(this.content);}
    if (content instanceof OAuthClientAuthorizationList){ this.content= new OAuthClientAuthorizationListBuilder((OAuthClientAuthorizationList)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildSpec){ this.content= new BuildSpecBuilder((BuildSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof ProjectStatus){ this.content= new ProjectStatusBuilder((ProjectStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof LocalSubjectAccessReview){ this.content= new LocalSubjectAccessReviewBuilder((LocalSubjectAccessReview)content); _visitables.get("content").add(this.content);}
    if (content instanceof RollingDeploymentStrategyParams){ this.content= new RollingDeploymentStrategyParamsBuilder((RollingDeploymentStrategyParams)content); _visitables.get("content").add(this.content);}
    if (content instanceof GitSourceRevision){ this.content= new GitSourceRevisionBuilder((GitSourceRevision)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageLabel){ this.content= new ImageLabelBuilder((ImageLabel)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageChangeTrigger){ this.content= new ImageChangeTriggerBuilder((ImageChangeTrigger)content); _visitables.get("content").add(this.content);}
    if (content instanceof PodSecurityPolicyReviewSpec){ this.content= new PodSecurityPolicyReviewSpecBuilder((PodSecurityPolicyReviewSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageTag){ this.content= new ImageTagBuilder((ImageTag)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageStreamImportSpec){ this.content= new ImageStreamImportSpecBuilder((ImageStreamImportSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof FSGroupStrategyOptions){ this.content= new FSGroupStrategyOptionsBuilder((FSGroupStrategyOptions)content); _visitables.get("content").add(this.content);}
    if (content instanceof PodSecurityPolicyReview){ this.content= new PodSecurityPolicyReviewBuilder((PodSecurityPolicyReview)content); _visitables.get("content").add(this.content);}
    if (content instanceof RecreateDeploymentStrategyParams){ this.content= new RecreateDeploymentStrategyParamsBuilder((RecreateDeploymentStrategyParams)content); _visitables.get("content").add(this.content);}
    if (content instanceof DockerStrategyOptions){ this.content= new DockerStrategyOptionsBuilder((DockerStrategyOptions)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageList){ this.content= new ImageListBuilder((ImageList)content); _visitables.get("content").add(this.content);}
    if (content instanceof ConfigMapBuildSource){ this.content= new ConfigMapBuildSourceBuilder((ConfigMapBuildSource)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageTagList){ this.content= new ImageTagListBuilder((ImageTagList)content); _visitables.get("content").add(this.content);}
    if (content instanceof OAuthAccessToken){ this.content= new OAuthAccessTokenBuilder((OAuthAccessToken)content); _visitables.get("content").add(this.content);}
    if (content instanceof DeploymentConfig){ this.content= new DeploymentConfigBuilder((DeploymentConfig)content); _visitables.get("content").add(this.content);}
    if (content instanceof RoleBinding){ this.content= new RoleBindingBuilder((RoleBinding)content); _visitables.get("content").add(this.content);}
    if (content instanceof Image){ this.content= new ImageBuilder((Image)content); _visitables.get("content").add(this.content);}
    if (content instanceof TLSConfig){ this.content= new TLSConfigBuilder((TLSConfig)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildVolume){ this.content= new BuildVolumeBuilder((BuildVolume)content); _visitables.get("content").add(this.content);}
    if (content instanceof TemplateInstanceSpec){ this.content= new TemplateInstanceSpecBuilder((TemplateInstanceSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildStatus){ this.content= new BuildStatusBuilder((BuildStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageSource){ this.content= new ImageSourceBuilder((ImageSource)content); _visitables.get("content").add(this.content);}
    if (content instanceof ObjectMeta){ this.content= new ObjectMetaBuilder((ObjectMeta)content); _visitables.get("content").add(this.content);}
    if (content instanceof PersistentVolumeClaim){ this.content= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)content); _visitables.get("content").add(this.content);}
    if (content instanceof PodSecurityPolicySelfSubjectReview){ this.content= new PodSecurityPolicySelfSubjectReviewBuilder((PodSecurityPolicySelfSubjectReview)content); _visitables.get("content").add(this.content);}
    if (content instanceof TagReference){ this.content= new TagReferenceBuilder((TagReference)content); _visitables.get("content").add(this.content);}
    if (content instanceof EgressNetworkPolicyRule){ this.content= new EgressNetworkPolicyRuleBuilder((EgressNetworkPolicyRule)content); _visitables.get("content").add(this.content);}
    if (content instanceof SubjectRulesReviewStatus){ this.content= new SubjectRulesReviewStatusBuilder((SubjectRulesReviewStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildVolumeMount){ this.content= new BuildVolumeMountBuilder((BuildVolumeMount)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterNetworkEntry){ this.content= new ClusterNetworkEntryBuilder((ClusterNetworkEntry)content); _visitables.get("content").add(this.content);}
    if (content instanceof TemplateInstanceObject){ this.content= new TemplateInstanceObjectBuilder((TemplateInstanceObject)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildSource){ this.content= new BuildSourceBuilder((BuildSource)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterResourceQuotaStatus){ this.content= new ClusterResourceQuotaStatusBuilder((ClusterResourceQuotaStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof DeploymentCondition){ this.content= new DeploymentConditionBuilder((DeploymentCondition)content); _visitables.get("content").add(this.content);}
    if (content instanceof HelmChartRepositorySpec){ this.content= new HelmChartRepositorySpecBuilder((HelmChartRepositorySpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof DeploymentCauseImageTrigger){ this.content= new DeploymentCauseImageTriggerBuilder((DeploymentCauseImageTrigger)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageStreamMapping){ this.content= new ImageStreamMappingBuilder((ImageStreamMapping)content); _visitables.get("content").add(this.content);}
    if (content instanceof SubjectRulesReview){ this.content= new SubjectRulesReviewBuilder((SubjectRulesReview)content); _visitables.get("content").add(this.content);}
    if (content instanceof Role){ this.content= new RoleBuilder((Role)content); _visitables.get("content").add(this.content);}
    if (content instanceof GitBuildSource){ this.content= new GitBuildSourceBuilder((GitBuildSource)content); _visitables.get("content").add(this.content);}
    if (content instanceof EgressNetworkPolicyList){ this.content= new EgressNetworkPolicyListBuilder((EgressNetworkPolicyList)content); _visitables.get("content").add(this.content);}
    if (content instanceof SelfSubjectRulesReviewSpec){ this.content= new SelfSubjectRulesReviewSpecBuilder((SelfSubjectRulesReviewSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageSourcePath){ this.content= new ImageSourcePathBuilder((ImageSourcePath)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildConfigStatus){ this.content= new BuildConfigStatusBuilder((BuildConfigStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof ResourceQuotaStatusByNamespace){ this.content= new ResourceQuotaStatusByNamespaceBuilder((ResourceQuotaStatusByNamespace)content); _visitables.get("content").add(this.content);}
    if (content instanceof SourceBuildStrategy){ this.content= new SourceBuildStrategyBuilder((SourceBuildStrategy)content); _visitables.get("content").add(this.content);}
    if (content instanceof Parameter){ this.content= new ParameterBuilder((Parameter)content); _visitables.get("content").add(this.content);}
    if (content instanceof RoleBindingList){ this.content= new RoleBindingListBuilder((RoleBindingList)content); _visitables.get("content").add(this.content);}
    if (content instanceof PodSecurityPolicySelfSubjectReviewSpec){ this.content= new PodSecurityPolicySelfSubjectReviewSpecBuilder((PodSecurityPolicySelfSubjectReviewSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof BrokerTemplateInstance){ this.content= new BrokerTemplateInstanceBuilder((BrokerTemplateInstance)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildPostCommitSpec){ this.content= new BuildPostCommitSpecBuilder((BuildPostCommitSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof OAuthAuthorizeTokenList){ this.content= new OAuthAuthorizeTokenListBuilder((OAuthAuthorizeTokenList)content); _visitables.get("content").add(this.content);}
    if (content instanceof DeploymentStrategy){ this.content= new DeploymentStrategyBuilder((DeploymentStrategy)content); _visitables.get("content").add(this.content);}
    if (content instanceof SignatureSubject){ this.content= new SignatureSubjectBuilder((SignatureSubject)content); _visitables.get("content").add(this.content);}
    if (content instanceof HostSubnetList){ this.content= new HostSubnetListBuilder((HostSubnetList)content); _visitables.get("content").add(this.content);}
    if (content instanceof RouteIngressCondition){ this.content= new RouteIngressConditionBuilder((RouteIngressCondition)content); _visitables.get("content").add(this.content);}
    if (content instanceof CustomDeploymentStrategyParams){ this.content= new CustomDeploymentStrategyParamsBuilder((CustomDeploymentStrategyParams)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageImportSpec){ this.content= new ImageImportSpecBuilder((ImageImportSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof StageInfo){ this.content= new StageInfoBuilder((StageInfo)content); _visitables.get("content").add(this.content);}
    if (content instanceof RoleBindingRestrictionSpec){ this.content= new RoleBindingRestrictionSpecBuilder((RoleBindingRestrictionSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof IDRange){ this.content= new IDRangeBuilder((IDRange)content); _visitables.get("content").add(this.content);}
    if (content instanceof UserList){ this.content= new UserListBuilder((UserList)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildConfigSpec){ this.content= new BuildConfigSpecBuilder((BuildConfigSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof User){ this.content= new UserBuilder((User)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageStreamImage){ this.content= new ImageStreamImageBuilder((ImageStreamImage)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildStatusOutputTo){ this.content= new BuildStatusOutputToBuilder((BuildStatusOutputTo)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildCondition){ this.content= new BuildConditionBuilder((BuildCondition)content); _visitables.get("content").add(this.content);}
    if (content instanceof ResourceAccessReviewResponse){ this.content= new ResourceAccessReviewResponseBuilder((ResourceAccessReviewResponse)content); _visitables.get("content").add(this.content);}
    if (content instanceof ExecNewPodHook){ this.content= new ExecNewPodHookBuilder((ExecNewPodHook)content); _visitables.get("content").add(this.content);}
    if (content instanceof SecretSpec){ this.content= new SecretSpecBuilder((SecretSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterRoleBindingList){ this.content= new ClusterRoleBindingListBuilder((ClusterRoleBindingList)content); _visitables.get("content").add(this.content);}
    if (content instanceof EgressNetworkPolicyPeer){ this.content= new EgressNetworkPolicyPeerBuilder((EgressNetworkPolicyPeer)content); _visitables.get("content").add(this.content);}
    if (content instanceof TemplateInstance){ this.content= new TemplateInstanceBuilder((TemplateInstance)content); _visitables.get("content").add(this.content);}
    if (content instanceof WebHookTrigger){ this.content= new WebHookTriggerBuilder((WebHookTrigger)content); _visitables.get("content").add(this.content);}
    if (content instanceof ServiceAccountReference){ this.content= new ServiceAccountReferenceBuilder((ServiceAccountReference)content); _visitables.get("content").add(this.content);}
    if (content instanceof Build){ this.content= new BuildBuilder((Build)content); _visitables.get("content").add(this.content);}
    if (content instanceof RoleBindingRestriction){ this.content= new RoleBindingRestrictionBuilder((RoleBindingRestriction)content); _visitables.get("content").add(this.content);}
    if (content instanceof TagImportPolicy){ this.content= new TagImportPolicyBuilder((TagImportPolicy)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageStreamTag){ this.content= new ImageStreamTagBuilder((ImageStreamTag)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildTriggerPolicy){ this.content= new BuildTriggerPolicyBuilder((BuildTriggerPolicy)content); _visitables.get("content").add(this.content);}
    if (content instanceof RoutePort){ this.content= new RoutePortBuilder((RoutePort)content); _visitables.get("content").add(this.content);}
    if (content instanceof TemplateInstanceRequester){ this.content= new TemplateInstanceRequesterBuilder((TemplateInstanceRequester)content); _visitables.get("content").add(this.content);}
    if (content instanceof Group){ this.content= new GroupBuilder((Group)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildTriggerCause){ this.content= new BuildTriggerCauseBuilder((BuildTriggerCause)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageSignature){ this.content= new ImageSignatureBuilder((ImageSignature)content); _visitables.get("content").add(this.content);}
    if (content instanceof HelmChartRepositoryStatus){ this.content= new HelmChartRepositoryStatusBuilder((HelmChartRepositoryStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof DeploymentConfigSpec){ this.content= new DeploymentConfigSpecBuilder((DeploymentConfigSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof HostSubnet){ this.content= new HostSubnetBuilder((HostSubnet)content); _visitables.get("content").add(this.content);}
    if (content instanceof GroupRestriction){ this.content= new GroupRestrictionBuilder((GroupRestriction)content); _visitables.get("content").add(this.content);}
    if (content instanceof AppliedClusterResourceQuota){ this.content= new AppliedClusterResourceQuotaBuilder((AppliedClusterResourceQuota)content); _visitables.get("content").add(this.content);}
    if (content instanceof OAuthAccessTokenList){ this.content= new OAuthAccessTokenListBuilder((OAuthAccessTokenList)content); _visitables.get("content").add(this.content);}
    if (content instanceof JenkinsPipelineBuildStrategy){ this.content= new JenkinsPipelineBuildStrategyBuilder((JenkinsPipelineBuildStrategy)content); _visitables.get("content").add(this.content);}
    if (content instanceof SecurityContextConstraints){ this.content= new SecurityContextConstraintsBuilder((SecurityContextConstraints)content); _visitables.get("content").add(this.content);}
    if (content instanceof SupplementalGroupsStrategyOptions){ this.content= new SupplementalGroupsStrategyOptionsBuilder((SupplementalGroupsStrategyOptions)content); _visitables.get("content").add(this.content);}
    if (content instanceof ServiceAccountPodSecurityPolicyReviewStatus){ this.content= new ServiceAccountPodSecurityPolicyReviewStatusBuilder((ServiceAccountPodSecurityPolicyReviewStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildRequest){ this.content= new BuildRequestBuilder((BuildRequest)content); _visitables.get("content").add(this.content);}
    if (content instanceof SELinuxContextStrategyOptions){ this.content= new SELinuxContextStrategyOptionsBuilder((SELinuxContextStrategyOptions)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterRoleList){ this.content= new ClusterRoleListBuilder((ClusterRoleList)content); _visitables.get("content").add(this.content);}
    if (content instanceof RouteList){ this.content= new RouteListBuilder((RouteList)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageStreamStatus){ this.content= new ImageStreamStatusBuilder((ImageStreamStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof EgressNetworkPolicy){ this.content= new EgressNetworkPolicyBuilder((EgressNetworkPolicy)content); _visitables.get("content").add(this.content);}
    if (content instanceof NetNamespace){ this.content= new NetNamespaceBuilder((NetNamespace)content); _visitables.get("content").add(this.content);}
    if (content instanceof UserIdentityMapping){ this.content= new UserIdentityMappingBuilder((UserIdentityMapping)content); _visitables.get("content").add(this.content);}
    if (content instanceof DeploymentDetails){ this.content= new DeploymentDetailsBuilder((DeploymentDetails)content); _visitables.get("content").add(this.content);}
    if (content instanceof PodSecurityPolicySubjectReviewStatus){ this.content= new PodSecurityPolicySubjectReviewStatusBuilder((PodSecurityPolicySubjectReviewStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof PodSecurityPolicySubjectReviewSpec){ this.content= new PodSecurityPolicySubjectReviewSpecBuilder((PodSecurityPolicySubjectReviewSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageStream){ this.content= new ImageStreamBuilder((ImageStream)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildList){ this.content= new BuildListBuilder((BuildList)content); _visitables.get("content").add(this.content);}
    if (content instanceof TemplateList){ this.content= new TemplateListBuilder((TemplateList)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildOutput){ this.content= new BuildOutputBuilder((BuildOutput)content); _visitables.get("content").add(this.content);}
    if (content instanceof ProjectSpec){ this.content= new ProjectSpecBuilder((ProjectSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof SourceRevision){ this.content= new SourceRevisionBuilder((SourceRevision)content); _visitables.get("content").add(this.content);}
    if (content instanceof ObjectReference){ this.content= new ObjectReferenceBuilder((ObjectReference)content); _visitables.get("content").add(this.content);}
    if (content instanceof SignatureIssuer){ this.content= new SignatureIssuerBuilder((SignatureIssuer)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageLayer){ this.content= new ImageLayerBuilder((ImageLayer)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterResourceQuotaSpec){ this.content= new ClusterResourceQuotaSpecBuilder((ClusterResourceQuotaSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageStreamSpec){ this.content= new ImageStreamSpecBuilder((ImageStreamSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof RouteIngress){ this.content= new RouteIngressBuilder((RouteIngress)content); _visitables.get("content").add(this.content);}
    if (content instanceof OAuthClient){ this.content= new OAuthClientBuilder((OAuthClient)content); _visitables.get("content").add(this.content);}
    if (content instanceof Identity){ this.content= new IdentityBuilder((Identity)content); _visitables.get("content").add(this.content);}
    if (content instanceof RangeAllocationList){ this.content= new RangeAllocationListBuilder((RangeAllocationList)content); _visitables.get("content").add(this.content);}
    return (A) this;
  }
  public Boolean hasContent() {
    return this.content != null;
  }
  public A withGenericWebHookCauseContent(GenericWebHookCause genericWebHookCauseContent) {
    _visitables.get("content").remove(this.content);
    if (genericWebHookCauseContent!=null){ this.content= new GenericWebHookCauseBuilder(genericWebHookCauseContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.GenericWebHookCauseContentNested<A> withNewGenericWebHookCauseContent() {
    return new LocalResourceAccessReviewFluentImpl.GenericWebHookCauseContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.GenericWebHookCauseContentNested<A> withNewGenericWebHookCauseContentLike(GenericWebHookCause item) {
    return new LocalResourceAccessReviewFluentImpl.GenericWebHookCauseContentNestedImpl(item);
  }
  public A withServiceAccountRestrictionContent(ServiceAccountRestriction serviceAccountRestrictionContent) {
    _visitables.get("content").remove(this.content);
    if (serviceAccountRestrictionContent!=null){ this.content= new ServiceAccountRestrictionBuilder(serviceAccountRestrictionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ServiceAccountRestrictionContentNested<A> withNewServiceAccountRestrictionContent() {
    return new LocalResourceAccessReviewFluentImpl.ServiceAccountRestrictionContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ServiceAccountRestrictionContentNested<A> withNewServiceAccountRestrictionContentLike(ServiceAccountRestriction item) {
    return new LocalResourceAccessReviewFluentImpl.ServiceAccountRestrictionContentNestedImpl(item);
  }
  public A withScopeRestrictionContent(ScopeRestriction scopeRestrictionContent) {
    _visitables.get("content").remove(this.content);
    if (scopeRestrictionContent!=null){ this.content= new ScopeRestrictionBuilder(scopeRestrictionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ScopeRestrictionContentNested<A> withNewScopeRestrictionContent() {
    return new LocalResourceAccessReviewFluentImpl.ScopeRestrictionContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ScopeRestrictionContentNested<A> withNewScopeRestrictionContentLike(ScopeRestriction item) {
    return new LocalResourceAccessReviewFluentImpl.ScopeRestrictionContentNestedImpl(item);
  }
  public A withSecretLocalReferenceContent(SecretLocalReference secretLocalReferenceContent) {
    _visitables.get("content").remove(this.content);
    if (secretLocalReferenceContent!=null){ this.content= new SecretLocalReferenceBuilder(secretLocalReferenceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.SecretLocalReferenceContentNested<A> withNewSecretLocalReferenceContent() {
    return new LocalResourceAccessReviewFluentImpl.SecretLocalReferenceContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.SecretLocalReferenceContentNested<A> withNewSecretLocalReferenceContentLike(SecretLocalReference item) {
    return new LocalResourceAccessReviewFluentImpl.SecretLocalReferenceContentNestedImpl(item);
  }
  public A withNewSecretLocalReferenceContent(String name) {
    return (A)withSecretLocalReferenceContent(new SecretLocalReference(name));
  }
  public A withStepInfoContent(StepInfo stepInfoContent) {
    _visitables.get("content").remove(this.content);
    if (stepInfoContent!=null){ this.content= new StepInfoBuilder(stepInfoContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.StepInfoContentNested<A> withNewStepInfoContent() {
    return new LocalResourceAccessReviewFluentImpl.StepInfoContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.StepInfoContentNested<A> withNewStepInfoContentLike(StepInfo item) {
    return new LocalResourceAccessReviewFluentImpl.StepInfoContentNestedImpl(item);
  }
  public A withNewStepInfoContent(Long durationMilliseconds,String name,String startTime) {
    return (A)withStepInfoContent(new StepInfo(durationMilliseconds, name, startTime));
  }
  public A withUserRestrictionContent(UserRestriction userRestrictionContent) {
    _visitables.get("content").remove(this.content);
    if (userRestrictionContent!=null){ this.content= new UserRestrictionBuilder(userRestrictionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.UserRestrictionContentNested<A> withNewUserRestrictionContent() {
    return new LocalResourceAccessReviewFluentImpl.UserRestrictionContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.UserRestrictionContentNested<A> withNewUserRestrictionContentLike(UserRestriction item) {
    return new LocalResourceAccessReviewFluentImpl.UserRestrictionContentNestedImpl(item);
  }
  public A withPodTemplateSpecContent(PodTemplateSpec podTemplateSpecContent) {
    _visitables.get("content").remove(this.content);
    if (podTemplateSpecContent!=null){ this.content= new PodTemplateSpecBuilder(podTemplateSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.PodTemplateSpecContentNested<A> withNewPodTemplateSpecContent() {
    return new LocalResourceAccessReviewFluentImpl.PodTemplateSpecContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.PodTemplateSpecContentNested<A> withNewPodTemplateSpecContentLike(PodTemplateSpec item) {
    return new LocalResourceAccessReviewFluentImpl.PodTemplateSpecContentNestedImpl(item);
  }
  public A withTemplateInstanceListContent(TemplateInstanceList templateInstanceListContent) {
    _visitables.get("content").remove(this.content);
    if (templateInstanceListContent!=null){ this.content= new TemplateInstanceListBuilder(templateInstanceListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.TemplateInstanceListContentNested<A> withNewTemplateInstanceListContent() {
    return new LocalResourceAccessReviewFluentImpl.TemplateInstanceListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.TemplateInstanceListContentNested<A> withNewTemplateInstanceListContentLike(TemplateInstanceList item) {
    return new LocalResourceAccessReviewFluentImpl.TemplateInstanceListContentNestedImpl(item);
  }
  public A withImageStreamImportContent(ImageStreamImport imageStreamImportContent) {
    _visitables.get("content").remove(this.content);
    if (imageStreamImportContent!=null){ this.content= new ImageStreamImportBuilder(imageStreamImportContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ImageStreamImportContentNested<A> withNewImageStreamImportContent() {
    return new LocalResourceAccessReviewFluentImpl.ImageStreamImportContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ImageStreamImportContentNested<A> withNewImageStreamImportContentLike(ImageStreamImport item) {
    return new LocalResourceAccessReviewFluentImpl.ImageStreamImportContentNestedImpl(item);
  }
  public A withResourceRequirementsContent(ResourceRequirements resourceRequirementsContent) {
    _visitables.get("content").remove(this.content);
    if (resourceRequirementsContent!=null){ this.content= new ResourceRequirementsBuilder(resourceRequirementsContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ResourceRequirementsContentNested<A> withNewResourceRequirementsContent() {
    return new LocalResourceAccessReviewFluentImpl.ResourceRequirementsContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ResourceRequirementsContentNested<A> withNewResourceRequirementsContentLike(ResourceRequirements item) {
    return new LocalResourceAccessReviewFluentImpl.ResourceRequirementsContentNestedImpl(item);
  }
  public A withGitHubWebHookCauseContent(GitHubWebHookCause gitHubWebHookCauseContent) {
    _visitables.get("content").remove(this.content);
    if (gitHubWebHookCauseContent!=null){ this.content= new GitHubWebHookCauseBuilder(gitHubWebHookCauseContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.GitHubWebHookCauseContentNested<A> withNewGitHubWebHookCauseContent() {
    return new LocalResourceAccessReviewFluentImpl.GitHubWebHookCauseContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.GitHubWebHookCauseContentNested<A> withNewGitHubWebHookCauseContentLike(GitHubWebHookCause item) {
    return new LocalResourceAccessReviewFluentImpl.GitHubWebHookCauseContentNestedImpl(item);
  }
  public A withOAuthClientListContent(OAuthClientList oAuthClientListContent) {
    _visitables.get("content").remove(this.content);
    if (oAuthClientListContent!=null){ this.content= new OAuthClientListBuilder(oAuthClientListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.OAuthClientListContentNested<A> withNewOAuthClientListContent() {
    return new LocalResourceAccessReviewFluentImpl.OAuthClientListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.OAuthClientListContentNested<A> withNewOAuthClientListContentLike(OAuthClientList item) {
    return new LocalResourceAccessReviewFluentImpl.OAuthClientListContentNestedImpl(item);
  }
  public A withPodSecurityPolicyReviewStatusContent(PodSecurityPolicyReviewStatus podSecurityPolicyReviewStatusContent) {
    _visitables.get("content").remove(this.content);
    if (podSecurityPolicyReviewStatusContent!=null){ this.content= new PodSecurityPolicyReviewStatusBuilder(podSecurityPolicyReviewStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.PodSecurityPolicyReviewStatusContentNested<A> withNewPodSecurityPolicyReviewStatusContent() {
    return new LocalResourceAccessReviewFluentImpl.PodSecurityPolicyReviewStatusContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.PodSecurityPolicyReviewStatusContentNested<A> withNewPodSecurityPolicyReviewStatusContentLike(PodSecurityPolicyReviewStatus item) {
    return new LocalResourceAccessReviewFluentImpl.PodSecurityPolicyReviewStatusContentNestedImpl(item);
  }
  public A withTemplateInstanceStatusContent(TemplateInstanceStatus templateInstanceStatusContent) {
    _visitables.get("content").remove(this.content);
    if (templateInstanceStatusContent!=null){ this.content= new TemplateInstanceStatusBuilder(templateInstanceStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.TemplateInstanceStatusContentNested<A> withNewTemplateInstanceStatusContent() {
    return new LocalResourceAccessReviewFluentImpl.TemplateInstanceStatusContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.TemplateInstanceStatusContentNested<A> withNewTemplateInstanceStatusContentLike(TemplateInstanceStatus item) {
    return new LocalResourceAccessReviewFluentImpl.TemplateInstanceStatusContentNestedImpl(item);
  }
  public A withHelmChartRepositoryListContent(HelmChartRepositoryList helmChartRepositoryListContent) {
    _visitables.get("content").remove(this.content);
    if (helmChartRepositoryListContent!=null){ this.content= new HelmChartRepositoryListBuilder(helmChartRepositoryListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.HelmChartRepositoryListContentNested<A> withNewHelmChartRepositoryListContent() {
    return new LocalResourceAccessReviewFluentImpl.HelmChartRepositoryListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.HelmChartRepositoryListContentNested<A> withNewHelmChartRepositoryListContentLike(HelmChartRepositoryList item) {
    return new LocalResourceAccessReviewFluentImpl.HelmChartRepositoryListContentNestedImpl(item);
  }
  public A withPolicyRuleContent(PolicyRule policyRuleContent) {
    _visitables.get("content").remove(this.content);
    if (policyRuleContent!=null){ this.content= new PolicyRuleBuilder(policyRuleContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.PolicyRuleContentNested<A> withNewPolicyRuleContent() {
    return new LocalResourceAccessReviewFluentImpl.PolicyRuleContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.PolicyRuleContentNested<A> withNewPolicyRuleContentLike(PolicyRule item) {
    return new LocalResourceAccessReviewFluentImpl.PolicyRuleContentNestedImpl(item);
  }
  public A withDeploymentTriggerPolicyContent(DeploymentTriggerPolicy deploymentTriggerPolicyContent) {
    _visitables.get("content").remove(this.content);
    if (deploymentTriggerPolicyContent!=null){ this.content= new DeploymentTriggerPolicyBuilder(deploymentTriggerPolicyContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.DeploymentTriggerPolicyContentNested<A> withNewDeploymentTriggerPolicyContent() {
    return new LocalResourceAccessReviewFluentImpl.DeploymentTriggerPolicyContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.DeploymentTriggerPolicyContentNested<A> withNewDeploymentTriggerPolicyContentLike(DeploymentTriggerPolicy item) {
    return new LocalResourceAccessReviewFluentImpl.DeploymentTriggerPolicyContentNestedImpl(item);
  }
  public A withBuildStrategyContent(BuildStrategy buildStrategyContent) {
    _visitables.get("content").remove(this.content);
    if (buildStrategyContent!=null){ this.content= new BuildStrategyBuilder(buildStrategyContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.BuildStrategyContentNested<A> withNewBuildStrategyContent() {
    return new LocalResourceAccessReviewFluentImpl.BuildStrategyContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.BuildStrategyContentNested<A> withNewBuildStrategyContentLike(BuildStrategy item) {
    return new LocalResourceAccessReviewFluentImpl.BuildStrategyContentNestedImpl(item);
  }
  public A withRepositoryImportSpecContent(RepositoryImportSpec repositoryImportSpecContent) {
    _visitables.get("content").remove(this.content);
    if (repositoryImportSpecContent!=null){ this.content= new RepositoryImportSpecBuilder(repositoryImportSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.RepositoryImportSpecContentNested<A> withNewRepositoryImportSpecContent() {
    return new LocalResourceAccessReviewFluentImpl.RepositoryImportSpecContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.RepositoryImportSpecContentNested<A> withNewRepositoryImportSpecContentLike(RepositoryImportSpec item) {
    return new LocalResourceAccessReviewFluentImpl.RepositoryImportSpecContentNestedImpl(item);
  }
  public A withBrokerTemplateInstanceListContent(BrokerTemplateInstanceList brokerTemplateInstanceListContent) {
    _visitables.get("content").remove(this.content);
    if (brokerTemplateInstanceListContent!=null){ this.content= new BrokerTemplateInstanceListBuilder(brokerTemplateInstanceListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.BrokerTemplateInstanceListContentNested<A> withNewBrokerTemplateInstanceListContent() {
    return new LocalResourceAccessReviewFluentImpl.BrokerTemplateInstanceListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.BrokerTemplateInstanceListContentNested<A> withNewBrokerTemplateInstanceListContentLike(BrokerTemplateInstanceList item) {
    return new LocalResourceAccessReviewFluentImpl.BrokerTemplateInstanceListContentNestedImpl(item);
  }
  public A withImageStreamImportStatusContent(ImageStreamImportStatus imageStreamImportStatusContent) {
    _visitables.get("content").remove(this.content);
    if (imageStreamImportStatusContent!=null){ this.content= new ImageStreamImportStatusBuilder(imageStreamImportStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ImageStreamImportStatusContentNested<A> withNewImageStreamImportStatusContent() {
    return new LocalResourceAccessReviewFluentImpl.ImageStreamImportStatusContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ImageStreamImportStatusContentNested<A> withNewImageStreamImportStatusContentLike(ImageStreamImportStatus item) {
    return new LocalResourceAccessReviewFluentImpl.ImageStreamImportStatusContentNestedImpl(item);
  }
  public A withCustomBuildStrategyContent(CustomBuildStrategy customBuildStrategyContent) {
    _visitables.get("content").remove(this.content);
    if (customBuildStrategyContent!=null){ this.content= new CustomBuildStrategyBuilder(customBuildStrategyContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.CustomBuildStrategyContentNested<A> withNewCustomBuildStrategyContent() {
    return new LocalResourceAccessReviewFluentImpl.CustomBuildStrategyContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.CustomBuildStrategyContentNested<A> withNewCustomBuildStrategyContentLike(CustomBuildStrategy item) {
    return new LocalResourceAccessReviewFluentImpl.CustomBuildStrategyContentNestedImpl(item);
  }
  public A withClusterResourceQuotaSelectorContent(ClusterResourceQuotaSelector clusterResourceQuotaSelectorContent) {
    _visitables.get("content").remove(this.content);
    if (clusterResourceQuotaSelectorContent!=null){ this.content= new ClusterResourceQuotaSelectorBuilder(clusterResourceQuotaSelectorContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ClusterResourceQuotaSelectorContentNested<A> withNewClusterResourceQuotaSelectorContent() {
    return new LocalResourceAccessReviewFluentImpl.ClusterResourceQuotaSelectorContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ClusterResourceQuotaSelectorContentNested<A> withNewClusterResourceQuotaSelectorContentLike(ClusterResourceQuotaSelector item) {
    return new LocalResourceAccessReviewFluentImpl.ClusterResourceQuotaSelectorContentNestedImpl(item);
  }
  public A withSubjectAccessReviewResponseContent(SubjectAccessReviewResponse subjectAccessReviewResponseContent) {
    _visitables.get("content").remove(this.content);
    if (subjectAccessReviewResponseContent!=null){ this.content= new SubjectAccessReviewResponseBuilder(subjectAccessReviewResponseContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.SubjectAccessReviewResponseContentNested<A> withNewSubjectAccessReviewResponseContent() {
    return new LocalResourceAccessReviewFluentImpl.SubjectAccessReviewResponseContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.SubjectAccessReviewResponseContentNested<A> withNewSubjectAccessReviewResponseContentLike(SubjectAccessReviewResponse item) {
    return new LocalResourceAccessReviewFluentImpl.SubjectAccessReviewResponseContentNestedImpl(item);
  }
  public A withDeploymentTriggerImageChangeParamsContent(DeploymentTriggerImageChangeParams deploymentTriggerImageChangeParamsContent) {
    _visitables.get("content").remove(this.content);
    if (deploymentTriggerImageChangeParamsContent!=null){ this.content= new DeploymentTriggerImageChangeParamsBuilder(deploymentTriggerImageChangeParamsContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.DeploymentTriggerImageChangeParamsContentNested<A> withNewDeploymentTriggerImageChangeParamsContent() {
    return new LocalResourceAccessReviewFluentImpl.DeploymentTriggerImageChangeParamsContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.DeploymentTriggerImageChangeParamsContentNested<A> withNewDeploymentTriggerImageChangeParamsContentLike(DeploymentTriggerImageChangeParams item) {
    return new LocalResourceAccessReviewFluentImpl.DeploymentTriggerImageChangeParamsContentNestedImpl(item);
  }
  public A withLocalObjectReferenceContent(LocalObjectReference localObjectReferenceContent) {
    _visitables.get("content").remove(this.content);
    if (localObjectReferenceContent!=null){ this.content= new LocalObjectReferenceBuilder(localObjectReferenceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.LocalObjectReferenceContentNested<A> withNewLocalObjectReferenceContent() {
    return new LocalResourceAccessReviewFluentImpl.LocalObjectReferenceContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.LocalObjectReferenceContentNested<A> withNewLocalObjectReferenceContentLike(LocalObjectReference item) {
    return new LocalResourceAccessReviewFluentImpl.LocalObjectReferenceContentNestedImpl(item);
  }
  public A withNewLocalObjectReferenceContent(String name) {
    return (A)withLocalObjectReferenceContent(new LocalObjectReference(name));
  }
  public A withTagImageHookContent(TagImageHook tagImageHookContent) {
    _visitables.get("content").remove(this.content);
    if (tagImageHookContent!=null){ this.content= new TagImageHookBuilder(tagImageHookContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.TagImageHookContentNested<A> withNewTagImageHookContent() {
    return new LocalResourceAccessReviewFluentImpl.TagImageHookContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.TagImageHookContentNested<A> withNewTagImageHookContentLike(TagImageHook item) {
    return new LocalResourceAccessReviewFluentImpl.TagImageHookContentNestedImpl(item);
  }
  public A withRouteTargetReferenceContent(RouteTargetReference routeTargetReferenceContent) {
    _visitables.get("content").remove(this.content);
    if (routeTargetReferenceContent!=null){ this.content= new RouteTargetReferenceBuilder(routeTargetReferenceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.RouteTargetReferenceContentNested<A> withNewRouteTargetReferenceContent() {
    return new LocalResourceAccessReviewFluentImpl.RouteTargetReferenceContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.RouteTargetReferenceContentNested<A> withNewRouteTargetReferenceContentLike(RouteTargetReference item) {
    return new LocalResourceAccessReviewFluentImpl.RouteTargetReferenceContentNestedImpl(item);
  }
  public A withNewRouteTargetReferenceContent(String kind,String name,Integer weight) {
    return (A)withRouteTargetReferenceContent(new RouteTargetReference(kind, name, weight));
  }
  public A withRawExtensionContent(RawExtension rawExtensionContent) {
    _visitables.get("content").remove(this.content);
    if (rawExtensionContent!=null){ this.content= new RawExtensionBuilder(rawExtensionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.RawExtensionContentNested<A> withNewRawExtensionContent() {
    return new LocalResourceAccessReviewFluentImpl.RawExtensionContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.RawExtensionContentNested<A> withNewRawExtensionContentLike(RawExtension item) {
    return new LocalResourceAccessReviewFluentImpl.RawExtensionContentNestedImpl(item);
  }
  public A withNewRawExtensionContent(Object value) {
    return (A)withRawExtensionContent(new RawExtension(value));
  }
  public A withSubjectRulesReviewSpecContent(SubjectRulesReviewSpec subjectRulesReviewSpecContent) {
    _visitables.get("content").remove(this.content);
    if (subjectRulesReviewSpecContent!=null){ this.content= new SubjectRulesReviewSpecBuilder(subjectRulesReviewSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.SubjectRulesReviewSpecContentNested<A> withNewSubjectRulesReviewSpecContent() {
    return new LocalResourceAccessReviewFluentImpl.SubjectRulesReviewSpecContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.SubjectRulesReviewSpecContentNested<A> withNewSubjectRulesReviewSpecContentLike(SubjectRulesReviewSpec item) {
    return new LocalResourceAccessReviewFluentImpl.SubjectRulesReviewSpecContentNestedImpl(item);
  }
  public A withTagReferencePolicyContent(TagReferencePolicy tagReferencePolicyContent) {
    _visitables.get("content").remove(this.content);
    if (tagReferencePolicyContent!=null){ this.content= new TagReferencePolicyBuilder(tagReferencePolicyContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.TagReferencePolicyContentNested<A> withNewTagReferencePolicyContent() {
    return new LocalResourceAccessReviewFluentImpl.TagReferencePolicyContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.TagReferencePolicyContentNested<A> withNewTagReferencePolicyContentLike(TagReferencePolicy item) {
    return new LocalResourceAccessReviewFluentImpl.TagReferencePolicyContentNestedImpl(item);
  }
  public A withNewTagReferencePolicyContent(String type) {
    return (A)withTagReferencePolicyContent(new TagReferencePolicy(type));
  }
  public A withRoleListContent(RoleList roleListContent) {
    _visitables.get("content").remove(this.content);
    if (roleListContent!=null){ this.content= new RoleListBuilder(roleListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.RoleListContentNested<A> withNewRoleListContent() {
    return new LocalResourceAccessReviewFluentImpl.RoleListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.RoleListContentNested<A> withNewRoleListContentLike(RoleList item) {
    return new LocalResourceAccessReviewFluentImpl.RoleListContentNestedImpl(item);
  }
  public A withProjectContent(Project projectContent) {
    _visitables.get("content").remove(this.content);
    if (projectContent!=null){ this.content= new ProjectBuilder(projectContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ProjectContentNested<A> withNewProjectContent() {
    return new LocalResourceAccessReviewFluentImpl.ProjectContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ProjectContentNested<A> withNewProjectContentLike(Project item) {
    return new LocalResourceAccessReviewFluentImpl.ProjectContentNestedImpl(item);
  }
  public A withBuildVolumeSourceContent(BuildVolumeSource buildVolumeSourceContent) {
    _visitables.get("content").remove(this.content);
    if (buildVolumeSourceContent!=null){ this.content= new BuildVolumeSourceBuilder(buildVolumeSourceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.BuildVolumeSourceContentNested<A> withNewBuildVolumeSourceContent() {
    return new LocalResourceAccessReviewFluentImpl.BuildVolumeSourceContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.BuildVolumeSourceContentNested<A> withNewBuildVolumeSourceContentLike(BuildVolumeSource item) {
    return new LocalResourceAccessReviewFluentImpl.BuildVolumeSourceContentNestedImpl(item);
  }
  public A withAppliedClusterResourceQuotaListContent(AppliedClusterResourceQuotaList appliedClusterResourceQuotaListContent) {
    _visitables.get("content").remove(this.content);
    if (appliedClusterResourceQuotaListContent!=null){ this.content= new AppliedClusterResourceQuotaListBuilder(appliedClusterResourceQuotaListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.AppliedClusterResourceQuotaListContentNested<A> withNewAppliedClusterResourceQuotaListContent() {
    return new LocalResourceAccessReviewFluentImpl.AppliedClusterResourceQuotaListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.AppliedClusterResourceQuotaListContentNested<A> withNewAppliedClusterResourceQuotaListContentLike(AppliedClusterResourceQuotaList item) {
    return new LocalResourceAccessReviewFluentImpl.AppliedClusterResourceQuotaListContentNestedImpl(item);
  }
  public A withDeploymentConfigListContent(DeploymentConfigList deploymentConfigListContent) {
    _visitables.get("content").remove(this.content);
    if (deploymentConfigListContent!=null){ this.content= new DeploymentConfigListBuilder(deploymentConfigListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.DeploymentConfigListContentNested<A> withNewDeploymentConfigListContent() {
    return new LocalResourceAccessReviewFluentImpl.DeploymentConfigListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.DeploymentConfigListContentNested<A> withNewDeploymentConfigListContentLike(DeploymentConfigList item) {
    return new LocalResourceAccessReviewFluentImpl.DeploymentConfigListContentNestedImpl(item);
  }
  public A withBuildStatusOutputContent(BuildStatusOutput buildStatusOutputContent) {
    _visitables.get("content").remove(this.content);
    if (buildStatusOutputContent!=null){ this.content= new BuildStatusOutputBuilder(buildStatusOutputContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.BuildStatusOutputContentNested<A> withNewBuildStatusOutputContent() {
    return new LocalResourceAccessReviewFluentImpl.BuildStatusOutputContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.BuildStatusOutputContentNested<A> withNewBuildStatusOutputContentLike(BuildStatusOutput item) {
    return new LocalResourceAccessReviewFluentImpl.BuildStatusOutputContentNestedImpl(item);
  }
  public A withBuildConfigContent(BuildConfig buildConfigContent) {
    _visitables.get("content").remove(this.content);
    if (buildConfigContent!=null){ this.content= new BuildConfigBuilder(buildConfigContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.BuildConfigContentNested<A> withNewBuildConfigContent() {
    return new LocalResourceAccessReviewFluentImpl.BuildConfigContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.BuildConfigContentNested<A> withNewBuildConfigContentLike(BuildConfig item) {
    return new LocalResourceAccessReviewFluentImpl.BuildConfigContentNestedImpl(item);
  }
  public A withImageImportStatusContent(ImageImportStatus imageImportStatusContent) {
    _visitables.get("content").remove(this.content);
    if (imageImportStatusContent!=null){ this.content= new ImageImportStatusBuilder(imageImportStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ImageImportStatusContentNested<A> withNewImageImportStatusContent() {
    return new LocalResourceAccessReviewFluentImpl.ImageImportStatusContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ImageImportStatusContentNested<A> withNewImageImportStatusContentLike(ImageImportStatus item) {
    return new LocalResourceAccessReviewFluentImpl.ImageImportStatusContentNestedImpl(item);
  }
  public A withPodSecurityPolicySubjectReviewContent(PodSecurityPolicySubjectReview podSecurityPolicySubjectReviewContent) {
    _visitables.get("content").remove(this.content);
    if (podSecurityPolicySubjectReviewContent!=null){ this.content= new PodSecurityPolicySubjectReviewBuilder(podSecurityPolicySubjectReviewContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.PodSecurityPolicySubjectReviewContentNested<A> withNewPodSecurityPolicySubjectReviewContent() {
    return new LocalResourceAccessReviewFluentImpl.PodSecurityPolicySubjectReviewContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.PodSecurityPolicySubjectReviewContentNested<A> withNewPodSecurityPolicySubjectReviewContentLike(PodSecurityPolicySubjectReview item) {
    return new LocalResourceAccessReviewFluentImpl.PodSecurityPolicySubjectReviewContentNestedImpl(item);
  }
  public A withGitLabWebHookCauseContent(GitLabWebHookCause gitLabWebHookCauseContent) {
    _visitables.get("content").remove(this.content);
    if (gitLabWebHookCauseContent!=null){ this.content= new GitLabWebHookCauseBuilder(gitLabWebHookCauseContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.GitLabWebHookCauseContentNested<A> withNewGitLabWebHookCauseContent() {
    return new LocalResourceAccessReviewFluentImpl.GitLabWebHookCauseContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.GitLabWebHookCauseContentNested<A> withNewGitLabWebHookCauseContentLike(GitLabWebHookCause item) {
    return new LocalResourceAccessReviewFluentImpl.GitLabWebHookCauseContentNestedImpl(item);
  }
  public A withDeploymentConfigStatusContent(DeploymentConfigStatus deploymentConfigStatusContent) {
    _visitables.get("content").remove(this.content);
    if (deploymentConfigStatusContent!=null){ this.content= new DeploymentConfigStatusBuilder(deploymentConfigStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.DeploymentConfigStatusContentNested<A> withNewDeploymentConfigStatusContent() {
    return new LocalResourceAccessReviewFluentImpl.DeploymentConfigStatusContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.DeploymentConfigStatusContentNested<A> withNewDeploymentConfigStatusContentLike(DeploymentConfigStatus item) {
    return new LocalResourceAccessReviewFluentImpl.DeploymentConfigStatusContentNestedImpl(item);
  }
  public A withSecretBuildSourceContent(SecretBuildSource secretBuildSourceContent) {
    _visitables.get("content").remove(this.content);
    if (secretBuildSourceContent!=null){ this.content= new SecretBuildSourceBuilder(secretBuildSourceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.SecretBuildSourceContentNested<A> withNewSecretBuildSourceContent() {
    return new LocalResourceAccessReviewFluentImpl.SecretBuildSourceContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.SecretBuildSourceContentNested<A> withNewSecretBuildSourceContentLike(SecretBuildSource item) {
    return new LocalResourceAccessReviewFluentImpl.SecretBuildSourceContentNestedImpl(item);
  }
  public A withEgressNetworkPolicySpecContent(EgressNetworkPolicySpec egressNetworkPolicySpecContent) {
    _visitables.get("content").remove(this.content);
    if (egressNetworkPolicySpecContent!=null){ this.content= new EgressNetworkPolicySpecBuilder(egressNetworkPolicySpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.EgressNetworkPolicySpecContentNested<A> withNewEgressNetworkPolicySpecContent() {
    return new LocalResourceAccessReviewFluentImpl.EgressNetworkPolicySpecContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.EgressNetworkPolicySpecContentNested<A> withNewEgressNetworkPolicySpecContentLike(EgressNetworkPolicySpec item) {
    return new LocalResourceAccessReviewFluentImpl.EgressNetworkPolicySpecContentNestedImpl(item);
  }
  public A withHelmChartRepositoryContent(HelmChartRepository helmChartRepositoryContent) {
    _visitables.get("content").remove(this.content);
    if (helmChartRepositoryContent!=null){ this.content= new HelmChartRepositoryBuilder(helmChartRepositoryContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.HelmChartRepositoryContentNested<A> withNewHelmChartRepositoryContent() {
    return new LocalResourceAccessReviewFluentImpl.HelmChartRepositoryContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.HelmChartRepositoryContentNested<A> withNewHelmChartRepositoryContentLike(HelmChartRepository item) {
    return new LocalResourceAccessReviewFluentImpl.HelmChartRepositoryContentNestedImpl(item);
  }
  public A withTagEventContent(TagEvent tagEventContent) {
    _visitables.get("content").remove(this.content);
    if (tagEventContent!=null){ this.content= new TagEventBuilder(tagEventContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.TagEventContentNested<A> withNewTagEventContent() {
    return new LocalResourceAccessReviewFluentImpl.TagEventContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.TagEventContentNested<A> withNewTagEventContentLike(TagEvent item) {
    return new LocalResourceAccessReviewFluentImpl.TagEventContentNestedImpl(item);
  }
  public A withNewTagEventContent(String created,String dockerImageReference,Long generation,String image) {
    return (A)withTagEventContent(new TagEvent(created, dockerImageReference, generation, image));
  }
  public A withImageStreamTagListContent(ImageStreamTagList imageStreamTagListContent) {
    _visitables.get("content").remove(this.content);
    if (imageStreamTagListContent!=null){ this.content= new ImageStreamTagListBuilder(imageStreamTagListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ImageStreamTagListContentNested<A> withNewImageStreamTagListContent() {
    return new LocalResourceAccessReviewFluentImpl.ImageStreamTagListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ImageStreamTagListContentNested<A> withNewImageStreamTagListContentLike(ImageStreamTagList item) {
    return new LocalResourceAccessReviewFluentImpl.ImageStreamTagListContentNestedImpl(item);
  }
  public A withBitbucketWebHookCauseContent(BitbucketWebHookCause bitbucketWebHookCauseContent) {
    _visitables.get("content").remove(this.content);
    if (bitbucketWebHookCauseContent!=null){ this.content= new BitbucketWebHookCauseBuilder(bitbucketWebHookCauseContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.BitbucketWebHookCauseContentNested<A> withNewBitbucketWebHookCauseContent() {
    return new LocalResourceAccessReviewFluentImpl.BitbucketWebHookCauseContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.BitbucketWebHookCauseContentNested<A> withNewBitbucketWebHookCauseContentLike(BitbucketWebHookCause item) {
    return new LocalResourceAccessReviewFluentImpl.BitbucketWebHookCauseContentNestedImpl(item);
  }
  public A withProjectListContent(ProjectList projectListContent) {
    _visitables.get("content").remove(this.content);
    if (projectListContent!=null){ this.content= new ProjectListBuilder(projectListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ProjectListContentNested<A> withNewProjectListContent() {
    return new LocalResourceAccessReviewFluentImpl.ProjectListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ProjectListContentNested<A> withNewProjectListContentLike(ProjectList item) {
    return new LocalResourceAccessReviewFluentImpl.ProjectListContentNestedImpl(item);
  }
  public A withRangeAllocationContent(RangeAllocation rangeAllocationContent) {
    _visitables.get("content").remove(this.content);
    if (rangeAllocationContent!=null){ this.content= new RangeAllocationBuilder(rangeAllocationContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.RangeAllocationContentNested<A> withNewRangeAllocationContent() {
    return new LocalResourceAccessReviewFluentImpl.RangeAllocationContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.RangeAllocationContentNested<A> withNewRangeAllocationContentLike(RangeAllocation item) {
    return new LocalResourceAccessReviewFluentImpl.RangeAllocationContentNestedImpl(item);
  }
  public A withClusterRoleScopeRestrictionContent(ClusterRoleScopeRestriction clusterRoleScopeRestrictionContent) {
    _visitables.get("content").remove(this.content);
    if (clusterRoleScopeRestrictionContent!=null){ this.content= new ClusterRoleScopeRestrictionBuilder(clusterRoleScopeRestrictionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ClusterRoleScopeRestrictionContentNested<A> withNewClusterRoleScopeRestrictionContent() {
    return new LocalResourceAccessReviewFluentImpl.ClusterRoleScopeRestrictionContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ClusterRoleScopeRestrictionContentNested<A> withNewClusterRoleScopeRestrictionContentLike(ClusterRoleScopeRestriction item) {
    return new LocalResourceAccessReviewFluentImpl.ClusterRoleScopeRestrictionContentNestedImpl(item);
  }
  public A withRouteContent(Route routeContent) {
    _visitables.get("content").remove(this.content);
    if (routeContent!=null){ this.content= new RouteBuilder(routeContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.RouteContentNested<A> withNewRouteContent() {
    return new LocalResourceAccessReviewFluentImpl.RouteContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.RouteContentNested<A> withNewRouteContentLike(Route item) {
    return new LocalResourceAccessReviewFluentImpl.RouteContentNestedImpl(item);
  }
  public A withSourceStrategyOptionsContent(SourceStrategyOptions sourceStrategyOptionsContent) {
    _visitables.get("content").remove(this.content);
    if (sourceStrategyOptionsContent!=null){ this.content= new SourceStrategyOptionsBuilder(sourceStrategyOptionsContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.SourceStrategyOptionsContentNested<A> withNewSourceStrategyOptionsContent() {
    return new LocalResourceAccessReviewFluentImpl.SourceStrategyOptionsContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.SourceStrategyOptionsContentNested<A> withNewSourceStrategyOptionsContentLike(SourceStrategyOptions item) {
    return new LocalResourceAccessReviewFluentImpl.SourceStrategyOptionsContentNestedImpl(item);
  }
  public A withNewSourceStrategyOptionsContent(Boolean incremental) {
    return (A)withSourceStrategyOptionsContent(new SourceStrategyOptions(incremental));
  }
  public A withClusterNetworkContent(ClusterNetwork clusterNetworkContent) {
    _visitables.get("content").remove(this.content);
    if (clusterNetworkContent!=null){ this.content= new ClusterNetworkBuilder(clusterNetworkContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ClusterNetworkContentNested<A> withNewClusterNetworkContent() {
    return new LocalResourceAccessReviewFluentImpl.ClusterNetworkContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ClusterNetworkContentNested<A> withNewClusterNetworkContentLike(ClusterNetwork item) {
    return new LocalResourceAccessReviewFluentImpl.ClusterNetworkContentNestedImpl(item);
  }
  public A withOAuthAuthorizeTokenContent(OAuthAuthorizeToken oAuthAuthorizeTokenContent) {
    _visitables.get("content").remove(this.content);
    if (oAuthAuthorizeTokenContent!=null){ this.content= new OAuthAuthorizeTokenBuilder(oAuthAuthorizeTokenContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.OAuthAuthorizeTokenContentNested<A> withNewOAuthAuthorizeTokenContent() {
    return new LocalResourceAccessReviewFluentImpl.OAuthAuthorizeTokenContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.OAuthAuthorizeTokenContentNested<A> withNewOAuthAuthorizeTokenContentLike(OAuthAuthorizeToken item) {
    return new LocalResourceAccessReviewFluentImpl.OAuthAuthorizeTokenContentNestedImpl(item);
  }
  public A withDockerBuildStrategyContent(DockerBuildStrategy dockerBuildStrategyContent) {
    _visitables.get("content").remove(this.content);
    if (dockerBuildStrategyContent!=null){ this.content= new DockerBuildStrategyBuilder(dockerBuildStrategyContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.DockerBuildStrategyContentNested<A> withNewDockerBuildStrategyContent() {
    return new LocalResourceAccessReviewFluentImpl.DockerBuildStrategyContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.DockerBuildStrategyContentNested<A> withNewDockerBuildStrategyContentLike(DockerBuildStrategy item) {
    return new LocalResourceAccessReviewFluentImpl.DockerBuildStrategyContentNestedImpl(item);
  }
  public A withSignatureConditionContent(SignatureCondition signatureConditionContent) {
    _visitables.get("content").remove(this.content);
    if (signatureConditionContent!=null){ this.content= new SignatureConditionBuilder(signatureConditionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.SignatureConditionContentNested<A> withNewSignatureConditionContent() {
    return new LocalResourceAccessReviewFluentImpl.SignatureConditionContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.SignatureConditionContentNested<A> withNewSignatureConditionContentLike(SignatureCondition item) {
    return new LocalResourceAccessReviewFluentImpl.SignatureConditionContentNestedImpl(item);
  }
  public A withUserOAuthAccessTokenContent(UserOAuthAccessToken userOAuthAccessTokenContent) {
    _visitables.get("content").remove(this.content);
    if (userOAuthAccessTokenContent!=null){ this.content= new UserOAuthAccessTokenBuilder(userOAuthAccessTokenContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.UserOAuthAccessTokenContentNested<A> withNewUserOAuthAccessTokenContent() {
    return new LocalResourceAccessReviewFluentImpl.UserOAuthAccessTokenContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.UserOAuthAccessTokenContentNested<A> withNewUserOAuthAccessTokenContentLike(UserOAuthAccessToken item) {
    return new LocalResourceAccessReviewFluentImpl.UserOAuthAccessTokenContentNestedImpl(item);
  }
  public A withRoleBindingRestrictionListContent(RoleBindingRestrictionList roleBindingRestrictionListContent) {
    _visitables.get("content").remove(this.content);
    if (roleBindingRestrictionListContent!=null){ this.content= new RoleBindingRestrictionListBuilder(roleBindingRestrictionListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.RoleBindingRestrictionListContentNested<A> withNewRoleBindingRestrictionListContent() {
    return new LocalResourceAccessReviewFluentImpl.RoleBindingRestrictionListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.RoleBindingRestrictionListContentNested<A> withNewRoleBindingRestrictionListContentLike(RoleBindingRestrictionList item) {
    return new LocalResourceAccessReviewFluentImpl.RoleBindingRestrictionListContentNestedImpl(item);
  }
  public A withSecurityContextConstraintsListContent(SecurityContextConstraintsList securityContextConstraintsListContent) {
    _visitables.get("content").remove(this.content);
    if (securityContextConstraintsListContent!=null){ this.content= new SecurityContextConstraintsListBuilder(securityContextConstraintsListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.SecurityContextConstraintsListContentNested<A> withNewSecurityContextConstraintsListContent() {
    return new LocalResourceAccessReviewFluentImpl.SecurityContextConstraintsListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.SecurityContextConstraintsListContentNested<A> withNewSecurityContextConstraintsListContentLike(SecurityContextConstraintsList item) {
    return new LocalResourceAccessReviewFluentImpl.SecurityContextConstraintsListContentNestedImpl(item);
  }
  public A withIdentityListContent(IdentityList identityListContent) {
    _visitables.get("content").remove(this.content);
    if (identityListContent!=null){ this.content= new IdentityListBuilder(identityListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.IdentityListContentNested<A> withNewIdentityListContent() {
    return new LocalResourceAccessReviewFluentImpl.IdentityListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.IdentityListContentNested<A> withNewIdentityListContentLike(IdentityList item) {
    return new LocalResourceAccessReviewFluentImpl.IdentityListContentNestedImpl(item);
  }
  public A withBuildConfigListContent(BuildConfigList buildConfigListContent) {
    _visitables.get("content").remove(this.content);
    if (buildConfigListContent!=null){ this.content= new BuildConfigListBuilder(buildConfigListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.BuildConfigListContentNested<A> withNewBuildConfigListContent() {
    return new LocalResourceAccessReviewFluentImpl.BuildConfigListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.BuildConfigListContentNested<A> withNewBuildConfigListContentLike(BuildConfigList item) {
    return new LocalResourceAccessReviewFluentImpl.BuildConfigListContentNestedImpl(item);
  }
  public A withClusterNetworkListContent(ClusterNetworkList clusterNetworkListContent) {
    _visitables.get("content").remove(this.content);
    if (clusterNetworkListContent!=null){ this.content= new ClusterNetworkListBuilder(clusterNetworkListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ClusterNetworkListContentNested<A> withNewClusterNetworkListContent() {
    return new LocalResourceAccessReviewFluentImpl.ClusterNetworkListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ClusterNetworkListContentNested<A> withNewClusterNetworkListContentLike(ClusterNetworkList item) {
    return new LocalResourceAccessReviewFluentImpl.ClusterNetworkListContentNestedImpl(item);
  }
  public A withTemplateInstanceConditionContent(TemplateInstanceCondition templateInstanceConditionContent) {
    _visitables.get("content").remove(this.content);
    if (templateInstanceConditionContent!=null){ this.content= new TemplateInstanceConditionBuilder(templateInstanceConditionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.TemplateInstanceConditionContentNested<A> withNewTemplateInstanceConditionContent() {
    return new LocalResourceAccessReviewFluentImpl.TemplateInstanceConditionContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.TemplateInstanceConditionContentNested<A> withNewTemplateInstanceConditionContentLike(TemplateInstanceCondition item) {
    return new LocalResourceAccessReviewFluentImpl.TemplateInstanceConditionContentNestedImpl(item);
  }
  public A withNewTemplateInstanceConditionContent(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withTemplateInstanceConditionContent(new TemplateInstanceCondition(lastTransitionTime, message, reason, status, type));
  }
  public A withRepositoryImportStatusContent(RepositoryImportStatus repositoryImportStatusContent) {
    _visitables.get("content").remove(this.content);
    if (repositoryImportStatusContent!=null){ this.content= new RepositoryImportStatusBuilder(repositoryImportStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.RepositoryImportStatusContentNested<A> withNewRepositoryImportStatusContent() {
    return new LocalResourceAccessReviewFluentImpl.RepositoryImportStatusContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.RepositoryImportStatusContentNested<A> withNewRepositoryImportStatusContentLike(RepositoryImportStatus item) {
    return new LocalResourceAccessReviewFluentImpl.RepositoryImportStatusContentNestedImpl(item);
  }
  public A withDeploymentCauseContent(DeploymentCause deploymentCauseContent) {
    _visitables.get("content").remove(this.content);
    if (deploymentCauseContent!=null){ this.content= new DeploymentCauseBuilder(deploymentCauseContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.DeploymentCauseContentNested<A> withNewDeploymentCauseContent() {
    return new LocalResourceAccessReviewFluentImpl.DeploymentCauseContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.DeploymentCauseContentNested<A> withNewDeploymentCauseContentLike(DeploymentCause item) {
    return new LocalResourceAccessReviewFluentImpl.DeploymentCauseContentNestedImpl(item);
  }
  public A withGroupListContent(GroupList groupListContent) {
    _visitables.get("content").remove(this.content);
    if (groupListContent!=null){ this.content= new GroupListBuilder(groupListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.GroupListContentNested<A> withNewGroupListContent() {
    return new LocalResourceAccessReviewFluentImpl.GroupListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.GroupListContentNested<A> withNewGroupListContentLike(GroupList item) {
    return new LocalResourceAccessReviewFluentImpl.GroupListContentNestedImpl(item);
  }
  public A withRunAsUserStrategyOptionsContent(RunAsUserStrategyOptions runAsUserStrategyOptionsContent) {
    _visitables.get("content").remove(this.content);
    if (runAsUserStrategyOptionsContent!=null){ this.content= new RunAsUserStrategyOptionsBuilder(runAsUserStrategyOptionsContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.RunAsUserStrategyOptionsContentNested<A> withNewRunAsUserStrategyOptionsContent() {
    return new LocalResourceAccessReviewFluentImpl.RunAsUserStrategyOptionsContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.RunAsUserStrategyOptionsContentNested<A> withNewRunAsUserStrategyOptionsContentLike(RunAsUserStrategyOptions item) {
    return new LocalResourceAccessReviewFluentImpl.RunAsUserStrategyOptionsContentNestedImpl(item);
  }
  public A withNewRunAsUserStrategyOptionsContent(String type,Long uid,Long uidRangeMax,Long uidRangeMin) {
    return (A)withRunAsUserStrategyOptionsContent(new RunAsUserStrategyOptions(type, uid, uidRangeMax, uidRangeMin));
  }
  public A withLifecycleHookContent(LifecycleHook lifecycleHookContent) {
    _visitables.get("content").remove(this.content);
    if (lifecycleHookContent!=null){ this.content= new LifecycleHookBuilder(lifecycleHookContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.LifecycleHookContentNested<A> withNewLifecycleHookContent() {
    return new LocalResourceAccessReviewFluentImpl.LifecycleHookContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.LifecycleHookContentNested<A> withNewLifecycleHookContentLike(LifecycleHook item) {
    return new LocalResourceAccessReviewFluentImpl.LifecycleHookContentNestedImpl(item);
  }
  public A withImageStreamTagReferenceContent(ImageStreamTagReference imageStreamTagReferenceContent) {
    _visitables.get("content").remove(this.content);
    if (imageStreamTagReferenceContent!=null){ this.content= new ImageStreamTagReferenceBuilder(imageStreamTagReferenceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ImageStreamTagReferenceContentNested<A> withNewImageStreamTagReferenceContent() {
    return new LocalResourceAccessReviewFluentImpl.ImageStreamTagReferenceContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ImageStreamTagReferenceContentNested<A> withNewImageStreamTagReferenceContentLike(ImageStreamTagReference item) {
    return new LocalResourceAccessReviewFluentImpl.ImageStreamTagReferenceContentNestedImpl(item);
  }
  public A withNewImageStreamTagReferenceContent(String name,String namespace) {
    return (A)withImageStreamTagReferenceContent(new ImageStreamTagReference(name, namespace));
  }
  public A withSourceControlUserContent(SourceControlUser sourceControlUserContent) {
    _visitables.get("content").remove(this.content);
    if (sourceControlUserContent!=null){ this.content= new SourceControlUserBuilder(sourceControlUserContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.SourceControlUserContentNested<A> withNewSourceControlUserContent() {
    return new LocalResourceAccessReviewFluentImpl.SourceControlUserContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.SourceControlUserContentNested<A> withNewSourceControlUserContentLike(SourceControlUser item) {
    return new LocalResourceAccessReviewFluentImpl.SourceControlUserContentNestedImpl(item);
  }
  public A withNewSourceControlUserContent(String email,String name) {
    return (A)withSourceControlUserContent(new SourceControlUser(email, name));
  }
  public A withContainerContent(Container containerContent) {
    _visitables.get("content").remove(this.content);
    if (containerContent!=null){ this.content= new ContainerBuilder(containerContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ContainerContentNested<A> withNewContainerContent() {
    return new LocalResourceAccessReviewFluentImpl.ContainerContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ContainerContentNested<A> withNewContainerContentLike(Container item) {
    return new LocalResourceAccessReviewFluentImpl.ContainerContentNestedImpl(item);
  }
  public A withImageStreamListContent(ImageStreamList imageStreamListContent) {
    _visitables.get("content").remove(this.content);
    if (imageStreamListContent!=null){ this.content= new ImageStreamListBuilder(imageStreamListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ImageStreamListContentNested<A> withNewImageStreamListContent() {
    return new LocalResourceAccessReviewFluentImpl.ImageStreamListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ImageStreamListContentNested<A> withNewImageStreamListContentLike(ImageStreamList item) {
    return new LocalResourceAccessReviewFluentImpl.ImageStreamListContentNestedImpl(item);
  }
  public A withClusterRoleBindingContent(ClusterRoleBinding clusterRoleBindingContent) {
    _visitables.get("content").remove(this.content);
    if (clusterRoleBindingContent!=null){ this.content= new ClusterRoleBindingBuilder(clusterRoleBindingContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ClusterRoleBindingContentNested<A> withNewClusterRoleBindingContent() {
    return new LocalResourceAccessReviewFluentImpl.ClusterRoleBindingContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ClusterRoleBindingContentNested<A> withNewClusterRoleBindingContentLike(ClusterRoleBinding item) {
    return new LocalResourceAccessReviewFluentImpl.ClusterRoleBindingContentNestedImpl(item);
  }
  public A withResourceAccessReviewContent(ResourceAccessReview resourceAccessReviewContent) {
    _visitables.get("content").remove(this.content);
    if (resourceAccessReviewContent!=null){ this.content= new ResourceAccessReviewBuilder(resourceAccessReviewContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ResourceAccessReviewContentNested<A> withNewResourceAccessReviewContent() {
    return new LocalResourceAccessReviewFluentImpl.ResourceAccessReviewContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ResourceAccessReviewContentNested<A> withNewResourceAccessReviewContentLike(ResourceAccessReview item) {
    return new LocalResourceAccessReviewFluentImpl.ResourceAccessReviewContentNestedImpl(item);
  }
  public A withSelfSubjectRulesReviewContent(SelfSubjectRulesReview selfSubjectRulesReviewContent) {
    _visitables.get("content").remove(this.content);
    if (selfSubjectRulesReviewContent!=null){ this.content= new SelfSubjectRulesReviewBuilder(selfSubjectRulesReviewContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.SelfSubjectRulesReviewContentNested<A> withNewSelfSubjectRulesReviewContent() {
    return new LocalResourceAccessReviewFluentImpl.SelfSubjectRulesReviewContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.SelfSubjectRulesReviewContentNested<A> withNewSelfSubjectRulesReviewContentLike(SelfSubjectRulesReview item) {
    return new LocalResourceAccessReviewFluentImpl.SelfSubjectRulesReviewContentNestedImpl(item);
  }
  public A withUserOAuthAccessTokenListContent(UserOAuthAccessTokenList userOAuthAccessTokenListContent) {
    _visitables.get("content").remove(this.content);
    if (userOAuthAccessTokenListContent!=null){ this.content= new UserOAuthAccessTokenListBuilder(userOAuthAccessTokenListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.UserOAuthAccessTokenListContentNested<A> withNewUserOAuthAccessTokenListContent() {
    return new LocalResourceAccessReviewFluentImpl.UserOAuthAccessTokenListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.UserOAuthAccessTokenListContentNested<A> withNewUserOAuthAccessTokenListContentLike(UserOAuthAccessTokenList item) {
    return new LocalResourceAccessReviewFluentImpl.UserOAuthAccessTokenListContentNestedImpl(item);
  }
  public A withImageChangeTriggerStatusContent(ImageChangeTriggerStatus imageChangeTriggerStatusContent) {
    _visitables.get("content").remove(this.content);
    if (imageChangeTriggerStatusContent!=null){ this.content= new ImageChangeTriggerStatusBuilder(imageChangeTriggerStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ImageChangeTriggerStatusContentNested<A> withNewImageChangeTriggerStatusContent() {
    return new LocalResourceAccessReviewFluentImpl.ImageChangeTriggerStatusContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ImageChangeTriggerStatusContentNested<A> withNewImageChangeTriggerStatusContentLike(ImageChangeTriggerStatus item) {
    return new LocalResourceAccessReviewFluentImpl.ImageChangeTriggerStatusContentNestedImpl(item);
  }
  public A withRouteStatusContent(RouteStatus routeStatusContent) {
    _visitables.get("content").remove(this.content);
    if (routeStatusContent!=null){ this.content= new RouteStatusBuilder(routeStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.RouteStatusContentNested<A> withNewRouteStatusContent() {
    return new LocalResourceAccessReviewFluentImpl.RouteStatusContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.RouteStatusContentNested<A> withNewRouteStatusContentLike(RouteStatus item) {
    return new LocalResourceAccessReviewFluentImpl.RouteStatusContentNestedImpl(item);
  }
  public A withClusterResourceQuotaContent(ClusterResourceQuota clusterResourceQuotaContent) {
    _visitables.get("content").remove(this.content);
    if (clusterResourceQuotaContent!=null){ this.content= new ClusterResourceQuotaBuilder(clusterResourceQuotaContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ClusterResourceQuotaContentNested<A> withNewClusterResourceQuotaContent() {
    return new LocalResourceAccessReviewFluentImpl.ClusterResourceQuotaContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ClusterResourceQuotaContentNested<A> withNewClusterResourceQuotaContentLike(ClusterResourceQuota item) {
    return new LocalResourceAccessReviewFluentImpl.ClusterResourceQuotaContentNestedImpl(item);
  }
  public A withNamedTagEventListContent(NamedTagEventList namedTagEventListContent) {
    _visitables.get("content").remove(this.content);
    if (namedTagEventListContent!=null){ this.content= new NamedTagEventListBuilder(namedTagEventListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.NamedTagEventListContentNested<A> withNewNamedTagEventListContent() {
    return new LocalResourceAccessReviewFluentImpl.NamedTagEventListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.NamedTagEventListContentNested<A> withNewNamedTagEventListContentLike(NamedTagEventList item) {
    return new LocalResourceAccessReviewFluentImpl.NamedTagEventListContentNestedImpl(item);
  }
  public A withClusterResourceQuotaListContent(ClusterResourceQuotaList clusterResourceQuotaListContent) {
    _visitables.get("content").remove(this.content);
    if (clusterResourceQuotaListContent!=null){ this.content= new ClusterResourceQuotaListBuilder(clusterResourceQuotaListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ClusterResourceQuotaListContentNested<A> withNewClusterResourceQuotaListContent() {
    return new LocalResourceAccessReviewFluentImpl.ClusterResourceQuotaListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ClusterResourceQuotaListContentNested<A> withNewClusterResourceQuotaListContentLike(ClusterResourceQuotaList item) {
    return new LocalResourceAccessReviewFluentImpl.ClusterResourceQuotaListContentNestedImpl(item);
  }
  public A withRouteSpecContent(RouteSpec routeSpecContent) {
    _visitables.get("content").remove(this.content);
    if (routeSpecContent!=null){ this.content= new RouteSpecBuilder(routeSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.RouteSpecContentNested<A> withNewRouteSpecContent() {
    return new LocalResourceAccessReviewFluentImpl.RouteSpecContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.RouteSpecContentNested<A> withNewRouteSpecContentLike(RouteSpec item) {
    return new LocalResourceAccessReviewFluentImpl.RouteSpecContentNestedImpl(item);
  }
  public A withProjectRequestContent(ProjectRequest projectRequestContent) {
    _visitables.get("content").remove(this.content);
    if (projectRequestContent!=null){ this.content= new ProjectRequestBuilder(projectRequestContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ProjectRequestContentNested<A> withNewProjectRequestContent() {
    return new LocalResourceAccessReviewFluentImpl.ProjectRequestContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ProjectRequestContentNested<A> withNewProjectRequestContentLike(ProjectRequest item) {
    return new LocalResourceAccessReviewFluentImpl.ProjectRequestContentNestedImpl(item);
  }
  public A withTemplateContent(Template templateContent) {
    _visitables.get("content").remove(this.content);
    if (templateContent!=null){ this.content= new TemplateBuilder(templateContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.TemplateContentNested<A> withNewTemplateContent() {
    return new LocalResourceAccessReviewFluentImpl.TemplateContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.TemplateContentNested<A> withNewTemplateContentLike(Template item) {
    return new LocalResourceAccessReviewFluentImpl.TemplateContentNestedImpl(item);
  }
  public A withImageLookupPolicyContent(ImageLookupPolicy imageLookupPolicyContent) {
    _visitables.get("content").remove(this.content);
    if (imageLookupPolicyContent!=null){ this.content= new ImageLookupPolicyBuilder(imageLookupPolicyContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ImageLookupPolicyContentNested<A> withNewImageLookupPolicyContent() {
    return new LocalResourceAccessReviewFluentImpl.ImageLookupPolicyContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ImageLookupPolicyContentNested<A> withNewImageLookupPolicyContentLike(ImageLookupPolicy item) {
    return new LocalResourceAccessReviewFluentImpl.ImageLookupPolicyContentNestedImpl(item);
  }
  public A withNewImageLookupPolicyContent(Boolean local) {
    return (A)withImageLookupPolicyContent(new ImageLookupPolicy(local));
  }
  public A withOAuthClientAuthorizationContent(OAuthClientAuthorization oAuthClientAuthorizationContent) {
    _visitables.get("content").remove(this.content);
    if (oAuthClientAuthorizationContent!=null){ this.content= new OAuthClientAuthorizationBuilder(oAuthClientAuthorizationContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.OAuthClientAuthorizationContentNested<A> withNewOAuthClientAuthorizationContent() {
    return new LocalResourceAccessReviewFluentImpl.OAuthClientAuthorizationContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.OAuthClientAuthorizationContentNested<A> withNewOAuthClientAuthorizationContentLike(OAuthClientAuthorization item) {
    return new LocalResourceAccessReviewFluentImpl.OAuthClientAuthorizationContentNestedImpl(item);
  }
  public A withImageChangeCauseContent(ImageChangeCause imageChangeCauseContent) {
    _visitables.get("content").remove(this.content);
    if (imageChangeCauseContent!=null){ this.content= new ImageChangeCauseBuilder(imageChangeCauseContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ImageChangeCauseContentNested<A> withNewImageChangeCauseContent() {
    return new LocalResourceAccessReviewFluentImpl.ImageChangeCauseContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ImageChangeCauseContentNested<A> withNewImageChangeCauseContentLike(ImageChangeCause item) {
    return new LocalResourceAccessReviewFluentImpl.ImageChangeCauseContentNestedImpl(item);
  }
  public A withAllowedFlexVolumeContent(AllowedFlexVolume allowedFlexVolumeContent) {
    _visitables.get("content").remove(this.content);
    if (allowedFlexVolumeContent!=null){ this.content= new AllowedFlexVolumeBuilder(allowedFlexVolumeContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.AllowedFlexVolumeContentNested<A> withNewAllowedFlexVolumeContent() {
    return new LocalResourceAccessReviewFluentImpl.AllowedFlexVolumeContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.AllowedFlexVolumeContentNested<A> withNewAllowedFlexVolumeContentLike(AllowedFlexVolume item) {
    return new LocalResourceAccessReviewFluentImpl.AllowedFlexVolumeContentNestedImpl(item);
  }
  public A withNewAllowedFlexVolumeContent(String driver) {
    return (A)withAllowedFlexVolumeContent(new AllowedFlexVolume(driver));
  }
  public A withSubjectAccessReviewContent(SubjectAccessReview subjectAccessReviewContent) {
    _visitables.get("content").remove(this.content);
    if (subjectAccessReviewContent!=null){ this.content= new SubjectAccessReviewBuilder(subjectAccessReviewContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.SubjectAccessReviewContentNested<A> withNewSubjectAccessReviewContent() {
    return new LocalResourceAccessReviewFluentImpl.SubjectAccessReviewContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.SubjectAccessReviewContentNested<A> withNewSubjectAccessReviewContentLike(SubjectAccessReview item) {
    return new LocalResourceAccessReviewFluentImpl.SubjectAccessReviewContentNestedImpl(item);
  }
  public A withLocalResourceAccessReviewContent(LocalResourceAccessReview localResourceAccessReviewContent) {
    _visitables.get("content").remove(this.content);
    if (localResourceAccessReviewContent!=null){ this.content= new LocalResourceAccessReviewBuilder(localResourceAccessReviewContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.LocalResourceAccessReviewContentNested<A> withNewLocalResourceAccessReviewContent() {
    return new LocalResourceAccessReviewFluentImpl.LocalResourceAccessReviewContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.LocalResourceAccessReviewContentNested<A> withNewLocalResourceAccessReviewContentLike(LocalResourceAccessReview item) {
    return new LocalResourceAccessReviewFluentImpl.LocalResourceAccessReviewContentNestedImpl(item);
  }
  public A withClusterRoleContent(ClusterRole clusterRoleContent) {
    _visitables.get("content").remove(this.content);
    if (clusterRoleContent!=null){ this.content= new ClusterRoleBuilder(clusterRoleContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ClusterRoleContentNested<A> withNewClusterRoleContent() {
    return new LocalResourceAccessReviewFluentImpl.ClusterRoleContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ClusterRoleContentNested<A> withNewClusterRoleContentLike(ClusterRole item) {
    return new LocalResourceAccessReviewFluentImpl.ClusterRoleContentNestedImpl(item);
  }
  public A withConnectionConfigContent(ConnectionConfig connectionConfigContent) {
    _visitables.get("content").remove(this.content);
    if (connectionConfigContent!=null){ this.content= new ConnectionConfigBuilder(connectionConfigContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ConnectionConfigContentNested<A> withNewConnectionConfigContent() {
    return new LocalResourceAccessReviewFluentImpl.ConnectionConfigContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ConnectionConfigContentNested<A> withNewConnectionConfigContentLike(ConnectionConfig item) {
    return new LocalResourceAccessReviewFluentImpl.ConnectionConfigContentNestedImpl(item);
  }
  public A withTagEventConditionContent(TagEventCondition tagEventConditionContent) {
    _visitables.get("content").remove(this.content);
    if (tagEventConditionContent!=null){ this.content= new TagEventConditionBuilder(tagEventConditionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.TagEventConditionContentNested<A> withNewTagEventConditionContent() {
    return new LocalResourceAccessReviewFluentImpl.TagEventConditionContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.TagEventConditionContentNested<A> withNewTagEventConditionContentLike(TagEventCondition item) {
    return new LocalResourceAccessReviewFluentImpl.TagEventConditionContentNestedImpl(item);
  }
  public A withLabelSelectorContent(LabelSelector labelSelectorContent) {
    _visitables.get("content").remove(this.content);
    if (labelSelectorContent!=null){ this.content= new LabelSelectorBuilder(labelSelectorContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.LabelSelectorContentNested<A> withNewLabelSelectorContent() {
    return new LocalResourceAccessReviewFluentImpl.LabelSelectorContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.LabelSelectorContentNested<A> withNewLabelSelectorContentLike(LabelSelector item) {
    return new LocalResourceAccessReviewFluentImpl.LabelSelectorContentNestedImpl(item);
  }
  public A withNetNamespaceListContent(NetNamespaceList netNamespaceListContent) {
    _visitables.get("content").remove(this.content);
    if (netNamespaceListContent!=null){ this.content= new NetNamespaceListBuilder(netNamespaceListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.NetNamespaceListContentNested<A> withNewNetNamespaceListContent() {
    return new LocalResourceAccessReviewFluentImpl.NetNamespaceListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.NetNamespaceListContentNested<A> withNewNetNamespaceListContentLike(NetNamespaceList item) {
    return new LocalResourceAccessReviewFluentImpl.NetNamespaceListContentNestedImpl(item);
  }
  public A withBrokerTemplateInstanceSpecContent(BrokerTemplateInstanceSpec brokerTemplateInstanceSpecContent) {
    _visitables.get("content").remove(this.content);
    if (brokerTemplateInstanceSpecContent!=null){ this.content= new BrokerTemplateInstanceSpecBuilder(brokerTemplateInstanceSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.BrokerTemplateInstanceSpecContentNested<A> withNewBrokerTemplateInstanceSpecContent() {
    return new LocalResourceAccessReviewFluentImpl.BrokerTemplateInstanceSpecContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.BrokerTemplateInstanceSpecContentNested<A> withNewBrokerTemplateInstanceSpecContentLike(BrokerTemplateInstanceSpec item) {
    return new LocalResourceAccessReviewFluentImpl.BrokerTemplateInstanceSpecContentNestedImpl(item);
  }
  public A withBinaryBuildSourceContent(BinaryBuildSource binaryBuildSourceContent) {
    _visitables.get("content").remove(this.content);
    if (binaryBuildSourceContent!=null){ this.content= new BinaryBuildSourceBuilder(binaryBuildSourceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.BinaryBuildSourceContentNested<A> withNewBinaryBuildSourceContent() {
    return new LocalResourceAccessReviewFluentImpl.BinaryBuildSourceContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.BinaryBuildSourceContentNested<A> withNewBinaryBuildSourceContentLike(BinaryBuildSource item) {
    return new LocalResourceAccessReviewFluentImpl.BinaryBuildSourceContentNestedImpl(item);
  }
  public A withNewBinaryBuildSourceContent(String asFile) {
    return (A)withBinaryBuildSourceContent(new BinaryBuildSource(asFile));
  }
  public A withOAuthClientAuthorizationListContent(OAuthClientAuthorizationList oAuthClientAuthorizationListContent) {
    _visitables.get("content").remove(this.content);
    if (oAuthClientAuthorizationListContent!=null){ this.content= new OAuthClientAuthorizationListBuilder(oAuthClientAuthorizationListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.OAuthClientAuthorizationListContentNested<A> withNewOAuthClientAuthorizationListContent() {
    return new LocalResourceAccessReviewFluentImpl.OAuthClientAuthorizationListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.OAuthClientAuthorizationListContentNested<A> withNewOAuthClientAuthorizationListContentLike(OAuthClientAuthorizationList item) {
    return new LocalResourceAccessReviewFluentImpl.OAuthClientAuthorizationListContentNestedImpl(item);
  }
  public A withBuildSpecContent(BuildSpec buildSpecContent) {
    _visitables.get("content").remove(this.content);
    if (buildSpecContent!=null){ this.content= new BuildSpecBuilder(buildSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.BuildSpecContentNested<A> withNewBuildSpecContent() {
    return new LocalResourceAccessReviewFluentImpl.BuildSpecContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.BuildSpecContentNested<A> withNewBuildSpecContentLike(BuildSpec item) {
    return new LocalResourceAccessReviewFluentImpl.BuildSpecContentNestedImpl(item);
  }
  public A withProjectStatusContent(ProjectStatus projectStatusContent) {
    _visitables.get("content").remove(this.content);
    if (projectStatusContent!=null){ this.content= new ProjectStatusBuilder(projectStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ProjectStatusContentNested<A> withNewProjectStatusContent() {
    return new LocalResourceAccessReviewFluentImpl.ProjectStatusContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ProjectStatusContentNested<A> withNewProjectStatusContentLike(ProjectStatus item) {
    return new LocalResourceAccessReviewFluentImpl.ProjectStatusContentNestedImpl(item);
  }
  public A withLocalSubjectAccessReviewContent(LocalSubjectAccessReview localSubjectAccessReviewContent) {
    _visitables.get("content").remove(this.content);
    if (localSubjectAccessReviewContent!=null){ this.content= new LocalSubjectAccessReviewBuilder(localSubjectAccessReviewContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.LocalSubjectAccessReviewContentNested<A> withNewLocalSubjectAccessReviewContent() {
    return new LocalResourceAccessReviewFluentImpl.LocalSubjectAccessReviewContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.LocalSubjectAccessReviewContentNested<A> withNewLocalSubjectAccessReviewContentLike(LocalSubjectAccessReview item) {
    return new LocalResourceAccessReviewFluentImpl.LocalSubjectAccessReviewContentNestedImpl(item);
  }
  public A withRollingDeploymentStrategyParamsContent(RollingDeploymentStrategyParams rollingDeploymentStrategyParamsContent) {
    _visitables.get("content").remove(this.content);
    if (rollingDeploymentStrategyParamsContent!=null){ this.content= new RollingDeploymentStrategyParamsBuilder(rollingDeploymentStrategyParamsContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.RollingDeploymentStrategyParamsContentNested<A> withNewRollingDeploymentStrategyParamsContent() {
    return new LocalResourceAccessReviewFluentImpl.RollingDeploymentStrategyParamsContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.RollingDeploymentStrategyParamsContentNested<A> withNewRollingDeploymentStrategyParamsContentLike(RollingDeploymentStrategyParams item) {
    return new LocalResourceAccessReviewFluentImpl.RollingDeploymentStrategyParamsContentNestedImpl(item);
  }
  public A withGitSourceRevisionContent(GitSourceRevision gitSourceRevisionContent) {
    _visitables.get("content").remove(this.content);
    if (gitSourceRevisionContent!=null){ this.content= new GitSourceRevisionBuilder(gitSourceRevisionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.GitSourceRevisionContentNested<A> withNewGitSourceRevisionContent() {
    return new LocalResourceAccessReviewFluentImpl.GitSourceRevisionContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.GitSourceRevisionContentNested<A> withNewGitSourceRevisionContentLike(GitSourceRevision item) {
    return new LocalResourceAccessReviewFluentImpl.GitSourceRevisionContentNestedImpl(item);
  }
  public A withImageLabelContent(ImageLabel imageLabelContent) {
    _visitables.get("content").remove(this.content);
    if (imageLabelContent!=null){ this.content= new ImageLabelBuilder(imageLabelContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ImageLabelContentNested<A> withNewImageLabelContent() {
    return new LocalResourceAccessReviewFluentImpl.ImageLabelContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ImageLabelContentNested<A> withNewImageLabelContentLike(ImageLabel item) {
    return new LocalResourceAccessReviewFluentImpl.ImageLabelContentNestedImpl(item);
  }
  public A withNewImageLabelContent(String name,String value) {
    return (A)withImageLabelContent(new ImageLabel(name, value));
  }
  public A withImageChangeTriggerContent(ImageChangeTrigger imageChangeTriggerContent) {
    _visitables.get("content").remove(this.content);
    if (imageChangeTriggerContent!=null){ this.content= new ImageChangeTriggerBuilder(imageChangeTriggerContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ImageChangeTriggerContentNested<A> withNewImageChangeTriggerContent() {
    return new LocalResourceAccessReviewFluentImpl.ImageChangeTriggerContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ImageChangeTriggerContentNested<A> withNewImageChangeTriggerContentLike(ImageChangeTrigger item) {
    return new LocalResourceAccessReviewFluentImpl.ImageChangeTriggerContentNestedImpl(item);
  }
  public A withPodSecurityPolicyReviewSpecContent(PodSecurityPolicyReviewSpec podSecurityPolicyReviewSpecContent) {
    _visitables.get("content").remove(this.content);
    if (podSecurityPolicyReviewSpecContent!=null){ this.content= new PodSecurityPolicyReviewSpecBuilder(podSecurityPolicyReviewSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.PodSecurityPolicyReviewSpecContentNested<A> withNewPodSecurityPolicyReviewSpecContent() {
    return new LocalResourceAccessReviewFluentImpl.PodSecurityPolicyReviewSpecContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.PodSecurityPolicyReviewSpecContentNested<A> withNewPodSecurityPolicyReviewSpecContentLike(PodSecurityPolicyReviewSpec item) {
    return new LocalResourceAccessReviewFluentImpl.PodSecurityPolicyReviewSpecContentNestedImpl(item);
  }
  public A withImageTagContent(ImageTag imageTagContent) {
    _visitables.get("content").remove(this.content);
    if (imageTagContent!=null){ this.content= new ImageTagBuilder(imageTagContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ImageTagContentNested<A> withNewImageTagContent() {
    return new LocalResourceAccessReviewFluentImpl.ImageTagContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ImageTagContentNested<A> withNewImageTagContentLike(ImageTag item) {
    return new LocalResourceAccessReviewFluentImpl.ImageTagContentNestedImpl(item);
  }
  public A withImageStreamImportSpecContent(ImageStreamImportSpec imageStreamImportSpecContent) {
    _visitables.get("content").remove(this.content);
    if (imageStreamImportSpecContent!=null){ this.content= new ImageStreamImportSpecBuilder(imageStreamImportSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ImageStreamImportSpecContentNested<A> withNewImageStreamImportSpecContent() {
    return new LocalResourceAccessReviewFluentImpl.ImageStreamImportSpecContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ImageStreamImportSpecContentNested<A> withNewImageStreamImportSpecContentLike(ImageStreamImportSpec item) {
    return new LocalResourceAccessReviewFluentImpl.ImageStreamImportSpecContentNestedImpl(item);
  }
  public A withFSGroupStrategyOptionsContent(FSGroupStrategyOptions fSGroupStrategyOptionsContent) {
    _visitables.get("content").remove(this.content);
    if (fSGroupStrategyOptionsContent!=null){ this.content= new FSGroupStrategyOptionsBuilder(fSGroupStrategyOptionsContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.FSGroupStrategyOptionsContentNested<A> withNewFSGroupStrategyOptionsContent() {
    return new LocalResourceAccessReviewFluentImpl.FSGroupStrategyOptionsContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.FSGroupStrategyOptionsContentNested<A> withNewFSGroupStrategyOptionsContentLike(FSGroupStrategyOptions item) {
    return new LocalResourceAccessReviewFluentImpl.FSGroupStrategyOptionsContentNestedImpl(item);
  }
  public A withPodSecurityPolicyReviewContent(PodSecurityPolicyReview podSecurityPolicyReviewContent) {
    _visitables.get("content").remove(this.content);
    if (podSecurityPolicyReviewContent!=null){ this.content= new PodSecurityPolicyReviewBuilder(podSecurityPolicyReviewContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.PodSecurityPolicyReviewContentNested<A> withNewPodSecurityPolicyReviewContent() {
    return new LocalResourceAccessReviewFluentImpl.PodSecurityPolicyReviewContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.PodSecurityPolicyReviewContentNested<A> withNewPodSecurityPolicyReviewContentLike(PodSecurityPolicyReview item) {
    return new LocalResourceAccessReviewFluentImpl.PodSecurityPolicyReviewContentNestedImpl(item);
  }
  public A withRecreateDeploymentStrategyParamsContent(RecreateDeploymentStrategyParams recreateDeploymentStrategyParamsContent) {
    _visitables.get("content").remove(this.content);
    if (recreateDeploymentStrategyParamsContent!=null){ this.content= new RecreateDeploymentStrategyParamsBuilder(recreateDeploymentStrategyParamsContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.RecreateDeploymentStrategyParamsContentNested<A> withNewRecreateDeploymentStrategyParamsContent() {
    return new LocalResourceAccessReviewFluentImpl.RecreateDeploymentStrategyParamsContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.RecreateDeploymentStrategyParamsContentNested<A> withNewRecreateDeploymentStrategyParamsContentLike(RecreateDeploymentStrategyParams item) {
    return new LocalResourceAccessReviewFluentImpl.RecreateDeploymentStrategyParamsContentNestedImpl(item);
  }
  public A withDockerStrategyOptionsContent(DockerStrategyOptions dockerStrategyOptionsContent) {
    _visitables.get("content").remove(this.content);
    if (dockerStrategyOptionsContent!=null){ this.content= new DockerStrategyOptionsBuilder(dockerStrategyOptionsContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.DockerStrategyOptionsContentNested<A> withNewDockerStrategyOptionsContent() {
    return new LocalResourceAccessReviewFluentImpl.DockerStrategyOptionsContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.DockerStrategyOptionsContentNested<A> withNewDockerStrategyOptionsContentLike(DockerStrategyOptions item) {
    return new LocalResourceAccessReviewFluentImpl.DockerStrategyOptionsContentNestedImpl(item);
  }
  public A withImageListContent(ImageList imageListContent) {
    _visitables.get("content").remove(this.content);
    if (imageListContent!=null){ this.content= new ImageListBuilder(imageListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ImageListContentNested<A> withNewImageListContent() {
    return new LocalResourceAccessReviewFluentImpl.ImageListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ImageListContentNested<A> withNewImageListContentLike(ImageList item) {
    return new LocalResourceAccessReviewFluentImpl.ImageListContentNestedImpl(item);
  }
  public A withConfigMapBuildSourceContent(ConfigMapBuildSource configMapBuildSourceContent) {
    _visitables.get("content").remove(this.content);
    if (configMapBuildSourceContent!=null){ this.content= new ConfigMapBuildSourceBuilder(configMapBuildSourceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ConfigMapBuildSourceContentNested<A> withNewConfigMapBuildSourceContent() {
    return new LocalResourceAccessReviewFluentImpl.ConfigMapBuildSourceContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ConfigMapBuildSourceContentNested<A> withNewConfigMapBuildSourceContentLike(ConfigMapBuildSource item) {
    return new LocalResourceAccessReviewFluentImpl.ConfigMapBuildSourceContentNestedImpl(item);
  }
  public A withImageTagListContent(ImageTagList imageTagListContent) {
    _visitables.get("content").remove(this.content);
    if (imageTagListContent!=null){ this.content= new ImageTagListBuilder(imageTagListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ImageTagListContentNested<A> withNewImageTagListContent() {
    return new LocalResourceAccessReviewFluentImpl.ImageTagListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ImageTagListContentNested<A> withNewImageTagListContentLike(ImageTagList item) {
    return new LocalResourceAccessReviewFluentImpl.ImageTagListContentNestedImpl(item);
  }
  public A withOAuthAccessTokenContent(OAuthAccessToken oAuthAccessTokenContent) {
    _visitables.get("content").remove(this.content);
    if (oAuthAccessTokenContent!=null){ this.content= new OAuthAccessTokenBuilder(oAuthAccessTokenContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.OAuthAccessTokenContentNested<A> withNewOAuthAccessTokenContent() {
    return new LocalResourceAccessReviewFluentImpl.OAuthAccessTokenContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.OAuthAccessTokenContentNested<A> withNewOAuthAccessTokenContentLike(OAuthAccessToken item) {
    return new LocalResourceAccessReviewFluentImpl.OAuthAccessTokenContentNestedImpl(item);
  }
  public A withDeploymentConfigContent(DeploymentConfig deploymentConfigContent) {
    _visitables.get("content").remove(this.content);
    if (deploymentConfigContent!=null){ this.content= new DeploymentConfigBuilder(deploymentConfigContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.DeploymentConfigContentNested<A> withNewDeploymentConfigContent() {
    return new LocalResourceAccessReviewFluentImpl.DeploymentConfigContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.DeploymentConfigContentNested<A> withNewDeploymentConfigContentLike(DeploymentConfig item) {
    return new LocalResourceAccessReviewFluentImpl.DeploymentConfigContentNestedImpl(item);
  }
  public A withRoleBindingContent(RoleBinding roleBindingContent) {
    _visitables.get("content").remove(this.content);
    if (roleBindingContent!=null){ this.content= new RoleBindingBuilder(roleBindingContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.RoleBindingContentNested<A> withNewRoleBindingContent() {
    return new LocalResourceAccessReviewFluentImpl.RoleBindingContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.RoleBindingContentNested<A> withNewRoleBindingContentLike(RoleBinding item) {
    return new LocalResourceAccessReviewFluentImpl.RoleBindingContentNestedImpl(item);
  }
  public A withImageContent(Image imageContent) {
    _visitables.get("content").remove(this.content);
    if (imageContent!=null){ this.content= new ImageBuilder(imageContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ImageContentNested<A> withNewImageContent() {
    return new LocalResourceAccessReviewFluentImpl.ImageContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ImageContentNested<A> withNewImageContentLike(Image item) {
    return new LocalResourceAccessReviewFluentImpl.ImageContentNestedImpl(item);
  }
  public A withTLSConfigContent(TLSConfig tLSConfigContent) {
    _visitables.get("content").remove(this.content);
    if (tLSConfigContent!=null){ this.content= new TLSConfigBuilder(tLSConfigContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.TLSConfigContentNested<A> withNewTLSConfigContent() {
    return new LocalResourceAccessReviewFluentImpl.TLSConfigContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.TLSConfigContentNested<A> withNewTLSConfigContentLike(TLSConfig item) {
    return new LocalResourceAccessReviewFluentImpl.TLSConfigContentNestedImpl(item);
  }
  public A withBuildVolumeContent(BuildVolume buildVolumeContent) {
    _visitables.get("content").remove(this.content);
    if (buildVolumeContent!=null){ this.content= new BuildVolumeBuilder(buildVolumeContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.BuildVolumeContentNested<A> withNewBuildVolumeContent() {
    return new LocalResourceAccessReviewFluentImpl.BuildVolumeContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.BuildVolumeContentNested<A> withNewBuildVolumeContentLike(BuildVolume item) {
    return new LocalResourceAccessReviewFluentImpl.BuildVolumeContentNestedImpl(item);
  }
  public A withTemplateInstanceSpecContent(TemplateInstanceSpec templateInstanceSpecContent) {
    _visitables.get("content").remove(this.content);
    if (templateInstanceSpecContent!=null){ this.content= new TemplateInstanceSpecBuilder(templateInstanceSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.TemplateInstanceSpecContentNested<A> withNewTemplateInstanceSpecContent() {
    return new LocalResourceAccessReviewFluentImpl.TemplateInstanceSpecContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.TemplateInstanceSpecContentNested<A> withNewTemplateInstanceSpecContentLike(TemplateInstanceSpec item) {
    return new LocalResourceAccessReviewFluentImpl.TemplateInstanceSpecContentNestedImpl(item);
  }
  public A withBuildStatusContent(BuildStatus buildStatusContent) {
    _visitables.get("content").remove(this.content);
    if (buildStatusContent!=null){ this.content= new BuildStatusBuilder(buildStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.BuildStatusContentNested<A> withNewBuildStatusContent() {
    return new LocalResourceAccessReviewFluentImpl.BuildStatusContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.BuildStatusContentNested<A> withNewBuildStatusContentLike(BuildStatus item) {
    return new LocalResourceAccessReviewFluentImpl.BuildStatusContentNestedImpl(item);
  }
  public A withImageSourceContent(ImageSource imageSourceContent) {
    _visitables.get("content").remove(this.content);
    if (imageSourceContent!=null){ this.content= new ImageSourceBuilder(imageSourceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ImageSourceContentNested<A> withNewImageSourceContent() {
    return new LocalResourceAccessReviewFluentImpl.ImageSourceContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ImageSourceContentNested<A> withNewImageSourceContentLike(ImageSource item) {
    return new LocalResourceAccessReviewFluentImpl.ImageSourceContentNestedImpl(item);
  }
  public A withObjectMetaContent(ObjectMeta objectMetaContent) {
    _visitables.get("content").remove(this.content);
    if (objectMetaContent!=null){ this.content= new ObjectMetaBuilder(objectMetaContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ObjectMetaContentNested<A> withNewObjectMetaContent() {
    return new LocalResourceAccessReviewFluentImpl.ObjectMetaContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ObjectMetaContentNested<A> withNewObjectMetaContentLike(ObjectMeta item) {
    return new LocalResourceAccessReviewFluentImpl.ObjectMetaContentNestedImpl(item);
  }
  public A withPersistentVolumeClaimContent(PersistentVolumeClaim persistentVolumeClaimContent) {
    _visitables.get("content").remove(this.content);
    if (persistentVolumeClaimContent!=null){ this.content= new PersistentVolumeClaimBuilder(persistentVolumeClaimContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.PersistentVolumeClaimContentNested<A> withNewPersistentVolumeClaimContent() {
    return new LocalResourceAccessReviewFluentImpl.PersistentVolumeClaimContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.PersistentVolumeClaimContentNested<A> withNewPersistentVolumeClaimContentLike(PersistentVolumeClaim item) {
    return new LocalResourceAccessReviewFluentImpl.PersistentVolumeClaimContentNestedImpl(item);
  }
  public A withPodSecurityPolicySelfSubjectReviewContent(PodSecurityPolicySelfSubjectReview podSecurityPolicySelfSubjectReviewContent) {
    _visitables.get("content").remove(this.content);
    if (podSecurityPolicySelfSubjectReviewContent!=null){ this.content= new PodSecurityPolicySelfSubjectReviewBuilder(podSecurityPolicySelfSubjectReviewContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.PodSecurityPolicySelfSubjectReviewContentNested<A> withNewPodSecurityPolicySelfSubjectReviewContent() {
    return new LocalResourceAccessReviewFluentImpl.PodSecurityPolicySelfSubjectReviewContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.PodSecurityPolicySelfSubjectReviewContentNested<A> withNewPodSecurityPolicySelfSubjectReviewContentLike(PodSecurityPolicySelfSubjectReview item) {
    return new LocalResourceAccessReviewFluentImpl.PodSecurityPolicySelfSubjectReviewContentNestedImpl(item);
  }
  public A withTagReferenceContent(TagReference tagReferenceContent) {
    _visitables.get("content").remove(this.content);
    if (tagReferenceContent!=null){ this.content= new TagReferenceBuilder(tagReferenceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.TagReferenceContentNested<A> withNewTagReferenceContent() {
    return new LocalResourceAccessReviewFluentImpl.TagReferenceContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.TagReferenceContentNested<A> withNewTagReferenceContentLike(TagReference item) {
    return new LocalResourceAccessReviewFluentImpl.TagReferenceContentNestedImpl(item);
  }
  public A withEgressNetworkPolicyRuleContent(EgressNetworkPolicyRule egressNetworkPolicyRuleContent) {
    _visitables.get("content").remove(this.content);
    if (egressNetworkPolicyRuleContent!=null){ this.content= new EgressNetworkPolicyRuleBuilder(egressNetworkPolicyRuleContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.EgressNetworkPolicyRuleContentNested<A> withNewEgressNetworkPolicyRuleContent() {
    return new LocalResourceAccessReviewFluentImpl.EgressNetworkPolicyRuleContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.EgressNetworkPolicyRuleContentNested<A> withNewEgressNetworkPolicyRuleContentLike(EgressNetworkPolicyRule item) {
    return new LocalResourceAccessReviewFluentImpl.EgressNetworkPolicyRuleContentNestedImpl(item);
  }
  public A withSubjectRulesReviewStatusContent(SubjectRulesReviewStatus subjectRulesReviewStatusContent) {
    _visitables.get("content").remove(this.content);
    if (subjectRulesReviewStatusContent!=null){ this.content= new SubjectRulesReviewStatusBuilder(subjectRulesReviewStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.SubjectRulesReviewStatusContentNested<A> withNewSubjectRulesReviewStatusContent() {
    return new LocalResourceAccessReviewFluentImpl.SubjectRulesReviewStatusContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.SubjectRulesReviewStatusContentNested<A> withNewSubjectRulesReviewStatusContentLike(SubjectRulesReviewStatus item) {
    return new LocalResourceAccessReviewFluentImpl.SubjectRulesReviewStatusContentNestedImpl(item);
  }
  public A withBuildVolumeMountContent(BuildVolumeMount buildVolumeMountContent) {
    _visitables.get("content").remove(this.content);
    if (buildVolumeMountContent!=null){ this.content= new BuildVolumeMountBuilder(buildVolumeMountContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.BuildVolumeMountContentNested<A> withNewBuildVolumeMountContent() {
    return new LocalResourceAccessReviewFluentImpl.BuildVolumeMountContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.BuildVolumeMountContentNested<A> withNewBuildVolumeMountContentLike(BuildVolumeMount item) {
    return new LocalResourceAccessReviewFluentImpl.BuildVolumeMountContentNestedImpl(item);
  }
  public A withNewBuildVolumeMountContent(String destinationPath) {
    return (A)withBuildVolumeMountContent(new BuildVolumeMount(destinationPath));
  }
  public A withClusterNetworkEntryContent(ClusterNetworkEntry clusterNetworkEntryContent) {
    _visitables.get("content").remove(this.content);
    if (clusterNetworkEntryContent!=null){ this.content= new ClusterNetworkEntryBuilder(clusterNetworkEntryContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ClusterNetworkEntryContentNested<A> withNewClusterNetworkEntryContent() {
    return new LocalResourceAccessReviewFluentImpl.ClusterNetworkEntryContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ClusterNetworkEntryContentNested<A> withNewClusterNetworkEntryContentLike(ClusterNetworkEntry item) {
    return new LocalResourceAccessReviewFluentImpl.ClusterNetworkEntryContentNestedImpl(item);
  }
  public A withNewClusterNetworkEntryContent(String cidr,Integer hostSubnetLength) {
    return (A)withClusterNetworkEntryContent(new ClusterNetworkEntry(cidr, hostSubnetLength));
  }
  public A withTemplateInstanceObjectContent(TemplateInstanceObject templateInstanceObjectContent) {
    _visitables.get("content").remove(this.content);
    if (templateInstanceObjectContent!=null){ this.content= new TemplateInstanceObjectBuilder(templateInstanceObjectContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.TemplateInstanceObjectContentNested<A> withNewTemplateInstanceObjectContent() {
    return new LocalResourceAccessReviewFluentImpl.TemplateInstanceObjectContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.TemplateInstanceObjectContentNested<A> withNewTemplateInstanceObjectContentLike(TemplateInstanceObject item) {
    return new LocalResourceAccessReviewFluentImpl.TemplateInstanceObjectContentNestedImpl(item);
  }
  public A withBuildSourceContent(BuildSource buildSourceContent) {
    _visitables.get("content").remove(this.content);
    if (buildSourceContent!=null){ this.content= new BuildSourceBuilder(buildSourceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.BuildSourceContentNested<A> withNewBuildSourceContent() {
    return new LocalResourceAccessReviewFluentImpl.BuildSourceContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.BuildSourceContentNested<A> withNewBuildSourceContentLike(BuildSource item) {
    return new LocalResourceAccessReviewFluentImpl.BuildSourceContentNestedImpl(item);
  }
  public A withClusterResourceQuotaStatusContent(ClusterResourceQuotaStatus clusterResourceQuotaStatusContent) {
    _visitables.get("content").remove(this.content);
    if (clusterResourceQuotaStatusContent!=null){ this.content= new ClusterResourceQuotaStatusBuilder(clusterResourceQuotaStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ClusterResourceQuotaStatusContentNested<A> withNewClusterResourceQuotaStatusContent() {
    return new LocalResourceAccessReviewFluentImpl.ClusterResourceQuotaStatusContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ClusterResourceQuotaStatusContentNested<A> withNewClusterResourceQuotaStatusContentLike(ClusterResourceQuotaStatus item) {
    return new LocalResourceAccessReviewFluentImpl.ClusterResourceQuotaStatusContentNestedImpl(item);
  }
  public A withDeploymentConditionContent(DeploymentCondition deploymentConditionContent) {
    _visitables.get("content").remove(this.content);
    if (deploymentConditionContent!=null){ this.content= new DeploymentConditionBuilder(deploymentConditionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.DeploymentConditionContentNested<A> withNewDeploymentConditionContent() {
    return new LocalResourceAccessReviewFluentImpl.DeploymentConditionContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.DeploymentConditionContentNested<A> withNewDeploymentConditionContentLike(DeploymentCondition item) {
    return new LocalResourceAccessReviewFluentImpl.DeploymentConditionContentNestedImpl(item);
  }
  public A withHelmChartRepositorySpecContent(HelmChartRepositorySpec helmChartRepositorySpecContent) {
    _visitables.get("content").remove(this.content);
    if (helmChartRepositorySpecContent!=null){ this.content= new HelmChartRepositorySpecBuilder(helmChartRepositorySpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.HelmChartRepositorySpecContentNested<A> withNewHelmChartRepositorySpecContent() {
    return new LocalResourceAccessReviewFluentImpl.HelmChartRepositorySpecContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.HelmChartRepositorySpecContentNested<A> withNewHelmChartRepositorySpecContentLike(HelmChartRepositorySpec item) {
    return new LocalResourceAccessReviewFluentImpl.HelmChartRepositorySpecContentNestedImpl(item);
  }
  public A withDeploymentCauseImageTriggerContent(DeploymentCauseImageTrigger deploymentCauseImageTriggerContent) {
    _visitables.get("content").remove(this.content);
    if (deploymentCauseImageTriggerContent!=null){ this.content= new DeploymentCauseImageTriggerBuilder(deploymentCauseImageTriggerContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.DeploymentCauseImageTriggerContentNested<A> withNewDeploymentCauseImageTriggerContent() {
    return new LocalResourceAccessReviewFluentImpl.DeploymentCauseImageTriggerContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.DeploymentCauseImageTriggerContentNested<A> withNewDeploymentCauseImageTriggerContentLike(DeploymentCauseImageTrigger item) {
    return new LocalResourceAccessReviewFluentImpl.DeploymentCauseImageTriggerContentNestedImpl(item);
  }
  public A withImageStreamMappingContent(ImageStreamMapping imageStreamMappingContent) {
    _visitables.get("content").remove(this.content);
    if (imageStreamMappingContent!=null){ this.content= new ImageStreamMappingBuilder(imageStreamMappingContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ImageStreamMappingContentNested<A> withNewImageStreamMappingContent() {
    return new LocalResourceAccessReviewFluentImpl.ImageStreamMappingContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ImageStreamMappingContentNested<A> withNewImageStreamMappingContentLike(ImageStreamMapping item) {
    return new LocalResourceAccessReviewFluentImpl.ImageStreamMappingContentNestedImpl(item);
  }
  public A withSubjectRulesReviewContent(SubjectRulesReview subjectRulesReviewContent) {
    _visitables.get("content").remove(this.content);
    if (subjectRulesReviewContent!=null){ this.content= new SubjectRulesReviewBuilder(subjectRulesReviewContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.SubjectRulesReviewContentNested<A> withNewSubjectRulesReviewContent() {
    return new LocalResourceAccessReviewFluentImpl.SubjectRulesReviewContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.SubjectRulesReviewContentNested<A> withNewSubjectRulesReviewContentLike(SubjectRulesReview item) {
    return new LocalResourceAccessReviewFluentImpl.SubjectRulesReviewContentNestedImpl(item);
  }
  public A withRoleContent(Role roleContent) {
    _visitables.get("content").remove(this.content);
    if (roleContent!=null){ this.content= new RoleBuilder(roleContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.RoleContentNested<A> withNewRoleContent() {
    return new LocalResourceAccessReviewFluentImpl.RoleContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.RoleContentNested<A> withNewRoleContentLike(Role item) {
    return new LocalResourceAccessReviewFluentImpl.RoleContentNestedImpl(item);
  }
  public A withGitBuildSourceContent(GitBuildSource gitBuildSourceContent) {
    _visitables.get("content").remove(this.content);
    if (gitBuildSourceContent!=null){ this.content= new GitBuildSourceBuilder(gitBuildSourceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.GitBuildSourceContentNested<A> withNewGitBuildSourceContent() {
    return new LocalResourceAccessReviewFluentImpl.GitBuildSourceContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.GitBuildSourceContentNested<A> withNewGitBuildSourceContentLike(GitBuildSource item) {
    return new LocalResourceAccessReviewFluentImpl.GitBuildSourceContentNestedImpl(item);
  }
  public A withNewGitBuildSourceContent(String httpProxy,String httpsProxy,String noProxy,String ref,String uri) {
    return (A)withGitBuildSourceContent(new GitBuildSource(httpProxy, httpsProxy, noProxy, ref, uri));
  }
  public A withEgressNetworkPolicyListContent(EgressNetworkPolicyList egressNetworkPolicyListContent) {
    _visitables.get("content").remove(this.content);
    if (egressNetworkPolicyListContent!=null){ this.content= new EgressNetworkPolicyListBuilder(egressNetworkPolicyListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.EgressNetworkPolicyListContentNested<A> withNewEgressNetworkPolicyListContent() {
    return new LocalResourceAccessReviewFluentImpl.EgressNetworkPolicyListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.EgressNetworkPolicyListContentNested<A> withNewEgressNetworkPolicyListContentLike(EgressNetworkPolicyList item) {
    return new LocalResourceAccessReviewFluentImpl.EgressNetworkPolicyListContentNestedImpl(item);
  }
  public A withSelfSubjectRulesReviewSpecContent(SelfSubjectRulesReviewSpec selfSubjectRulesReviewSpecContent) {
    _visitables.get("content").remove(this.content);
    if (selfSubjectRulesReviewSpecContent!=null){ this.content= new SelfSubjectRulesReviewSpecBuilder(selfSubjectRulesReviewSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.SelfSubjectRulesReviewSpecContentNested<A> withNewSelfSubjectRulesReviewSpecContent() {
    return new LocalResourceAccessReviewFluentImpl.SelfSubjectRulesReviewSpecContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.SelfSubjectRulesReviewSpecContentNested<A> withNewSelfSubjectRulesReviewSpecContentLike(SelfSubjectRulesReviewSpec item) {
    return new LocalResourceAccessReviewFluentImpl.SelfSubjectRulesReviewSpecContentNestedImpl(item);
  }
  public A withImageSourcePathContent(ImageSourcePath imageSourcePathContent) {
    _visitables.get("content").remove(this.content);
    if (imageSourcePathContent!=null){ this.content= new ImageSourcePathBuilder(imageSourcePathContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ImageSourcePathContentNested<A> withNewImageSourcePathContent() {
    return new LocalResourceAccessReviewFluentImpl.ImageSourcePathContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ImageSourcePathContentNested<A> withNewImageSourcePathContentLike(ImageSourcePath item) {
    return new LocalResourceAccessReviewFluentImpl.ImageSourcePathContentNestedImpl(item);
  }
  public A withNewImageSourcePathContent(String destinationDir,String sourcePath) {
    return (A)withImageSourcePathContent(new ImageSourcePath(destinationDir, sourcePath));
  }
  public A withBuildConfigStatusContent(BuildConfigStatus buildConfigStatusContent) {
    _visitables.get("content").remove(this.content);
    if (buildConfigStatusContent!=null){ this.content= new BuildConfigStatusBuilder(buildConfigStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.BuildConfigStatusContentNested<A> withNewBuildConfigStatusContent() {
    return new LocalResourceAccessReviewFluentImpl.BuildConfigStatusContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.BuildConfigStatusContentNested<A> withNewBuildConfigStatusContentLike(BuildConfigStatus item) {
    return new LocalResourceAccessReviewFluentImpl.BuildConfigStatusContentNestedImpl(item);
  }
  public A withResourceQuotaStatusByNamespaceContent(ResourceQuotaStatusByNamespace resourceQuotaStatusByNamespaceContent) {
    _visitables.get("content").remove(this.content);
    if (resourceQuotaStatusByNamespaceContent!=null){ this.content= new ResourceQuotaStatusByNamespaceBuilder(resourceQuotaStatusByNamespaceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ResourceQuotaStatusByNamespaceContentNested<A> withNewResourceQuotaStatusByNamespaceContent() {
    return new LocalResourceAccessReviewFluentImpl.ResourceQuotaStatusByNamespaceContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ResourceQuotaStatusByNamespaceContentNested<A> withNewResourceQuotaStatusByNamespaceContentLike(ResourceQuotaStatusByNamespace item) {
    return new LocalResourceAccessReviewFluentImpl.ResourceQuotaStatusByNamespaceContentNestedImpl(item);
  }
  public A withSourceBuildStrategyContent(SourceBuildStrategy sourceBuildStrategyContent) {
    _visitables.get("content").remove(this.content);
    if (sourceBuildStrategyContent!=null){ this.content= new SourceBuildStrategyBuilder(sourceBuildStrategyContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.SourceBuildStrategyContentNested<A> withNewSourceBuildStrategyContent() {
    return new LocalResourceAccessReviewFluentImpl.SourceBuildStrategyContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.SourceBuildStrategyContentNested<A> withNewSourceBuildStrategyContentLike(SourceBuildStrategy item) {
    return new LocalResourceAccessReviewFluentImpl.SourceBuildStrategyContentNestedImpl(item);
  }
  public A withParameterContent(Parameter parameterContent) {
    _visitables.get("content").remove(this.content);
    if (parameterContent!=null){ this.content= new ParameterBuilder(parameterContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ParameterContentNested<A> withNewParameterContent() {
    return new LocalResourceAccessReviewFluentImpl.ParameterContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ParameterContentNested<A> withNewParameterContentLike(Parameter item) {
    return new LocalResourceAccessReviewFluentImpl.ParameterContentNestedImpl(item);
  }
  public A withRoleBindingListContent(RoleBindingList roleBindingListContent) {
    _visitables.get("content").remove(this.content);
    if (roleBindingListContent!=null){ this.content= new RoleBindingListBuilder(roleBindingListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.RoleBindingListContentNested<A> withNewRoleBindingListContent() {
    return new LocalResourceAccessReviewFluentImpl.RoleBindingListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.RoleBindingListContentNested<A> withNewRoleBindingListContentLike(RoleBindingList item) {
    return new LocalResourceAccessReviewFluentImpl.RoleBindingListContentNestedImpl(item);
  }
  public A withPodSecurityPolicySelfSubjectReviewSpecContent(PodSecurityPolicySelfSubjectReviewSpec podSecurityPolicySelfSubjectReviewSpecContent) {
    _visitables.get("content").remove(this.content);
    if (podSecurityPolicySelfSubjectReviewSpecContent!=null){ this.content= new PodSecurityPolicySelfSubjectReviewSpecBuilder(podSecurityPolicySelfSubjectReviewSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.PodSecurityPolicySelfSubjectReviewSpecContentNested<A> withNewPodSecurityPolicySelfSubjectReviewSpecContent() {
    return new LocalResourceAccessReviewFluentImpl.PodSecurityPolicySelfSubjectReviewSpecContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.PodSecurityPolicySelfSubjectReviewSpecContentNested<A> withNewPodSecurityPolicySelfSubjectReviewSpecContentLike(PodSecurityPolicySelfSubjectReviewSpec item) {
    return new LocalResourceAccessReviewFluentImpl.PodSecurityPolicySelfSubjectReviewSpecContentNestedImpl(item);
  }
  public A withBrokerTemplateInstanceContent(BrokerTemplateInstance brokerTemplateInstanceContent) {
    _visitables.get("content").remove(this.content);
    if (brokerTemplateInstanceContent!=null){ this.content= new BrokerTemplateInstanceBuilder(brokerTemplateInstanceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.BrokerTemplateInstanceContentNested<A> withNewBrokerTemplateInstanceContent() {
    return new LocalResourceAccessReviewFluentImpl.BrokerTemplateInstanceContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.BrokerTemplateInstanceContentNested<A> withNewBrokerTemplateInstanceContentLike(BrokerTemplateInstance item) {
    return new LocalResourceAccessReviewFluentImpl.BrokerTemplateInstanceContentNestedImpl(item);
  }
  public A withBuildPostCommitSpecContent(BuildPostCommitSpec buildPostCommitSpecContent) {
    _visitables.get("content").remove(this.content);
    if (buildPostCommitSpecContent!=null){ this.content= new BuildPostCommitSpecBuilder(buildPostCommitSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.BuildPostCommitSpecContentNested<A> withNewBuildPostCommitSpecContent() {
    return new LocalResourceAccessReviewFluentImpl.BuildPostCommitSpecContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.BuildPostCommitSpecContentNested<A> withNewBuildPostCommitSpecContentLike(BuildPostCommitSpec item) {
    return new LocalResourceAccessReviewFluentImpl.BuildPostCommitSpecContentNestedImpl(item);
  }
  public A withOAuthAuthorizeTokenListContent(OAuthAuthorizeTokenList oAuthAuthorizeTokenListContent) {
    _visitables.get("content").remove(this.content);
    if (oAuthAuthorizeTokenListContent!=null){ this.content= new OAuthAuthorizeTokenListBuilder(oAuthAuthorizeTokenListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.OAuthAuthorizeTokenListContentNested<A> withNewOAuthAuthorizeTokenListContent() {
    return new LocalResourceAccessReviewFluentImpl.OAuthAuthorizeTokenListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.OAuthAuthorizeTokenListContentNested<A> withNewOAuthAuthorizeTokenListContentLike(OAuthAuthorizeTokenList item) {
    return new LocalResourceAccessReviewFluentImpl.OAuthAuthorizeTokenListContentNestedImpl(item);
  }
  public A withDeploymentStrategyContent(DeploymentStrategy deploymentStrategyContent) {
    _visitables.get("content").remove(this.content);
    if (deploymentStrategyContent!=null){ this.content= new DeploymentStrategyBuilder(deploymentStrategyContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.DeploymentStrategyContentNested<A> withNewDeploymentStrategyContent() {
    return new LocalResourceAccessReviewFluentImpl.DeploymentStrategyContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.DeploymentStrategyContentNested<A> withNewDeploymentStrategyContentLike(DeploymentStrategy item) {
    return new LocalResourceAccessReviewFluentImpl.DeploymentStrategyContentNestedImpl(item);
  }
  public A withSignatureSubjectContent(SignatureSubject signatureSubjectContent) {
    _visitables.get("content").remove(this.content);
    if (signatureSubjectContent!=null){ this.content= new SignatureSubjectBuilder(signatureSubjectContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.SignatureSubjectContentNested<A> withNewSignatureSubjectContent() {
    return new LocalResourceAccessReviewFluentImpl.SignatureSubjectContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.SignatureSubjectContentNested<A> withNewSignatureSubjectContentLike(SignatureSubject item) {
    return new LocalResourceAccessReviewFluentImpl.SignatureSubjectContentNestedImpl(item);
  }
  public A withNewSignatureSubjectContent(String commonName,String organization,String publicKeyID) {
    return (A)withSignatureSubjectContent(new SignatureSubject(commonName, organization, publicKeyID));
  }
  public A withHostSubnetListContent(HostSubnetList hostSubnetListContent) {
    _visitables.get("content").remove(this.content);
    if (hostSubnetListContent!=null){ this.content= new HostSubnetListBuilder(hostSubnetListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.HostSubnetListContentNested<A> withNewHostSubnetListContent() {
    return new LocalResourceAccessReviewFluentImpl.HostSubnetListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.HostSubnetListContentNested<A> withNewHostSubnetListContentLike(HostSubnetList item) {
    return new LocalResourceAccessReviewFluentImpl.HostSubnetListContentNestedImpl(item);
  }
  public A withRouteIngressConditionContent(RouteIngressCondition routeIngressConditionContent) {
    _visitables.get("content").remove(this.content);
    if (routeIngressConditionContent!=null){ this.content= new RouteIngressConditionBuilder(routeIngressConditionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.RouteIngressConditionContentNested<A> withNewRouteIngressConditionContent() {
    return new LocalResourceAccessReviewFluentImpl.RouteIngressConditionContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.RouteIngressConditionContentNested<A> withNewRouteIngressConditionContentLike(RouteIngressCondition item) {
    return new LocalResourceAccessReviewFluentImpl.RouteIngressConditionContentNestedImpl(item);
  }
  public A withNewRouteIngressConditionContent(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withRouteIngressConditionContent(new RouteIngressCondition(lastTransitionTime, message, reason, status, type));
  }
  public A withCustomDeploymentStrategyParamsContent(CustomDeploymentStrategyParams customDeploymentStrategyParamsContent) {
    _visitables.get("content").remove(this.content);
    if (customDeploymentStrategyParamsContent!=null){ this.content= new CustomDeploymentStrategyParamsBuilder(customDeploymentStrategyParamsContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.CustomDeploymentStrategyParamsContentNested<A> withNewCustomDeploymentStrategyParamsContent() {
    return new LocalResourceAccessReviewFluentImpl.CustomDeploymentStrategyParamsContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.CustomDeploymentStrategyParamsContentNested<A> withNewCustomDeploymentStrategyParamsContentLike(CustomDeploymentStrategyParams item) {
    return new LocalResourceAccessReviewFluentImpl.CustomDeploymentStrategyParamsContentNestedImpl(item);
  }
  public A withImageImportSpecContent(ImageImportSpec imageImportSpecContent) {
    _visitables.get("content").remove(this.content);
    if (imageImportSpecContent!=null){ this.content= new ImageImportSpecBuilder(imageImportSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ImageImportSpecContentNested<A> withNewImageImportSpecContent() {
    return new LocalResourceAccessReviewFluentImpl.ImageImportSpecContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ImageImportSpecContentNested<A> withNewImageImportSpecContentLike(ImageImportSpec item) {
    return new LocalResourceAccessReviewFluentImpl.ImageImportSpecContentNestedImpl(item);
  }
  public A withStageInfoContent(StageInfo stageInfoContent) {
    _visitables.get("content").remove(this.content);
    if (stageInfoContent!=null){ this.content= new StageInfoBuilder(stageInfoContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.StageInfoContentNested<A> withNewStageInfoContent() {
    return new LocalResourceAccessReviewFluentImpl.StageInfoContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.StageInfoContentNested<A> withNewStageInfoContentLike(StageInfo item) {
    return new LocalResourceAccessReviewFluentImpl.StageInfoContentNestedImpl(item);
  }
  public A withRoleBindingRestrictionSpecContent(RoleBindingRestrictionSpec roleBindingRestrictionSpecContent) {
    _visitables.get("content").remove(this.content);
    if (roleBindingRestrictionSpecContent!=null){ this.content= new RoleBindingRestrictionSpecBuilder(roleBindingRestrictionSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.RoleBindingRestrictionSpecContentNested<A> withNewRoleBindingRestrictionSpecContent() {
    return new LocalResourceAccessReviewFluentImpl.RoleBindingRestrictionSpecContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.RoleBindingRestrictionSpecContentNested<A> withNewRoleBindingRestrictionSpecContentLike(RoleBindingRestrictionSpec item) {
    return new LocalResourceAccessReviewFluentImpl.RoleBindingRestrictionSpecContentNestedImpl(item);
  }
  public A withIDRangeContent(IDRange iDRangeContent) {
    _visitables.get("content").remove(this.content);
    if (iDRangeContent!=null){ this.content= new IDRangeBuilder(iDRangeContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.IDRangeContentNested<A> withNewIDRangeContent() {
    return new LocalResourceAccessReviewFluentImpl.IDRangeContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.IDRangeContentNested<A> withNewIDRangeContentLike(IDRange item) {
    return new LocalResourceAccessReviewFluentImpl.IDRangeContentNestedImpl(item);
  }
  public A withNewIDRangeContent(Long max,Long min) {
    return (A)withIDRangeContent(new IDRange(max, min));
  }
  public A withUserListContent(UserList userListContent) {
    _visitables.get("content").remove(this.content);
    if (userListContent!=null){ this.content= new UserListBuilder(userListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.UserListContentNested<A> withNewUserListContent() {
    return new LocalResourceAccessReviewFluentImpl.UserListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.UserListContentNested<A> withNewUserListContentLike(UserList item) {
    return new LocalResourceAccessReviewFluentImpl.UserListContentNestedImpl(item);
  }
  public A withBuildConfigSpecContent(BuildConfigSpec buildConfigSpecContent) {
    _visitables.get("content").remove(this.content);
    if (buildConfigSpecContent!=null){ this.content= new BuildConfigSpecBuilder(buildConfigSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.BuildConfigSpecContentNested<A> withNewBuildConfigSpecContent() {
    return new LocalResourceAccessReviewFluentImpl.BuildConfigSpecContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.BuildConfigSpecContentNested<A> withNewBuildConfigSpecContentLike(BuildConfigSpec item) {
    return new LocalResourceAccessReviewFluentImpl.BuildConfigSpecContentNestedImpl(item);
  }
  public A withUserContent(User userContent) {
    _visitables.get("content").remove(this.content);
    if (userContent!=null){ this.content= new UserBuilder(userContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.UserContentNested<A> withNewUserContent() {
    return new LocalResourceAccessReviewFluentImpl.UserContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.UserContentNested<A> withNewUserContentLike(User item) {
    return new LocalResourceAccessReviewFluentImpl.UserContentNestedImpl(item);
  }
  public A withImageStreamImageContent(ImageStreamImage imageStreamImageContent) {
    _visitables.get("content").remove(this.content);
    if (imageStreamImageContent!=null){ this.content= new ImageStreamImageBuilder(imageStreamImageContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ImageStreamImageContentNested<A> withNewImageStreamImageContent() {
    return new LocalResourceAccessReviewFluentImpl.ImageStreamImageContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ImageStreamImageContentNested<A> withNewImageStreamImageContentLike(ImageStreamImage item) {
    return new LocalResourceAccessReviewFluentImpl.ImageStreamImageContentNestedImpl(item);
  }
  public A withBuildStatusOutputToContent(BuildStatusOutputTo buildStatusOutputToContent) {
    _visitables.get("content").remove(this.content);
    if (buildStatusOutputToContent!=null){ this.content= new BuildStatusOutputToBuilder(buildStatusOutputToContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.BuildStatusOutputToContentNested<A> withNewBuildStatusOutputToContent() {
    return new LocalResourceAccessReviewFluentImpl.BuildStatusOutputToContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.BuildStatusOutputToContentNested<A> withNewBuildStatusOutputToContentLike(BuildStatusOutputTo item) {
    return new LocalResourceAccessReviewFluentImpl.BuildStatusOutputToContentNestedImpl(item);
  }
  public A withNewBuildStatusOutputToContent(String imageDigest) {
    return (A)withBuildStatusOutputToContent(new BuildStatusOutputTo(imageDigest));
  }
  public A withBuildConditionContent(BuildCondition buildConditionContent) {
    _visitables.get("content").remove(this.content);
    if (buildConditionContent!=null){ this.content= new BuildConditionBuilder(buildConditionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.BuildConditionContentNested<A> withNewBuildConditionContent() {
    return new LocalResourceAccessReviewFluentImpl.BuildConditionContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.BuildConditionContentNested<A> withNewBuildConditionContentLike(BuildCondition item) {
    return new LocalResourceAccessReviewFluentImpl.BuildConditionContentNestedImpl(item);
  }
  public A withResourceAccessReviewResponseContent(ResourceAccessReviewResponse resourceAccessReviewResponseContent) {
    _visitables.get("content").remove(this.content);
    if (resourceAccessReviewResponseContent!=null){ this.content= new ResourceAccessReviewResponseBuilder(resourceAccessReviewResponseContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ResourceAccessReviewResponseContentNested<A> withNewResourceAccessReviewResponseContent() {
    return new LocalResourceAccessReviewFluentImpl.ResourceAccessReviewResponseContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ResourceAccessReviewResponseContentNested<A> withNewResourceAccessReviewResponseContentLike(ResourceAccessReviewResponse item) {
    return new LocalResourceAccessReviewFluentImpl.ResourceAccessReviewResponseContentNestedImpl(item);
  }
  public A withExecNewPodHookContent(ExecNewPodHook execNewPodHookContent) {
    _visitables.get("content").remove(this.content);
    if (execNewPodHookContent!=null){ this.content= new ExecNewPodHookBuilder(execNewPodHookContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ExecNewPodHookContentNested<A> withNewExecNewPodHookContent() {
    return new LocalResourceAccessReviewFluentImpl.ExecNewPodHookContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ExecNewPodHookContentNested<A> withNewExecNewPodHookContentLike(ExecNewPodHook item) {
    return new LocalResourceAccessReviewFluentImpl.ExecNewPodHookContentNestedImpl(item);
  }
  public A withSecretSpecContent(SecretSpec secretSpecContent) {
    _visitables.get("content").remove(this.content);
    if (secretSpecContent!=null){ this.content= new SecretSpecBuilder(secretSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.SecretSpecContentNested<A> withNewSecretSpecContent() {
    return new LocalResourceAccessReviewFluentImpl.SecretSpecContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.SecretSpecContentNested<A> withNewSecretSpecContentLike(SecretSpec item) {
    return new LocalResourceAccessReviewFluentImpl.SecretSpecContentNestedImpl(item);
  }
  public A withClusterRoleBindingListContent(ClusterRoleBindingList clusterRoleBindingListContent) {
    _visitables.get("content").remove(this.content);
    if (clusterRoleBindingListContent!=null){ this.content= new ClusterRoleBindingListBuilder(clusterRoleBindingListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ClusterRoleBindingListContentNested<A> withNewClusterRoleBindingListContent() {
    return new LocalResourceAccessReviewFluentImpl.ClusterRoleBindingListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ClusterRoleBindingListContentNested<A> withNewClusterRoleBindingListContentLike(ClusterRoleBindingList item) {
    return new LocalResourceAccessReviewFluentImpl.ClusterRoleBindingListContentNestedImpl(item);
  }
  public A withEgressNetworkPolicyPeerContent(EgressNetworkPolicyPeer egressNetworkPolicyPeerContent) {
    _visitables.get("content").remove(this.content);
    if (egressNetworkPolicyPeerContent!=null){ this.content= new EgressNetworkPolicyPeerBuilder(egressNetworkPolicyPeerContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.EgressNetworkPolicyPeerContentNested<A> withNewEgressNetworkPolicyPeerContent() {
    return new LocalResourceAccessReviewFluentImpl.EgressNetworkPolicyPeerContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.EgressNetworkPolicyPeerContentNested<A> withNewEgressNetworkPolicyPeerContentLike(EgressNetworkPolicyPeer item) {
    return new LocalResourceAccessReviewFluentImpl.EgressNetworkPolicyPeerContentNestedImpl(item);
  }
  public A withNewEgressNetworkPolicyPeerContent(String cidrSelector,String dnsName) {
    return (A)withEgressNetworkPolicyPeerContent(new EgressNetworkPolicyPeer(cidrSelector, dnsName));
  }
  public A withTemplateInstanceContent(TemplateInstance templateInstanceContent) {
    _visitables.get("content").remove(this.content);
    if (templateInstanceContent!=null){ this.content= new TemplateInstanceBuilder(templateInstanceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.TemplateInstanceContentNested<A> withNewTemplateInstanceContent() {
    return new LocalResourceAccessReviewFluentImpl.TemplateInstanceContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.TemplateInstanceContentNested<A> withNewTemplateInstanceContentLike(TemplateInstance item) {
    return new LocalResourceAccessReviewFluentImpl.TemplateInstanceContentNestedImpl(item);
  }
  public A withWebHookTriggerContent(WebHookTrigger webHookTriggerContent) {
    _visitables.get("content").remove(this.content);
    if (webHookTriggerContent!=null){ this.content= new WebHookTriggerBuilder(webHookTriggerContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.WebHookTriggerContentNested<A> withNewWebHookTriggerContent() {
    return new LocalResourceAccessReviewFluentImpl.WebHookTriggerContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.WebHookTriggerContentNested<A> withNewWebHookTriggerContentLike(WebHookTrigger item) {
    return new LocalResourceAccessReviewFluentImpl.WebHookTriggerContentNestedImpl(item);
  }
  public A withServiceAccountReferenceContent(ServiceAccountReference serviceAccountReferenceContent) {
    _visitables.get("content").remove(this.content);
    if (serviceAccountReferenceContent!=null){ this.content= new ServiceAccountReferenceBuilder(serviceAccountReferenceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ServiceAccountReferenceContentNested<A> withNewServiceAccountReferenceContent() {
    return new LocalResourceAccessReviewFluentImpl.ServiceAccountReferenceContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ServiceAccountReferenceContentNested<A> withNewServiceAccountReferenceContentLike(ServiceAccountReference item) {
    return new LocalResourceAccessReviewFluentImpl.ServiceAccountReferenceContentNestedImpl(item);
  }
  public A withNewServiceAccountReferenceContent(String name,String namespace) {
    return (A)withServiceAccountReferenceContent(new ServiceAccountReference(name, namespace));
  }
  public A withBuildContent(Build buildContent) {
    _visitables.get("content").remove(this.content);
    if (buildContent!=null){ this.content= new BuildBuilder(buildContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.BuildContentNested<A> withNewBuildContent() {
    return new LocalResourceAccessReviewFluentImpl.BuildContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.BuildContentNested<A> withNewBuildContentLike(Build item) {
    return new LocalResourceAccessReviewFluentImpl.BuildContentNestedImpl(item);
  }
  public A withRoleBindingRestrictionContent(RoleBindingRestriction roleBindingRestrictionContent) {
    _visitables.get("content").remove(this.content);
    if (roleBindingRestrictionContent!=null){ this.content= new RoleBindingRestrictionBuilder(roleBindingRestrictionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.RoleBindingRestrictionContentNested<A> withNewRoleBindingRestrictionContent() {
    return new LocalResourceAccessReviewFluentImpl.RoleBindingRestrictionContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.RoleBindingRestrictionContentNested<A> withNewRoleBindingRestrictionContentLike(RoleBindingRestriction item) {
    return new LocalResourceAccessReviewFluentImpl.RoleBindingRestrictionContentNestedImpl(item);
  }
  public A withTagImportPolicyContent(TagImportPolicy tagImportPolicyContent) {
    _visitables.get("content").remove(this.content);
    if (tagImportPolicyContent!=null){ this.content= new TagImportPolicyBuilder(tagImportPolicyContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.TagImportPolicyContentNested<A> withNewTagImportPolicyContent() {
    return new LocalResourceAccessReviewFluentImpl.TagImportPolicyContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.TagImportPolicyContentNested<A> withNewTagImportPolicyContentLike(TagImportPolicy item) {
    return new LocalResourceAccessReviewFluentImpl.TagImportPolicyContentNestedImpl(item);
  }
  public A withNewTagImportPolicyContent(Boolean insecure,Boolean scheduled) {
    return (A)withTagImportPolicyContent(new TagImportPolicy(insecure, scheduled));
  }
  public A withImageStreamTagContent(ImageStreamTag imageStreamTagContent) {
    _visitables.get("content").remove(this.content);
    if (imageStreamTagContent!=null){ this.content= new ImageStreamTagBuilder(imageStreamTagContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ImageStreamTagContentNested<A> withNewImageStreamTagContent() {
    return new LocalResourceAccessReviewFluentImpl.ImageStreamTagContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ImageStreamTagContentNested<A> withNewImageStreamTagContentLike(ImageStreamTag item) {
    return new LocalResourceAccessReviewFluentImpl.ImageStreamTagContentNestedImpl(item);
  }
  public A withBuildTriggerPolicyContent(BuildTriggerPolicy buildTriggerPolicyContent) {
    _visitables.get("content").remove(this.content);
    if (buildTriggerPolicyContent!=null){ this.content= new BuildTriggerPolicyBuilder(buildTriggerPolicyContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.BuildTriggerPolicyContentNested<A> withNewBuildTriggerPolicyContent() {
    return new LocalResourceAccessReviewFluentImpl.BuildTriggerPolicyContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.BuildTriggerPolicyContentNested<A> withNewBuildTriggerPolicyContentLike(BuildTriggerPolicy item) {
    return new LocalResourceAccessReviewFluentImpl.BuildTriggerPolicyContentNestedImpl(item);
  }
  public A withRoutePortContent(RoutePort routePortContent) {
    _visitables.get("content").remove(this.content);
    if (routePortContent!=null){ this.content= new RoutePortBuilder(routePortContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.RoutePortContentNested<A> withNewRoutePortContent() {
    return new LocalResourceAccessReviewFluentImpl.RoutePortContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.RoutePortContentNested<A> withNewRoutePortContentLike(RoutePort item) {
    return new LocalResourceAccessReviewFluentImpl.RoutePortContentNestedImpl(item);
  }
  public A withTemplateInstanceRequesterContent(TemplateInstanceRequester templateInstanceRequesterContent) {
    _visitables.get("content").remove(this.content);
    if (templateInstanceRequesterContent!=null){ this.content= new TemplateInstanceRequesterBuilder(templateInstanceRequesterContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.TemplateInstanceRequesterContentNested<A> withNewTemplateInstanceRequesterContent() {
    return new LocalResourceAccessReviewFluentImpl.TemplateInstanceRequesterContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.TemplateInstanceRequesterContentNested<A> withNewTemplateInstanceRequesterContentLike(TemplateInstanceRequester item) {
    return new LocalResourceAccessReviewFluentImpl.TemplateInstanceRequesterContentNestedImpl(item);
  }
  public A withGroupContent(Group groupContent) {
    _visitables.get("content").remove(this.content);
    if (groupContent!=null){ this.content= new GroupBuilder(groupContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.GroupContentNested<A> withNewGroupContent() {
    return new LocalResourceAccessReviewFluentImpl.GroupContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.GroupContentNested<A> withNewGroupContentLike(Group item) {
    return new LocalResourceAccessReviewFluentImpl.GroupContentNestedImpl(item);
  }
  public A withBuildTriggerCauseContent(BuildTriggerCause buildTriggerCauseContent) {
    _visitables.get("content").remove(this.content);
    if (buildTriggerCauseContent!=null){ this.content= new BuildTriggerCauseBuilder(buildTriggerCauseContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.BuildTriggerCauseContentNested<A> withNewBuildTriggerCauseContent() {
    return new LocalResourceAccessReviewFluentImpl.BuildTriggerCauseContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.BuildTriggerCauseContentNested<A> withNewBuildTriggerCauseContentLike(BuildTriggerCause item) {
    return new LocalResourceAccessReviewFluentImpl.BuildTriggerCauseContentNestedImpl(item);
  }
  public A withImageSignatureContent(ImageSignature imageSignatureContent) {
    _visitables.get("content").remove(this.content);
    if (imageSignatureContent!=null){ this.content= new ImageSignatureBuilder(imageSignatureContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ImageSignatureContentNested<A> withNewImageSignatureContent() {
    return new LocalResourceAccessReviewFluentImpl.ImageSignatureContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ImageSignatureContentNested<A> withNewImageSignatureContentLike(ImageSignature item) {
    return new LocalResourceAccessReviewFluentImpl.ImageSignatureContentNestedImpl(item);
  }
  public A withHelmChartRepositoryStatusContent(HelmChartRepositoryStatus helmChartRepositoryStatusContent) {
    _visitables.get("content").remove(this.content);
    if (helmChartRepositoryStatusContent!=null){ this.content= new HelmChartRepositoryStatusBuilder(helmChartRepositoryStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.HelmChartRepositoryStatusContentNested<A> withNewHelmChartRepositoryStatusContent() {
    return new LocalResourceAccessReviewFluentImpl.HelmChartRepositoryStatusContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.HelmChartRepositoryStatusContentNested<A> withNewHelmChartRepositoryStatusContentLike(HelmChartRepositoryStatus item) {
    return new LocalResourceAccessReviewFluentImpl.HelmChartRepositoryStatusContentNestedImpl(item);
  }
  public A withDeploymentConfigSpecContent(DeploymentConfigSpec deploymentConfigSpecContent) {
    _visitables.get("content").remove(this.content);
    if (deploymentConfigSpecContent!=null){ this.content= new DeploymentConfigSpecBuilder(deploymentConfigSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.DeploymentConfigSpecContentNested<A> withNewDeploymentConfigSpecContent() {
    return new LocalResourceAccessReviewFluentImpl.DeploymentConfigSpecContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.DeploymentConfigSpecContentNested<A> withNewDeploymentConfigSpecContentLike(DeploymentConfigSpec item) {
    return new LocalResourceAccessReviewFluentImpl.DeploymentConfigSpecContentNestedImpl(item);
  }
  public A withHostSubnetContent(HostSubnet hostSubnetContent) {
    _visitables.get("content").remove(this.content);
    if (hostSubnetContent!=null){ this.content= new HostSubnetBuilder(hostSubnetContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.HostSubnetContentNested<A> withNewHostSubnetContent() {
    return new LocalResourceAccessReviewFluentImpl.HostSubnetContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.HostSubnetContentNested<A> withNewHostSubnetContentLike(HostSubnet item) {
    return new LocalResourceAccessReviewFluentImpl.HostSubnetContentNestedImpl(item);
  }
  public A withGroupRestrictionContent(GroupRestriction groupRestrictionContent) {
    _visitables.get("content").remove(this.content);
    if (groupRestrictionContent!=null){ this.content= new GroupRestrictionBuilder(groupRestrictionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.GroupRestrictionContentNested<A> withNewGroupRestrictionContent() {
    return new LocalResourceAccessReviewFluentImpl.GroupRestrictionContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.GroupRestrictionContentNested<A> withNewGroupRestrictionContentLike(GroupRestriction item) {
    return new LocalResourceAccessReviewFluentImpl.GroupRestrictionContentNestedImpl(item);
  }
  public A withAppliedClusterResourceQuotaContent(AppliedClusterResourceQuota appliedClusterResourceQuotaContent) {
    _visitables.get("content").remove(this.content);
    if (appliedClusterResourceQuotaContent!=null){ this.content= new AppliedClusterResourceQuotaBuilder(appliedClusterResourceQuotaContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.AppliedClusterResourceQuotaContentNested<A> withNewAppliedClusterResourceQuotaContent() {
    return new LocalResourceAccessReviewFluentImpl.AppliedClusterResourceQuotaContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.AppliedClusterResourceQuotaContentNested<A> withNewAppliedClusterResourceQuotaContentLike(AppliedClusterResourceQuota item) {
    return new LocalResourceAccessReviewFluentImpl.AppliedClusterResourceQuotaContentNestedImpl(item);
  }
  public A withOAuthAccessTokenListContent(OAuthAccessTokenList oAuthAccessTokenListContent) {
    _visitables.get("content").remove(this.content);
    if (oAuthAccessTokenListContent!=null){ this.content= new OAuthAccessTokenListBuilder(oAuthAccessTokenListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.OAuthAccessTokenListContentNested<A> withNewOAuthAccessTokenListContent() {
    return new LocalResourceAccessReviewFluentImpl.OAuthAccessTokenListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.OAuthAccessTokenListContentNested<A> withNewOAuthAccessTokenListContentLike(OAuthAccessTokenList item) {
    return new LocalResourceAccessReviewFluentImpl.OAuthAccessTokenListContentNestedImpl(item);
  }
  public A withJenkinsPipelineBuildStrategyContent(JenkinsPipelineBuildStrategy jenkinsPipelineBuildStrategyContent) {
    _visitables.get("content").remove(this.content);
    if (jenkinsPipelineBuildStrategyContent!=null){ this.content= new JenkinsPipelineBuildStrategyBuilder(jenkinsPipelineBuildStrategyContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.JenkinsPipelineBuildStrategyContentNested<A> withNewJenkinsPipelineBuildStrategyContent() {
    return new LocalResourceAccessReviewFluentImpl.JenkinsPipelineBuildStrategyContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.JenkinsPipelineBuildStrategyContentNested<A> withNewJenkinsPipelineBuildStrategyContentLike(JenkinsPipelineBuildStrategy item) {
    return new LocalResourceAccessReviewFluentImpl.JenkinsPipelineBuildStrategyContentNestedImpl(item);
  }
  public A withSecurityContextConstraintsContent(SecurityContextConstraints securityContextConstraintsContent) {
    _visitables.get("content").remove(this.content);
    if (securityContextConstraintsContent!=null){ this.content= new SecurityContextConstraintsBuilder(securityContextConstraintsContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.SecurityContextConstraintsContentNested<A> withNewSecurityContextConstraintsContent() {
    return new LocalResourceAccessReviewFluentImpl.SecurityContextConstraintsContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.SecurityContextConstraintsContentNested<A> withNewSecurityContextConstraintsContentLike(SecurityContextConstraints item) {
    return new LocalResourceAccessReviewFluentImpl.SecurityContextConstraintsContentNestedImpl(item);
  }
  public A withSupplementalGroupsStrategyOptionsContent(SupplementalGroupsStrategyOptions supplementalGroupsStrategyOptionsContent) {
    _visitables.get("content").remove(this.content);
    if (supplementalGroupsStrategyOptionsContent!=null){ this.content= new SupplementalGroupsStrategyOptionsBuilder(supplementalGroupsStrategyOptionsContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.SupplementalGroupsStrategyOptionsContentNested<A> withNewSupplementalGroupsStrategyOptionsContent() {
    return new LocalResourceAccessReviewFluentImpl.SupplementalGroupsStrategyOptionsContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.SupplementalGroupsStrategyOptionsContentNested<A> withNewSupplementalGroupsStrategyOptionsContentLike(SupplementalGroupsStrategyOptions item) {
    return new LocalResourceAccessReviewFluentImpl.SupplementalGroupsStrategyOptionsContentNestedImpl(item);
  }
  public A withServiceAccountPodSecurityPolicyReviewStatusContent(ServiceAccountPodSecurityPolicyReviewStatus serviceAccountPodSecurityPolicyReviewStatusContent) {
    _visitables.get("content").remove(this.content);
    if (serviceAccountPodSecurityPolicyReviewStatusContent!=null){ this.content= new ServiceAccountPodSecurityPolicyReviewStatusBuilder(serviceAccountPodSecurityPolicyReviewStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ServiceAccountPodSecurityPolicyReviewStatusContentNested<A> withNewServiceAccountPodSecurityPolicyReviewStatusContent() {
    return new LocalResourceAccessReviewFluentImpl.ServiceAccountPodSecurityPolicyReviewStatusContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ServiceAccountPodSecurityPolicyReviewStatusContentNested<A> withNewServiceAccountPodSecurityPolicyReviewStatusContentLike(ServiceAccountPodSecurityPolicyReviewStatus item) {
    return new LocalResourceAccessReviewFluentImpl.ServiceAccountPodSecurityPolicyReviewStatusContentNestedImpl(item);
  }
  public A withBuildRequestContent(BuildRequest buildRequestContent) {
    _visitables.get("content").remove(this.content);
    if (buildRequestContent!=null){ this.content= new BuildRequestBuilder(buildRequestContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.BuildRequestContentNested<A> withNewBuildRequestContent() {
    return new LocalResourceAccessReviewFluentImpl.BuildRequestContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.BuildRequestContentNested<A> withNewBuildRequestContentLike(BuildRequest item) {
    return new LocalResourceAccessReviewFluentImpl.BuildRequestContentNestedImpl(item);
  }
  public A withSELinuxContextStrategyOptionsContent(SELinuxContextStrategyOptions sELinuxContextStrategyOptionsContent) {
    _visitables.get("content").remove(this.content);
    if (sELinuxContextStrategyOptionsContent!=null){ this.content= new SELinuxContextStrategyOptionsBuilder(sELinuxContextStrategyOptionsContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.SELinuxContextStrategyOptionsContentNested<A> withNewSELinuxContextStrategyOptionsContent() {
    return new LocalResourceAccessReviewFluentImpl.SELinuxContextStrategyOptionsContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.SELinuxContextStrategyOptionsContentNested<A> withNewSELinuxContextStrategyOptionsContentLike(SELinuxContextStrategyOptions item) {
    return new LocalResourceAccessReviewFluentImpl.SELinuxContextStrategyOptionsContentNestedImpl(item);
  }
  public A withClusterRoleListContent(ClusterRoleList clusterRoleListContent) {
    _visitables.get("content").remove(this.content);
    if (clusterRoleListContent!=null){ this.content= new ClusterRoleListBuilder(clusterRoleListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ClusterRoleListContentNested<A> withNewClusterRoleListContent() {
    return new LocalResourceAccessReviewFluentImpl.ClusterRoleListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ClusterRoleListContentNested<A> withNewClusterRoleListContentLike(ClusterRoleList item) {
    return new LocalResourceAccessReviewFluentImpl.ClusterRoleListContentNestedImpl(item);
  }
  public A withRouteListContent(RouteList routeListContent) {
    _visitables.get("content").remove(this.content);
    if (routeListContent!=null){ this.content= new RouteListBuilder(routeListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.RouteListContentNested<A> withNewRouteListContent() {
    return new LocalResourceAccessReviewFluentImpl.RouteListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.RouteListContentNested<A> withNewRouteListContentLike(RouteList item) {
    return new LocalResourceAccessReviewFluentImpl.RouteListContentNestedImpl(item);
  }
  public A withImageStreamStatusContent(ImageStreamStatus imageStreamStatusContent) {
    _visitables.get("content").remove(this.content);
    if (imageStreamStatusContent!=null){ this.content= new ImageStreamStatusBuilder(imageStreamStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ImageStreamStatusContentNested<A> withNewImageStreamStatusContent() {
    return new LocalResourceAccessReviewFluentImpl.ImageStreamStatusContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ImageStreamStatusContentNested<A> withNewImageStreamStatusContentLike(ImageStreamStatus item) {
    return new LocalResourceAccessReviewFluentImpl.ImageStreamStatusContentNestedImpl(item);
  }
  public A withEgressNetworkPolicyContent(EgressNetworkPolicy egressNetworkPolicyContent) {
    _visitables.get("content").remove(this.content);
    if (egressNetworkPolicyContent!=null){ this.content= new EgressNetworkPolicyBuilder(egressNetworkPolicyContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.EgressNetworkPolicyContentNested<A> withNewEgressNetworkPolicyContent() {
    return new LocalResourceAccessReviewFluentImpl.EgressNetworkPolicyContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.EgressNetworkPolicyContentNested<A> withNewEgressNetworkPolicyContentLike(EgressNetworkPolicy item) {
    return new LocalResourceAccessReviewFluentImpl.EgressNetworkPolicyContentNestedImpl(item);
  }
  public A withNetNamespaceContent(NetNamespace netNamespaceContent) {
    _visitables.get("content").remove(this.content);
    if (netNamespaceContent!=null){ this.content= new NetNamespaceBuilder(netNamespaceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.NetNamespaceContentNested<A> withNewNetNamespaceContent() {
    return new LocalResourceAccessReviewFluentImpl.NetNamespaceContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.NetNamespaceContentNested<A> withNewNetNamespaceContentLike(NetNamespace item) {
    return new LocalResourceAccessReviewFluentImpl.NetNamespaceContentNestedImpl(item);
  }
  public A withUserIdentityMappingContent(UserIdentityMapping userIdentityMappingContent) {
    _visitables.get("content").remove(this.content);
    if (userIdentityMappingContent!=null){ this.content= new UserIdentityMappingBuilder(userIdentityMappingContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.UserIdentityMappingContentNested<A> withNewUserIdentityMappingContent() {
    return new LocalResourceAccessReviewFluentImpl.UserIdentityMappingContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.UserIdentityMappingContentNested<A> withNewUserIdentityMappingContentLike(UserIdentityMapping item) {
    return new LocalResourceAccessReviewFluentImpl.UserIdentityMappingContentNestedImpl(item);
  }
  public A withDeploymentDetailsContent(DeploymentDetails deploymentDetailsContent) {
    _visitables.get("content").remove(this.content);
    if (deploymentDetailsContent!=null){ this.content= new DeploymentDetailsBuilder(deploymentDetailsContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.DeploymentDetailsContentNested<A> withNewDeploymentDetailsContent() {
    return new LocalResourceAccessReviewFluentImpl.DeploymentDetailsContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.DeploymentDetailsContentNested<A> withNewDeploymentDetailsContentLike(DeploymentDetails item) {
    return new LocalResourceAccessReviewFluentImpl.DeploymentDetailsContentNestedImpl(item);
  }
  public A withPodSecurityPolicySubjectReviewStatusContent(PodSecurityPolicySubjectReviewStatus podSecurityPolicySubjectReviewStatusContent) {
    _visitables.get("content").remove(this.content);
    if (podSecurityPolicySubjectReviewStatusContent!=null){ this.content= new PodSecurityPolicySubjectReviewStatusBuilder(podSecurityPolicySubjectReviewStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.PodSecurityPolicySubjectReviewStatusContentNested<A> withNewPodSecurityPolicySubjectReviewStatusContent() {
    return new LocalResourceAccessReviewFluentImpl.PodSecurityPolicySubjectReviewStatusContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.PodSecurityPolicySubjectReviewStatusContentNested<A> withNewPodSecurityPolicySubjectReviewStatusContentLike(PodSecurityPolicySubjectReviewStatus item) {
    return new LocalResourceAccessReviewFluentImpl.PodSecurityPolicySubjectReviewStatusContentNestedImpl(item);
  }
  public A withPodSecurityPolicySubjectReviewSpecContent(PodSecurityPolicySubjectReviewSpec podSecurityPolicySubjectReviewSpecContent) {
    _visitables.get("content").remove(this.content);
    if (podSecurityPolicySubjectReviewSpecContent!=null){ this.content= new PodSecurityPolicySubjectReviewSpecBuilder(podSecurityPolicySubjectReviewSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.PodSecurityPolicySubjectReviewSpecContentNested<A> withNewPodSecurityPolicySubjectReviewSpecContent() {
    return new LocalResourceAccessReviewFluentImpl.PodSecurityPolicySubjectReviewSpecContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.PodSecurityPolicySubjectReviewSpecContentNested<A> withNewPodSecurityPolicySubjectReviewSpecContentLike(PodSecurityPolicySubjectReviewSpec item) {
    return new LocalResourceAccessReviewFluentImpl.PodSecurityPolicySubjectReviewSpecContentNestedImpl(item);
  }
  public A withImageStreamContent(ImageStream imageStreamContent) {
    _visitables.get("content").remove(this.content);
    if (imageStreamContent!=null){ this.content= new ImageStreamBuilder(imageStreamContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ImageStreamContentNested<A> withNewImageStreamContent() {
    return new LocalResourceAccessReviewFluentImpl.ImageStreamContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ImageStreamContentNested<A> withNewImageStreamContentLike(ImageStream item) {
    return new LocalResourceAccessReviewFluentImpl.ImageStreamContentNestedImpl(item);
  }
  public A withBuildListContent(BuildList buildListContent) {
    _visitables.get("content").remove(this.content);
    if (buildListContent!=null){ this.content= new BuildListBuilder(buildListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.BuildListContentNested<A> withNewBuildListContent() {
    return new LocalResourceAccessReviewFluentImpl.BuildListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.BuildListContentNested<A> withNewBuildListContentLike(BuildList item) {
    return new LocalResourceAccessReviewFluentImpl.BuildListContentNestedImpl(item);
  }
  public A withTemplateListContent(TemplateList templateListContent) {
    _visitables.get("content").remove(this.content);
    if (templateListContent!=null){ this.content= new TemplateListBuilder(templateListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.TemplateListContentNested<A> withNewTemplateListContent() {
    return new LocalResourceAccessReviewFluentImpl.TemplateListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.TemplateListContentNested<A> withNewTemplateListContentLike(TemplateList item) {
    return new LocalResourceAccessReviewFluentImpl.TemplateListContentNestedImpl(item);
  }
  public A withBuildOutputContent(BuildOutput buildOutputContent) {
    _visitables.get("content").remove(this.content);
    if (buildOutputContent!=null){ this.content= new BuildOutputBuilder(buildOutputContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.BuildOutputContentNested<A> withNewBuildOutputContent() {
    return new LocalResourceAccessReviewFluentImpl.BuildOutputContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.BuildOutputContentNested<A> withNewBuildOutputContentLike(BuildOutput item) {
    return new LocalResourceAccessReviewFluentImpl.BuildOutputContentNestedImpl(item);
  }
  public A withProjectSpecContent(ProjectSpec projectSpecContent) {
    _visitables.get("content").remove(this.content);
    if (projectSpecContent!=null){ this.content= new ProjectSpecBuilder(projectSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ProjectSpecContentNested<A> withNewProjectSpecContent() {
    return new LocalResourceAccessReviewFluentImpl.ProjectSpecContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ProjectSpecContentNested<A> withNewProjectSpecContentLike(ProjectSpec item) {
    return new LocalResourceAccessReviewFluentImpl.ProjectSpecContentNestedImpl(item);
  }
  public A withSourceRevisionContent(SourceRevision sourceRevisionContent) {
    _visitables.get("content").remove(this.content);
    if (sourceRevisionContent!=null){ this.content= new SourceRevisionBuilder(sourceRevisionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.SourceRevisionContentNested<A> withNewSourceRevisionContent() {
    return new LocalResourceAccessReviewFluentImpl.SourceRevisionContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.SourceRevisionContentNested<A> withNewSourceRevisionContentLike(SourceRevision item) {
    return new LocalResourceAccessReviewFluentImpl.SourceRevisionContentNestedImpl(item);
  }
  public A withObjectReferenceContent(ObjectReference objectReferenceContent) {
    _visitables.get("content").remove(this.content);
    if (objectReferenceContent!=null){ this.content= new ObjectReferenceBuilder(objectReferenceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ObjectReferenceContentNested<A> withNewObjectReferenceContent() {
    return new LocalResourceAccessReviewFluentImpl.ObjectReferenceContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ObjectReferenceContentNested<A> withNewObjectReferenceContentLike(ObjectReference item) {
    return new LocalResourceAccessReviewFluentImpl.ObjectReferenceContentNestedImpl(item);
  }
  public A withSignatureIssuerContent(SignatureIssuer signatureIssuerContent) {
    _visitables.get("content").remove(this.content);
    if (signatureIssuerContent!=null){ this.content= new SignatureIssuerBuilder(signatureIssuerContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.SignatureIssuerContentNested<A> withNewSignatureIssuerContent() {
    return new LocalResourceAccessReviewFluentImpl.SignatureIssuerContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.SignatureIssuerContentNested<A> withNewSignatureIssuerContentLike(SignatureIssuer item) {
    return new LocalResourceAccessReviewFluentImpl.SignatureIssuerContentNestedImpl(item);
  }
  public A withNewSignatureIssuerContent(String commonName,String organization) {
    return (A)withSignatureIssuerContent(new SignatureIssuer(commonName, organization));
  }
  public A withImageLayerContent(ImageLayer imageLayerContent) {
    _visitables.get("content").remove(this.content);
    if (imageLayerContent!=null){ this.content= new ImageLayerBuilder(imageLayerContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ImageLayerContentNested<A> withNewImageLayerContent() {
    return new LocalResourceAccessReviewFluentImpl.ImageLayerContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ImageLayerContentNested<A> withNewImageLayerContentLike(ImageLayer item) {
    return new LocalResourceAccessReviewFluentImpl.ImageLayerContentNestedImpl(item);
  }
  public A withNewImageLayerContent(String mediaType,String name,Long size) {
    return (A)withImageLayerContent(new ImageLayer(mediaType, name, size));
  }
  public A withClusterResourceQuotaSpecContent(ClusterResourceQuotaSpec clusterResourceQuotaSpecContent) {
    _visitables.get("content").remove(this.content);
    if (clusterResourceQuotaSpecContent!=null){ this.content= new ClusterResourceQuotaSpecBuilder(clusterResourceQuotaSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ClusterResourceQuotaSpecContentNested<A> withNewClusterResourceQuotaSpecContent() {
    return new LocalResourceAccessReviewFluentImpl.ClusterResourceQuotaSpecContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ClusterResourceQuotaSpecContentNested<A> withNewClusterResourceQuotaSpecContentLike(ClusterResourceQuotaSpec item) {
    return new LocalResourceAccessReviewFluentImpl.ClusterResourceQuotaSpecContentNestedImpl(item);
  }
  public A withImageStreamSpecContent(ImageStreamSpec imageStreamSpecContent) {
    _visitables.get("content").remove(this.content);
    if (imageStreamSpecContent!=null){ this.content= new ImageStreamSpecBuilder(imageStreamSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.ImageStreamSpecContentNested<A> withNewImageStreamSpecContent() {
    return new LocalResourceAccessReviewFluentImpl.ImageStreamSpecContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.ImageStreamSpecContentNested<A> withNewImageStreamSpecContentLike(ImageStreamSpec item) {
    return new LocalResourceAccessReviewFluentImpl.ImageStreamSpecContentNestedImpl(item);
  }
  public A withRouteIngressContent(RouteIngress routeIngressContent) {
    _visitables.get("content").remove(this.content);
    if (routeIngressContent!=null){ this.content= new RouteIngressBuilder(routeIngressContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.RouteIngressContentNested<A> withNewRouteIngressContent() {
    return new LocalResourceAccessReviewFluentImpl.RouteIngressContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.RouteIngressContentNested<A> withNewRouteIngressContentLike(RouteIngress item) {
    return new LocalResourceAccessReviewFluentImpl.RouteIngressContentNestedImpl(item);
  }
  public A withOAuthClientContent(OAuthClient oAuthClientContent) {
    _visitables.get("content").remove(this.content);
    if (oAuthClientContent!=null){ this.content= new OAuthClientBuilder(oAuthClientContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.OAuthClientContentNested<A> withNewOAuthClientContent() {
    return new LocalResourceAccessReviewFluentImpl.OAuthClientContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.OAuthClientContentNested<A> withNewOAuthClientContentLike(OAuthClient item) {
    return new LocalResourceAccessReviewFluentImpl.OAuthClientContentNestedImpl(item);
  }
  public A withIdentityContent(Identity identityContent) {
    _visitables.get("content").remove(this.content);
    if (identityContent!=null){ this.content= new IdentityBuilder(identityContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.IdentityContentNested<A> withNewIdentityContent() {
    return new LocalResourceAccessReviewFluentImpl.IdentityContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.IdentityContentNested<A> withNewIdentityContentLike(Identity item) {
    return new LocalResourceAccessReviewFluentImpl.IdentityContentNestedImpl(item);
  }
  public A withRangeAllocationListContent(RangeAllocationList rangeAllocationListContent) {
    _visitables.get("content").remove(this.content);
    if (rangeAllocationListContent!=null){ this.content= new RangeAllocationListBuilder(rangeAllocationListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalResourceAccessReviewFluent.RangeAllocationListContentNested<A> withNewRangeAllocationListContent() {
    return new LocalResourceAccessReviewFluentImpl.RangeAllocationListContentNestedImpl();
  }
  public LocalResourceAccessReviewFluent.RangeAllocationListContentNested<A> withNewRangeAllocationListContentLike(RangeAllocationList item) {
    return new LocalResourceAccessReviewFluentImpl.RangeAllocationListContentNestedImpl(item);
  }
  public Boolean getIsNonResourceURL() {
    return this.isNonResourceURL;
  }
  public A withIsNonResourceURL(Boolean isNonResourceURL) {
    this.isNonResourceURL=isNonResourceURL; return (A) this;
  }
  public Boolean hasIsNonResourceURL() {
    return this.isNonResourceURL != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  public String getNamespace() {
    return this.namespace;
  }
  public A withNamespace(String namespace) {
    this.namespace=namespace; return (A) this;
  }
  public Boolean hasNamespace() {
    return this.namespace != null;
  }
  public String getPath() {
    return this.path;
  }
  public A withPath(String path) {
    this.path=path; return (A) this;
  }
  public Boolean hasPath() {
    return this.path != null;
  }
  public String getResource() {
    return this.resource;
  }
  public A withResource(String resource) {
    this.resource=resource; return (A) this;
  }
  public Boolean hasResource() {
    return this.resource != null;
  }
  public String getResourceAPIGroup() {
    return this.resourceAPIGroup;
  }
  public A withResourceAPIGroup(String resourceAPIGroup) {
    this.resourceAPIGroup=resourceAPIGroup; return (A) this;
  }
  public Boolean hasResourceAPIGroup() {
    return this.resourceAPIGroup != null;
  }
  public String getResourceAPIVersion() {
    return this.resourceAPIVersion;
  }
  public A withResourceAPIVersion(String resourceAPIVersion) {
    this.resourceAPIVersion=resourceAPIVersion; return (A) this;
  }
  public Boolean hasResourceAPIVersion() {
    return this.resourceAPIVersion != null;
  }
  public String getResourceName() {
    return this.resourceName;
  }
  public A withResourceName(String resourceName) {
    this.resourceName=resourceName; return (A) this;
  }
  public Boolean hasResourceName() {
    return this.resourceName != null;
  }
  public String getVerb() {
    return this.verb;
  }
  public A withVerb(String verb) {
    this.verb=verb; return (A) this;
  }
  public Boolean hasVerb() {
    return this.verb != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LocalResourceAccessReviewFluentImpl that = (LocalResourceAccessReviewFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (content != null ? !content.equals(that.content) :that.content != null) return false;
    if (isNonResourceURL != null ? !isNonResourceURL.equals(that.isNonResourceURL) :that.isNonResourceURL != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
    if (path != null ? !path.equals(that.path) :that.path != null) return false;
    if (resource != null ? !resource.equals(that.resource) :that.resource != null) return false;
    if (resourceAPIGroup != null ? !resourceAPIGroup.equals(that.resourceAPIGroup) :that.resourceAPIGroup != null) return false;
    if (resourceAPIVersion != null ? !resourceAPIVersion.equals(that.resourceAPIVersion) :that.resourceAPIVersion != null) return false;
    if (resourceName != null ? !resourceName.equals(that.resourceName) :that.resourceName != null) return false;
    if (verb != null ? !verb.equals(that.verb) :that.verb != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  content,  isNonResourceURL,  kind,  namespace,  path,  resource,  resourceAPIGroup,  resourceAPIVersion,  resourceName,  verb,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (content != null) { sb.append("content:"); sb.append(content + ","); }
    if (isNonResourceURL != null) { sb.append("isNonResourceURL:"); sb.append(isNonResourceURL + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (resource != null) { sb.append("resource:"); sb.append(resource + ","); }
    if (resourceAPIGroup != null) { sb.append("resourceAPIGroup:"); sb.append(resourceAPIGroup + ","); }
    if (resourceAPIVersion != null) { sb.append("resourceAPIVersion:"); sb.append(resourceAPIVersion + ","); }
    if (resourceName != null) { sb.append("resourceName:"); sb.append(resourceName + ","); }
    if (verb != null) { sb.append("verb:"); sb.append(verb + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withIsNonResourceURL() {
    return withIsNonResourceURL(true);
  }
  class GenericWebHookCauseContentNestedImpl<N> extends GenericWebHookCauseFluentImpl<LocalResourceAccessReviewFluent.GenericWebHookCauseContentNested<N>> implements LocalResourceAccessReviewFluent.GenericWebHookCauseContentNested<N>,Nested<N>{
    GenericWebHookCauseContentNestedImpl(GenericWebHookCause item) {
      this.builder = new GenericWebHookCauseBuilder(this, item);
    }
    GenericWebHookCauseContentNestedImpl() {
      this.builder = new GenericWebHookCauseBuilder(this);
    }
    GenericWebHookCauseBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endGenericWebHookCauseContent() {
      return and();
    }
    
  }
  class ServiceAccountRestrictionContentNestedImpl<N> extends ServiceAccountRestrictionFluentImpl<LocalResourceAccessReviewFluent.ServiceAccountRestrictionContentNested<N>> implements LocalResourceAccessReviewFluent.ServiceAccountRestrictionContentNested<N>,Nested<N>{
    ServiceAccountRestrictionContentNestedImpl(ServiceAccountRestriction item) {
      this.builder = new ServiceAccountRestrictionBuilder(this, item);
    }
    ServiceAccountRestrictionContentNestedImpl() {
      this.builder = new ServiceAccountRestrictionBuilder(this);
    }
    ServiceAccountRestrictionBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endServiceAccountRestrictionContent() {
      return and();
    }
    
  }
  class ScopeRestrictionContentNestedImpl<N> extends ScopeRestrictionFluentImpl<LocalResourceAccessReviewFluent.ScopeRestrictionContentNested<N>> implements LocalResourceAccessReviewFluent.ScopeRestrictionContentNested<N>,Nested<N>{
    ScopeRestrictionContentNestedImpl(ScopeRestriction item) {
      this.builder = new ScopeRestrictionBuilder(this, item);
    }
    ScopeRestrictionContentNestedImpl() {
      this.builder = new ScopeRestrictionBuilder(this);
    }
    ScopeRestrictionBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endScopeRestrictionContent() {
      return and();
    }
    
  }
  class SecretLocalReferenceContentNestedImpl<N> extends SecretLocalReferenceFluentImpl<LocalResourceAccessReviewFluent.SecretLocalReferenceContentNested<N>> implements LocalResourceAccessReviewFluent.SecretLocalReferenceContentNested<N>,Nested<N>{
    SecretLocalReferenceContentNestedImpl(SecretLocalReference item) {
      this.builder = new SecretLocalReferenceBuilder(this, item);
    }
    SecretLocalReferenceContentNestedImpl() {
      this.builder = new SecretLocalReferenceBuilder(this);
    }
    SecretLocalReferenceBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSecretLocalReferenceContent() {
      return and();
    }
    
  }
  class StepInfoContentNestedImpl<N> extends StepInfoFluentImpl<LocalResourceAccessReviewFluent.StepInfoContentNested<N>> implements LocalResourceAccessReviewFluent.StepInfoContentNested<N>,Nested<N>{
    StepInfoContentNestedImpl(StepInfo item) {
      this.builder = new StepInfoBuilder(this, item);
    }
    StepInfoContentNestedImpl() {
      this.builder = new StepInfoBuilder(this);
    }
    StepInfoBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endStepInfoContent() {
      return and();
    }
    
  }
  class UserRestrictionContentNestedImpl<N> extends UserRestrictionFluentImpl<LocalResourceAccessReviewFluent.UserRestrictionContentNested<N>> implements LocalResourceAccessReviewFluent.UserRestrictionContentNested<N>,Nested<N>{
    UserRestrictionContentNestedImpl(UserRestriction item) {
      this.builder = new UserRestrictionBuilder(this, item);
    }
    UserRestrictionContentNestedImpl() {
      this.builder = new UserRestrictionBuilder(this);
    }
    UserRestrictionBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endUserRestrictionContent() {
      return and();
    }
    
  }
  class PodTemplateSpecContentNestedImpl<N> extends PodTemplateSpecFluentImpl<LocalResourceAccessReviewFluent.PodTemplateSpecContentNested<N>> implements LocalResourceAccessReviewFluent.PodTemplateSpecContentNested<N>,Nested<N>{
    PodTemplateSpecContentNestedImpl(PodTemplateSpec item) {
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    PodTemplateSpecContentNestedImpl() {
      this.builder = new PodTemplateSpecBuilder(this);
    }
    PodTemplateSpecBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endPodTemplateSpecContent() {
      return and();
    }
    
  }
  class TemplateInstanceListContentNestedImpl<N> extends TemplateInstanceListFluentImpl<LocalResourceAccessReviewFluent.TemplateInstanceListContentNested<N>> implements LocalResourceAccessReviewFluent.TemplateInstanceListContentNested<N>,Nested<N>{
    TemplateInstanceListContentNestedImpl(TemplateInstanceList item) {
      this.builder = new TemplateInstanceListBuilder(this, item);
    }
    TemplateInstanceListContentNestedImpl() {
      this.builder = new TemplateInstanceListBuilder(this);
    }
    TemplateInstanceListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTemplateInstanceListContent() {
      return and();
    }
    
  }
  class ImageStreamImportContentNestedImpl<N> extends ImageStreamImportFluentImpl<LocalResourceAccessReviewFluent.ImageStreamImportContentNested<N>> implements LocalResourceAccessReviewFluent.ImageStreamImportContentNested<N>,Nested<N>{
    ImageStreamImportContentNestedImpl(ImageStreamImport item) {
      this.builder = new ImageStreamImportBuilder(this, item);
    }
    ImageStreamImportContentNestedImpl() {
      this.builder = new ImageStreamImportBuilder(this);
    }
    ImageStreamImportBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamImportContent() {
      return and();
    }
    
  }
  class ResourceRequirementsContentNestedImpl<N> extends ResourceRequirementsFluentImpl<LocalResourceAccessReviewFluent.ResourceRequirementsContentNested<N>> implements LocalResourceAccessReviewFluent.ResourceRequirementsContentNested<N>,Nested<N>{
    ResourceRequirementsContentNestedImpl(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsContentNestedImpl() {
      this.builder = new ResourceRequirementsBuilder(this);
    }
    ResourceRequirementsBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endResourceRequirementsContent() {
      return and();
    }
    
  }
  class GitHubWebHookCauseContentNestedImpl<N> extends GitHubWebHookCauseFluentImpl<LocalResourceAccessReviewFluent.GitHubWebHookCauseContentNested<N>> implements LocalResourceAccessReviewFluent.GitHubWebHookCauseContentNested<N>,Nested<N>{
    GitHubWebHookCauseContentNestedImpl(GitHubWebHookCause item) {
      this.builder = new GitHubWebHookCauseBuilder(this, item);
    }
    GitHubWebHookCauseContentNestedImpl() {
      this.builder = new GitHubWebHookCauseBuilder(this);
    }
    GitHubWebHookCauseBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endGitHubWebHookCauseContent() {
      return and();
    }
    
  }
  class OAuthClientListContentNestedImpl<N> extends OAuthClientListFluentImpl<LocalResourceAccessReviewFluent.OAuthClientListContentNested<N>> implements LocalResourceAccessReviewFluent.OAuthClientListContentNested<N>,Nested<N>{
    OAuthClientListContentNestedImpl(OAuthClientList item) {
      this.builder = new OAuthClientListBuilder(this, item);
    }
    OAuthClientListContentNestedImpl() {
      this.builder = new OAuthClientListBuilder(this);
    }
    OAuthClientListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endOAuthClientListContent() {
      return and();
    }
    
  }
  class PodSecurityPolicyReviewStatusContentNestedImpl<N> extends PodSecurityPolicyReviewStatusFluentImpl<LocalResourceAccessReviewFluent.PodSecurityPolicyReviewStatusContentNested<N>> implements LocalResourceAccessReviewFluent.PodSecurityPolicyReviewStatusContentNested<N>,Nested<N>{
    PodSecurityPolicyReviewStatusContentNestedImpl(PodSecurityPolicyReviewStatus item) {
      this.builder = new PodSecurityPolicyReviewStatusBuilder(this, item);
    }
    PodSecurityPolicyReviewStatusContentNestedImpl() {
      this.builder = new PodSecurityPolicyReviewStatusBuilder(this);
    }
    PodSecurityPolicyReviewStatusBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endPodSecurityPolicyReviewStatusContent() {
      return and();
    }
    
  }
  class TemplateInstanceStatusContentNestedImpl<N> extends TemplateInstanceStatusFluentImpl<LocalResourceAccessReviewFluent.TemplateInstanceStatusContentNested<N>> implements LocalResourceAccessReviewFluent.TemplateInstanceStatusContentNested<N>,Nested<N>{
    TemplateInstanceStatusContentNestedImpl(TemplateInstanceStatus item) {
      this.builder = new TemplateInstanceStatusBuilder(this, item);
    }
    TemplateInstanceStatusContentNestedImpl() {
      this.builder = new TemplateInstanceStatusBuilder(this);
    }
    TemplateInstanceStatusBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTemplateInstanceStatusContent() {
      return and();
    }
    
  }
  class HelmChartRepositoryListContentNestedImpl<N> extends HelmChartRepositoryListFluentImpl<LocalResourceAccessReviewFluent.HelmChartRepositoryListContentNested<N>> implements LocalResourceAccessReviewFluent.HelmChartRepositoryListContentNested<N>,Nested<N>{
    HelmChartRepositoryListContentNestedImpl(HelmChartRepositoryList item) {
      this.builder = new HelmChartRepositoryListBuilder(this, item);
    }
    HelmChartRepositoryListContentNestedImpl() {
      this.builder = new HelmChartRepositoryListBuilder(this);
    }
    HelmChartRepositoryListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endHelmChartRepositoryListContent() {
      return and();
    }
    
  }
  class PolicyRuleContentNestedImpl<N> extends PolicyRuleFluentImpl<LocalResourceAccessReviewFluent.PolicyRuleContentNested<N>> implements LocalResourceAccessReviewFluent.PolicyRuleContentNested<N>,Nested<N>{
    PolicyRuleContentNestedImpl(PolicyRule item) {
      this.builder = new PolicyRuleBuilder(this, item);
    }
    PolicyRuleContentNestedImpl() {
      this.builder = new PolicyRuleBuilder(this);
    }
    PolicyRuleBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endPolicyRuleContent() {
      return and();
    }
    
  }
  class DeploymentTriggerPolicyContentNestedImpl<N> extends DeploymentTriggerPolicyFluentImpl<LocalResourceAccessReviewFluent.DeploymentTriggerPolicyContentNested<N>> implements LocalResourceAccessReviewFluent.DeploymentTriggerPolicyContentNested<N>,Nested<N>{
    DeploymentTriggerPolicyContentNestedImpl(DeploymentTriggerPolicy item) {
      this.builder = new DeploymentTriggerPolicyBuilder(this, item);
    }
    DeploymentTriggerPolicyContentNestedImpl() {
      this.builder = new DeploymentTriggerPolicyBuilder(this);
    }
    DeploymentTriggerPolicyBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endDeploymentTriggerPolicyContent() {
      return and();
    }
    
  }
  class BuildStrategyContentNestedImpl<N> extends BuildStrategyFluentImpl<LocalResourceAccessReviewFluent.BuildStrategyContentNested<N>> implements LocalResourceAccessReviewFluent.BuildStrategyContentNested<N>,Nested<N>{
    BuildStrategyContentNestedImpl(BuildStrategy item) {
      this.builder = new BuildStrategyBuilder(this, item);
    }
    BuildStrategyContentNestedImpl() {
      this.builder = new BuildStrategyBuilder(this);
    }
    BuildStrategyBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildStrategyContent() {
      return and();
    }
    
  }
  class RepositoryImportSpecContentNestedImpl<N> extends RepositoryImportSpecFluentImpl<LocalResourceAccessReviewFluent.RepositoryImportSpecContentNested<N>> implements LocalResourceAccessReviewFluent.RepositoryImportSpecContentNested<N>,Nested<N>{
    RepositoryImportSpecContentNestedImpl(RepositoryImportSpec item) {
      this.builder = new RepositoryImportSpecBuilder(this, item);
    }
    RepositoryImportSpecContentNestedImpl() {
      this.builder = new RepositoryImportSpecBuilder(this);
    }
    RepositoryImportSpecBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRepositoryImportSpecContent() {
      return and();
    }
    
  }
  class BrokerTemplateInstanceListContentNestedImpl<N> extends BrokerTemplateInstanceListFluentImpl<LocalResourceAccessReviewFluent.BrokerTemplateInstanceListContentNested<N>> implements LocalResourceAccessReviewFluent.BrokerTemplateInstanceListContentNested<N>,Nested<N>{
    BrokerTemplateInstanceListContentNestedImpl(BrokerTemplateInstanceList item) {
      this.builder = new BrokerTemplateInstanceListBuilder(this, item);
    }
    BrokerTemplateInstanceListContentNestedImpl() {
      this.builder = new BrokerTemplateInstanceListBuilder(this);
    }
    BrokerTemplateInstanceListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBrokerTemplateInstanceListContent() {
      return and();
    }
    
  }
  class ImageStreamImportStatusContentNestedImpl<N> extends ImageStreamImportStatusFluentImpl<LocalResourceAccessReviewFluent.ImageStreamImportStatusContentNested<N>> implements LocalResourceAccessReviewFluent.ImageStreamImportStatusContentNested<N>,Nested<N>{
    ImageStreamImportStatusContentNestedImpl(ImageStreamImportStatus item) {
      this.builder = new ImageStreamImportStatusBuilder(this, item);
    }
    ImageStreamImportStatusContentNestedImpl() {
      this.builder = new ImageStreamImportStatusBuilder(this);
    }
    ImageStreamImportStatusBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamImportStatusContent() {
      return and();
    }
    
  }
  class CustomBuildStrategyContentNestedImpl<N> extends CustomBuildStrategyFluentImpl<LocalResourceAccessReviewFluent.CustomBuildStrategyContentNested<N>> implements LocalResourceAccessReviewFluent.CustomBuildStrategyContentNested<N>,Nested<N>{
    CustomBuildStrategyContentNestedImpl(CustomBuildStrategy item) {
      this.builder = new CustomBuildStrategyBuilder(this, item);
    }
    CustomBuildStrategyContentNestedImpl() {
      this.builder = new CustomBuildStrategyBuilder(this);
    }
    CustomBuildStrategyBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endCustomBuildStrategyContent() {
      return and();
    }
    
  }
  class ClusterResourceQuotaSelectorContentNestedImpl<N> extends ClusterResourceQuotaSelectorFluentImpl<LocalResourceAccessReviewFluent.ClusterResourceQuotaSelectorContentNested<N>> implements LocalResourceAccessReviewFluent.ClusterResourceQuotaSelectorContentNested<N>,Nested<N>{
    ClusterResourceQuotaSelectorContentNestedImpl(ClusterResourceQuotaSelector item) {
      this.builder = new ClusterResourceQuotaSelectorBuilder(this, item);
    }
    ClusterResourceQuotaSelectorContentNestedImpl() {
      this.builder = new ClusterResourceQuotaSelectorBuilder(this);
    }
    ClusterResourceQuotaSelectorBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterResourceQuotaSelectorContent() {
      return and();
    }
    
  }
  class SubjectAccessReviewResponseContentNestedImpl<N> extends SubjectAccessReviewResponseFluentImpl<LocalResourceAccessReviewFluent.SubjectAccessReviewResponseContentNested<N>> implements LocalResourceAccessReviewFluent.SubjectAccessReviewResponseContentNested<N>,Nested<N>{
    SubjectAccessReviewResponseContentNestedImpl(SubjectAccessReviewResponse item) {
      this.builder = new SubjectAccessReviewResponseBuilder(this, item);
    }
    SubjectAccessReviewResponseContentNestedImpl() {
      this.builder = new SubjectAccessReviewResponseBuilder(this);
    }
    SubjectAccessReviewResponseBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSubjectAccessReviewResponseContent() {
      return and();
    }
    
  }
  class DeploymentTriggerImageChangeParamsContentNestedImpl<N> extends DeploymentTriggerImageChangeParamsFluentImpl<LocalResourceAccessReviewFluent.DeploymentTriggerImageChangeParamsContentNested<N>> implements LocalResourceAccessReviewFluent.DeploymentTriggerImageChangeParamsContentNested<N>,Nested<N>{
    DeploymentTriggerImageChangeParamsContentNestedImpl(DeploymentTriggerImageChangeParams item) {
      this.builder = new DeploymentTriggerImageChangeParamsBuilder(this, item);
    }
    DeploymentTriggerImageChangeParamsContentNestedImpl() {
      this.builder = new DeploymentTriggerImageChangeParamsBuilder(this);
    }
    DeploymentTriggerImageChangeParamsBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endDeploymentTriggerImageChangeParamsContent() {
      return and();
    }
    
  }
  class LocalObjectReferenceContentNestedImpl<N> extends LocalObjectReferenceFluentImpl<LocalResourceAccessReviewFluent.LocalObjectReferenceContentNested<N>> implements LocalResourceAccessReviewFluent.LocalObjectReferenceContentNested<N>,Nested<N>{
    LocalObjectReferenceContentNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceContentNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endLocalObjectReferenceContent() {
      return and();
    }
    
  }
  class TagImageHookContentNestedImpl<N> extends TagImageHookFluentImpl<LocalResourceAccessReviewFluent.TagImageHookContentNested<N>> implements LocalResourceAccessReviewFluent.TagImageHookContentNested<N>,Nested<N>{
    TagImageHookContentNestedImpl(TagImageHook item) {
      this.builder = new TagImageHookBuilder(this, item);
    }
    TagImageHookContentNestedImpl() {
      this.builder = new TagImageHookBuilder(this);
    }
    TagImageHookBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTagImageHookContent() {
      return and();
    }
    
  }
  class RouteTargetReferenceContentNestedImpl<N> extends RouteTargetReferenceFluentImpl<LocalResourceAccessReviewFluent.RouteTargetReferenceContentNested<N>> implements LocalResourceAccessReviewFluent.RouteTargetReferenceContentNested<N>,Nested<N>{
    RouteTargetReferenceContentNestedImpl(RouteTargetReference item) {
      this.builder = new RouteTargetReferenceBuilder(this, item);
    }
    RouteTargetReferenceContentNestedImpl() {
      this.builder = new RouteTargetReferenceBuilder(this);
    }
    RouteTargetReferenceBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRouteTargetReferenceContent() {
      return and();
    }
    
  }
  class RawExtensionContentNestedImpl<N> extends RawExtensionFluentImpl<LocalResourceAccessReviewFluent.RawExtensionContentNested<N>> implements LocalResourceAccessReviewFluent.RawExtensionContentNested<N>,Nested<N>{
    RawExtensionContentNestedImpl(RawExtension item) {
      this.builder = new RawExtensionBuilder(this, item);
    }
    RawExtensionContentNestedImpl() {
      this.builder = new RawExtensionBuilder(this);
    }
    RawExtensionBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRawExtensionContent() {
      return and();
    }
    
  }
  class SubjectRulesReviewSpecContentNestedImpl<N> extends SubjectRulesReviewSpecFluentImpl<LocalResourceAccessReviewFluent.SubjectRulesReviewSpecContentNested<N>> implements LocalResourceAccessReviewFluent.SubjectRulesReviewSpecContentNested<N>,Nested<N>{
    SubjectRulesReviewSpecContentNestedImpl(SubjectRulesReviewSpec item) {
      this.builder = new SubjectRulesReviewSpecBuilder(this, item);
    }
    SubjectRulesReviewSpecContentNestedImpl() {
      this.builder = new SubjectRulesReviewSpecBuilder(this);
    }
    SubjectRulesReviewSpecBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSubjectRulesReviewSpecContent() {
      return and();
    }
    
  }
  class TagReferencePolicyContentNestedImpl<N> extends TagReferencePolicyFluentImpl<LocalResourceAccessReviewFluent.TagReferencePolicyContentNested<N>> implements LocalResourceAccessReviewFluent.TagReferencePolicyContentNested<N>,Nested<N>{
    TagReferencePolicyContentNestedImpl(TagReferencePolicy item) {
      this.builder = new TagReferencePolicyBuilder(this, item);
    }
    TagReferencePolicyContentNestedImpl() {
      this.builder = new TagReferencePolicyBuilder(this);
    }
    TagReferencePolicyBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTagReferencePolicyContent() {
      return and();
    }
    
  }
  class RoleListContentNestedImpl<N> extends RoleListFluentImpl<LocalResourceAccessReviewFluent.RoleListContentNested<N>> implements LocalResourceAccessReviewFluent.RoleListContentNested<N>,Nested<N>{
    RoleListContentNestedImpl(RoleList item) {
      this.builder = new RoleListBuilder(this, item);
    }
    RoleListContentNestedImpl() {
      this.builder = new RoleListBuilder(this);
    }
    RoleListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRoleListContent() {
      return and();
    }
    
  }
  class ProjectContentNestedImpl<N> extends ProjectFluentImpl<LocalResourceAccessReviewFluent.ProjectContentNested<N>> implements LocalResourceAccessReviewFluent.ProjectContentNested<N>,Nested<N>{
    ProjectContentNestedImpl(Project item) {
      this.builder = new ProjectBuilder(this, item);
    }
    ProjectContentNestedImpl() {
      this.builder = new ProjectBuilder(this);
    }
    ProjectBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endProjectContent() {
      return and();
    }
    
  }
  class BuildVolumeSourceContentNestedImpl<N> extends BuildVolumeSourceFluentImpl<LocalResourceAccessReviewFluent.BuildVolumeSourceContentNested<N>> implements LocalResourceAccessReviewFluent.BuildVolumeSourceContentNested<N>,Nested<N>{
    BuildVolumeSourceContentNestedImpl(BuildVolumeSource item) {
      this.builder = new BuildVolumeSourceBuilder(this, item);
    }
    BuildVolumeSourceContentNestedImpl() {
      this.builder = new BuildVolumeSourceBuilder(this);
    }
    BuildVolumeSourceBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildVolumeSourceContent() {
      return and();
    }
    
  }
  class AppliedClusterResourceQuotaListContentNestedImpl<N> extends AppliedClusterResourceQuotaListFluentImpl<LocalResourceAccessReviewFluent.AppliedClusterResourceQuotaListContentNested<N>> implements LocalResourceAccessReviewFluent.AppliedClusterResourceQuotaListContentNested<N>,Nested<N>{
    AppliedClusterResourceQuotaListContentNestedImpl(AppliedClusterResourceQuotaList item) {
      this.builder = new AppliedClusterResourceQuotaListBuilder(this, item);
    }
    AppliedClusterResourceQuotaListContentNestedImpl() {
      this.builder = new AppliedClusterResourceQuotaListBuilder(this);
    }
    AppliedClusterResourceQuotaListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endAppliedClusterResourceQuotaListContent() {
      return and();
    }
    
  }
  class DeploymentConfigListContentNestedImpl<N> extends DeploymentConfigListFluentImpl<LocalResourceAccessReviewFluent.DeploymentConfigListContentNested<N>> implements LocalResourceAccessReviewFluent.DeploymentConfigListContentNested<N>,Nested<N>{
    DeploymentConfigListContentNestedImpl(DeploymentConfigList item) {
      this.builder = new DeploymentConfigListBuilder(this, item);
    }
    DeploymentConfigListContentNestedImpl() {
      this.builder = new DeploymentConfigListBuilder(this);
    }
    DeploymentConfigListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endDeploymentConfigListContent() {
      return and();
    }
    
  }
  class BuildStatusOutputContentNestedImpl<N> extends BuildStatusOutputFluentImpl<LocalResourceAccessReviewFluent.BuildStatusOutputContentNested<N>> implements LocalResourceAccessReviewFluent.BuildStatusOutputContentNested<N>,Nested<N>{
    BuildStatusOutputContentNestedImpl(BuildStatusOutput item) {
      this.builder = new BuildStatusOutputBuilder(this, item);
    }
    BuildStatusOutputContentNestedImpl() {
      this.builder = new BuildStatusOutputBuilder(this);
    }
    BuildStatusOutputBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildStatusOutputContent() {
      return and();
    }
    
  }
  class BuildConfigContentNestedImpl<N> extends BuildConfigFluentImpl<LocalResourceAccessReviewFluent.BuildConfigContentNested<N>> implements LocalResourceAccessReviewFluent.BuildConfigContentNested<N>,Nested<N>{
    BuildConfigContentNestedImpl(BuildConfig item) {
      this.builder = new BuildConfigBuilder(this, item);
    }
    BuildConfigContentNestedImpl() {
      this.builder = new BuildConfigBuilder(this);
    }
    BuildConfigBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildConfigContent() {
      return and();
    }
    
  }
  class ImageImportStatusContentNestedImpl<N> extends ImageImportStatusFluentImpl<LocalResourceAccessReviewFluent.ImageImportStatusContentNested<N>> implements LocalResourceAccessReviewFluent.ImageImportStatusContentNested<N>,Nested<N>{
    ImageImportStatusContentNestedImpl(ImageImportStatus item) {
      this.builder = new ImageImportStatusBuilder(this, item);
    }
    ImageImportStatusContentNestedImpl() {
      this.builder = new ImageImportStatusBuilder(this);
    }
    ImageImportStatusBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageImportStatusContent() {
      return and();
    }
    
  }
  class PodSecurityPolicySubjectReviewContentNestedImpl<N> extends PodSecurityPolicySubjectReviewFluentImpl<LocalResourceAccessReviewFluent.PodSecurityPolicySubjectReviewContentNested<N>> implements LocalResourceAccessReviewFluent.PodSecurityPolicySubjectReviewContentNested<N>,Nested<N>{
    PodSecurityPolicySubjectReviewContentNestedImpl(PodSecurityPolicySubjectReview item) {
      this.builder = new PodSecurityPolicySubjectReviewBuilder(this, item);
    }
    PodSecurityPolicySubjectReviewContentNestedImpl() {
      this.builder = new PodSecurityPolicySubjectReviewBuilder(this);
    }
    PodSecurityPolicySubjectReviewBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endPodSecurityPolicySubjectReviewContent() {
      return and();
    }
    
  }
  class GitLabWebHookCauseContentNestedImpl<N> extends GitLabWebHookCauseFluentImpl<LocalResourceAccessReviewFluent.GitLabWebHookCauseContentNested<N>> implements LocalResourceAccessReviewFluent.GitLabWebHookCauseContentNested<N>,Nested<N>{
    GitLabWebHookCauseContentNestedImpl(GitLabWebHookCause item) {
      this.builder = new GitLabWebHookCauseBuilder(this, item);
    }
    GitLabWebHookCauseContentNestedImpl() {
      this.builder = new GitLabWebHookCauseBuilder(this);
    }
    GitLabWebHookCauseBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endGitLabWebHookCauseContent() {
      return and();
    }
    
  }
  class DeploymentConfigStatusContentNestedImpl<N> extends DeploymentConfigStatusFluentImpl<LocalResourceAccessReviewFluent.DeploymentConfigStatusContentNested<N>> implements LocalResourceAccessReviewFluent.DeploymentConfigStatusContentNested<N>,Nested<N>{
    DeploymentConfigStatusContentNestedImpl(DeploymentConfigStatus item) {
      this.builder = new DeploymentConfigStatusBuilder(this, item);
    }
    DeploymentConfigStatusContentNestedImpl() {
      this.builder = new DeploymentConfigStatusBuilder(this);
    }
    DeploymentConfigStatusBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endDeploymentConfigStatusContent() {
      return and();
    }
    
  }
  class SecretBuildSourceContentNestedImpl<N> extends SecretBuildSourceFluentImpl<LocalResourceAccessReviewFluent.SecretBuildSourceContentNested<N>> implements LocalResourceAccessReviewFluent.SecretBuildSourceContentNested<N>,Nested<N>{
    SecretBuildSourceContentNestedImpl(SecretBuildSource item) {
      this.builder = new SecretBuildSourceBuilder(this, item);
    }
    SecretBuildSourceContentNestedImpl() {
      this.builder = new SecretBuildSourceBuilder(this);
    }
    SecretBuildSourceBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSecretBuildSourceContent() {
      return and();
    }
    
  }
  class EgressNetworkPolicySpecContentNestedImpl<N> extends EgressNetworkPolicySpecFluentImpl<LocalResourceAccessReviewFluent.EgressNetworkPolicySpecContentNested<N>> implements LocalResourceAccessReviewFluent.EgressNetworkPolicySpecContentNested<N>,Nested<N>{
    EgressNetworkPolicySpecContentNestedImpl(EgressNetworkPolicySpec item) {
      this.builder = new EgressNetworkPolicySpecBuilder(this, item);
    }
    EgressNetworkPolicySpecContentNestedImpl() {
      this.builder = new EgressNetworkPolicySpecBuilder(this);
    }
    EgressNetworkPolicySpecBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endEgressNetworkPolicySpecContent() {
      return and();
    }
    
  }
  class HelmChartRepositoryContentNestedImpl<N> extends HelmChartRepositoryFluentImpl<LocalResourceAccessReviewFluent.HelmChartRepositoryContentNested<N>> implements LocalResourceAccessReviewFluent.HelmChartRepositoryContentNested<N>,Nested<N>{
    HelmChartRepositoryContentNestedImpl(HelmChartRepository item) {
      this.builder = new HelmChartRepositoryBuilder(this, item);
    }
    HelmChartRepositoryContentNestedImpl() {
      this.builder = new HelmChartRepositoryBuilder(this);
    }
    HelmChartRepositoryBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endHelmChartRepositoryContent() {
      return and();
    }
    
  }
  class TagEventContentNestedImpl<N> extends TagEventFluentImpl<LocalResourceAccessReviewFluent.TagEventContentNested<N>> implements LocalResourceAccessReviewFluent.TagEventContentNested<N>,Nested<N>{
    TagEventContentNestedImpl(TagEvent item) {
      this.builder = new TagEventBuilder(this, item);
    }
    TagEventContentNestedImpl() {
      this.builder = new TagEventBuilder(this);
    }
    TagEventBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTagEventContent() {
      return and();
    }
    
  }
  class ImageStreamTagListContentNestedImpl<N> extends ImageStreamTagListFluentImpl<LocalResourceAccessReviewFluent.ImageStreamTagListContentNested<N>> implements LocalResourceAccessReviewFluent.ImageStreamTagListContentNested<N>,Nested<N>{
    ImageStreamTagListContentNestedImpl(ImageStreamTagList item) {
      this.builder = new ImageStreamTagListBuilder(this, item);
    }
    ImageStreamTagListContentNestedImpl() {
      this.builder = new ImageStreamTagListBuilder(this);
    }
    ImageStreamTagListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamTagListContent() {
      return and();
    }
    
  }
  class BitbucketWebHookCauseContentNestedImpl<N> extends BitbucketWebHookCauseFluentImpl<LocalResourceAccessReviewFluent.BitbucketWebHookCauseContentNested<N>> implements LocalResourceAccessReviewFluent.BitbucketWebHookCauseContentNested<N>,Nested<N>{
    BitbucketWebHookCauseContentNestedImpl(BitbucketWebHookCause item) {
      this.builder = new BitbucketWebHookCauseBuilder(this, item);
    }
    BitbucketWebHookCauseContentNestedImpl() {
      this.builder = new BitbucketWebHookCauseBuilder(this);
    }
    BitbucketWebHookCauseBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBitbucketWebHookCauseContent() {
      return and();
    }
    
  }
  class ProjectListContentNestedImpl<N> extends ProjectListFluentImpl<LocalResourceAccessReviewFluent.ProjectListContentNested<N>> implements LocalResourceAccessReviewFluent.ProjectListContentNested<N>,Nested<N>{
    ProjectListContentNestedImpl(ProjectList item) {
      this.builder = new ProjectListBuilder(this, item);
    }
    ProjectListContentNestedImpl() {
      this.builder = new ProjectListBuilder(this);
    }
    ProjectListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endProjectListContent() {
      return and();
    }
    
  }
  class RangeAllocationContentNestedImpl<N> extends RangeAllocationFluentImpl<LocalResourceAccessReviewFluent.RangeAllocationContentNested<N>> implements LocalResourceAccessReviewFluent.RangeAllocationContentNested<N>,Nested<N>{
    RangeAllocationContentNestedImpl(RangeAllocation item) {
      this.builder = new RangeAllocationBuilder(this, item);
    }
    RangeAllocationContentNestedImpl() {
      this.builder = new RangeAllocationBuilder(this);
    }
    RangeAllocationBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRangeAllocationContent() {
      return and();
    }
    
  }
  class ClusterRoleScopeRestrictionContentNestedImpl<N> extends ClusterRoleScopeRestrictionFluentImpl<LocalResourceAccessReviewFluent.ClusterRoleScopeRestrictionContentNested<N>> implements LocalResourceAccessReviewFluent.ClusterRoleScopeRestrictionContentNested<N>,Nested<N>{
    ClusterRoleScopeRestrictionContentNestedImpl(ClusterRoleScopeRestriction item) {
      this.builder = new ClusterRoleScopeRestrictionBuilder(this, item);
    }
    ClusterRoleScopeRestrictionContentNestedImpl() {
      this.builder = new ClusterRoleScopeRestrictionBuilder(this);
    }
    ClusterRoleScopeRestrictionBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterRoleScopeRestrictionContent() {
      return and();
    }
    
  }
  class RouteContentNestedImpl<N> extends RouteFluentImpl<LocalResourceAccessReviewFluent.RouteContentNested<N>> implements LocalResourceAccessReviewFluent.RouteContentNested<N>,Nested<N>{
    RouteContentNestedImpl(Route item) {
      this.builder = new RouteBuilder(this, item);
    }
    RouteContentNestedImpl() {
      this.builder = new RouteBuilder(this);
    }
    RouteBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRouteContent() {
      return and();
    }
    
  }
  class SourceStrategyOptionsContentNestedImpl<N> extends SourceStrategyOptionsFluentImpl<LocalResourceAccessReviewFluent.SourceStrategyOptionsContentNested<N>> implements LocalResourceAccessReviewFluent.SourceStrategyOptionsContentNested<N>,Nested<N>{
    SourceStrategyOptionsContentNestedImpl(SourceStrategyOptions item) {
      this.builder = new SourceStrategyOptionsBuilder(this, item);
    }
    SourceStrategyOptionsContentNestedImpl() {
      this.builder = new SourceStrategyOptionsBuilder(this);
    }
    SourceStrategyOptionsBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSourceStrategyOptionsContent() {
      return and();
    }
    
  }
  class ClusterNetworkContentNestedImpl<N> extends ClusterNetworkFluentImpl<LocalResourceAccessReviewFluent.ClusterNetworkContentNested<N>> implements LocalResourceAccessReviewFluent.ClusterNetworkContentNested<N>,Nested<N>{
    ClusterNetworkContentNestedImpl(ClusterNetwork item) {
      this.builder = new ClusterNetworkBuilder(this, item);
    }
    ClusterNetworkContentNestedImpl() {
      this.builder = new ClusterNetworkBuilder(this);
    }
    ClusterNetworkBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterNetworkContent() {
      return and();
    }
    
  }
  class OAuthAuthorizeTokenContentNestedImpl<N> extends OAuthAuthorizeTokenFluentImpl<LocalResourceAccessReviewFluent.OAuthAuthorizeTokenContentNested<N>> implements LocalResourceAccessReviewFluent.OAuthAuthorizeTokenContentNested<N>,Nested<N>{
    OAuthAuthorizeTokenContentNestedImpl(OAuthAuthorizeToken item) {
      this.builder = new OAuthAuthorizeTokenBuilder(this, item);
    }
    OAuthAuthorizeTokenContentNestedImpl() {
      this.builder = new OAuthAuthorizeTokenBuilder(this);
    }
    OAuthAuthorizeTokenBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endOAuthAuthorizeTokenContent() {
      return and();
    }
    
  }
  class DockerBuildStrategyContentNestedImpl<N> extends DockerBuildStrategyFluentImpl<LocalResourceAccessReviewFluent.DockerBuildStrategyContentNested<N>> implements LocalResourceAccessReviewFluent.DockerBuildStrategyContentNested<N>,Nested<N>{
    DockerBuildStrategyContentNestedImpl(DockerBuildStrategy item) {
      this.builder = new DockerBuildStrategyBuilder(this, item);
    }
    DockerBuildStrategyContentNestedImpl() {
      this.builder = new DockerBuildStrategyBuilder(this);
    }
    DockerBuildStrategyBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endDockerBuildStrategyContent() {
      return and();
    }
    
  }
  class SignatureConditionContentNestedImpl<N> extends SignatureConditionFluentImpl<LocalResourceAccessReviewFluent.SignatureConditionContentNested<N>> implements LocalResourceAccessReviewFluent.SignatureConditionContentNested<N>,Nested<N>{
    SignatureConditionContentNestedImpl(SignatureCondition item) {
      this.builder = new SignatureConditionBuilder(this, item);
    }
    SignatureConditionContentNestedImpl() {
      this.builder = new SignatureConditionBuilder(this);
    }
    SignatureConditionBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSignatureConditionContent() {
      return and();
    }
    
  }
  class UserOAuthAccessTokenContentNestedImpl<N> extends UserOAuthAccessTokenFluentImpl<LocalResourceAccessReviewFluent.UserOAuthAccessTokenContentNested<N>> implements LocalResourceAccessReviewFluent.UserOAuthAccessTokenContentNested<N>,Nested<N>{
    UserOAuthAccessTokenContentNestedImpl(UserOAuthAccessToken item) {
      this.builder = new UserOAuthAccessTokenBuilder(this, item);
    }
    UserOAuthAccessTokenContentNestedImpl() {
      this.builder = new UserOAuthAccessTokenBuilder(this);
    }
    UserOAuthAccessTokenBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endUserOAuthAccessTokenContent() {
      return and();
    }
    
  }
  class RoleBindingRestrictionListContentNestedImpl<N> extends RoleBindingRestrictionListFluentImpl<LocalResourceAccessReviewFluent.RoleBindingRestrictionListContentNested<N>> implements LocalResourceAccessReviewFluent.RoleBindingRestrictionListContentNested<N>,Nested<N>{
    RoleBindingRestrictionListContentNestedImpl(RoleBindingRestrictionList item) {
      this.builder = new RoleBindingRestrictionListBuilder(this, item);
    }
    RoleBindingRestrictionListContentNestedImpl() {
      this.builder = new RoleBindingRestrictionListBuilder(this);
    }
    RoleBindingRestrictionListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRoleBindingRestrictionListContent() {
      return and();
    }
    
  }
  class SecurityContextConstraintsListContentNestedImpl<N> extends SecurityContextConstraintsListFluentImpl<LocalResourceAccessReviewFluent.SecurityContextConstraintsListContentNested<N>> implements LocalResourceAccessReviewFluent.SecurityContextConstraintsListContentNested<N>,Nested<N>{
    SecurityContextConstraintsListContentNestedImpl(SecurityContextConstraintsList item) {
      this.builder = new SecurityContextConstraintsListBuilder(this, item);
    }
    SecurityContextConstraintsListContentNestedImpl() {
      this.builder = new SecurityContextConstraintsListBuilder(this);
    }
    SecurityContextConstraintsListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSecurityContextConstraintsListContent() {
      return and();
    }
    
  }
  class IdentityListContentNestedImpl<N> extends IdentityListFluentImpl<LocalResourceAccessReviewFluent.IdentityListContentNested<N>> implements LocalResourceAccessReviewFluent.IdentityListContentNested<N>,Nested<N>{
    IdentityListContentNestedImpl(IdentityList item) {
      this.builder = new IdentityListBuilder(this, item);
    }
    IdentityListContentNestedImpl() {
      this.builder = new IdentityListBuilder(this);
    }
    IdentityListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endIdentityListContent() {
      return and();
    }
    
  }
  class BuildConfigListContentNestedImpl<N> extends BuildConfigListFluentImpl<LocalResourceAccessReviewFluent.BuildConfigListContentNested<N>> implements LocalResourceAccessReviewFluent.BuildConfigListContentNested<N>,Nested<N>{
    BuildConfigListContentNestedImpl(BuildConfigList item) {
      this.builder = new BuildConfigListBuilder(this, item);
    }
    BuildConfigListContentNestedImpl() {
      this.builder = new BuildConfigListBuilder(this);
    }
    BuildConfigListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildConfigListContent() {
      return and();
    }
    
  }
  class ClusterNetworkListContentNestedImpl<N> extends ClusterNetworkListFluentImpl<LocalResourceAccessReviewFluent.ClusterNetworkListContentNested<N>> implements LocalResourceAccessReviewFluent.ClusterNetworkListContentNested<N>,Nested<N>{
    ClusterNetworkListContentNestedImpl(ClusterNetworkList item) {
      this.builder = new ClusterNetworkListBuilder(this, item);
    }
    ClusterNetworkListContentNestedImpl() {
      this.builder = new ClusterNetworkListBuilder(this);
    }
    ClusterNetworkListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterNetworkListContent() {
      return and();
    }
    
  }
  class TemplateInstanceConditionContentNestedImpl<N> extends TemplateInstanceConditionFluentImpl<LocalResourceAccessReviewFluent.TemplateInstanceConditionContentNested<N>> implements LocalResourceAccessReviewFluent.TemplateInstanceConditionContentNested<N>,Nested<N>{
    TemplateInstanceConditionContentNestedImpl(TemplateInstanceCondition item) {
      this.builder = new TemplateInstanceConditionBuilder(this, item);
    }
    TemplateInstanceConditionContentNestedImpl() {
      this.builder = new TemplateInstanceConditionBuilder(this);
    }
    TemplateInstanceConditionBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTemplateInstanceConditionContent() {
      return and();
    }
    
  }
  class RepositoryImportStatusContentNestedImpl<N> extends RepositoryImportStatusFluentImpl<LocalResourceAccessReviewFluent.RepositoryImportStatusContentNested<N>> implements LocalResourceAccessReviewFluent.RepositoryImportStatusContentNested<N>,Nested<N>{
    RepositoryImportStatusContentNestedImpl(RepositoryImportStatus item) {
      this.builder = new RepositoryImportStatusBuilder(this, item);
    }
    RepositoryImportStatusContentNestedImpl() {
      this.builder = new RepositoryImportStatusBuilder(this);
    }
    RepositoryImportStatusBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRepositoryImportStatusContent() {
      return and();
    }
    
  }
  class DeploymentCauseContentNestedImpl<N> extends DeploymentCauseFluentImpl<LocalResourceAccessReviewFluent.DeploymentCauseContentNested<N>> implements LocalResourceAccessReviewFluent.DeploymentCauseContentNested<N>,Nested<N>{
    DeploymentCauseContentNestedImpl(DeploymentCause item) {
      this.builder = new DeploymentCauseBuilder(this, item);
    }
    DeploymentCauseContentNestedImpl() {
      this.builder = new DeploymentCauseBuilder(this);
    }
    DeploymentCauseBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endDeploymentCauseContent() {
      return and();
    }
    
  }
  class GroupListContentNestedImpl<N> extends GroupListFluentImpl<LocalResourceAccessReviewFluent.GroupListContentNested<N>> implements LocalResourceAccessReviewFluent.GroupListContentNested<N>,Nested<N>{
    GroupListContentNestedImpl(GroupList item) {
      this.builder = new GroupListBuilder(this, item);
    }
    GroupListContentNestedImpl() {
      this.builder = new GroupListBuilder(this);
    }
    GroupListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endGroupListContent() {
      return and();
    }
    
  }
  class RunAsUserStrategyOptionsContentNestedImpl<N> extends RunAsUserStrategyOptionsFluentImpl<LocalResourceAccessReviewFluent.RunAsUserStrategyOptionsContentNested<N>> implements LocalResourceAccessReviewFluent.RunAsUserStrategyOptionsContentNested<N>,Nested<N>{
    RunAsUserStrategyOptionsContentNestedImpl(RunAsUserStrategyOptions item) {
      this.builder = new RunAsUserStrategyOptionsBuilder(this, item);
    }
    RunAsUserStrategyOptionsContentNestedImpl() {
      this.builder = new RunAsUserStrategyOptionsBuilder(this);
    }
    RunAsUserStrategyOptionsBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRunAsUserStrategyOptionsContent() {
      return and();
    }
    
  }
  class LifecycleHookContentNestedImpl<N> extends LifecycleHookFluentImpl<LocalResourceAccessReviewFluent.LifecycleHookContentNested<N>> implements LocalResourceAccessReviewFluent.LifecycleHookContentNested<N>,Nested<N>{
    LifecycleHookContentNestedImpl(LifecycleHook item) {
      this.builder = new LifecycleHookBuilder(this, item);
    }
    LifecycleHookContentNestedImpl() {
      this.builder = new LifecycleHookBuilder(this);
    }
    LifecycleHookBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endLifecycleHookContent() {
      return and();
    }
    
  }
  class ImageStreamTagReferenceContentNestedImpl<N> extends ImageStreamTagReferenceFluentImpl<LocalResourceAccessReviewFluent.ImageStreamTagReferenceContentNested<N>> implements LocalResourceAccessReviewFluent.ImageStreamTagReferenceContentNested<N>,Nested<N>{
    ImageStreamTagReferenceContentNestedImpl(ImageStreamTagReference item) {
      this.builder = new ImageStreamTagReferenceBuilder(this, item);
    }
    ImageStreamTagReferenceContentNestedImpl() {
      this.builder = new ImageStreamTagReferenceBuilder(this);
    }
    ImageStreamTagReferenceBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamTagReferenceContent() {
      return and();
    }
    
  }
  class SourceControlUserContentNestedImpl<N> extends SourceControlUserFluentImpl<LocalResourceAccessReviewFluent.SourceControlUserContentNested<N>> implements LocalResourceAccessReviewFluent.SourceControlUserContentNested<N>,Nested<N>{
    SourceControlUserContentNestedImpl(SourceControlUser item) {
      this.builder = new SourceControlUserBuilder(this, item);
    }
    SourceControlUserContentNestedImpl() {
      this.builder = new SourceControlUserBuilder(this);
    }
    SourceControlUserBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSourceControlUserContent() {
      return and();
    }
    
  }
  class ContainerContentNestedImpl<N> extends ContainerFluentImpl<LocalResourceAccessReviewFluent.ContainerContentNested<N>> implements LocalResourceAccessReviewFluent.ContainerContentNested<N>,Nested<N>{
    ContainerContentNestedImpl(Container item) {
      this.builder = new ContainerBuilder(this, item);
    }
    ContainerContentNestedImpl() {
      this.builder = new ContainerBuilder(this);
    }
    ContainerBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endContainerContent() {
      return and();
    }
    
  }
  class ImageStreamListContentNestedImpl<N> extends ImageStreamListFluentImpl<LocalResourceAccessReviewFluent.ImageStreamListContentNested<N>> implements LocalResourceAccessReviewFluent.ImageStreamListContentNested<N>,Nested<N>{
    ImageStreamListContentNestedImpl(ImageStreamList item) {
      this.builder = new ImageStreamListBuilder(this, item);
    }
    ImageStreamListContentNestedImpl() {
      this.builder = new ImageStreamListBuilder(this);
    }
    ImageStreamListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamListContent() {
      return and();
    }
    
  }
  class ClusterRoleBindingContentNestedImpl<N> extends ClusterRoleBindingFluentImpl<LocalResourceAccessReviewFluent.ClusterRoleBindingContentNested<N>> implements LocalResourceAccessReviewFluent.ClusterRoleBindingContentNested<N>,Nested<N>{
    ClusterRoleBindingContentNestedImpl(ClusterRoleBinding item) {
      this.builder = new ClusterRoleBindingBuilder(this, item);
    }
    ClusterRoleBindingContentNestedImpl() {
      this.builder = new ClusterRoleBindingBuilder(this);
    }
    ClusterRoleBindingBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterRoleBindingContent() {
      return and();
    }
    
  }
  class ResourceAccessReviewContentNestedImpl<N> extends ResourceAccessReviewFluentImpl<LocalResourceAccessReviewFluent.ResourceAccessReviewContentNested<N>> implements LocalResourceAccessReviewFluent.ResourceAccessReviewContentNested<N>,Nested<N>{
    ResourceAccessReviewContentNestedImpl(ResourceAccessReview item) {
      this.builder = new ResourceAccessReviewBuilder(this, item);
    }
    ResourceAccessReviewContentNestedImpl() {
      this.builder = new ResourceAccessReviewBuilder(this);
    }
    ResourceAccessReviewBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endResourceAccessReviewContent() {
      return and();
    }
    
  }
  class SelfSubjectRulesReviewContentNestedImpl<N> extends SelfSubjectRulesReviewFluentImpl<LocalResourceAccessReviewFluent.SelfSubjectRulesReviewContentNested<N>> implements LocalResourceAccessReviewFluent.SelfSubjectRulesReviewContentNested<N>,Nested<N>{
    SelfSubjectRulesReviewContentNestedImpl(SelfSubjectRulesReview item) {
      this.builder = new SelfSubjectRulesReviewBuilder(this, item);
    }
    SelfSubjectRulesReviewContentNestedImpl() {
      this.builder = new SelfSubjectRulesReviewBuilder(this);
    }
    SelfSubjectRulesReviewBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSelfSubjectRulesReviewContent() {
      return and();
    }
    
  }
  class UserOAuthAccessTokenListContentNestedImpl<N> extends UserOAuthAccessTokenListFluentImpl<LocalResourceAccessReviewFluent.UserOAuthAccessTokenListContentNested<N>> implements LocalResourceAccessReviewFluent.UserOAuthAccessTokenListContentNested<N>,Nested<N>{
    UserOAuthAccessTokenListContentNestedImpl(UserOAuthAccessTokenList item) {
      this.builder = new UserOAuthAccessTokenListBuilder(this, item);
    }
    UserOAuthAccessTokenListContentNestedImpl() {
      this.builder = new UserOAuthAccessTokenListBuilder(this);
    }
    UserOAuthAccessTokenListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endUserOAuthAccessTokenListContent() {
      return and();
    }
    
  }
  class ImageChangeTriggerStatusContentNestedImpl<N> extends ImageChangeTriggerStatusFluentImpl<LocalResourceAccessReviewFluent.ImageChangeTriggerStatusContentNested<N>> implements LocalResourceAccessReviewFluent.ImageChangeTriggerStatusContentNested<N>,Nested<N>{
    ImageChangeTriggerStatusContentNestedImpl(ImageChangeTriggerStatus item) {
      this.builder = new ImageChangeTriggerStatusBuilder(this, item);
    }
    ImageChangeTriggerStatusContentNestedImpl() {
      this.builder = new ImageChangeTriggerStatusBuilder(this);
    }
    ImageChangeTriggerStatusBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageChangeTriggerStatusContent() {
      return and();
    }
    
  }
  class RouteStatusContentNestedImpl<N> extends RouteStatusFluentImpl<LocalResourceAccessReviewFluent.RouteStatusContentNested<N>> implements LocalResourceAccessReviewFluent.RouteStatusContentNested<N>,Nested<N>{
    RouteStatusContentNestedImpl(RouteStatus item) {
      this.builder = new RouteStatusBuilder(this, item);
    }
    RouteStatusContentNestedImpl() {
      this.builder = new RouteStatusBuilder(this);
    }
    RouteStatusBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRouteStatusContent() {
      return and();
    }
    
  }
  class ClusterResourceQuotaContentNestedImpl<N> extends ClusterResourceQuotaFluentImpl<LocalResourceAccessReviewFluent.ClusterResourceQuotaContentNested<N>> implements LocalResourceAccessReviewFluent.ClusterResourceQuotaContentNested<N>,Nested<N>{
    ClusterResourceQuotaContentNestedImpl(ClusterResourceQuota item) {
      this.builder = new ClusterResourceQuotaBuilder(this, item);
    }
    ClusterResourceQuotaContentNestedImpl() {
      this.builder = new ClusterResourceQuotaBuilder(this);
    }
    ClusterResourceQuotaBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterResourceQuotaContent() {
      return and();
    }
    
  }
  class NamedTagEventListContentNestedImpl<N> extends NamedTagEventListFluentImpl<LocalResourceAccessReviewFluent.NamedTagEventListContentNested<N>> implements LocalResourceAccessReviewFluent.NamedTagEventListContentNested<N>,Nested<N>{
    NamedTagEventListContentNestedImpl(NamedTagEventList item) {
      this.builder = new NamedTagEventListBuilder(this, item);
    }
    NamedTagEventListContentNestedImpl() {
      this.builder = new NamedTagEventListBuilder(this);
    }
    NamedTagEventListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endNamedTagEventListContent() {
      return and();
    }
    
  }
  class ClusterResourceQuotaListContentNestedImpl<N> extends ClusterResourceQuotaListFluentImpl<LocalResourceAccessReviewFluent.ClusterResourceQuotaListContentNested<N>> implements LocalResourceAccessReviewFluent.ClusterResourceQuotaListContentNested<N>,Nested<N>{
    ClusterResourceQuotaListContentNestedImpl(ClusterResourceQuotaList item) {
      this.builder = new ClusterResourceQuotaListBuilder(this, item);
    }
    ClusterResourceQuotaListContentNestedImpl() {
      this.builder = new ClusterResourceQuotaListBuilder(this);
    }
    ClusterResourceQuotaListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterResourceQuotaListContent() {
      return and();
    }
    
  }
  class RouteSpecContentNestedImpl<N> extends RouteSpecFluentImpl<LocalResourceAccessReviewFluent.RouteSpecContentNested<N>> implements LocalResourceAccessReviewFluent.RouteSpecContentNested<N>,Nested<N>{
    RouteSpecContentNestedImpl(RouteSpec item) {
      this.builder = new RouteSpecBuilder(this, item);
    }
    RouteSpecContentNestedImpl() {
      this.builder = new RouteSpecBuilder(this);
    }
    RouteSpecBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRouteSpecContent() {
      return and();
    }
    
  }
  class ProjectRequestContentNestedImpl<N> extends ProjectRequestFluentImpl<LocalResourceAccessReviewFluent.ProjectRequestContentNested<N>> implements LocalResourceAccessReviewFluent.ProjectRequestContentNested<N>,Nested<N>{
    ProjectRequestContentNestedImpl(ProjectRequest item) {
      this.builder = new ProjectRequestBuilder(this, item);
    }
    ProjectRequestContentNestedImpl() {
      this.builder = new ProjectRequestBuilder(this);
    }
    ProjectRequestBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endProjectRequestContent() {
      return and();
    }
    
  }
  class TemplateContentNestedImpl<N> extends TemplateFluentImpl<LocalResourceAccessReviewFluent.TemplateContentNested<N>> implements LocalResourceAccessReviewFluent.TemplateContentNested<N>,Nested<N>{
    TemplateContentNestedImpl(Template item) {
      this.builder = new TemplateBuilder(this, item);
    }
    TemplateContentNestedImpl() {
      this.builder = new TemplateBuilder(this);
    }
    TemplateBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTemplateContent() {
      return and();
    }
    
  }
  class ImageLookupPolicyContentNestedImpl<N> extends ImageLookupPolicyFluentImpl<LocalResourceAccessReviewFluent.ImageLookupPolicyContentNested<N>> implements LocalResourceAccessReviewFluent.ImageLookupPolicyContentNested<N>,Nested<N>{
    ImageLookupPolicyContentNestedImpl(ImageLookupPolicy item) {
      this.builder = new ImageLookupPolicyBuilder(this, item);
    }
    ImageLookupPolicyContentNestedImpl() {
      this.builder = new ImageLookupPolicyBuilder(this);
    }
    ImageLookupPolicyBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageLookupPolicyContent() {
      return and();
    }
    
  }
  class OAuthClientAuthorizationContentNestedImpl<N> extends OAuthClientAuthorizationFluentImpl<LocalResourceAccessReviewFluent.OAuthClientAuthorizationContentNested<N>> implements LocalResourceAccessReviewFluent.OAuthClientAuthorizationContentNested<N>,Nested<N>{
    OAuthClientAuthorizationContentNestedImpl(OAuthClientAuthorization item) {
      this.builder = new OAuthClientAuthorizationBuilder(this, item);
    }
    OAuthClientAuthorizationContentNestedImpl() {
      this.builder = new OAuthClientAuthorizationBuilder(this);
    }
    OAuthClientAuthorizationBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endOAuthClientAuthorizationContent() {
      return and();
    }
    
  }
  class ImageChangeCauseContentNestedImpl<N> extends ImageChangeCauseFluentImpl<LocalResourceAccessReviewFluent.ImageChangeCauseContentNested<N>> implements LocalResourceAccessReviewFluent.ImageChangeCauseContentNested<N>,Nested<N>{
    ImageChangeCauseContentNestedImpl(ImageChangeCause item) {
      this.builder = new ImageChangeCauseBuilder(this, item);
    }
    ImageChangeCauseContentNestedImpl() {
      this.builder = new ImageChangeCauseBuilder(this);
    }
    ImageChangeCauseBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageChangeCauseContent() {
      return and();
    }
    
  }
  class AllowedFlexVolumeContentNestedImpl<N> extends AllowedFlexVolumeFluentImpl<LocalResourceAccessReviewFluent.AllowedFlexVolumeContentNested<N>> implements LocalResourceAccessReviewFluent.AllowedFlexVolumeContentNested<N>,Nested<N>{
    AllowedFlexVolumeContentNestedImpl(AllowedFlexVolume item) {
      this.builder = new AllowedFlexVolumeBuilder(this, item);
    }
    AllowedFlexVolumeContentNestedImpl() {
      this.builder = new AllowedFlexVolumeBuilder(this);
    }
    AllowedFlexVolumeBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endAllowedFlexVolumeContent() {
      return and();
    }
    
  }
  class SubjectAccessReviewContentNestedImpl<N> extends SubjectAccessReviewFluentImpl<LocalResourceAccessReviewFluent.SubjectAccessReviewContentNested<N>> implements LocalResourceAccessReviewFluent.SubjectAccessReviewContentNested<N>,Nested<N>{
    SubjectAccessReviewContentNestedImpl(SubjectAccessReview item) {
      this.builder = new SubjectAccessReviewBuilder(this, item);
    }
    SubjectAccessReviewContentNestedImpl() {
      this.builder = new SubjectAccessReviewBuilder(this);
    }
    SubjectAccessReviewBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSubjectAccessReviewContent() {
      return and();
    }
    
  }
  class LocalResourceAccessReviewContentNestedImpl<N> extends LocalResourceAccessReviewFluentImpl<LocalResourceAccessReviewFluent.LocalResourceAccessReviewContentNested<N>> implements LocalResourceAccessReviewFluent.LocalResourceAccessReviewContentNested<N>,Nested<N>{
    LocalResourceAccessReviewContentNestedImpl(LocalResourceAccessReview item) {
      this.builder = new LocalResourceAccessReviewBuilder(this, item);
    }
    LocalResourceAccessReviewContentNestedImpl() {
      this.builder = new LocalResourceAccessReviewBuilder(this);
    }
    LocalResourceAccessReviewBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endLocalResourceAccessReviewContent() {
      return and();
    }
    
  }
  class ClusterRoleContentNestedImpl<N> extends ClusterRoleFluentImpl<LocalResourceAccessReviewFluent.ClusterRoleContentNested<N>> implements LocalResourceAccessReviewFluent.ClusterRoleContentNested<N>,Nested<N>{
    ClusterRoleContentNestedImpl(ClusterRole item) {
      this.builder = new ClusterRoleBuilder(this, item);
    }
    ClusterRoleContentNestedImpl() {
      this.builder = new ClusterRoleBuilder(this);
    }
    ClusterRoleBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterRoleContent() {
      return and();
    }
    
  }
  class ConnectionConfigContentNestedImpl<N> extends ConnectionConfigFluentImpl<LocalResourceAccessReviewFluent.ConnectionConfigContentNested<N>> implements LocalResourceAccessReviewFluent.ConnectionConfigContentNested<N>,Nested<N>{
    ConnectionConfigContentNestedImpl(ConnectionConfig item) {
      this.builder = new ConnectionConfigBuilder(this, item);
    }
    ConnectionConfigContentNestedImpl() {
      this.builder = new ConnectionConfigBuilder(this);
    }
    ConnectionConfigBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endConnectionConfigContent() {
      return and();
    }
    
  }
  class TagEventConditionContentNestedImpl<N> extends TagEventConditionFluentImpl<LocalResourceAccessReviewFluent.TagEventConditionContentNested<N>> implements LocalResourceAccessReviewFluent.TagEventConditionContentNested<N>,Nested<N>{
    TagEventConditionContentNestedImpl(TagEventCondition item) {
      this.builder = new TagEventConditionBuilder(this, item);
    }
    TagEventConditionContentNestedImpl() {
      this.builder = new TagEventConditionBuilder(this);
    }
    TagEventConditionBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTagEventConditionContent() {
      return and();
    }
    
  }
  class LabelSelectorContentNestedImpl<N> extends LabelSelectorFluentImpl<LocalResourceAccessReviewFluent.LabelSelectorContentNested<N>> implements LocalResourceAccessReviewFluent.LabelSelectorContentNested<N>,Nested<N>{
    LabelSelectorContentNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorContentNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endLabelSelectorContent() {
      return and();
    }
    
  }
  class NetNamespaceListContentNestedImpl<N> extends NetNamespaceListFluentImpl<LocalResourceAccessReviewFluent.NetNamespaceListContentNested<N>> implements LocalResourceAccessReviewFluent.NetNamespaceListContentNested<N>,Nested<N>{
    NetNamespaceListContentNestedImpl(NetNamespaceList item) {
      this.builder = new NetNamespaceListBuilder(this, item);
    }
    NetNamespaceListContentNestedImpl() {
      this.builder = new NetNamespaceListBuilder(this);
    }
    NetNamespaceListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endNetNamespaceListContent() {
      return and();
    }
    
  }
  class BrokerTemplateInstanceSpecContentNestedImpl<N> extends BrokerTemplateInstanceSpecFluentImpl<LocalResourceAccessReviewFluent.BrokerTemplateInstanceSpecContentNested<N>> implements LocalResourceAccessReviewFluent.BrokerTemplateInstanceSpecContentNested<N>,Nested<N>{
    BrokerTemplateInstanceSpecContentNestedImpl(BrokerTemplateInstanceSpec item) {
      this.builder = new BrokerTemplateInstanceSpecBuilder(this, item);
    }
    BrokerTemplateInstanceSpecContentNestedImpl() {
      this.builder = new BrokerTemplateInstanceSpecBuilder(this);
    }
    BrokerTemplateInstanceSpecBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBrokerTemplateInstanceSpecContent() {
      return and();
    }
    
  }
  class BinaryBuildSourceContentNestedImpl<N> extends BinaryBuildSourceFluentImpl<LocalResourceAccessReviewFluent.BinaryBuildSourceContentNested<N>> implements LocalResourceAccessReviewFluent.BinaryBuildSourceContentNested<N>,Nested<N>{
    BinaryBuildSourceContentNestedImpl(BinaryBuildSource item) {
      this.builder = new BinaryBuildSourceBuilder(this, item);
    }
    BinaryBuildSourceContentNestedImpl() {
      this.builder = new BinaryBuildSourceBuilder(this);
    }
    BinaryBuildSourceBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBinaryBuildSourceContent() {
      return and();
    }
    
  }
  class OAuthClientAuthorizationListContentNestedImpl<N> extends OAuthClientAuthorizationListFluentImpl<LocalResourceAccessReviewFluent.OAuthClientAuthorizationListContentNested<N>> implements LocalResourceAccessReviewFluent.OAuthClientAuthorizationListContentNested<N>,Nested<N>{
    OAuthClientAuthorizationListContentNestedImpl(OAuthClientAuthorizationList item) {
      this.builder = new OAuthClientAuthorizationListBuilder(this, item);
    }
    OAuthClientAuthorizationListContentNestedImpl() {
      this.builder = new OAuthClientAuthorizationListBuilder(this);
    }
    OAuthClientAuthorizationListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endOAuthClientAuthorizationListContent() {
      return and();
    }
    
  }
  class BuildSpecContentNestedImpl<N> extends BuildSpecFluentImpl<LocalResourceAccessReviewFluent.BuildSpecContentNested<N>> implements LocalResourceAccessReviewFluent.BuildSpecContentNested<N>,Nested<N>{
    BuildSpecContentNestedImpl(BuildSpec item) {
      this.builder = new BuildSpecBuilder(this, item);
    }
    BuildSpecContentNestedImpl() {
      this.builder = new BuildSpecBuilder(this);
    }
    BuildSpecBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildSpecContent() {
      return and();
    }
    
  }
  class ProjectStatusContentNestedImpl<N> extends ProjectStatusFluentImpl<LocalResourceAccessReviewFluent.ProjectStatusContentNested<N>> implements LocalResourceAccessReviewFluent.ProjectStatusContentNested<N>,Nested<N>{
    ProjectStatusContentNestedImpl(ProjectStatus item) {
      this.builder = new ProjectStatusBuilder(this, item);
    }
    ProjectStatusContentNestedImpl() {
      this.builder = new ProjectStatusBuilder(this);
    }
    ProjectStatusBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endProjectStatusContent() {
      return and();
    }
    
  }
  class LocalSubjectAccessReviewContentNestedImpl<N> extends LocalSubjectAccessReviewFluentImpl<LocalResourceAccessReviewFluent.LocalSubjectAccessReviewContentNested<N>> implements LocalResourceAccessReviewFluent.LocalSubjectAccessReviewContentNested<N>,Nested<N>{
    LocalSubjectAccessReviewContentNestedImpl(LocalSubjectAccessReview item) {
      this.builder = new LocalSubjectAccessReviewBuilder(this, item);
    }
    LocalSubjectAccessReviewContentNestedImpl() {
      this.builder = new LocalSubjectAccessReviewBuilder(this);
    }
    LocalSubjectAccessReviewBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endLocalSubjectAccessReviewContent() {
      return and();
    }
    
  }
  class RollingDeploymentStrategyParamsContentNestedImpl<N> extends RollingDeploymentStrategyParamsFluentImpl<LocalResourceAccessReviewFluent.RollingDeploymentStrategyParamsContentNested<N>> implements LocalResourceAccessReviewFluent.RollingDeploymentStrategyParamsContentNested<N>,Nested<N>{
    RollingDeploymentStrategyParamsContentNestedImpl(RollingDeploymentStrategyParams item) {
      this.builder = new RollingDeploymentStrategyParamsBuilder(this, item);
    }
    RollingDeploymentStrategyParamsContentNestedImpl() {
      this.builder = new RollingDeploymentStrategyParamsBuilder(this);
    }
    RollingDeploymentStrategyParamsBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRollingDeploymentStrategyParamsContent() {
      return and();
    }
    
  }
  class GitSourceRevisionContentNestedImpl<N> extends GitSourceRevisionFluentImpl<LocalResourceAccessReviewFluent.GitSourceRevisionContentNested<N>> implements LocalResourceAccessReviewFluent.GitSourceRevisionContentNested<N>,Nested<N>{
    GitSourceRevisionContentNestedImpl(GitSourceRevision item) {
      this.builder = new GitSourceRevisionBuilder(this, item);
    }
    GitSourceRevisionContentNestedImpl() {
      this.builder = new GitSourceRevisionBuilder(this);
    }
    GitSourceRevisionBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endGitSourceRevisionContent() {
      return and();
    }
    
  }
  class ImageLabelContentNestedImpl<N> extends ImageLabelFluentImpl<LocalResourceAccessReviewFluent.ImageLabelContentNested<N>> implements LocalResourceAccessReviewFluent.ImageLabelContentNested<N>,Nested<N>{
    ImageLabelContentNestedImpl(ImageLabel item) {
      this.builder = new ImageLabelBuilder(this, item);
    }
    ImageLabelContentNestedImpl() {
      this.builder = new ImageLabelBuilder(this);
    }
    ImageLabelBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageLabelContent() {
      return and();
    }
    
  }
  class ImageChangeTriggerContentNestedImpl<N> extends ImageChangeTriggerFluentImpl<LocalResourceAccessReviewFluent.ImageChangeTriggerContentNested<N>> implements LocalResourceAccessReviewFluent.ImageChangeTriggerContentNested<N>,Nested<N>{
    ImageChangeTriggerContentNestedImpl(ImageChangeTrigger item) {
      this.builder = new ImageChangeTriggerBuilder(this, item);
    }
    ImageChangeTriggerContentNestedImpl() {
      this.builder = new ImageChangeTriggerBuilder(this);
    }
    ImageChangeTriggerBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageChangeTriggerContent() {
      return and();
    }
    
  }
  class PodSecurityPolicyReviewSpecContentNestedImpl<N> extends PodSecurityPolicyReviewSpecFluentImpl<LocalResourceAccessReviewFluent.PodSecurityPolicyReviewSpecContentNested<N>> implements LocalResourceAccessReviewFluent.PodSecurityPolicyReviewSpecContentNested<N>,Nested<N>{
    PodSecurityPolicyReviewSpecContentNestedImpl(PodSecurityPolicyReviewSpec item) {
      this.builder = new PodSecurityPolicyReviewSpecBuilder(this, item);
    }
    PodSecurityPolicyReviewSpecContentNestedImpl() {
      this.builder = new PodSecurityPolicyReviewSpecBuilder(this);
    }
    PodSecurityPolicyReviewSpecBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endPodSecurityPolicyReviewSpecContent() {
      return and();
    }
    
  }
  class ImageTagContentNestedImpl<N> extends ImageTagFluentImpl<LocalResourceAccessReviewFluent.ImageTagContentNested<N>> implements LocalResourceAccessReviewFluent.ImageTagContentNested<N>,Nested<N>{
    ImageTagContentNestedImpl(ImageTag item) {
      this.builder = new ImageTagBuilder(this, item);
    }
    ImageTagContentNestedImpl() {
      this.builder = new ImageTagBuilder(this);
    }
    ImageTagBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageTagContent() {
      return and();
    }
    
  }
  class ImageStreamImportSpecContentNestedImpl<N> extends ImageStreamImportSpecFluentImpl<LocalResourceAccessReviewFluent.ImageStreamImportSpecContentNested<N>> implements LocalResourceAccessReviewFluent.ImageStreamImportSpecContentNested<N>,Nested<N>{
    ImageStreamImportSpecContentNestedImpl(ImageStreamImportSpec item) {
      this.builder = new ImageStreamImportSpecBuilder(this, item);
    }
    ImageStreamImportSpecContentNestedImpl() {
      this.builder = new ImageStreamImportSpecBuilder(this);
    }
    ImageStreamImportSpecBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamImportSpecContent() {
      return and();
    }
    
  }
  class FSGroupStrategyOptionsContentNestedImpl<N> extends FSGroupStrategyOptionsFluentImpl<LocalResourceAccessReviewFluent.FSGroupStrategyOptionsContentNested<N>> implements LocalResourceAccessReviewFluent.FSGroupStrategyOptionsContentNested<N>,Nested<N>{
    FSGroupStrategyOptionsContentNestedImpl(FSGroupStrategyOptions item) {
      this.builder = new FSGroupStrategyOptionsBuilder(this, item);
    }
    FSGroupStrategyOptionsContentNestedImpl() {
      this.builder = new FSGroupStrategyOptionsBuilder(this);
    }
    FSGroupStrategyOptionsBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endFSGroupStrategyOptionsContent() {
      return and();
    }
    
  }
  class PodSecurityPolicyReviewContentNestedImpl<N> extends PodSecurityPolicyReviewFluentImpl<LocalResourceAccessReviewFluent.PodSecurityPolicyReviewContentNested<N>> implements LocalResourceAccessReviewFluent.PodSecurityPolicyReviewContentNested<N>,Nested<N>{
    PodSecurityPolicyReviewContentNestedImpl(PodSecurityPolicyReview item) {
      this.builder = new PodSecurityPolicyReviewBuilder(this, item);
    }
    PodSecurityPolicyReviewContentNestedImpl() {
      this.builder = new PodSecurityPolicyReviewBuilder(this);
    }
    PodSecurityPolicyReviewBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endPodSecurityPolicyReviewContent() {
      return and();
    }
    
  }
  class RecreateDeploymentStrategyParamsContentNestedImpl<N> extends RecreateDeploymentStrategyParamsFluentImpl<LocalResourceAccessReviewFluent.RecreateDeploymentStrategyParamsContentNested<N>> implements LocalResourceAccessReviewFluent.RecreateDeploymentStrategyParamsContentNested<N>,Nested<N>{
    RecreateDeploymentStrategyParamsContentNestedImpl(RecreateDeploymentStrategyParams item) {
      this.builder = new RecreateDeploymentStrategyParamsBuilder(this, item);
    }
    RecreateDeploymentStrategyParamsContentNestedImpl() {
      this.builder = new RecreateDeploymentStrategyParamsBuilder(this);
    }
    RecreateDeploymentStrategyParamsBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRecreateDeploymentStrategyParamsContent() {
      return and();
    }
    
  }
  class DockerStrategyOptionsContentNestedImpl<N> extends DockerStrategyOptionsFluentImpl<LocalResourceAccessReviewFluent.DockerStrategyOptionsContentNested<N>> implements LocalResourceAccessReviewFluent.DockerStrategyOptionsContentNested<N>,Nested<N>{
    DockerStrategyOptionsContentNestedImpl(DockerStrategyOptions item) {
      this.builder = new DockerStrategyOptionsBuilder(this, item);
    }
    DockerStrategyOptionsContentNestedImpl() {
      this.builder = new DockerStrategyOptionsBuilder(this);
    }
    DockerStrategyOptionsBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endDockerStrategyOptionsContent() {
      return and();
    }
    
  }
  class ImageListContentNestedImpl<N> extends ImageListFluentImpl<LocalResourceAccessReviewFluent.ImageListContentNested<N>> implements LocalResourceAccessReviewFluent.ImageListContentNested<N>,Nested<N>{
    ImageListContentNestedImpl(ImageList item) {
      this.builder = new ImageListBuilder(this, item);
    }
    ImageListContentNestedImpl() {
      this.builder = new ImageListBuilder(this);
    }
    ImageListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageListContent() {
      return and();
    }
    
  }
  class ConfigMapBuildSourceContentNestedImpl<N> extends ConfigMapBuildSourceFluentImpl<LocalResourceAccessReviewFluent.ConfigMapBuildSourceContentNested<N>> implements LocalResourceAccessReviewFluent.ConfigMapBuildSourceContentNested<N>,Nested<N>{
    ConfigMapBuildSourceContentNestedImpl(ConfigMapBuildSource item) {
      this.builder = new ConfigMapBuildSourceBuilder(this, item);
    }
    ConfigMapBuildSourceContentNestedImpl() {
      this.builder = new ConfigMapBuildSourceBuilder(this);
    }
    ConfigMapBuildSourceBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endConfigMapBuildSourceContent() {
      return and();
    }
    
  }
  class ImageTagListContentNestedImpl<N> extends ImageTagListFluentImpl<LocalResourceAccessReviewFluent.ImageTagListContentNested<N>> implements LocalResourceAccessReviewFluent.ImageTagListContentNested<N>,Nested<N>{
    ImageTagListContentNestedImpl(ImageTagList item) {
      this.builder = new ImageTagListBuilder(this, item);
    }
    ImageTagListContentNestedImpl() {
      this.builder = new ImageTagListBuilder(this);
    }
    ImageTagListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageTagListContent() {
      return and();
    }
    
  }
  class OAuthAccessTokenContentNestedImpl<N> extends OAuthAccessTokenFluentImpl<LocalResourceAccessReviewFluent.OAuthAccessTokenContentNested<N>> implements LocalResourceAccessReviewFluent.OAuthAccessTokenContentNested<N>,Nested<N>{
    OAuthAccessTokenContentNestedImpl(OAuthAccessToken item) {
      this.builder = new OAuthAccessTokenBuilder(this, item);
    }
    OAuthAccessTokenContentNestedImpl() {
      this.builder = new OAuthAccessTokenBuilder(this);
    }
    OAuthAccessTokenBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endOAuthAccessTokenContent() {
      return and();
    }
    
  }
  class DeploymentConfigContentNestedImpl<N> extends DeploymentConfigFluentImpl<LocalResourceAccessReviewFluent.DeploymentConfigContentNested<N>> implements LocalResourceAccessReviewFluent.DeploymentConfigContentNested<N>,Nested<N>{
    DeploymentConfigContentNestedImpl(DeploymentConfig item) {
      this.builder = new DeploymentConfigBuilder(this, item);
    }
    DeploymentConfigContentNestedImpl() {
      this.builder = new DeploymentConfigBuilder(this);
    }
    DeploymentConfigBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endDeploymentConfigContent() {
      return and();
    }
    
  }
  class RoleBindingContentNestedImpl<N> extends RoleBindingFluentImpl<LocalResourceAccessReviewFluent.RoleBindingContentNested<N>> implements LocalResourceAccessReviewFluent.RoleBindingContentNested<N>,Nested<N>{
    RoleBindingContentNestedImpl(RoleBinding item) {
      this.builder = new RoleBindingBuilder(this, item);
    }
    RoleBindingContentNestedImpl() {
      this.builder = new RoleBindingBuilder(this);
    }
    RoleBindingBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRoleBindingContent() {
      return and();
    }
    
  }
  class ImageContentNestedImpl<N> extends ImageFluentImpl<LocalResourceAccessReviewFluent.ImageContentNested<N>> implements LocalResourceAccessReviewFluent.ImageContentNested<N>,Nested<N>{
    ImageContentNestedImpl(Image item) {
      this.builder = new ImageBuilder(this, item);
    }
    ImageContentNestedImpl() {
      this.builder = new ImageBuilder(this);
    }
    ImageBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageContent() {
      return and();
    }
    
  }
  class TLSConfigContentNestedImpl<N> extends TLSConfigFluentImpl<LocalResourceAccessReviewFluent.TLSConfigContentNested<N>> implements LocalResourceAccessReviewFluent.TLSConfigContentNested<N>,Nested<N>{
    TLSConfigContentNestedImpl(TLSConfig item) {
      this.builder = new TLSConfigBuilder(this, item);
    }
    TLSConfigContentNestedImpl() {
      this.builder = new TLSConfigBuilder(this);
    }
    TLSConfigBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTLSConfigContent() {
      return and();
    }
    
  }
  class BuildVolumeContentNestedImpl<N> extends BuildVolumeFluentImpl<LocalResourceAccessReviewFluent.BuildVolumeContentNested<N>> implements LocalResourceAccessReviewFluent.BuildVolumeContentNested<N>,Nested<N>{
    BuildVolumeContentNestedImpl(BuildVolume item) {
      this.builder = new BuildVolumeBuilder(this, item);
    }
    BuildVolumeContentNestedImpl() {
      this.builder = new BuildVolumeBuilder(this);
    }
    BuildVolumeBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildVolumeContent() {
      return and();
    }
    
  }
  class TemplateInstanceSpecContentNestedImpl<N> extends TemplateInstanceSpecFluentImpl<LocalResourceAccessReviewFluent.TemplateInstanceSpecContentNested<N>> implements LocalResourceAccessReviewFluent.TemplateInstanceSpecContentNested<N>,Nested<N>{
    TemplateInstanceSpecContentNestedImpl(TemplateInstanceSpec item) {
      this.builder = new TemplateInstanceSpecBuilder(this, item);
    }
    TemplateInstanceSpecContentNestedImpl() {
      this.builder = new TemplateInstanceSpecBuilder(this);
    }
    TemplateInstanceSpecBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTemplateInstanceSpecContent() {
      return and();
    }
    
  }
  class BuildStatusContentNestedImpl<N> extends BuildStatusFluentImpl<LocalResourceAccessReviewFluent.BuildStatusContentNested<N>> implements LocalResourceAccessReviewFluent.BuildStatusContentNested<N>,Nested<N>{
    BuildStatusContentNestedImpl(BuildStatus item) {
      this.builder = new BuildStatusBuilder(this, item);
    }
    BuildStatusContentNestedImpl() {
      this.builder = new BuildStatusBuilder(this);
    }
    BuildStatusBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildStatusContent() {
      return and();
    }
    
  }
  class ImageSourceContentNestedImpl<N> extends ImageSourceFluentImpl<LocalResourceAccessReviewFluent.ImageSourceContentNested<N>> implements LocalResourceAccessReviewFluent.ImageSourceContentNested<N>,Nested<N>{
    ImageSourceContentNestedImpl(ImageSource item) {
      this.builder = new ImageSourceBuilder(this, item);
    }
    ImageSourceContentNestedImpl() {
      this.builder = new ImageSourceBuilder(this);
    }
    ImageSourceBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageSourceContent() {
      return and();
    }
    
  }
  class ObjectMetaContentNestedImpl<N> extends ObjectMetaFluentImpl<LocalResourceAccessReviewFluent.ObjectMetaContentNested<N>> implements LocalResourceAccessReviewFluent.ObjectMetaContentNested<N>,Nested<N>{
    ObjectMetaContentNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaContentNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endObjectMetaContent() {
      return and();
    }
    
  }
  class PersistentVolumeClaimContentNestedImpl<N> extends PersistentVolumeClaimFluentImpl<LocalResourceAccessReviewFluent.PersistentVolumeClaimContentNested<N>> implements LocalResourceAccessReviewFluent.PersistentVolumeClaimContentNested<N>,Nested<N>{
    PersistentVolumeClaimContentNestedImpl(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimContentNestedImpl() {
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endPersistentVolumeClaimContent() {
      return and();
    }
    
  }
  class PodSecurityPolicySelfSubjectReviewContentNestedImpl<N> extends PodSecurityPolicySelfSubjectReviewFluentImpl<LocalResourceAccessReviewFluent.PodSecurityPolicySelfSubjectReviewContentNested<N>> implements LocalResourceAccessReviewFluent.PodSecurityPolicySelfSubjectReviewContentNested<N>,Nested<N>{
    PodSecurityPolicySelfSubjectReviewContentNestedImpl(PodSecurityPolicySelfSubjectReview item) {
      this.builder = new PodSecurityPolicySelfSubjectReviewBuilder(this, item);
    }
    PodSecurityPolicySelfSubjectReviewContentNestedImpl() {
      this.builder = new PodSecurityPolicySelfSubjectReviewBuilder(this);
    }
    PodSecurityPolicySelfSubjectReviewBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endPodSecurityPolicySelfSubjectReviewContent() {
      return and();
    }
    
  }
  class TagReferenceContentNestedImpl<N> extends TagReferenceFluentImpl<LocalResourceAccessReviewFluent.TagReferenceContentNested<N>> implements LocalResourceAccessReviewFluent.TagReferenceContentNested<N>,Nested<N>{
    TagReferenceContentNestedImpl(TagReference item) {
      this.builder = new TagReferenceBuilder(this, item);
    }
    TagReferenceContentNestedImpl() {
      this.builder = new TagReferenceBuilder(this);
    }
    TagReferenceBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTagReferenceContent() {
      return and();
    }
    
  }
  class EgressNetworkPolicyRuleContentNestedImpl<N> extends EgressNetworkPolicyRuleFluentImpl<LocalResourceAccessReviewFluent.EgressNetworkPolicyRuleContentNested<N>> implements LocalResourceAccessReviewFluent.EgressNetworkPolicyRuleContentNested<N>,Nested<N>{
    EgressNetworkPolicyRuleContentNestedImpl(EgressNetworkPolicyRule item) {
      this.builder = new EgressNetworkPolicyRuleBuilder(this, item);
    }
    EgressNetworkPolicyRuleContentNestedImpl() {
      this.builder = new EgressNetworkPolicyRuleBuilder(this);
    }
    EgressNetworkPolicyRuleBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endEgressNetworkPolicyRuleContent() {
      return and();
    }
    
  }
  class SubjectRulesReviewStatusContentNestedImpl<N> extends SubjectRulesReviewStatusFluentImpl<LocalResourceAccessReviewFluent.SubjectRulesReviewStatusContentNested<N>> implements LocalResourceAccessReviewFluent.SubjectRulesReviewStatusContentNested<N>,Nested<N>{
    SubjectRulesReviewStatusContentNestedImpl(SubjectRulesReviewStatus item) {
      this.builder = new SubjectRulesReviewStatusBuilder(this, item);
    }
    SubjectRulesReviewStatusContentNestedImpl() {
      this.builder = new SubjectRulesReviewStatusBuilder(this);
    }
    SubjectRulesReviewStatusBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSubjectRulesReviewStatusContent() {
      return and();
    }
    
  }
  class BuildVolumeMountContentNestedImpl<N> extends BuildVolumeMountFluentImpl<LocalResourceAccessReviewFluent.BuildVolumeMountContentNested<N>> implements LocalResourceAccessReviewFluent.BuildVolumeMountContentNested<N>,Nested<N>{
    BuildVolumeMountContentNestedImpl(BuildVolumeMount item) {
      this.builder = new BuildVolumeMountBuilder(this, item);
    }
    BuildVolumeMountContentNestedImpl() {
      this.builder = new BuildVolumeMountBuilder(this);
    }
    BuildVolumeMountBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildVolumeMountContent() {
      return and();
    }
    
  }
  class ClusterNetworkEntryContentNestedImpl<N> extends ClusterNetworkEntryFluentImpl<LocalResourceAccessReviewFluent.ClusterNetworkEntryContentNested<N>> implements LocalResourceAccessReviewFluent.ClusterNetworkEntryContentNested<N>,Nested<N>{
    ClusterNetworkEntryContentNestedImpl(ClusterNetworkEntry item) {
      this.builder = new ClusterNetworkEntryBuilder(this, item);
    }
    ClusterNetworkEntryContentNestedImpl() {
      this.builder = new ClusterNetworkEntryBuilder(this);
    }
    ClusterNetworkEntryBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterNetworkEntryContent() {
      return and();
    }
    
  }
  class TemplateInstanceObjectContentNestedImpl<N> extends TemplateInstanceObjectFluentImpl<LocalResourceAccessReviewFluent.TemplateInstanceObjectContentNested<N>> implements LocalResourceAccessReviewFluent.TemplateInstanceObjectContentNested<N>,Nested<N>{
    TemplateInstanceObjectContentNestedImpl(TemplateInstanceObject item) {
      this.builder = new TemplateInstanceObjectBuilder(this, item);
    }
    TemplateInstanceObjectContentNestedImpl() {
      this.builder = new TemplateInstanceObjectBuilder(this);
    }
    TemplateInstanceObjectBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTemplateInstanceObjectContent() {
      return and();
    }
    
  }
  class BuildSourceContentNestedImpl<N> extends BuildSourceFluentImpl<LocalResourceAccessReviewFluent.BuildSourceContentNested<N>> implements LocalResourceAccessReviewFluent.BuildSourceContentNested<N>,Nested<N>{
    BuildSourceContentNestedImpl(BuildSource item) {
      this.builder = new BuildSourceBuilder(this, item);
    }
    BuildSourceContentNestedImpl() {
      this.builder = new BuildSourceBuilder(this);
    }
    BuildSourceBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildSourceContent() {
      return and();
    }
    
  }
  class ClusterResourceQuotaStatusContentNestedImpl<N> extends ClusterResourceQuotaStatusFluentImpl<LocalResourceAccessReviewFluent.ClusterResourceQuotaStatusContentNested<N>> implements LocalResourceAccessReviewFluent.ClusterResourceQuotaStatusContentNested<N>,Nested<N>{
    ClusterResourceQuotaStatusContentNestedImpl(ClusterResourceQuotaStatus item) {
      this.builder = new ClusterResourceQuotaStatusBuilder(this, item);
    }
    ClusterResourceQuotaStatusContentNestedImpl() {
      this.builder = new ClusterResourceQuotaStatusBuilder(this);
    }
    ClusterResourceQuotaStatusBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterResourceQuotaStatusContent() {
      return and();
    }
    
  }
  class DeploymentConditionContentNestedImpl<N> extends DeploymentConditionFluentImpl<LocalResourceAccessReviewFluent.DeploymentConditionContentNested<N>> implements LocalResourceAccessReviewFluent.DeploymentConditionContentNested<N>,Nested<N>{
    DeploymentConditionContentNestedImpl(DeploymentCondition item) {
      this.builder = new DeploymentConditionBuilder(this, item);
    }
    DeploymentConditionContentNestedImpl() {
      this.builder = new DeploymentConditionBuilder(this);
    }
    DeploymentConditionBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endDeploymentConditionContent() {
      return and();
    }
    
  }
  class HelmChartRepositorySpecContentNestedImpl<N> extends HelmChartRepositorySpecFluentImpl<LocalResourceAccessReviewFluent.HelmChartRepositorySpecContentNested<N>> implements LocalResourceAccessReviewFluent.HelmChartRepositorySpecContentNested<N>,Nested<N>{
    HelmChartRepositorySpecContentNestedImpl(HelmChartRepositorySpec item) {
      this.builder = new HelmChartRepositorySpecBuilder(this, item);
    }
    HelmChartRepositorySpecContentNestedImpl() {
      this.builder = new HelmChartRepositorySpecBuilder(this);
    }
    HelmChartRepositorySpecBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endHelmChartRepositorySpecContent() {
      return and();
    }
    
  }
  class DeploymentCauseImageTriggerContentNestedImpl<N> extends DeploymentCauseImageTriggerFluentImpl<LocalResourceAccessReviewFluent.DeploymentCauseImageTriggerContentNested<N>> implements LocalResourceAccessReviewFluent.DeploymentCauseImageTriggerContentNested<N>,Nested<N>{
    DeploymentCauseImageTriggerContentNestedImpl(DeploymentCauseImageTrigger item) {
      this.builder = new DeploymentCauseImageTriggerBuilder(this, item);
    }
    DeploymentCauseImageTriggerContentNestedImpl() {
      this.builder = new DeploymentCauseImageTriggerBuilder(this);
    }
    DeploymentCauseImageTriggerBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endDeploymentCauseImageTriggerContent() {
      return and();
    }
    
  }
  class ImageStreamMappingContentNestedImpl<N> extends ImageStreamMappingFluentImpl<LocalResourceAccessReviewFluent.ImageStreamMappingContentNested<N>> implements LocalResourceAccessReviewFluent.ImageStreamMappingContentNested<N>,Nested<N>{
    ImageStreamMappingContentNestedImpl(ImageStreamMapping item) {
      this.builder = new ImageStreamMappingBuilder(this, item);
    }
    ImageStreamMappingContentNestedImpl() {
      this.builder = new ImageStreamMappingBuilder(this);
    }
    ImageStreamMappingBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamMappingContent() {
      return and();
    }
    
  }
  class SubjectRulesReviewContentNestedImpl<N> extends SubjectRulesReviewFluentImpl<LocalResourceAccessReviewFluent.SubjectRulesReviewContentNested<N>> implements LocalResourceAccessReviewFluent.SubjectRulesReviewContentNested<N>,Nested<N>{
    SubjectRulesReviewContentNestedImpl(SubjectRulesReview item) {
      this.builder = new SubjectRulesReviewBuilder(this, item);
    }
    SubjectRulesReviewContentNestedImpl() {
      this.builder = new SubjectRulesReviewBuilder(this);
    }
    SubjectRulesReviewBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSubjectRulesReviewContent() {
      return and();
    }
    
  }
  class RoleContentNestedImpl<N> extends RoleFluentImpl<LocalResourceAccessReviewFluent.RoleContentNested<N>> implements LocalResourceAccessReviewFluent.RoleContentNested<N>,Nested<N>{
    RoleContentNestedImpl(Role item) {
      this.builder = new RoleBuilder(this, item);
    }
    RoleContentNestedImpl() {
      this.builder = new RoleBuilder(this);
    }
    RoleBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRoleContent() {
      return and();
    }
    
  }
  class GitBuildSourceContentNestedImpl<N> extends GitBuildSourceFluentImpl<LocalResourceAccessReviewFluent.GitBuildSourceContentNested<N>> implements LocalResourceAccessReviewFluent.GitBuildSourceContentNested<N>,Nested<N>{
    GitBuildSourceContentNestedImpl(GitBuildSource item) {
      this.builder = new GitBuildSourceBuilder(this, item);
    }
    GitBuildSourceContentNestedImpl() {
      this.builder = new GitBuildSourceBuilder(this);
    }
    GitBuildSourceBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endGitBuildSourceContent() {
      return and();
    }
    
  }
  class EgressNetworkPolicyListContentNestedImpl<N> extends EgressNetworkPolicyListFluentImpl<LocalResourceAccessReviewFluent.EgressNetworkPolicyListContentNested<N>> implements LocalResourceAccessReviewFluent.EgressNetworkPolicyListContentNested<N>,Nested<N>{
    EgressNetworkPolicyListContentNestedImpl(EgressNetworkPolicyList item) {
      this.builder = new EgressNetworkPolicyListBuilder(this, item);
    }
    EgressNetworkPolicyListContentNestedImpl() {
      this.builder = new EgressNetworkPolicyListBuilder(this);
    }
    EgressNetworkPolicyListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endEgressNetworkPolicyListContent() {
      return and();
    }
    
  }
  class SelfSubjectRulesReviewSpecContentNestedImpl<N> extends SelfSubjectRulesReviewSpecFluentImpl<LocalResourceAccessReviewFluent.SelfSubjectRulesReviewSpecContentNested<N>> implements LocalResourceAccessReviewFluent.SelfSubjectRulesReviewSpecContentNested<N>,Nested<N>{
    SelfSubjectRulesReviewSpecContentNestedImpl(SelfSubjectRulesReviewSpec item) {
      this.builder = new SelfSubjectRulesReviewSpecBuilder(this, item);
    }
    SelfSubjectRulesReviewSpecContentNestedImpl() {
      this.builder = new SelfSubjectRulesReviewSpecBuilder(this);
    }
    SelfSubjectRulesReviewSpecBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSelfSubjectRulesReviewSpecContent() {
      return and();
    }
    
  }
  class ImageSourcePathContentNestedImpl<N> extends ImageSourcePathFluentImpl<LocalResourceAccessReviewFluent.ImageSourcePathContentNested<N>> implements LocalResourceAccessReviewFluent.ImageSourcePathContentNested<N>,Nested<N>{
    ImageSourcePathContentNestedImpl(ImageSourcePath item) {
      this.builder = new ImageSourcePathBuilder(this, item);
    }
    ImageSourcePathContentNestedImpl() {
      this.builder = new ImageSourcePathBuilder(this);
    }
    ImageSourcePathBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageSourcePathContent() {
      return and();
    }
    
  }
  class BuildConfigStatusContentNestedImpl<N> extends BuildConfigStatusFluentImpl<LocalResourceAccessReviewFluent.BuildConfigStatusContentNested<N>> implements LocalResourceAccessReviewFluent.BuildConfigStatusContentNested<N>,Nested<N>{
    BuildConfigStatusContentNestedImpl(BuildConfigStatus item) {
      this.builder = new BuildConfigStatusBuilder(this, item);
    }
    BuildConfigStatusContentNestedImpl() {
      this.builder = new BuildConfigStatusBuilder(this);
    }
    BuildConfigStatusBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildConfigStatusContent() {
      return and();
    }
    
  }
  class ResourceQuotaStatusByNamespaceContentNestedImpl<N> extends ResourceQuotaStatusByNamespaceFluentImpl<LocalResourceAccessReviewFluent.ResourceQuotaStatusByNamespaceContentNested<N>> implements LocalResourceAccessReviewFluent.ResourceQuotaStatusByNamespaceContentNested<N>,Nested<N>{
    ResourceQuotaStatusByNamespaceContentNestedImpl(ResourceQuotaStatusByNamespace item) {
      this.builder = new ResourceQuotaStatusByNamespaceBuilder(this, item);
    }
    ResourceQuotaStatusByNamespaceContentNestedImpl() {
      this.builder = new ResourceQuotaStatusByNamespaceBuilder(this);
    }
    ResourceQuotaStatusByNamespaceBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endResourceQuotaStatusByNamespaceContent() {
      return and();
    }
    
  }
  class SourceBuildStrategyContentNestedImpl<N> extends SourceBuildStrategyFluentImpl<LocalResourceAccessReviewFluent.SourceBuildStrategyContentNested<N>> implements LocalResourceAccessReviewFluent.SourceBuildStrategyContentNested<N>,Nested<N>{
    SourceBuildStrategyContentNestedImpl(SourceBuildStrategy item) {
      this.builder = new SourceBuildStrategyBuilder(this, item);
    }
    SourceBuildStrategyContentNestedImpl() {
      this.builder = new SourceBuildStrategyBuilder(this);
    }
    SourceBuildStrategyBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSourceBuildStrategyContent() {
      return and();
    }
    
  }
  class ParameterContentNestedImpl<N> extends ParameterFluentImpl<LocalResourceAccessReviewFluent.ParameterContentNested<N>> implements LocalResourceAccessReviewFluent.ParameterContentNested<N>,Nested<N>{
    ParameterContentNestedImpl(Parameter item) {
      this.builder = new ParameterBuilder(this, item);
    }
    ParameterContentNestedImpl() {
      this.builder = new ParameterBuilder(this);
    }
    ParameterBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endParameterContent() {
      return and();
    }
    
  }
  class RoleBindingListContentNestedImpl<N> extends RoleBindingListFluentImpl<LocalResourceAccessReviewFluent.RoleBindingListContentNested<N>> implements LocalResourceAccessReviewFluent.RoleBindingListContentNested<N>,Nested<N>{
    RoleBindingListContentNestedImpl(RoleBindingList item) {
      this.builder = new RoleBindingListBuilder(this, item);
    }
    RoleBindingListContentNestedImpl() {
      this.builder = new RoleBindingListBuilder(this);
    }
    RoleBindingListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRoleBindingListContent() {
      return and();
    }
    
  }
  class PodSecurityPolicySelfSubjectReviewSpecContentNestedImpl<N> extends PodSecurityPolicySelfSubjectReviewSpecFluentImpl<LocalResourceAccessReviewFluent.PodSecurityPolicySelfSubjectReviewSpecContentNested<N>> implements LocalResourceAccessReviewFluent.PodSecurityPolicySelfSubjectReviewSpecContentNested<N>,Nested<N>{
    PodSecurityPolicySelfSubjectReviewSpecContentNestedImpl(PodSecurityPolicySelfSubjectReviewSpec item) {
      this.builder = new PodSecurityPolicySelfSubjectReviewSpecBuilder(this, item);
    }
    PodSecurityPolicySelfSubjectReviewSpecContentNestedImpl() {
      this.builder = new PodSecurityPolicySelfSubjectReviewSpecBuilder(this);
    }
    PodSecurityPolicySelfSubjectReviewSpecBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endPodSecurityPolicySelfSubjectReviewSpecContent() {
      return and();
    }
    
  }
  class BrokerTemplateInstanceContentNestedImpl<N> extends BrokerTemplateInstanceFluentImpl<LocalResourceAccessReviewFluent.BrokerTemplateInstanceContentNested<N>> implements LocalResourceAccessReviewFluent.BrokerTemplateInstanceContentNested<N>,Nested<N>{
    BrokerTemplateInstanceContentNestedImpl(BrokerTemplateInstance item) {
      this.builder = new BrokerTemplateInstanceBuilder(this, item);
    }
    BrokerTemplateInstanceContentNestedImpl() {
      this.builder = new BrokerTemplateInstanceBuilder(this);
    }
    BrokerTemplateInstanceBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBrokerTemplateInstanceContent() {
      return and();
    }
    
  }
  class BuildPostCommitSpecContentNestedImpl<N> extends BuildPostCommitSpecFluentImpl<LocalResourceAccessReviewFluent.BuildPostCommitSpecContentNested<N>> implements LocalResourceAccessReviewFluent.BuildPostCommitSpecContentNested<N>,Nested<N>{
    BuildPostCommitSpecContentNestedImpl(BuildPostCommitSpec item) {
      this.builder = new BuildPostCommitSpecBuilder(this, item);
    }
    BuildPostCommitSpecContentNestedImpl() {
      this.builder = new BuildPostCommitSpecBuilder(this);
    }
    BuildPostCommitSpecBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildPostCommitSpecContent() {
      return and();
    }
    
  }
  class OAuthAuthorizeTokenListContentNestedImpl<N> extends OAuthAuthorizeTokenListFluentImpl<LocalResourceAccessReviewFluent.OAuthAuthorizeTokenListContentNested<N>> implements LocalResourceAccessReviewFluent.OAuthAuthorizeTokenListContentNested<N>,Nested<N>{
    OAuthAuthorizeTokenListContentNestedImpl(OAuthAuthorizeTokenList item) {
      this.builder = new OAuthAuthorizeTokenListBuilder(this, item);
    }
    OAuthAuthorizeTokenListContentNestedImpl() {
      this.builder = new OAuthAuthorizeTokenListBuilder(this);
    }
    OAuthAuthorizeTokenListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endOAuthAuthorizeTokenListContent() {
      return and();
    }
    
  }
  class DeploymentStrategyContentNestedImpl<N> extends DeploymentStrategyFluentImpl<LocalResourceAccessReviewFluent.DeploymentStrategyContentNested<N>> implements LocalResourceAccessReviewFluent.DeploymentStrategyContentNested<N>,Nested<N>{
    DeploymentStrategyContentNestedImpl(DeploymentStrategy item) {
      this.builder = new DeploymentStrategyBuilder(this, item);
    }
    DeploymentStrategyContentNestedImpl() {
      this.builder = new DeploymentStrategyBuilder(this);
    }
    DeploymentStrategyBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endDeploymentStrategyContent() {
      return and();
    }
    
  }
  class SignatureSubjectContentNestedImpl<N> extends SignatureSubjectFluentImpl<LocalResourceAccessReviewFluent.SignatureSubjectContentNested<N>> implements LocalResourceAccessReviewFluent.SignatureSubjectContentNested<N>,Nested<N>{
    SignatureSubjectContentNestedImpl(SignatureSubject item) {
      this.builder = new SignatureSubjectBuilder(this, item);
    }
    SignatureSubjectContentNestedImpl() {
      this.builder = new SignatureSubjectBuilder(this);
    }
    SignatureSubjectBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSignatureSubjectContent() {
      return and();
    }
    
  }
  class HostSubnetListContentNestedImpl<N> extends HostSubnetListFluentImpl<LocalResourceAccessReviewFluent.HostSubnetListContentNested<N>> implements LocalResourceAccessReviewFluent.HostSubnetListContentNested<N>,Nested<N>{
    HostSubnetListContentNestedImpl(HostSubnetList item) {
      this.builder = new HostSubnetListBuilder(this, item);
    }
    HostSubnetListContentNestedImpl() {
      this.builder = new HostSubnetListBuilder(this);
    }
    HostSubnetListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endHostSubnetListContent() {
      return and();
    }
    
  }
  class RouteIngressConditionContentNestedImpl<N> extends RouteIngressConditionFluentImpl<LocalResourceAccessReviewFluent.RouteIngressConditionContentNested<N>> implements LocalResourceAccessReviewFluent.RouteIngressConditionContentNested<N>,Nested<N>{
    RouteIngressConditionContentNestedImpl(RouteIngressCondition item) {
      this.builder = new RouteIngressConditionBuilder(this, item);
    }
    RouteIngressConditionContentNestedImpl() {
      this.builder = new RouteIngressConditionBuilder(this);
    }
    RouteIngressConditionBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRouteIngressConditionContent() {
      return and();
    }
    
  }
  class CustomDeploymentStrategyParamsContentNestedImpl<N> extends CustomDeploymentStrategyParamsFluentImpl<LocalResourceAccessReviewFluent.CustomDeploymentStrategyParamsContentNested<N>> implements LocalResourceAccessReviewFluent.CustomDeploymentStrategyParamsContentNested<N>,Nested<N>{
    CustomDeploymentStrategyParamsContentNestedImpl(CustomDeploymentStrategyParams item) {
      this.builder = new CustomDeploymentStrategyParamsBuilder(this, item);
    }
    CustomDeploymentStrategyParamsContentNestedImpl() {
      this.builder = new CustomDeploymentStrategyParamsBuilder(this);
    }
    CustomDeploymentStrategyParamsBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endCustomDeploymentStrategyParamsContent() {
      return and();
    }
    
  }
  class ImageImportSpecContentNestedImpl<N> extends ImageImportSpecFluentImpl<LocalResourceAccessReviewFluent.ImageImportSpecContentNested<N>> implements LocalResourceAccessReviewFluent.ImageImportSpecContentNested<N>,Nested<N>{
    ImageImportSpecContentNestedImpl(ImageImportSpec item) {
      this.builder = new ImageImportSpecBuilder(this, item);
    }
    ImageImportSpecContentNestedImpl() {
      this.builder = new ImageImportSpecBuilder(this);
    }
    ImageImportSpecBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageImportSpecContent() {
      return and();
    }
    
  }
  class StageInfoContentNestedImpl<N> extends StageInfoFluentImpl<LocalResourceAccessReviewFluent.StageInfoContentNested<N>> implements LocalResourceAccessReviewFluent.StageInfoContentNested<N>,Nested<N>{
    StageInfoContentNestedImpl(StageInfo item) {
      this.builder = new StageInfoBuilder(this, item);
    }
    StageInfoContentNestedImpl() {
      this.builder = new StageInfoBuilder(this);
    }
    StageInfoBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endStageInfoContent() {
      return and();
    }
    
  }
  class RoleBindingRestrictionSpecContentNestedImpl<N> extends RoleBindingRestrictionSpecFluentImpl<LocalResourceAccessReviewFluent.RoleBindingRestrictionSpecContentNested<N>> implements LocalResourceAccessReviewFluent.RoleBindingRestrictionSpecContentNested<N>,Nested<N>{
    RoleBindingRestrictionSpecContentNestedImpl(RoleBindingRestrictionSpec item) {
      this.builder = new RoleBindingRestrictionSpecBuilder(this, item);
    }
    RoleBindingRestrictionSpecContentNestedImpl() {
      this.builder = new RoleBindingRestrictionSpecBuilder(this);
    }
    RoleBindingRestrictionSpecBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRoleBindingRestrictionSpecContent() {
      return and();
    }
    
  }
  class IDRangeContentNestedImpl<N> extends IDRangeFluentImpl<LocalResourceAccessReviewFluent.IDRangeContentNested<N>> implements LocalResourceAccessReviewFluent.IDRangeContentNested<N>,Nested<N>{
    IDRangeContentNestedImpl(IDRange item) {
      this.builder = new IDRangeBuilder(this, item);
    }
    IDRangeContentNestedImpl() {
      this.builder = new IDRangeBuilder(this);
    }
    IDRangeBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endIDRangeContent() {
      return and();
    }
    
  }
  class UserListContentNestedImpl<N> extends UserListFluentImpl<LocalResourceAccessReviewFluent.UserListContentNested<N>> implements LocalResourceAccessReviewFluent.UserListContentNested<N>,Nested<N>{
    UserListContentNestedImpl(UserList item) {
      this.builder = new UserListBuilder(this, item);
    }
    UserListContentNestedImpl() {
      this.builder = new UserListBuilder(this);
    }
    UserListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endUserListContent() {
      return and();
    }
    
  }
  class BuildConfigSpecContentNestedImpl<N> extends BuildConfigSpecFluentImpl<LocalResourceAccessReviewFluent.BuildConfigSpecContentNested<N>> implements LocalResourceAccessReviewFluent.BuildConfigSpecContentNested<N>,Nested<N>{
    BuildConfigSpecContentNestedImpl(BuildConfigSpec item) {
      this.builder = new BuildConfigSpecBuilder(this, item);
    }
    BuildConfigSpecContentNestedImpl() {
      this.builder = new BuildConfigSpecBuilder(this);
    }
    BuildConfigSpecBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildConfigSpecContent() {
      return and();
    }
    
  }
  class UserContentNestedImpl<N> extends UserFluentImpl<LocalResourceAccessReviewFluent.UserContentNested<N>> implements LocalResourceAccessReviewFluent.UserContentNested<N>,Nested<N>{
    UserContentNestedImpl(User item) {
      this.builder = new UserBuilder(this, item);
    }
    UserContentNestedImpl() {
      this.builder = new UserBuilder(this);
    }
    UserBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endUserContent() {
      return and();
    }
    
  }
  class ImageStreamImageContentNestedImpl<N> extends ImageStreamImageFluentImpl<LocalResourceAccessReviewFluent.ImageStreamImageContentNested<N>> implements LocalResourceAccessReviewFluent.ImageStreamImageContentNested<N>,Nested<N>{
    ImageStreamImageContentNestedImpl(ImageStreamImage item) {
      this.builder = new ImageStreamImageBuilder(this, item);
    }
    ImageStreamImageContentNestedImpl() {
      this.builder = new ImageStreamImageBuilder(this);
    }
    ImageStreamImageBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamImageContent() {
      return and();
    }
    
  }
  class BuildStatusOutputToContentNestedImpl<N> extends BuildStatusOutputToFluentImpl<LocalResourceAccessReviewFluent.BuildStatusOutputToContentNested<N>> implements LocalResourceAccessReviewFluent.BuildStatusOutputToContentNested<N>,Nested<N>{
    BuildStatusOutputToContentNestedImpl(BuildStatusOutputTo item) {
      this.builder = new BuildStatusOutputToBuilder(this, item);
    }
    BuildStatusOutputToContentNestedImpl() {
      this.builder = new BuildStatusOutputToBuilder(this);
    }
    BuildStatusOutputToBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildStatusOutputToContent() {
      return and();
    }
    
  }
  class BuildConditionContentNestedImpl<N> extends BuildConditionFluentImpl<LocalResourceAccessReviewFluent.BuildConditionContentNested<N>> implements LocalResourceAccessReviewFluent.BuildConditionContentNested<N>,Nested<N>{
    BuildConditionContentNestedImpl(BuildCondition item) {
      this.builder = new BuildConditionBuilder(this, item);
    }
    BuildConditionContentNestedImpl() {
      this.builder = new BuildConditionBuilder(this);
    }
    BuildConditionBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildConditionContent() {
      return and();
    }
    
  }
  class ResourceAccessReviewResponseContentNestedImpl<N> extends ResourceAccessReviewResponseFluentImpl<LocalResourceAccessReviewFluent.ResourceAccessReviewResponseContentNested<N>> implements LocalResourceAccessReviewFluent.ResourceAccessReviewResponseContentNested<N>,Nested<N>{
    ResourceAccessReviewResponseContentNestedImpl(ResourceAccessReviewResponse item) {
      this.builder = new ResourceAccessReviewResponseBuilder(this, item);
    }
    ResourceAccessReviewResponseContentNestedImpl() {
      this.builder = new ResourceAccessReviewResponseBuilder(this);
    }
    ResourceAccessReviewResponseBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endResourceAccessReviewResponseContent() {
      return and();
    }
    
  }
  class ExecNewPodHookContentNestedImpl<N> extends ExecNewPodHookFluentImpl<LocalResourceAccessReviewFluent.ExecNewPodHookContentNested<N>> implements LocalResourceAccessReviewFluent.ExecNewPodHookContentNested<N>,Nested<N>{
    ExecNewPodHookContentNestedImpl(ExecNewPodHook item) {
      this.builder = new ExecNewPodHookBuilder(this, item);
    }
    ExecNewPodHookContentNestedImpl() {
      this.builder = new ExecNewPodHookBuilder(this);
    }
    ExecNewPodHookBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endExecNewPodHookContent() {
      return and();
    }
    
  }
  class SecretSpecContentNestedImpl<N> extends SecretSpecFluentImpl<LocalResourceAccessReviewFluent.SecretSpecContentNested<N>> implements LocalResourceAccessReviewFluent.SecretSpecContentNested<N>,Nested<N>{
    SecretSpecContentNestedImpl(SecretSpec item) {
      this.builder = new SecretSpecBuilder(this, item);
    }
    SecretSpecContentNestedImpl() {
      this.builder = new SecretSpecBuilder(this);
    }
    SecretSpecBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSecretSpecContent() {
      return and();
    }
    
  }
  class ClusterRoleBindingListContentNestedImpl<N> extends ClusterRoleBindingListFluentImpl<LocalResourceAccessReviewFluent.ClusterRoleBindingListContentNested<N>> implements LocalResourceAccessReviewFluent.ClusterRoleBindingListContentNested<N>,Nested<N>{
    ClusterRoleBindingListContentNestedImpl(ClusterRoleBindingList item) {
      this.builder = new ClusterRoleBindingListBuilder(this, item);
    }
    ClusterRoleBindingListContentNestedImpl() {
      this.builder = new ClusterRoleBindingListBuilder(this);
    }
    ClusterRoleBindingListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterRoleBindingListContent() {
      return and();
    }
    
  }
  class EgressNetworkPolicyPeerContentNestedImpl<N> extends EgressNetworkPolicyPeerFluentImpl<LocalResourceAccessReviewFluent.EgressNetworkPolicyPeerContentNested<N>> implements LocalResourceAccessReviewFluent.EgressNetworkPolicyPeerContentNested<N>,Nested<N>{
    EgressNetworkPolicyPeerContentNestedImpl(EgressNetworkPolicyPeer item) {
      this.builder = new EgressNetworkPolicyPeerBuilder(this, item);
    }
    EgressNetworkPolicyPeerContentNestedImpl() {
      this.builder = new EgressNetworkPolicyPeerBuilder(this);
    }
    EgressNetworkPolicyPeerBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endEgressNetworkPolicyPeerContent() {
      return and();
    }
    
  }
  class TemplateInstanceContentNestedImpl<N> extends TemplateInstanceFluentImpl<LocalResourceAccessReviewFluent.TemplateInstanceContentNested<N>> implements LocalResourceAccessReviewFluent.TemplateInstanceContentNested<N>,Nested<N>{
    TemplateInstanceContentNestedImpl(TemplateInstance item) {
      this.builder = new TemplateInstanceBuilder(this, item);
    }
    TemplateInstanceContentNestedImpl() {
      this.builder = new TemplateInstanceBuilder(this);
    }
    TemplateInstanceBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTemplateInstanceContent() {
      return and();
    }
    
  }
  class WebHookTriggerContentNestedImpl<N> extends WebHookTriggerFluentImpl<LocalResourceAccessReviewFluent.WebHookTriggerContentNested<N>> implements LocalResourceAccessReviewFluent.WebHookTriggerContentNested<N>,Nested<N>{
    WebHookTriggerContentNestedImpl(WebHookTrigger item) {
      this.builder = new WebHookTriggerBuilder(this, item);
    }
    WebHookTriggerContentNestedImpl() {
      this.builder = new WebHookTriggerBuilder(this);
    }
    WebHookTriggerBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endWebHookTriggerContent() {
      return and();
    }
    
  }
  class ServiceAccountReferenceContentNestedImpl<N> extends ServiceAccountReferenceFluentImpl<LocalResourceAccessReviewFluent.ServiceAccountReferenceContentNested<N>> implements LocalResourceAccessReviewFluent.ServiceAccountReferenceContentNested<N>,Nested<N>{
    ServiceAccountReferenceContentNestedImpl(ServiceAccountReference item) {
      this.builder = new ServiceAccountReferenceBuilder(this, item);
    }
    ServiceAccountReferenceContentNestedImpl() {
      this.builder = new ServiceAccountReferenceBuilder(this);
    }
    ServiceAccountReferenceBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endServiceAccountReferenceContent() {
      return and();
    }
    
  }
  class BuildContentNestedImpl<N> extends BuildFluentImpl<LocalResourceAccessReviewFluent.BuildContentNested<N>> implements LocalResourceAccessReviewFluent.BuildContentNested<N>,Nested<N>{
    BuildContentNestedImpl(Build item) {
      this.builder = new BuildBuilder(this, item);
    }
    BuildContentNestedImpl() {
      this.builder = new BuildBuilder(this);
    }
    BuildBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildContent() {
      return and();
    }
    
  }
  class RoleBindingRestrictionContentNestedImpl<N> extends RoleBindingRestrictionFluentImpl<LocalResourceAccessReviewFluent.RoleBindingRestrictionContentNested<N>> implements LocalResourceAccessReviewFluent.RoleBindingRestrictionContentNested<N>,Nested<N>{
    RoleBindingRestrictionContentNestedImpl(RoleBindingRestriction item) {
      this.builder = new RoleBindingRestrictionBuilder(this, item);
    }
    RoleBindingRestrictionContentNestedImpl() {
      this.builder = new RoleBindingRestrictionBuilder(this);
    }
    RoleBindingRestrictionBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRoleBindingRestrictionContent() {
      return and();
    }
    
  }
  class TagImportPolicyContentNestedImpl<N> extends TagImportPolicyFluentImpl<LocalResourceAccessReviewFluent.TagImportPolicyContentNested<N>> implements LocalResourceAccessReviewFluent.TagImportPolicyContentNested<N>,Nested<N>{
    TagImportPolicyContentNestedImpl(TagImportPolicy item) {
      this.builder = new TagImportPolicyBuilder(this, item);
    }
    TagImportPolicyContentNestedImpl() {
      this.builder = new TagImportPolicyBuilder(this);
    }
    TagImportPolicyBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTagImportPolicyContent() {
      return and();
    }
    
  }
  class ImageStreamTagContentNestedImpl<N> extends ImageStreamTagFluentImpl<LocalResourceAccessReviewFluent.ImageStreamTagContentNested<N>> implements LocalResourceAccessReviewFluent.ImageStreamTagContentNested<N>,Nested<N>{
    ImageStreamTagContentNestedImpl(ImageStreamTag item) {
      this.builder = new ImageStreamTagBuilder(this, item);
    }
    ImageStreamTagContentNestedImpl() {
      this.builder = new ImageStreamTagBuilder(this);
    }
    ImageStreamTagBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamTagContent() {
      return and();
    }
    
  }
  class BuildTriggerPolicyContentNestedImpl<N> extends BuildTriggerPolicyFluentImpl<LocalResourceAccessReviewFluent.BuildTriggerPolicyContentNested<N>> implements LocalResourceAccessReviewFluent.BuildTriggerPolicyContentNested<N>,Nested<N>{
    BuildTriggerPolicyContentNestedImpl(BuildTriggerPolicy item) {
      this.builder = new BuildTriggerPolicyBuilder(this, item);
    }
    BuildTriggerPolicyContentNestedImpl() {
      this.builder = new BuildTriggerPolicyBuilder(this);
    }
    BuildTriggerPolicyBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildTriggerPolicyContent() {
      return and();
    }
    
  }
  class RoutePortContentNestedImpl<N> extends RoutePortFluentImpl<LocalResourceAccessReviewFluent.RoutePortContentNested<N>> implements LocalResourceAccessReviewFluent.RoutePortContentNested<N>,Nested<N>{
    RoutePortContentNestedImpl(RoutePort item) {
      this.builder = new RoutePortBuilder(this, item);
    }
    RoutePortContentNestedImpl() {
      this.builder = new RoutePortBuilder(this);
    }
    RoutePortBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRoutePortContent() {
      return and();
    }
    
  }
  class TemplateInstanceRequesterContentNestedImpl<N> extends TemplateInstanceRequesterFluentImpl<LocalResourceAccessReviewFluent.TemplateInstanceRequesterContentNested<N>> implements LocalResourceAccessReviewFluent.TemplateInstanceRequesterContentNested<N>,Nested<N>{
    TemplateInstanceRequesterContentNestedImpl(TemplateInstanceRequester item) {
      this.builder = new TemplateInstanceRequesterBuilder(this, item);
    }
    TemplateInstanceRequesterContentNestedImpl() {
      this.builder = new TemplateInstanceRequesterBuilder(this);
    }
    TemplateInstanceRequesterBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTemplateInstanceRequesterContent() {
      return and();
    }
    
  }
  class GroupContentNestedImpl<N> extends GroupFluentImpl<LocalResourceAccessReviewFluent.GroupContentNested<N>> implements LocalResourceAccessReviewFluent.GroupContentNested<N>,Nested<N>{
    GroupContentNestedImpl(Group item) {
      this.builder = new GroupBuilder(this, item);
    }
    GroupContentNestedImpl() {
      this.builder = new GroupBuilder(this);
    }
    GroupBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endGroupContent() {
      return and();
    }
    
  }
  class BuildTriggerCauseContentNestedImpl<N> extends BuildTriggerCauseFluentImpl<LocalResourceAccessReviewFluent.BuildTriggerCauseContentNested<N>> implements LocalResourceAccessReviewFluent.BuildTriggerCauseContentNested<N>,Nested<N>{
    BuildTriggerCauseContentNestedImpl(BuildTriggerCause item) {
      this.builder = new BuildTriggerCauseBuilder(this, item);
    }
    BuildTriggerCauseContentNestedImpl() {
      this.builder = new BuildTriggerCauseBuilder(this);
    }
    BuildTriggerCauseBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildTriggerCauseContent() {
      return and();
    }
    
  }
  class ImageSignatureContentNestedImpl<N> extends ImageSignatureFluentImpl<LocalResourceAccessReviewFluent.ImageSignatureContentNested<N>> implements LocalResourceAccessReviewFluent.ImageSignatureContentNested<N>,Nested<N>{
    ImageSignatureContentNestedImpl(ImageSignature item) {
      this.builder = new ImageSignatureBuilder(this, item);
    }
    ImageSignatureContentNestedImpl() {
      this.builder = new ImageSignatureBuilder(this);
    }
    ImageSignatureBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageSignatureContent() {
      return and();
    }
    
  }
  class HelmChartRepositoryStatusContentNestedImpl<N> extends HelmChartRepositoryStatusFluentImpl<LocalResourceAccessReviewFluent.HelmChartRepositoryStatusContentNested<N>> implements LocalResourceAccessReviewFluent.HelmChartRepositoryStatusContentNested<N>,Nested<N>{
    HelmChartRepositoryStatusContentNestedImpl(HelmChartRepositoryStatus item) {
      this.builder = new HelmChartRepositoryStatusBuilder(this, item);
    }
    HelmChartRepositoryStatusContentNestedImpl() {
      this.builder = new HelmChartRepositoryStatusBuilder(this);
    }
    HelmChartRepositoryStatusBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endHelmChartRepositoryStatusContent() {
      return and();
    }
    
  }
  class DeploymentConfigSpecContentNestedImpl<N> extends DeploymentConfigSpecFluentImpl<LocalResourceAccessReviewFluent.DeploymentConfigSpecContentNested<N>> implements LocalResourceAccessReviewFluent.DeploymentConfigSpecContentNested<N>,Nested<N>{
    DeploymentConfigSpecContentNestedImpl(DeploymentConfigSpec item) {
      this.builder = new DeploymentConfigSpecBuilder(this, item);
    }
    DeploymentConfigSpecContentNestedImpl() {
      this.builder = new DeploymentConfigSpecBuilder(this);
    }
    DeploymentConfigSpecBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endDeploymentConfigSpecContent() {
      return and();
    }
    
  }
  class HostSubnetContentNestedImpl<N> extends HostSubnetFluentImpl<LocalResourceAccessReviewFluent.HostSubnetContentNested<N>> implements LocalResourceAccessReviewFluent.HostSubnetContentNested<N>,Nested<N>{
    HostSubnetContentNestedImpl(HostSubnet item) {
      this.builder = new HostSubnetBuilder(this, item);
    }
    HostSubnetContentNestedImpl() {
      this.builder = new HostSubnetBuilder(this);
    }
    HostSubnetBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endHostSubnetContent() {
      return and();
    }
    
  }
  class GroupRestrictionContentNestedImpl<N> extends GroupRestrictionFluentImpl<LocalResourceAccessReviewFluent.GroupRestrictionContentNested<N>> implements LocalResourceAccessReviewFluent.GroupRestrictionContentNested<N>,Nested<N>{
    GroupRestrictionContentNestedImpl(GroupRestriction item) {
      this.builder = new GroupRestrictionBuilder(this, item);
    }
    GroupRestrictionContentNestedImpl() {
      this.builder = new GroupRestrictionBuilder(this);
    }
    GroupRestrictionBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endGroupRestrictionContent() {
      return and();
    }
    
  }
  class AppliedClusterResourceQuotaContentNestedImpl<N> extends AppliedClusterResourceQuotaFluentImpl<LocalResourceAccessReviewFluent.AppliedClusterResourceQuotaContentNested<N>> implements LocalResourceAccessReviewFluent.AppliedClusterResourceQuotaContentNested<N>,Nested<N>{
    AppliedClusterResourceQuotaContentNestedImpl(AppliedClusterResourceQuota item) {
      this.builder = new AppliedClusterResourceQuotaBuilder(this, item);
    }
    AppliedClusterResourceQuotaContentNestedImpl() {
      this.builder = new AppliedClusterResourceQuotaBuilder(this);
    }
    AppliedClusterResourceQuotaBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endAppliedClusterResourceQuotaContent() {
      return and();
    }
    
  }
  class OAuthAccessTokenListContentNestedImpl<N> extends OAuthAccessTokenListFluentImpl<LocalResourceAccessReviewFluent.OAuthAccessTokenListContentNested<N>> implements LocalResourceAccessReviewFluent.OAuthAccessTokenListContentNested<N>,Nested<N>{
    OAuthAccessTokenListContentNestedImpl(OAuthAccessTokenList item) {
      this.builder = new OAuthAccessTokenListBuilder(this, item);
    }
    OAuthAccessTokenListContentNestedImpl() {
      this.builder = new OAuthAccessTokenListBuilder(this);
    }
    OAuthAccessTokenListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endOAuthAccessTokenListContent() {
      return and();
    }
    
  }
  class JenkinsPipelineBuildStrategyContentNestedImpl<N> extends JenkinsPipelineBuildStrategyFluentImpl<LocalResourceAccessReviewFluent.JenkinsPipelineBuildStrategyContentNested<N>> implements LocalResourceAccessReviewFluent.JenkinsPipelineBuildStrategyContentNested<N>,Nested<N>{
    JenkinsPipelineBuildStrategyContentNestedImpl(JenkinsPipelineBuildStrategy item) {
      this.builder = new JenkinsPipelineBuildStrategyBuilder(this, item);
    }
    JenkinsPipelineBuildStrategyContentNestedImpl() {
      this.builder = new JenkinsPipelineBuildStrategyBuilder(this);
    }
    JenkinsPipelineBuildStrategyBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endJenkinsPipelineBuildStrategyContent() {
      return and();
    }
    
  }
  class SecurityContextConstraintsContentNestedImpl<N> extends SecurityContextConstraintsFluentImpl<LocalResourceAccessReviewFluent.SecurityContextConstraintsContentNested<N>> implements LocalResourceAccessReviewFluent.SecurityContextConstraintsContentNested<N>,Nested<N>{
    SecurityContextConstraintsContentNestedImpl(SecurityContextConstraints item) {
      this.builder = new SecurityContextConstraintsBuilder(this, item);
    }
    SecurityContextConstraintsContentNestedImpl() {
      this.builder = new SecurityContextConstraintsBuilder(this);
    }
    SecurityContextConstraintsBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSecurityContextConstraintsContent() {
      return and();
    }
    
  }
  class SupplementalGroupsStrategyOptionsContentNestedImpl<N> extends SupplementalGroupsStrategyOptionsFluentImpl<LocalResourceAccessReviewFluent.SupplementalGroupsStrategyOptionsContentNested<N>> implements LocalResourceAccessReviewFluent.SupplementalGroupsStrategyOptionsContentNested<N>,Nested<N>{
    SupplementalGroupsStrategyOptionsContentNestedImpl(SupplementalGroupsStrategyOptions item) {
      this.builder = new SupplementalGroupsStrategyOptionsBuilder(this, item);
    }
    SupplementalGroupsStrategyOptionsContentNestedImpl() {
      this.builder = new SupplementalGroupsStrategyOptionsBuilder(this);
    }
    SupplementalGroupsStrategyOptionsBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSupplementalGroupsStrategyOptionsContent() {
      return and();
    }
    
  }
  class ServiceAccountPodSecurityPolicyReviewStatusContentNestedImpl<N> extends ServiceAccountPodSecurityPolicyReviewStatusFluentImpl<LocalResourceAccessReviewFluent.ServiceAccountPodSecurityPolicyReviewStatusContentNested<N>> implements LocalResourceAccessReviewFluent.ServiceAccountPodSecurityPolicyReviewStatusContentNested<N>,Nested<N>{
    ServiceAccountPodSecurityPolicyReviewStatusContentNestedImpl(ServiceAccountPodSecurityPolicyReviewStatus item) {
      this.builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(this, item);
    }
    ServiceAccountPodSecurityPolicyReviewStatusContentNestedImpl() {
      this.builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(this);
    }
    ServiceAccountPodSecurityPolicyReviewStatusBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endServiceAccountPodSecurityPolicyReviewStatusContent() {
      return and();
    }
    
  }
  class BuildRequestContentNestedImpl<N> extends BuildRequestFluentImpl<LocalResourceAccessReviewFluent.BuildRequestContentNested<N>> implements LocalResourceAccessReviewFluent.BuildRequestContentNested<N>,Nested<N>{
    BuildRequestContentNestedImpl(BuildRequest item) {
      this.builder = new BuildRequestBuilder(this, item);
    }
    BuildRequestContentNestedImpl() {
      this.builder = new BuildRequestBuilder(this);
    }
    BuildRequestBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildRequestContent() {
      return and();
    }
    
  }
  class SELinuxContextStrategyOptionsContentNestedImpl<N> extends SELinuxContextStrategyOptionsFluentImpl<LocalResourceAccessReviewFluent.SELinuxContextStrategyOptionsContentNested<N>> implements LocalResourceAccessReviewFluent.SELinuxContextStrategyOptionsContentNested<N>,Nested<N>{
    SELinuxContextStrategyOptionsContentNestedImpl(SELinuxContextStrategyOptions item) {
      this.builder = new SELinuxContextStrategyOptionsBuilder(this, item);
    }
    SELinuxContextStrategyOptionsContentNestedImpl() {
      this.builder = new SELinuxContextStrategyOptionsBuilder(this);
    }
    SELinuxContextStrategyOptionsBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSELinuxContextStrategyOptionsContent() {
      return and();
    }
    
  }
  class ClusterRoleListContentNestedImpl<N> extends ClusterRoleListFluentImpl<LocalResourceAccessReviewFluent.ClusterRoleListContentNested<N>> implements LocalResourceAccessReviewFluent.ClusterRoleListContentNested<N>,Nested<N>{
    ClusterRoleListContentNestedImpl(ClusterRoleList item) {
      this.builder = new ClusterRoleListBuilder(this, item);
    }
    ClusterRoleListContentNestedImpl() {
      this.builder = new ClusterRoleListBuilder(this);
    }
    ClusterRoleListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterRoleListContent() {
      return and();
    }
    
  }
  class RouteListContentNestedImpl<N> extends RouteListFluentImpl<LocalResourceAccessReviewFluent.RouteListContentNested<N>> implements LocalResourceAccessReviewFluent.RouteListContentNested<N>,Nested<N>{
    RouteListContentNestedImpl(RouteList item) {
      this.builder = new RouteListBuilder(this, item);
    }
    RouteListContentNestedImpl() {
      this.builder = new RouteListBuilder(this);
    }
    RouteListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRouteListContent() {
      return and();
    }
    
  }
  class ImageStreamStatusContentNestedImpl<N> extends ImageStreamStatusFluentImpl<LocalResourceAccessReviewFluent.ImageStreamStatusContentNested<N>> implements LocalResourceAccessReviewFluent.ImageStreamStatusContentNested<N>,Nested<N>{
    ImageStreamStatusContentNestedImpl(ImageStreamStatus item) {
      this.builder = new ImageStreamStatusBuilder(this, item);
    }
    ImageStreamStatusContentNestedImpl() {
      this.builder = new ImageStreamStatusBuilder(this);
    }
    ImageStreamStatusBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamStatusContent() {
      return and();
    }
    
  }
  class EgressNetworkPolicyContentNestedImpl<N> extends EgressNetworkPolicyFluentImpl<LocalResourceAccessReviewFluent.EgressNetworkPolicyContentNested<N>> implements LocalResourceAccessReviewFluent.EgressNetworkPolicyContentNested<N>,Nested<N>{
    EgressNetworkPolicyContentNestedImpl(EgressNetworkPolicy item) {
      this.builder = new EgressNetworkPolicyBuilder(this, item);
    }
    EgressNetworkPolicyContentNestedImpl() {
      this.builder = new EgressNetworkPolicyBuilder(this);
    }
    EgressNetworkPolicyBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endEgressNetworkPolicyContent() {
      return and();
    }
    
  }
  class NetNamespaceContentNestedImpl<N> extends NetNamespaceFluentImpl<LocalResourceAccessReviewFluent.NetNamespaceContentNested<N>> implements LocalResourceAccessReviewFluent.NetNamespaceContentNested<N>,Nested<N>{
    NetNamespaceContentNestedImpl(NetNamespace item) {
      this.builder = new NetNamespaceBuilder(this, item);
    }
    NetNamespaceContentNestedImpl() {
      this.builder = new NetNamespaceBuilder(this);
    }
    NetNamespaceBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endNetNamespaceContent() {
      return and();
    }
    
  }
  class UserIdentityMappingContentNestedImpl<N> extends UserIdentityMappingFluentImpl<LocalResourceAccessReviewFluent.UserIdentityMappingContentNested<N>> implements LocalResourceAccessReviewFluent.UserIdentityMappingContentNested<N>,Nested<N>{
    UserIdentityMappingContentNestedImpl(UserIdentityMapping item) {
      this.builder = new UserIdentityMappingBuilder(this, item);
    }
    UserIdentityMappingContentNestedImpl() {
      this.builder = new UserIdentityMappingBuilder(this);
    }
    UserIdentityMappingBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endUserIdentityMappingContent() {
      return and();
    }
    
  }
  class DeploymentDetailsContentNestedImpl<N> extends DeploymentDetailsFluentImpl<LocalResourceAccessReviewFluent.DeploymentDetailsContentNested<N>> implements LocalResourceAccessReviewFluent.DeploymentDetailsContentNested<N>,Nested<N>{
    DeploymentDetailsContentNestedImpl(DeploymentDetails item) {
      this.builder = new DeploymentDetailsBuilder(this, item);
    }
    DeploymentDetailsContentNestedImpl() {
      this.builder = new DeploymentDetailsBuilder(this);
    }
    DeploymentDetailsBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endDeploymentDetailsContent() {
      return and();
    }
    
  }
  class PodSecurityPolicySubjectReviewStatusContentNestedImpl<N> extends PodSecurityPolicySubjectReviewStatusFluentImpl<LocalResourceAccessReviewFluent.PodSecurityPolicySubjectReviewStatusContentNested<N>> implements LocalResourceAccessReviewFluent.PodSecurityPolicySubjectReviewStatusContentNested<N>,Nested<N>{
    PodSecurityPolicySubjectReviewStatusContentNestedImpl(PodSecurityPolicySubjectReviewStatus item) {
      this.builder = new PodSecurityPolicySubjectReviewStatusBuilder(this, item);
    }
    PodSecurityPolicySubjectReviewStatusContentNestedImpl() {
      this.builder = new PodSecurityPolicySubjectReviewStatusBuilder(this);
    }
    PodSecurityPolicySubjectReviewStatusBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endPodSecurityPolicySubjectReviewStatusContent() {
      return and();
    }
    
  }
  class PodSecurityPolicySubjectReviewSpecContentNestedImpl<N> extends PodSecurityPolicySubjectReviewSpecFluentImpl<LocalResourceAccessReviewFluent.PodSecurityPolicySubjectReviewSpecContentNested<N>> implements LocalResourceAccessReviewFluent.PodSecurityPolicySubjectReviewSpecContentNested<N>,Nested<N>{
    PodSecurityPolicySubjectReviewSpecContentNestedImpl(PodSecurityPolicySubjectReviewSpec item) {
      this.builder = new PodSecurityPolicySubjectReviewSpecBuilder(this, item);
    }
    PodSecurityPolicySubjectReviewSpecContentNestedImpl() {
      this.builder = new PodSecurityPolicySubjectReviewSpecBuilder(this);
    }
    PodSecurityPolicySubjectReviewSpecBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endPodSecurityPolicySubjectReviewSpecContent() {
      return and();
    }
    
  }
  class ImageStreamContentNestedImpl<N> extends ImageStreamFluentImpl<LocalResourceAccessReviewFluent.ImageStreamContentNested<N>> implements LocalResourceAccessReviewFluent.ImageStreamContentNested<N>,Nested<N>{
    ImageStreamContentNestedImpl(ImageStream item) {
      this.builder = new ImageStreamBuilder(this, item);
    }
    ImageStreamContentNestedImpl() {
      this.builder = new ImageStreamBuilder(this);
    }
    ImageStreamBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamContent() {
      return and();
    }
    
  }
  class BuildListContentNestedImpl<N> extends BuildListFluentImpl<LocalResourceAccessReviewFluent.BuildListContentNested<N>> implements LocalResourceAccessReviewFluent.BuildListContentNested<N>,Nested<N>{
    BuildListContentNestedImpl(BuildList item) {
      this.builder = new BuildListBuilder(this, item);
    }
    BuildListContentNestedImpl() {
      this.builder = new BuildListBuilder(this);
    }
    BuildListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildListContent() {
      return and();
    }
    
  }
  class TemplateListContentNestedImpl<N> extends TemplateListFluentImpl<LocalResourceAccessReviewFluent.TemplateListContentNested<N>> implements LocalResourceAccessReviewFluent.TemplateListContentNested<N>,Nested<N>{
    TemplateListContentNestedImpl(TemplateList item) {
      this.builder = new TemplateListBuilder(this, item);
    }
    TemplateListContentNestedImpl() {
      this.builder = new TemplateListBuilder(this);
    }
    TemplateListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTemplateListContent() {
      return and();
    }
    
  }
  class BuildOutputContentNestedImpl<N> extends BuildOutputFluentImpl<LocalResourceAccessReviewFluent.BuildOutputContentNested<N>> implements LocalResourceAccessReviewFluent.BuildOutputContentNested<N>,Nested<N>{
    BuildOutputContentNestedImpl(BuildOutput item) {
      this.builder = new BuildOutputBuilder(this, item);
    }
    BuildOutputContentNestedImpl() {
      this.builder = new BuildOutputBuilder(this);
    }
    BuildOutputBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildOutputContent() {
      return and();
    }
    
  }
  class ProjectSpecContentNestedImpl<N> extends ProjectSpecFluentImpl<LocalResourceAccessReviewFluent.ProjectSpecContentNested<N>> implements LocalResourceAccessReviewFluent.ProjectSpecContentNested<N>,Nested<N>{
    ProjectSpecContentNestedImpl(ProjectSpec item) {
      this.builder = new ProjectSpecBuilder(this, item);
    }
    ProjectSpecContentNestedImpl() {
      this.builder = new ProjectSpecBuilder(this);
    }
    ProjectSpecBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endProjectSpecContent() {
      return and();
    }
    
  }
  class SourceRevisionContentNestedImpl<N> extends SourceRevisionFluentImpl<LocalResourceAccessReviewFluent.SourceRevisionContentNested<N>> implements LocalResourceAccessReviewFluent.SourceRevisionContentNested<N>,Nested<N>{
    SourceRevisionContentNestedImpl(SourceRevision item) {
      this.builder = new SourceRevisionBuilder(this, item);
    }
    SourceRevisionContentNestedImpl() {
      this.builder = new SourceRevisionBuilder(this);
    }
    SourceRevisionBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSourceRevisionContent() {
      return and();
    }
    
  }
  class ObjectReferenceContentNestedImpl<N> extends ObjectReferenceFluentImpl<LocalResourceAccessReviewFluent.ObjectReferenceContentNested<N>> implements LocalResourceAccessReviewFluent.ObjectReferenceContentNested<N>,Nested<N>{
    ObjectReferenceContentNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceContentNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endObjectReferenceContent() {
      return and();
    }
    
  }
  class SignatureIssuerContentNestedImpl<N> extends SignatureIssuerFluentImpl<LocalResourceAccessReviewFluent.SignatureIssuerContentNested<N>> implements LocalResourceAccessReviewFluent.SignatureIssuerContentNested<N>,Nested<N>{
    SignatureIssuerContentNestedImpl(SignatureIssuer item) {
      this.builder = new SignatureIssuerBuilder(this, item);
    }
    SignatureIssuerContentNestedImpl() {
      this.builder = new SignatureIssuerBuilder(this);
    }
    SignatureIssuerBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSignatureIssuerContent() {
      return and();
    }
    
  }
  class ImageLayerContentNestedImpl<N> extends ImageLayerFluentImpl<LocalResourceAccessReviewFluent.ImageLayerContentNested<N>> implements LocalResourceAccessReviewFluent.ImageLayerContentNested<N>,Nested<N>{
    ImageLayerContentNestedImpl(ImageLayer item) {
      this.builder = new ImageLayerBuilder(this, item);
    }
    ImageLayerContentNestedImpl() {
      this.builder = new ImageLayerBuilder(this);
    }
    ImageLayerBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageLayerContent() {
      return and();
    }
    
  }
  class ClusterResourceQuotaSpecContentNestedImpl<N> extends ClusterResourceQuotaSpecFluentImpl<LocalResourceAccessReviewFluent.ClusterResourceQuotaSpecContentNested<N>> implements LocalResourceAccessReviewFluent.ClusterResourceQuotaSpecContentNested<N>,Nested<N>{
    ClusterResourceQuotaSpecContentNestedImpl(ClusterResourceQuotaSpec item) {
      this.builder = new ClusterResourceQuotaSpecBuilder(this, item);
    }
    ClusterResourceQuotaSpecContentNestedImpl() {
      this.builder = new ClusterResourceQuotaSpecBuilder(this);
    }
    ClusterResourceQuotaSpecBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterResourceQuotaSpecContent() {
      return and();
    }
    
  }
  class ImageStreamSpecContentNestedImpl<N> extends ImageStreamSpecFluentImpl<LocalResourceAccessReviewFluent.ImageStreamSpecContentNested<N>> implements LocalResourceAccessReviewFluent.ImageStreamSpecContentNested<N>,Nested<N>{
    ImageStreamSpecContentNestedImpl(ImageStreamSpec item) {
      this.builder = new ImageStreamSpecBuilder(this, item);
    }
    ImageStreamSpecContentNestedImpl() {
      this.builder = new ImageStreamSpecBuilder(this);
    }
    ImageStreamSpecBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamSpecContent() {
      return and();
    }
    
  }
  class RouteIngressContentNestedImpl<N> extends RouteIngressFluentImpl<LocalResourceAccessReviewFluent.RouteIngressContentNested<N>> implements LocalResourceAccessReviewFluent.RouteIngressContentNested<N>,Nested<N>{
    RouteIngressContentNestedImpl(RouteIngress item) {
      this.builder = new RouteIngressBuilder(this, item);
    }
    RouteIngressContentNestedImpl() {
      this.builder = new RouteIngressBuilder(this);
    }
    RouteIngressBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRouteIngressContent() {
      return and();
    }
    
  }
  class OAuthClientContentNestedImpl<N> extends OAuthClientFluentImpl<LocalResourceAccessReviewFluent.OAuthClientContentNested<N>> implements LocalResourceAccessReviewFluent.OAuthClientContentNested<N>,Nested<N>{
    OAuthClientContentNestedImpl(OAuthClient item) {
      this.builder = new OAuthClientBuilder(this, item);
    }
    OAuthClientContentNestedImpl() {
      this.builder = new OAuthClientBuilder(this);
    }
    OAuthClientBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endOAuthClientContent() {
      return and();
    }
    
  }
  class IdentityContentNestedImpl<N> extends IdentityFluentImpl<LocalResourceAccessReviewFluent.IdentityContentNested<N>> implements LocalResourceAccessReviewFluent.IdentityContentNested<N>,Nested<N>{
    IdentityContentNestedImpl(Identity item) {
      this.builder = new IdentityBuilder(this, item);
    }
    IdentityContentNestedImpl() {
      this.builder = new IdentityBuilder(this);
    }
    IdentityBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endIdentityContent() {
      return and();
    }
    
  }
  class RangeAllocationListContentNestedImpl<N> extends RangeAllocationListFluentImpl<LocalResourceAccessReviewFluent.RangeAllocationListContentNested<N>> implements LocalResourceAccessReviewFluent.RangeAllocationListContentNested<N>,Nested<N>{
    RangeAllocationListContentNestedImpl(RangeAllocationList item) {
      this.builder = new RangeAllocationListBuilder(this, item);
    }
    RangeAllocationListContentNestedImpl() {
      this.builder = new RangeAllocationListBuilder(this);
    }
    RangeAllocationListBuilder builder;
    public N and() {
      return (N) LocalResourceAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRangeAllocationListContent() {
      return and();
    }
    
  }
  
}