package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageChangeCauseBuilder extends ImageChangeCauseFluentImpl<ImageChangeCauseBuilder> implements VisitableBuilder<ImageChangeCause,ImageChangeCauseBuilder>{
  public ImageChangeCauseBuilder() {
    this(false);
  }
  public ImageChangeCauseBuilder(Boolean validationEnabled) {
    this(new ImageChangeCause(), validationEnabled);
  }
  public ImageChangeCauseBuilder(ImageChangeCauseFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageChangeCauseBuilder(ImageChangeCauseFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageChangeCause(), validationEnabled);
  }
  public ImageChangeCauseBuilder(ImageChangeCauseFluent<?> fluent,ImageChangeCause instance) {
    this(fluent, instance, false);
  }
  public ImageChangeCauseBuilder(ImageChangeCauseFluent<?> fluent,ImageChangeCause instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFromRef(instance.getFromRef()); 
    fluent.withImageID(instance.getImageID()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageChangeCauseBuilder(ImageChangeCause instance) {
    this(instance,false);
  }
  public ImageChangeCauseBuilder(ImageChangeCause instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withFromRef(instance.getFromRef()); 
    this.withImageID(instance.getImageID()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ImageChangeCauseFluent<?> fluent;
  Boolean validationEnabled;
  public ImageChangeCause build() {
    ImageChangeCause buildable = new ImageChangeCause(fluent.getFromRef(),fluent.getImageID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}