package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface GroupFluent<A extends GroupFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public GroupFluent.MetadataNested<A> withNewMetadata();
  public GroupFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public GroupFluent.MetadataNested<A> editMetadata();
  public GroupFluent.MetadataNested<A> editOrNewMetadata();
  public GroupFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  public A addToUsers(Integer index,String item);
  public A setToUsers(Integer index,String item);
  public A addToUsers(java.lang.String... items);
  public A addAllToUsers(Collection<String> items);
  public A removeFromUsers(java.lang.String... items);
  public A removeAllFromUsers(Collection<String> items);
  public List<String> getUsers();
  public String getUser(Integer index);
  public String getFirstUser();
  public String getLastUser();
  public String getMatchingUser(Predicate<String> predicate);
  public Boolean hasMatchingUser(Predicate<String> predicate);
  public A withUsers(List<String> users);
  public A withUsers(java.lang.String... users);
  public Boolean hasUsers();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<GroupFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  
}