package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface CustomBuildStrategyFluent<A extends CustomBuildStrategyFluent<A>> extends Fluent<A>{
  public String getBuildAPIVersion();
  public A withBuildAPIVersion(String buildAPIVersion);
  public Boolean hasBuildAPIVersion();
  public A addToEnv(Integer index,EnvVar item);
  public A setToEnv(Integer index,EnvVar item);
  public A addToEnv(io.fabric8.kubernetes.api.model.EnvVar... items);
  public A addAllToEnv(Collection<EnvVar> items);
  public A removeFromEnv(io.fabric8.kubernetes.api.model.EnvVar... items);
  public A removeAllFromEnv(Collection<EnvVar> items);
  public List<EnvVar> getEnv();
  public EnvVar getEnv(Integer index);
  public EnvVar getFirstEnv();
  public EnvVar getLastEnv();
  public EnvVar getMatchingEnv(Predicate<EnvVar> predicate);
  public Boolean hasMatchingEnv(Predicate<EnvVar> predicate);
  public A withEnv(List<EnvVar> env);
  public A withEnv(io.fabric8.kubernetes.api.model.EnvVar... env);
  public Boolean hasEnv();
  public Boolean getExposeDockerSocket();
  public A withExposeDockerSocket(Boolean exposeDockerSocket);
  public Boolean hasExposeDockerSocket();
  public Boolean getForcePull();
  public A withForcePull(Boolean forcePull);
  public Boolean hasForcePull();
  
  /**
   * This method has been deprecated, please use method buildFrom instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getFrom();
  public ObjectReference buildFrom();
  public A withFrom(ObjectReference from);
  public Boolean hasFrom();
  public CustomBuildStrategyFluent.FromNested<A> withNewFrom();
  public CustomBuildStrategyFluent.FromNested<A> withNewFromLike(ObjectReference item);
  public CustomBuildStrategyFluent.FromNested<A> editFrom();
  public CustomBuildStrategyFluent.FromNested<A> editOrNewFrom();
  public CustomBuildStrategyFluent.FromNested<A> editOrNewFromLike(ObjectReference item);
  
  /**
   * This method has been deprecated, please use method buildPullSecret instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getPullSecret();
  public LocalObjectReference buildPullSecret();
  public A withPullSecret(LocalObjectReference pullSecret);
  public Boolean hasPullSecret();
  public A withNewPullSecret(String name);
  public CustomBuildStrategyFluent.PullSecretNested<A> withNewPullSecret();
  public CustomBuildStrategyFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item);
  public CustomBuildStrategyFluent.PullSecretNested<A> editPullSecret();
  public CustomBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecret();
  public CustomBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item);
  public A addToSecrets(Integer index,SecretSpec item);
  public A setToSecrets(Integer index,SecretSpec item);
  public A addToSecrets(io.fabric8.openshift.api.model.SecretSpec... items);
  public A addAllToSecrets(Collection<SecretSpec> items);
  public A removeFromSecrets(io.fabric8.openshift.api.model.SecretSpec... items);
  public A removeAllFromSecrets(Collection<SecretSpec> items);
  public A removeMatchingFromSecrets(Predicate<SecretSpecBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildSecrets instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<SecretSpec> getSecrets();
  public List<SecretSpec> buildSecrets();
  public SecretSpec buildSecret(Integer index);
  public SecretSpec buildFirstSecret();
  public SecretSpec buildLastSecret();
  public SecretSpec buildMatchingSecret(Predicate<SecretSpecBuilder> predicate);
  public Boolean hasMatchingSecret(Predicate<SecretSpecBuilder> predicate);
  public A withSecrets(List<SecretSpec> secrets);
  public A withSecrets(io.fabric8.openshift.api.model.SecretSpec... secrets);
  public Boolean hasSecrets();
  public CustomBuildStrategyFluent.SecretsNested<A> addNewSecret();
  public CustomBuildStrategyFluent.SecretsNested<A> addNewSecretLike(SecretSpec item);
  public CustomBuildStrategyFluent.SecretsNested<A> setNewSecretLike(Integer index,SecretSpec item);
  public CustomBuildStrategyFluent.SecretsNested<A> editSecret(Integer index);
  public CustomBuildStrategyFluent.SecretsNested<A> editFirstSecret();
  public CustomBuildStrategyFluent.SecretsNested<A> editLastSecret();
  public CustomBuildStrategyFluent.SecretsNested<A> editMatchingSecret(Predicate<SecretSpecBuilder> predicate);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withExposeDockerSocket();
  public A withForcePull();
  public interface FromNested<N> extends Nested<N>,ObjectReferenceFluent<CustomBuildStrategyFluent.FromNested<N>>{
    public N and();
    public N endFrom();
    
  }
  public interface PullSecretNested<N> extends Nested<N>,LocalObjectReferenceFluent<CustomBuildStrategyFluent.PullSecretNested<N>>{
    public N and();
    public N endPullSecret();
    
  }
  public interface SecretsNested<N> extends Nested<N>,SecretSpecFluent<CustomBuildStrategyFluent.SecretsNested<N>>{
    public N and();
    public N endSecret();
    
  }
  
}