package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildTriggerCauseBuilder extends BuildTriggerCauseFluentImpl<BuildTriggerCauseBuilder> implements VisitableBuilder<BuildTriggerCause,BuildTriggerCauseBuilder>{
  public BuildTriggerCauseBuilder() {
    this(false);
  }
  public BuildTriggerCauseBuilder(Boolean validationEnabled) {
    this(new BuildTriggerCause(), validationEnabled);
  }
  public BuildTriggerCauseBuilder(BuildTriggerCauseFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildTriggerCauseBuilder(BuildTriggerCauseFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BuildTriggerCause(), validationEnabled);
  }
  public BuildTriggerCauseBuilder(BuildTriggerCauseFluent<?> fluent,BuildTriggerCause instance) {
    this(fluent, instance, false);
  }
  public BuildTriggerCauseBuilder(BuildTriggerCauseFluent<?> fluent,BuildTriggerCause instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBitbucketWebHook(instance.getBitbucketWebHook()); 
    fluent.withGenericWebHook(instance.getGenericWebHook()); 
    fluent.withGithubWebHook(instance.getGithubWebHook()); 
    fluent.withGitlabWebHook(instance.getGitlabWebHook()); 
    fluent.withImageChangeBuild(instance.getImageChangeBuild()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BuildTriggerCauseBuilder(BuildTriggerCause instance) {
    this(instance,false);
  }
  public BuildTriggerCauseBuilder(BuildTriggerCause instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withBitbucketWebHook(instance.getBitbucketWebHook()); 
    this.withGenericWebHook(instance.getGenericWebHook()); 
    this.withGithubWebHook(instance.getGithubWebHook()); 
    this.withGitlabWebHook(instance.getGitlabWebHook()); 
    this.withImageChangeBuild(instance.getImageChangeBuild()); 
    this.withMessage(instance.getMessage()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  BuildTriggerCauseFluent<?> fluent;
  Boolean validationEnabled;
  public BuildTriggerCause build() {
    BuildTriggerCause buildable = new BuildTriggerCause(fluent.getBitbucketWebHook(),fluent.getGenericWebHook(),fluent.getGithubWebHook(),fluent.getGitlabWebHook(),fluent.getImageChangeBuild(),fluent.getMessage());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}