package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class BrokerTemplateInstanceSpecFluentImpl<A extends BrokerTemplateInstanceSpecFluent<A>> extends BaseFluent<A> implements BrokerTemplateInstanceSpecFluent<A>{
  public BrokerTemplateInstanceSpecFluentImpl() {
  }
  public BrokerTemplateInstanceSpecFluentImpl(BrokerTemplateInstanceSpec instance) {
    this.withBindingIDs(instance.getBindingIDs()); 
    this.withSecret(instance.getSecret()); 
    this.withTemplateInstance(instance.getTemplateInstance()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> bindingIDs = new ArrayList<String>();
  private ObjectReferenceBuilder secret;
  private ObjectReferenceBuilder templateInstance;
  private Map<String,Object> additionalProperties;
  public A addToBindingIDs(Integer index,String item) {
    if (this.bindingIDs == null) {this.bindingIDs = new ArrayList<String>();}
    this.bindingIDs.add(index, item);
    return (A)this;
  }
  public A setToBindingIDs(Integer index,String item) {
    if (this.bindingIDs == null) {this.bindingIDs = new ArrayList<String>();}
    this.bindingIDs.set(index, item); return (A)this;
  }
  public A addToBindingIDs(java.lang.String... items) {
    if (this.bindingIDs == null) {this.bindingIDs = new ArrayList<String>();}
    for (String item : items) {this.bindingIDs.add(item);} return (A)this;
  }
  public A addAllToBindingIDs(Collection<String> items) {
    if (this.bindingIDs == null) {this.bindingIDs = new ArrayList<String>();}
    for (String item : items) {this.bindingIDs.add(item);} return (A)this;
  }
  public A removeFromBindingIDs(java.lang.String... items) {
    for (String item : items) {if (this.bindingIDs!= null){ this.bindingIDs.remove(item);}} return (A)this;
  }
  public A removeAllFromBindingIDs(Collection<String> items) {
    for (String item : items) {if (this.bindingIDs!= null){ this.bindingIDs.remove(item);}} return (A)this;
  }
  public List<String> getBindingIDs() {
    return this.bindingIDs;
  }
  public String getBindingID(Integer index) {
    return this.bindingIDs.get(index);
  }
  public String getFirstBindingID() {
    return this.bindingIDs.get(0);
  }
  public String getLastBindingID() {
    return this.bindingIDs.get(bindingIDs.size() - 1);
  }
  public String getMatchingBindingID(Predicate<String> predicate) {
    for (String item: bindingIDs) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingBindingID(Predicate<String> predicate) {
    for (String item: bindingIDs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withBindingIDs(List<String> bindingIDs) {
    if (bindingIDs != null) {this.bindingIDs = new ArrayList(); for (String item : bindingIDs){this.addToBindingIDs(item);}} else { this.bindingIDs = null;} return (A) this;
  }
  public A withBindingIDs(java.lang.String... bindingIDs) {
    if (this.bindingIDs != null) {this.bindingIDs.clear();}
    if (bindingIDs != null) {for (String item :bindingIDs){ this.addToBindingIDs(item);}} return (A) this;
  }
  public Boolean hasBindingIDs() {
    return bindingIDs != null && !bindingIDs.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildSecret instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getSecret() {
    return this.secret!=null ?this.secret.build():null;
  }
  public ObjectReference buildSecret() {
    return this.secret!=null ?this.secret.build():null;
  }
  public A withSecret(ObjectReference secret) {
    _visitables.get("secret").remove(this.secret);
    if (secret!=null){ this.secret= new ObjectReferenceBuilder(secret); _visitables.get("secret").add(this.secret);} else { this.secret = null; _visitables.get("secret").remove(this.secret); } return (A) this;
  }
  public Boolean hasSecret() {
    return this.secret != null;
  }
  public BrokerTemplateInstanceSpecFluent.SecretNested<A> withNewSecret() {
    return new BrokerTemplateInstanceSpecFluentImpl.SecretNestedImpl();
  }
  public BrokerTemplateInstanceSpecFluent.SecretNested<A> withNewSecretLike(ObjectReference item) {
    return new BrokerTemplateInstanceSpecFluentImpl.SecretNestedImpl(item);
  }
  public BrokerTemplateInstanceSpecFluent.SecretNested<A> editSecret() {
    return withNewSecretLike(getSecret());
  }
  public BrokerTemplateInstanceSpecFluent.SecretNested<A> editOrNewSecret() {
    return withNewSecretLike(getSecret() != null ? getSecret(): new ObjectReferenceBuilder().build());
  }
  public BrokerTemplateInstanceSpecFluent.SecretNested<A> editOrNewSecretLike(ObjectReference item) {
    return withNewSecretLike(getSecret() != null ? getSecret(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTemplateInstance instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getTemplateInstance() {
    return this.templateInstance!=null ?this.templateInstance.build():null;
  }
  public ObjectReference buildTemplateInstance() {
    return this.templateInstance!=null ?this.templateInstance.build():null;
  }
  public A withTemplateInstance(ObjectReference templateInstance) {
    _visitables.get("templateInstance").remove(this.templateInstance);
    if (templateInstance!=null){ this.templateInstance= new ObjectReferenceBuilder(templateInstance); _visitables.get("templateInstance").add(this.templateInstance);} else { this.templateInstance = null; _visitables.get("templateInstance").remove(this.templateInstance); } return (A) this;
  }
  public Boolean hasTemplateInstance() {
    return this.templateInstance != null;
  }
  public BrokerTemplateInstanceSpecFluent.TemplateInstanceNested<A> withNewTemplateInstance() {
    return new BrokerTemplateInstanceSpecFluentImpl.TemplateInstanceNestedImpl();
  }
  public BrokerTemplateInstanceSpecFluent.TemplateInstanceNested<A> withNewTemplateInstanceLike(ObjectReference item) {
    return new BrokerTemplateInstanceSpecFluentImpl.TemplateInstanceNestedImpl(item);
  }
  public BrokerTemplateInstanceSpecFluent.TemplateInstanceNested<A> editTemplateInstance() {
    return withNewTemplateInstanceLike(getTemplateInstance());
  }
  public BrokerTemplateInstanceSpecFluent.TemplateInstanceNested<A> editOrNewTemplateInstance() {
    return withNewTemplateInstanceLike(getTemplateInstance() != null ? getTemplateInstance(): new ObjectReferenceBuilder().build());
  }
  public BrokerTemplateInstanceSpecFluent.TemplateInstanceNested<A> editOrNewTemplateInstanceLike(ObjectReference item) {
    return withNewTemplateInstanceLike(getTemplateInstance() != null ? getTemplateInstance(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BrokerTemplateInstanceSpecFluentImpl that = (BrokerTemplateInstanceSpecFluentImpl) o;
    if (bindingIDs != null ? !bindingIDs.equals(that.bindingIDs) :that.bindingIDs != null) return false;
    if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
    if (templateInstance != null ? !templateInstance.equals(that.templateInstance) :that.templateInstance != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(bindingIDs,  secret,  templateInstance,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bindingIDs != null && !bindingIDs.isEmpty()) { sb.append("bindingIDs:"); sb.append(bindingIDs + ","); }
    if (secret != null) { sb.append("secret:"); sb.append(secret + ","); }
    if (templateInstance != null) { sb.append("templateInstance:"); sb.append(templateInstance + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class SecretNestedImpl<N> extends ObjectReferenceFluentImpl<BrokerTemplateInstanceSpecFluent.SecretNested<N>> implements BrokerTemplateInstanceSpecFluent.SecretNested<N>,Nested<N>{
    SecretNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    SecretNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) BrokerTemplateInstanceSpecFluentImpl.this.withSecret(builder.build());
    }
    public N endSecret() {
      return and();
    }
    
  }
  class TemplateInstanceNestedImpl<N> extends ObjectReferenceFluentImpl<BrokerTemplateInstanceSpecFluent.TemplateInstanceNested<N>> implements BrokerTemplateInstanceSpecFluent.TemplateInstanceNested<N>,Nested<N>{
    TemplateInstanceNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    TemplateInstanceNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) BrokerTemplateInstanceSpecFluentImpl.this.withTemplateInstance(builder.build());
    }
    public N endTemplateInstance() {
      return and();
    }
    
  }
  
}