/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.HostSubnet;
import io.fabric8.openshift.api.model.HostSubnetFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class HostSubnetFluentImpl<A extends HostSubnetFluent<A>>
extends BaseFluent<A>
implements HostSubnetFluent<A> {
    private String apiVersion;
    private List<String> egressCIDRs = new ArrayList<String>();
    private List<String> egressIPs = new ArrayList<String>();
    private String host;
    private String hostIP;
    private String kind;
    private ObjectMetaBuilder metadata;
    private String subnet;

    public HostSubnetFluentImpl() {
    }

    public HostSubnetFluentImpl(HostSubnet instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withEgressCIDRs(instance.getEgressCIDRs());
        this.withEgressIPs(instance.getEgressIPs());
        this.withHost(instance.getHost());
        this.withHostIP(instance.getHostIP());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSubnet(instance.getSubnet());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public A addToEgressCIDRs(Integer index, String item) {
        if (this.egressCIDRs == null) {
            this.egressCIDRs = new ArrayList<String>();
        }
        this.egressCIDRs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToEgressCIDRs(Integer index, String item) {
        if (this.egressCIDRs == null) {
            this.egressCIDRs = new ArrayList<String>();
        }
        this.egressCIDRs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToEgressCIDRs(String ... items) {
        if (this.egressCIDRs == null) {
            this.egressCIDRs = new ArrayList<String>();
        }
        for (String item : items) {
            this.egressCIDRs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToEgressCIDRs(Collection<String> items) {
        if (this.egressCIDRs == null) {
            this.egressCIDRs = new ArrayList<String>();
        }
        for (String item : items) {
            this.egressCIDRs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromEgressCIDRs(String ... items) {
        for (String item : items) {
            if (this.egressCIDRs == null) continue;
            this.egressCIDRs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEgressCIDRs(Collection<String> items) {
        for (String item : items) {
            if (this.egressCIDRs == null) continue;
            this.egressCIDRs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getEgressCIDRs() {
        return this.egressCIDRs;
    }

    @Override
    public String getEgressCIDR(Integer index) {
        return this.egressCIDRs.get(index);
    }

    @Override
    public String getFirstEgressCIDR() {
        return this.egressCIDRs.get(0);
    }

    @Override
    public String getLastEgressCIDR() {
        return this.egressCIDRs.get(this.egressCIDRs.size() - 1);
    }

    @Override
    public String getMatchingEgressCIDR(Predicate<String> predicate) {
        for (String item : this.egressCIDRs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEgressCIDR(Predicate<String> predicate) {
        for (String item : this.egressCIDRs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEgressCIDRs(List<String> egressCIDRs) {
        if (egressCIDRs != null) {
            this.egressCIDRs = new ArrayList<String>();
            for (String item : egressCIDRs) {
                this.addToEgressCIDRs(item);
            }
        } else {
            this.egressCIDRs = null;
        }
        return (A)this;
    }

    @Override
    public A withEgressCIDRs(String ... egressCIDRs) {
        if (this.egressCIDRs != null) {
            this.egressCIDRs.clear();
        }
        if (egressCIDRs != null) {
            for (String item : egressCIDRs) {
                this.addToEgressCIDRs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEgressCIDRs() {
        return this.egressCIDRs != null && !this.egressCIDRs.isEmpty();
    }

    @Override
    public A addNewEgressCIDR(String arg0) {
        return this.addToEgressCIDRs(new String(arg0));
    }

    @Override
    public A addToEgressIPs(Integer index, String item) {
        if (this.egressIPs == null) {
            this.egressIPs = new ArrayList<String>();
        }
        this.egressIPs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToEgressIPs(Integer index, String item) {
        if (this.egressIPs == null) {
            this.egressIPs = new ArrayList<String>();
        }
        this.egressIPs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToEgressIPs(String ... items) {
        if (this.egressIPs == null) {
            this.egressIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.egressIPs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToEgressIPs(Collection<String> items) {
        if (this.egressIPs == null) {
            this.egressIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.egressIPs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromEgressIPs(String ... items) {
        for (String item : items) {
            if (this.egressIPs == null) continue;
            this.egressIPs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEgressIPs(Collection<String> items) {
        for (String item : items) {
            if (this.egressIPs == null) continue;
            this.egressIPs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getEgressIPs() {
        return this.egressIPs;
    }

    @Override
    public String getEgressIP(Integer index) {
        return this.egressIPs.get(index);
    }

    @Override
    public String getFirstEgressIP() {
        return this.egressIPs.get(0);
    }

    @Override
    public String getLastEgressIP() {
        return this.egressIPs.get(this.egressIPs.size() - 1);
    }

    @Override
    public String getMatchingEgressIP(Predicate<String> predicate) {
        for (String item : this.egressIPs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEgressIP(Predicate<String> predicate) {
        for (String item : this.egressIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEgressIPs(List<String> egressIPs) {
        if (egressIPs != null) {
            this.egressIPs = new ArrayList<String>();
            for (String item : egressIPs) {
                this.addToEgressIPs(item);
            }
        } else {
            this.egressIPs = null;
        }
        return (A)this;
    }

    @Override
    public A withEgressIPs(String ... egressIPs) {
        if (this.egressIPs != null) {
            this.egressIPs.clear();
        }
        if (egressIPs != null) {
            for (String item : egressIPs) {
                this.addToEgressIPs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEgressIPs() {
        return this.egressIPs != null && !this.egressIPs.isEmpty();
    }

    @Override
    public A addNewEgressIP(String arg0) {
        return this.addToEgressIPs(new String(arg0));
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    @Override
    public Boolean hasHost() {
        return this.host != null;
    }

    @Override
    @Deprecated
    public A withNewHost(String arg0) {
        return this.withHost(new String(arg0));
    }

    @Override
    public String getHostIP() {
        return this.hostIP;
    }

    @Override
    public A withHostIP(String hostIP) {
        this.hostIP = hostIP;
        return (A)this;
    }

    @Override
    public Boolean hasHostIP() {
        return this.hostIP != null;
    }

    @Override
    @Deprecated
    public A withNewHostIP(String arg0) {
        return this.withHostIP(new String(arg0));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public HostSubnetFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public HostSubnetFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public HostSubnetFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public HostSubnetFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public HostSubnetFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public String getSubnet() {
        return this.subnet;
    }

    @Override
    public A withSubnet(String subnet) {
        this.subnet = subnet;
        return (A)this;
    }

    @Override
    public Boolean hasSubnet() {
        return this.subnet != null;
    }

    @Override
    @Deprecated
    public A withNewSubnet(String arg0) {
        return this.withSubnet(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostSubnetFluentImpl that = (HostSubnetFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.egressCIDRs != null ? !this.egressCIDRs.equals(that.egressCIDRs) : that.egressCIDRs != null) {
            return false;
        }
        if (this.egressIPs != null ? !this.egressIPs.equals(that.egressIPs) : that.egressIPs != null) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.hostIP != null ? !this.hostIP.equals(that.hostIP) : that.hostIP != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.subnet != null ? !this.subnet.equals(that.subnet) : that.subnet != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.egressCIDRs, this.egressIPs, this.host, this.hostIP, this.kind, this.metadata, this.subnet, super.hashCode());
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<HostSubnetFluent.MetadataNested<N>>
    implements HostSubnetFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this);
        }

        @Override
        public N and() {
            return (N)HostSubnetFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

