/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.ConfigMapFileReference;
import io.fabric8.openshift.api.model.ConfigMapFileReferenceBuilder;
import io.fabric8.openshift.api.model.ConfigMapFileReferenceFluentImpl;
import io.fabric8.openshift.api.model.InfrastructureSpec;
import io.fabric8.openshift.api.model.InfrastructureSpecFluent;
import io.fabric8.openshift.api.model.PlatformSpec;
import io.fabric8.openshift.api.model.PlatformSpecBuilder;
import io.fabric8.openshift.api.model.PlatformSpecFluentImpl;
import java.util.Objects;

public class InfrastructureSpecFluentImpl<A extends InfrastructureSpecFluent<A>>
extends BaseFluent<A>
implements InfrastructureSpecFluent<A> {
    private ConfigMapFileReferenceBuilder cloudConfig;
    private PlatformSpecBuilder platformSpec;

    public InfrastructureSpecFluentImpl() {
    }

    public InfrastructureSpecFluentImpl(InfrastructureSpec instance) {
        this.withCloudConfig(instance.getCloudConfig());
        this.withPlatformSpec(instance.getPlatformSpec());
    }

    @Override
    @Deprecated
    public ConfigMapFileReference getCloudConfig() {
        return this.cloudConfig != null ? this.cloudConfig.build() : null;
    }

    @Override
    public ConfigMapFileReference buildCloudConfig() {
        return this.cloudConfig != null ? this.cloudConfig.build() : null;
    }

    @Override
    public A withCloudConfig(ConfigMapFileReference cloudConfig) {
        this._visitables.get((Object)"cloudConfig").remove(this.cloudConfig);
        if (cloudConfig != null) {
            this.cloudConfig = new ConfigMapFileReferenceBuilder(cloudConfig);
            this._visitables.get((Object)"cloudConfig").add(this.cloudConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCloudConfig() {
        return this.cloudConfig != null;
    }

    @Override
    public A withNewCloudConfig(String key, String name) {
        return this.withCloudConfig(new ConfigMapFileReference(key, name));
    }

    @Override
    public InfrastructureSpecFluent.CloudConfigNested<A> withNewCloudConfig() {
        return new CloudConfigNestedImpl();
    }

    @Override
    public InfrastructureSpecFluent.CloudConfigNested<A> withNewCloudConfigLike(ConfigMapFileReference item) {
        return new CloudConfigNestedImpl(item);
    }

    @Override
    public InfrastructureSpecFluent.CloudConfigNested<A> editCloudConfig() {
        return this.withNewCloudConfigLike(this.getCloudConfig());
    }

    @Override
    public InfrastructureSpecFluent.CloudConfigNested<A> editOrNewCloudConfig() {
        return this.withNewCloudConfigLike(this.getCloudConfig() != null ? this.getCloudConfig() : new ConfigMapFileReferenceBuilder().build());
    }

    @Override
    public InfrastructureSpecFluent.CloudConfigNested<A> editOrNewCloudConfigLike(ConfigMapFileReference item) {
        return this.withNewCloudConfigLike(this.getCloudConfig() != null ? this.getCloudConfig() : item);
    }

    @Override
    @Deprecated
    public PlatformSpec getPlatformSpec() {
        return this.platformSpec != null ? this.platformSpec.build() : null;
    }

    @Override
    public PlatformSpec buildPlatformSpec() {
        return this.platformSpec != null ? this.platformSpec.build() : null;
    }

    @Override
    public A withPlatformSpec(PlatformSpec platformSpec) {
        this._visitables.get((Object)"platformSpec").remove(this.platformSpec);
        if (platformSpec != null) {
            this.platformSpec = new PlatformSpecBuilder(platformSpec);
            this._visitables.get((Object)"platformSpec").add(this.platformSpec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPlatformSpec() {
        return this.platformSpec != null;
    }

    @Override
    public InfrastructureSpecFluent.PlatformSpecNested<A> withNewPlatformSpec() {
        return new PlatformSpecNestedImpl();
    }

    @Override
    public InfrastructureSpecFluent.PlatformSpecNested<A> withNewPlatformSpecLike(PlatformSpec item) {
        return new PlatformSpecNestedImpl(item);
    }

    @Override
    public InfrastructureSpecFluent.PlatformSpecNested<A> editPlatformSpec() {
        return this.withNewPlatformSpecLike(this.getPlatformSpec());
    }

    @Override
    public InfrastructureSpecFluent.PlatformSpecNested<A> editOrNewPlatformSpec() {
        return this.withNewPlatformSpecLike(this.getPlatformSpec() != null ? this.getPlatformSpec() : new PlatformSpecBuilder().build());
    }

    @Override
    public InfrastructureSpecFluent.PlatformSpecNested<A> editOrNewPlatformSpecLike(PlatformSpec item) {
        return this.withNewPlatformSpecLike(this.getPlatformSpec() != null ? this.getPlatformSpec() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InfrastructureSpecFluentImpl that = (InfrastructureSpecFluentImpl)o;
        if (this.cloudConfig != null ? !this.cloudConfig.equals(that.cloudConfig) : that.cloudConfig != null) {
            return false;
        }
        return !(this.platformSpec != null ? !this.platformSpec.equals(that.platformSpec) : that.platformSpec != null);
    }

    public int hashCode() {
        return Objects.hash(this.cloudConfig, this.platformSpec, super.hashCode());
    }

    public class PlatformSpecNestedImpl<N>
    extends PlatformSpecFluentImpl<InfrastructureSpecFluent.PlatformSpecNested<N>>
    implements InfrastructureSpecFluent.PlatformSpecNested<N>,
    Nested<N> {
        private final PlatformSpecBuilder builder;

        PlatformSpecNestedImpl(PlatformSpec item) {
            this.builder = new PlatformSpecBuilder(this, item);
        }

        PlatformSpecNestedImpl() {
            this.builder = new PlatformSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)InfrastructureSpecFluentImpl.this.withPlatformSpec(this.builder.build());
        }

        @Override
        public N endPlatformSpec() {
            return this.and();
        }
    }

    public class CloudConfigNestedImpl<N>
    extends ConfigMapFileReferenceFluentImpl<InfrastructureSpecFluent.CloudConfigNested<N>>
    implements InfrastructureSpecFluent.CloudConfigNested<N>,
    Nested<N> {
        private final ConfigMapFileReferenceBuilder builder;

        CloudConfigNestedImpl(ConfigMapFileReference item) {
            this.builder = new ConfigMapFileReferenceBuilder(this, item);
        }

        CloudConfigNestedImpl() {
            this.builder = new ConfigMapFileReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)InfrastructureSpecFluentImpl.this.withCloudConfig(this.builder.build());
        }

        @Override
        public N endCloudConfig() {
            return this.and();
        }
    }
}

