/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.OAuthClientFluent;
import io.fabric8.openshift.api.model.ScopeRestriction;
import io.fabric8.openshift.api.model.ScopeRestrictionBuilder;
import io.fabric8.openshift.api.model.ScopeRestrictionFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class OAuthClientFluentImpl<A extends OAuthClientFluent<A>>
extends BaseFluent<A>
implements OAuthClientFluent<A> {
    private Integer accessTokenInactivityTimeoutSeconds;
    private Integer accessTokenMaxAgeSeconds;
    private List<String> additionalSecrets = new ArrayList<String>();
    private String apiVersion;
    private String grantMethod;
    private String kind;
    private ObjectMetaBuilder metadata;
    private List<String> redirectURIs = new ArrayList<String>();
    private Boolean respondWithChallenges;
    private List<ScopeRestrictionBuilder> scopeRestrictions = new ArrayList<ScopeRestrictionBuilder>();
    private String secret;

    public OAuthClientFluentImpl() {
    }

    public OAuthClientFluentImpl(OAuthClient instance) {
        this.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds());
        this.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds());
        this.withAdditionalSecrets(instance.getAdditionalSecrets());
        this.withApiVersion(instance.getApiVersion());
        this.withGrantMethod(instance.getGrantMethod());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRedirectURIs(instance.getRedirectURIs());
        this.withRespondWithChallenges(instance.getRespondWithChallenges());
        this.withScopeRestrictions(instance.getScopeRestrictions());
        this.withSecret(instance.getSecret());
    }

    @Override
    public Integer getAccessTokenInactivityTimeoutSeconds() {
        return this.accessTokenInactivityTimeoutSeconds;
    }

    @Override
    public A withAccessTokenInactivityTimeoutSeconds(Integer accessTokenInactivityTimeoutSeconds) {
        this.accessTokenInactivityTimeoutSeconds = accessTokenInactivityTimeoutSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasAccessTokenInactivityTimeoutSeconds() {
        return this.accessTokenInactivityTimeoutSeconds != null;
    }

    @Override
    public A withNewAccessTokenInactivityTimeoutSeconds(int arg0) {
        return this.withAccessTokenInactivityTimeoutSeconds(new Integer(arg0));
    }

    @Override
    public Integer getAccessTokenMaxAgeSeconds() {
        return this.accessTokenMaxAgeSeconds;
    }

    @Override
    public A withAccessTokenMaxAgeSeconds(Integer accessTokenMaxAgeSeconds) {
        this.accessTokenMaxAgeSeconds = accessTokenMaxAgeSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasAccessTokenMaxAgeSeconds() {
        return this.accessTokenMaxAgeSeconds != null;
    }

    @Override
    public A withNewAccessTokenMaxAgeSeconds(int arg0) {
        return this.withAccessTokenMaxAgeSeconds(new Integer(arg0));
    }

    @Override
    public A addToAdditionalSecrets(int index, String item) {
        if (this.additionalSecrets == null) {
            this.additionalSecrets = new ArrayList<String>();
        }
        this.additionalSecrets.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAdditionalSecrets(int index, String item) {
        if (this.additionalSecrets == null) {
            this.additionalSecrets = new ArrayList<String>();
        }
        this.additionalSecrets.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAdditionalSecrets(String ... items) {
        if (this.additionalSecrets == null) {
            this.additionalSecrets = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalSecrets.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAdditionalSecrets(Collection<String> items) {
        if (this.additionalSecrets == null) {
            this.additionalSecrets = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalSecrets.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalSecrets(String ... items) {
        for (String item : items) {
            if (this.additionalSecrets == null) continue;
            this.additionalSecrets.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAdditionalSecrets(Collection<String> items) {
        for (String item : items) {
            if (this.additionalSecrets == null) continue;
            this.additionalSecrets.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAdditionalSecrets() {
        return this.additionalSecrets;
    }

    @Override
    public String getAdditionalSecret(int index) {
        return this.additionalSecrets.get(index);
    }

    @Override
    public String getFirstAdditionalSecret() {
        return this.additionalSecrets.get(0);
    }

    @Override
    public String getLastAdditionalSecret() {
        return this.additionalSecrets.get(this.additionalSecrets.size() - 1);
    }

    @Override
    public String getMatchingAdditionalSecret(Predicate<String> predicate) {
        for (String item : this.additionalSecrets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAdditionalSecret(Predicate<String> predicate) {
        for (String item : this.additionalSecrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAdditionalSecrets(List<String> additionalSecrets) {
        if (this.additionalSecrets != null) {
            this._visitables.get((Object)"additionalSecrets").removeAll(this.additionalSecrets);
        }
        if (additionalSecrets != null) {
            this.additionalSecrets = new ArrayList<String>();
            for (String item : additionalSecrets) {
                this.addToAdditionalSecrets(item);
            }
        } else {
            this.additionalSecrets = null;
        }
        return (A)this;
    }

    @Override
    public A withAdditionalSecrets(String ... additionalSecrets) {
        if (this.additionalSecrets != null) {
            this.additionalSecrets.clear();
        }
        if (additionalSecrets != null) {
            for (String item : additionalSecrets) {
                this.addToAdditionalSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalSecrets() {
        return this.additionalSecrets != null && !this.additionalSecrets.isEmpty();
    }

    @Override
    public A addNewAdditionalSecret(StringBuilder arg1) {
        return this.addToAdditionalSecrets(new String(arg1));
    }

    @Override
    public A addNewAdditionalSecret(int[] arg1, int arg2, int arg3) {
        return this.addToAdditionalSecrets(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewAdditionalSecret(char[] arg1) {
        return this.addToAdditionalSecrets(new String(arg1));
    }

    @Override
    public A addNewAdditionalSecret(StringBuffer arg1) {
        return this.addToAdditionalSecrets(new String(arg1));
    }

    @Override
    public A addNewAdditionalSecret(byte[] arg1, int arg2) {
        return this.addToAdditionalSecrets(new String(arg1, arg2));
    }

    @Override
    public A addNewAdditionalSecret(byte[] arg1) {
        return this.addToAdditionalSecrets(new String(arg1));
    }

    @Override
    public A addNewAdditionalSecret(char[] arg1, int arg2, int arg3) {
        return this.addToAdditionalSecrets(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewAdditionalSecret(byte[] arg1, int arg2, int arg3) {
        return this.addToAdditionalSecrets(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewAdditionalSecret(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.addToAdditionalSecrets(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A addNewAdditionalSecret(String arg1) {
        return this.addToAdditionalSecrets(new String(arg1));
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(int[] arg1, int arg2, int arg3) {
        return this.withApiVersion(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewApiVersion(char[] arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(byte[] arg1, int arg2) {
        return this.withApiVersion(new String(arg1, arg2));
    }

    @Override
    public A withNewApiVersion(byte[] arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(char[] arg1, int arg2, int arg3) {
        return this.withApiVersion(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewApiVersion(byte[] arg1, int arg2, int arg3) {
        return this.withApiVersion(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewApiVersion(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.withApiVersion(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public String getGrantMethod() {
        return this.grantMethod;
    }

    @Override
    public A withGrantMethod(String grantMethod) {
        this.grantMethod = grantMethod;
        return (A)this;
    }

    @Override
    public Boolean hasGrantMethod() {
        return this.grantMethod != null;
    }

    @Override
    public A withNewGrantMethod(StringBuilder arg1) {
        return this.withGrantMethod(new String(arg1));
    }

    @Override
    public A withNewGrantMethod(int[] arg1, int arg2, int arg3) {
        return this.withGrantMethod(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewGrantMethod(char[] arg1) {
        return this.withGrantMethod(new String(arg1));
    }

    @Override
    public A withNewGrantMethod(StringBuffer arg1) {
        return this.withGrantMethod(new String(arg1));
    }

    @Override
    public A withNewGrantMethod(byte[] arg1, int arg2) {
        return this.withGrantMethod(new String(arg1, arg2));
    }

    @Override
    public A withNewGrantMethod(byte[] arg1) {
        return this.withGrantMethod(new String(arg1));
    }

    @Override
    public A withNewGrantMethod(char[] arg1, int arg2, int arg3) {
        return this.withGrantMethod(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewGrantMethod(byte[] arg1, int arg2, int arg3) {
        return this.withGrantMethod(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewGrantMethod(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.withGrantMethod(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewGrantMethod(String arg1) {
        return this.withGrantMethod(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(int[] arg1, int arg2, int arg3) {
        return this.withKind(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewKind(char[] arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(byte[] arg1, int arg2) {
        return this.withKind(new String(arg1, arg2));
    }

    @Override
    public A withNewKind(byte[] arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(char[] arg1, int arg2, int arg3) {
        return this.withKind(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewKind(byte[] arg1, int arg2, int arg3) {
        return this.withKind(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewKind(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.withKind(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public OAuthClientFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public OAuthClientFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public OAuthClientFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public OAuthClientFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public OAuthClientFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToRedirectURIs(int index, String item) {
        if (this.redirectURIs == null) {
            this.redirectURIs = new ArrayList<String>();
        }
        this.redirectURIs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToRedirectURIs(int index, String item) {
        if (this.redirectURIs == null) {
            this.redirectURIs = new ArrayList<String>();
        }
        this.redirectURIs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToRedirectURIs(String ... items) {
        if (this.redirectURIs == null) {
            this.redirectURIs = new ArrayList<String>();
        }
        for (String item : items) {
            this.redirectURIs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToRedirectURIs(Collection<String> items) {
        if (this.redirectURIs == null) {
            this.redirectURIs = new ArrayList<String>();
        }
        for (String item : items) {
            this.redirectURIs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromRedirectURIs(String ... items) {
        for (String item : items) {
            if (this.redirectURIs == null) continue;
            this.redirectURIs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRedirectURIs(Collection<String> items) {
        for (String item : items) {
            if (this.redirectURIs == null) continue;
            this.redirectURIs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getRedirectURIs() {
        return this.redirectURIs;
    }

    @Override
    public String getRedirectURI(int index) {
        return this.redirectURIs.get(index);
    }

    @Override
    public String getFirstRedirectURI() {
        return this.redirectURIs.get(0);
    }

    @Override
    public String getLastRedirectURI() {
        return this.redirectURIs.get(this.redirectURIs.size() - 1);
    }

    @Override
    public String getMatchingRedirectURI(Predicate<String> predicate) {
        for (String item : this.redirectURIs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRedirectURI(Predicate<String> predicate) {
        for (String item : this.redirectURIs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRedirectURIs(List<String> redirectURIs) {
        if (this.redirectURIs != null) {
            this._visitables.get((Object)"redirectURIs").removeAll(this.redirectURIs);
        }
        if (redirectURIs != null) {
            this.redirectURIs = new ArrayList<String>();
            for (String item : redirectURIs) {
                this.addToRedirectURIs(item);
            }
        } else {
            this.redirectURIs = null;
        }
        return (A)this;
    }

    @Override
    public A withRedirectURIs(String ... redirectURIs) {
        if (this.redirectURIs != null) {
            this.redirectURIs.clear();
        }
        if (redirectURIs != null) {
            for (String item : redirectURIs) {
                this.addToRedirectURIs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRedirectURIs() {
        return this.redirectURIs != null && !this.redirectURIs.isEmpty();
    }

    @Override
    public A addNewRedirectURI(StringBuilder arg1) {
        return this.addToRedirectURIs(new String(arg1));
    }

    @Override
    public A addNewRedirectURI(int[] arg1, int arg2, int arg3) {
        return this.addToRedirectURIs(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewRedirectURI(char[] arg1) {
        return this.addToRedirectURIs(new String(arg1));
    }

    @Override
    public A addNewRedirectURI(StringBuffer arg1) {
        return this.addToRedirectURIs(new String(arg1));
    }

    @Override
    public A addNewRedirectURI(byte[] arg1, int arg2) {
        return this.addToRedirectURIs(new String(arg1, arg2));
    }

    @Override
    public A addNewRedirectURI(byte[] arg1) {
        return this.addToRedirectURIs(new String(arg1));
    }

    @Override
    public A addNewRedirectURI(char[] arg1, int arg2, int arg3) {
        return this.addToRedirectURIs(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewRedirectURI(byte[] arg1, int arg2, int arg3) {
        return this.addToRedirectURIs(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewRedirectURI(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.addToRedirectURIs(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A addNewRedirectURI(String arg1) {
        return this.addToRedirectURIs(new String(arg1));
    }

    @Override
    public Boolean getRespondWithChallenges() {
        return this.respondWithChallenges;
    }

    @Override
    public A withRespondWithChallenges(Boolean respondWithChallenges) {
        this.respondWithChallenges = respondWithChallenges;
        return (A)this;
    }

    @Override
    public Boolean hasRespondWithChallenges() {
        return this.respondWithChallenges != null;
    }

    @Override
    public A withNewRespondWithChallenges(String arg1) {
        return this.withRespondWithChallenges(new Boolean(arg1));
    }

    @Override
    public A withNewRespondWithChallenges(boolean arg1) {
        return this.withRespondWithChallenges(new Boolean(arg1));
    }

    @Override
    public A addToScopeRestrictions(int index, ScopeRestriction item) {
        if (this.scopeRestrictions == null) {
            this.scopeRestrictions = new ArrayList<ScopeRestrictionBuilder>();
        }
        ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);
        this._visitables.get((Object)"scopeRestrictions").add(index >= 0 ? index : this._visitables.get((Object)"scopeRestrictions").size(), builder);
        this.scopeRestrictions.add(index >= 0 ? index : this.scopeRestrictions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToScopeRestrictions(int index, ScopeRestriction item) {
        if (this.scopeRestrictions == null) {
            this.scopeRestrictions = new ArrayList<ScopeRestrictionBuilder>();
        }
        ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"scopeRestrictions").size()) {
            this._visitables.get((Object)"scopeRestrictions").add(builder);
        } else {
            this._visitables.get((Object)"scopeRestrictions").set(index, builder);
        }
        if (index < 0 || index >= this.scopeRestrictions.size()) {
            this.scopeRestrictions.add(builder);
        } else {
            this.scopeRestrictions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToScopeRestrictions(ScopeRestriction ... items) {
        if (this.scopeRestrictions == null) {
            this.scopeRestrictions = new ArrayList<ScopeRestrictionBuilder>();
        }
        for (ScopeRestriction item : items) {
            ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);
            this._visitables.get((Object)"scopeRestrictions").add(builder);
            this.scopeRestrictions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToScopeRestrictions(Collection<ScopeRestriction> items) {
        if (this.scopeRestrictions == null) {
            this.scopeRestrictions = new ArrayList<ScopeRestrictionBuilder>();
        }
        for (ScopeRestriction item : items) {
            ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);
            this._visitables.get((Object)"scopeRestrictions").add(builder);
            this.scopeRestrictions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromScopeRestrictions(ScopeRestriction ... items) {
        for (ScopeRestriction item : items) {
            ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);
            this._visitables.get((Object)"scopeRestrictions").remove(builder);
            if (this.scopeRestrictions == null) continue;
            this.scopeRestrictions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromScopeRestrictions(Collection<ScopeRestriction> items) {
        for (ScopeRestriction item : items) {
            ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);
            this._visitables.get((Object)"scopeRestrictions").remove(builder);
            if (this.scopeRestrictions == null) continue;
            this.scopeRestrictions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromScopeRestrictions(Predicate<ScopeRestrictionBuilder> predicate) {
        if (this.scopeRestrictions == null) {
            return (A)this;
        }
        Iterator<ScopeRestrictionBuilder> each = this.scopeRestrictions.iterator();
        List visitables = this._visitables.get((Object)"scopeRestrictions");
        while (each.hasNext()) {
            ScopeRestrictionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ScopeRestriction> getScopeRestrictions() {
        return OAuthClientFluentImpl.build(this.scopeRestrictions);
    }

    @Override
    public List<ScopeRestriction> buildScopeRestrictions() {
        return OAuthClientFluentImpl.build(this.scopeRestrictions);
    }

    @Override
    public ScopeRestriction buildScopeRestriction(int index) {
        return this.scopeRestrictions.get(index).build();
    }

    @Override
    public ScopeRestriction buildFirstScopeRestriction() {
        return this.scopeRestrictions.get(0).build();
    }

    @Override
    public ScopeRestriction buildLastScopeRestriction() {
        return this.scopeRestrictions.get(this.scopeRestrictions.size() - 1).build();
    }

    @Override
    public ScopeRestriction buildMatchingScopeRestriction(Predicate<ScopeRestrictionBuilder> predicate) {
        for (ScopeRestrictionBuilder item : this.scopeRestrictions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingScopeRestriction(Predicate<ScopeRestrictionBuilder> predicate) {
        for (ScopeRestrictionBuilder item : this.scopeRestrictions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withScopeRestrictions(List<ScopeRestriction> scopeRestrictions) {
        if (this.scopeRestrictions != null) {
            this._visitables.get((Object)"scopeRestrictions").removeAll(this.scopeRestrictions);
        }
        if (scopeRestrictions != null) {
            this.scopeRestrictions = new ArrayList<ScopeRestrictionBuilder>();
            for (ScopeRestriction item : scopeRestrictions) {
                this.addToScopeRestrictions(item);
            }
        } else {
            this.scopeRestrictions = null;
        }
        return (A)this;
    }

    @Override
    public A withScopeRestrictions(ScopeRestriction ... scopeRestrictions) {
        if (this.scopeRestrictions != null) {
            this.scopeRestrictions.clear();
        }
        if (scopeRestrictions != null) {
            for (ScopeRestriction item : scopeRestrictions) {
                this.addToScopeRestrictions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasScopeRestrictions() {
        return this.scopeRestrictions != null && !this.scopeRestrictions.isEmpty();
    }

    @Override
    public OAuthClientFluent.ScopeRestrictionsNested<A> addNewScopeRestriction() {
        return new ScopeRestrictionsNestedImpl();
    }

    @Override
    public OAuthClientFluent.ScopeRestrictionsNested<A> addNewScopeRestrictionLike(ScopeRestriction item) {
        return new ScopeRestrictionsNestedImpl(-1, item);
    }

    @Override
    public OAuthClientFluent.ScopeRestrictionsNested<A> setNewScopeRestrictionLike(int index, ScopeRestriction item) {
        return new ScopeRestrictionsNestedImpl(index, item);
    }

    @Override
    public OAuthClientFluent.ScopeRestrictionsNested<A> editScopeRestriction(int index) {
        if (this.scopeRestrictions.size() <= index) {
            throw new RuntimeException("Can't edit scopeRestrictions. Index exceeds size.");
        }
        return this.setNewScopeRestrictionLike(index, this.buildScopeRestriction(index));
    }

    @Override
    public OAuthClientFluent.ScopeRestrictionsNested<A> editFirstScopeRestriction() {
        if (this.scopeRestrictions.size() == 0) {
            throw new RuntimeException("Can't edit first scopeRestrictions. The list is empty.");
        }
        return this.setNewScopeRestrictionLike(0, this.buildScopeRestriction(0));
    }

    @Override
    public OAuthClientFluent.ScopeRestrictionsNested<A> editLastScopeRestriction() {
        int index = this.scopeRestrictions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last scopeRestrictions. The list is empty.");
        }
        return this.setNewScopeRestrictionLike(index, this.buildScopeRestriction(index));
    }

    @Override
    public OAuthClientFluent.ScopeRestrictionsNested<A> editMatchingScopeRestriction(Predicate<ScopeRestrictionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.scopeRestrictions.size(); ++i) {
            if (!predicate.test(this.scopeRestrictions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching scopeRestrictions. No match found.");
        }
        return this.setNewScopeRestrictionLike(index, this.buildScopeRestriction(index));
    }

    @Override
    public String getSecret() {
        return this.secret;
    }

    @Override
    public A withSecret(String secret) {
        this.secret = secret;
        return (A)this;
    }

    @Override
    public Boolean hasSecret() {
        return this.secret != null;
    }

    @Override
    public A withNewSecret(StringBuilder arg1) {
        return this.withSecret(new String(arg1));
    }

    @Override
    public A withNewSecret(int[] arg1, int arg2, int arg3) {
        return this.withSecret(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewSecret(char[] arg1) {
        return this.withSecret(new String(arg1));
    }

    @Override
    public A withNewSecret(StringBuffer arg1) {
        return this.withSecret(new String(arg1));
    }

    @Override
    public A withNewSecret(byte[] arg1, int arg2) {
        return this.withSecret(new String(arg1, arg2));
    }

    @Override
    public A withNewSecret(byte[] arg1) {
        return this.withSecret(new String(arg1));
    }

    @Override
    public A withNewSecret(char[] arg1, int arg2, int arg3) {
        return this.withSecret(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewSecret(byte[] arg1, int arg2, int arg3) {
        return this.withSecret(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewSecret(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.withSecret(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewSecret(String arg1) {
        return this.withSecret(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthClientFluentImpl that = (OAuthClientFluentImpl)o;
        if (this.accessTokenInactivityTimeoutSeconds != null ? !this.accessTokenInactivityTimeoutSeconds.equals(that.accessTokenInactivityTimeoutSeconds) : that.accessTokenInactivityTimeoutSeconds != null) {
            return false;
        }
        if (this.accessTokenMaxAgeSeconds != null ? !this.accessTokenMaxAgeSeconds.equals(that.accessTokenMaxAgeSeconds) : that.accessTokenMaxAgeSeconds != null) {
            return false;
        }
        if (this.additionalSecrets != null ? !this.additionalSecrets.equals(that.additionalSecrets) : that.additionalSecrets != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.grantMethod != null ? !this.grantMethod.equals(that.grantMethod) : that.grantMethod != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.redirectURIs != null ? !this.redirectURIs.equals(that.redirectURIs) : that.redirectURIs != null) {
            return false;
        }
        if (this.respondWithChallenges != null ? !this.respondWithChallenges.equals(that.respondWithChallenges) : that.respondWithChallenges != null) {
            return false;
        }
        if (this.scopeRestrictions != null ? !this.scopeRestrictions.equals(that.scopeRestrictions) : that.scopeRestrictions != null) {
            return false;
        }
        return !(this.secret != null ? !this.secret.equals(that.secret) : that.secret != null);
    }

    public int hashCode() {
        return Objects.hash(this.accessTokenInactivityTimeoutSeconds, this.accessTokenMaxAgeSeconds, this.additionalSecrets, this.apiVersion, this.grantMethod, this.kind, this.metadata, this.redirectURIs, this.respondWithChallenges, this.scopeRestrictions, this.secret, super.hashCode());
    }

    public class ScopeRestrictionsNestedImpl<N>
    extends ScopeRestrictionFluentImpl<OAuthClientFluent.ScopeRestrictionsNested<N>>
    implements OAuthClientFluent.ScopeRestrictionsNested<N>,
    Nested<N> {
        private final ScopeRestrictionBuilder builder;
        private final int index;

        ScopeRestrictionsNestedImpl(int index, ScopeRestriction item) {
            this.index = index;
            this.builder = new ScopeRestrictionBuilder(this, item);
        }

        ScopeRestrictionsNestedImpl() {
            this.index = -1;
            this.builder = new ScopeRestrictionBuilder(this);
        }

        @Override
        public N and() {
            return (N)OAuthClientFluentImpl.this.setToScopeRestrictions(this.index, this.builder.build());
        }

        @Override
        public N endScopeRestriction() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<OAuthClientFluent.MetadataNested<N>>
    implements OAuthClientFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this);
        }

        @Override
        public N and() {
            return (N)OAuthClientFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

