/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.ImageImportStatus;
import io.fabric8.openshift.api.model.ImageImportStatusFluent;
import io.fabric8.openshift.api.model.ImageImportStatusFluentImpl;
import java.util.Objects;

public class ImageImportStatusBuilder
extends ImageImportStatusFluentImpl<ImageImportStatusBuilder>
implements VisitableBuilder<ImageImportStatus, ImageImportStatusBuilder> {
    ImageImportStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ImageImportStatusBuilder() {
        this(false);
    }

    public ImageImportStatusBuilder(Boolean validationEnabled) {
        this(new ImageImportStatus(), validationEnabled);
    }

    public ImageImportStatusBuilder(ImageImportStatusFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ImageImportStatusBuilder(ImageImportStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ImageImportStatus(), validationEnabled);
    }

    public ImageImportStatusBuilder(ImageImportStatusFluent<?> fluent, ImageImportStatus instance) {
        this(fluent, instance, false);
    }

    public ImageImportStatusBuilder(ImageImportStatusFluent<?> fluent, ImageImportStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withImage(instance.getImage());
        fluent.withStatus(instance.getStatus());
        fluent.withTag(instance.getTag());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ImageImportStatusBuilder(ImageImportStatus instance) {
        this(instance, (Boolean)false);
    }

    public ImageImportStatusBuilder(ImageImportStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withImage(instance.getImage());
        this.withStatus(instance.getStatus());
        this.withTag(instance.getTag());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ImageImportStatus build() {
        ImageImportStatus buildable = new ImageImportStatus(this.fluent.getImage(), this.fluent.getStatus(), this.fluent.getTag());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageImportStatusBuilder that = (ImageImportStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

