package io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class StorageVersionMigrationSpecFluent<A extends StorageVersionMigrationSpecFluent<A>> extends BaseFluent<A>{
  public StorageVersionMigrationSpecFluent() {
  }
  
  public StorageVersionMigrationSpecFluent(StorageVersionMigrationSpec instance) {
    this.copyInstance(instance);
  }
  private String continueToken;
  private StorageVersionMigrationSpecResourceBuilder resource;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(StorageVersionMigrationSpec instance) {
    instance = (instance != null ? instance : new StorageVersionMigrationSpec());
    if (instance != null) {
          this.withContinueToken(instance.getContinueToken());
          this.withResource(instance.getResource());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getContinueToken() {
    return this.continueToken;
  }
  
  public A withContinueToken(String continueToken) {
    this.continueToken = continueToken;
    return (A) this;
  }
  
  public boolean hasContinueToken() {
    return this.continueToken != null;
  }
  
  public StorageVersionMigrationSpecResource buildResource() {
    return this.resource != null ? this.resource.build() : null;
  }
  
  public A withResource(StorageVersionMigrationSpecResource resource) {
    this._visitables.remove("resource");
    if (resource != null) {
        this.resource = new StorageVersionMigrationSpecResourceBuilder(resource);
        this._visitables.get("resource").add(this.resource);
    } else {
        this.resource = null;
        this._visitables.get("resource").remove(this.resource);
    }
    return (A) this;
  }
  
  public boolean hasResource() {
    return this.resource != null;
  }
  
  public A withNewResource(String group,String resource,String version) {
    return (A)withResource(new StorageVersionMigrationSpecResource(group, resource, version));
  }
  
  public ResourceNested<A> withNewResource() {
    return new ResourceNested(null);
  }
  
  public ResourceNested<A> withNewResourceLike(StorageVersionMigrationSpecResource item) {
    return new ResourceNested(item);
  }
  
  public ResourceNested<A> editResource() {
    return withNewResourceLike(java.util.Optional.ofNullable(buildResource()).orElse(null));
  }
  
  public ResourceNested<A> editOrNewResource() {
    return withNewResourceLike(java.util.Optional.ofNullable(buildResource()).orElse(new StorageVersionMigrationSpecResourceBuilder().build()));
  }
  
  public ResourceNested<A> editOrNewResourceLike(StorageVersionMigrationSpecResource item) {
    return withNewResourceLike(java.util.Optional.ofNullable(buildResource()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    StorageVersionMigrationSpecFluent that = (StorageVersionMigrationSpecFluent) o;
    if (!java.util.Objects.equals(continueToken, that.continueToken)) return false;
    if (!java.util.Objects.equals(resource, that.resource)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(continueToken,  resource,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (continueToken != null) { sb.append("continueToken:"); sb.append(continueToken + ","); }
    if (resource != null) { sb.append("resource:"); sb.append(resource + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ResourceNested<N> extends StorageVersionMigrationSpecResourceFluent<ResourceNested<N>> implements Nested<N>{
    ResourceNested(StorageVersionMigrationSpecResource item) {
      this.builder = new StorageVersionMigrationSpecResourceBuilder(this, item);
    }
    StorageVersionMigrationSpecResourceBuilder builder;
    
    public N and() {
      return (N) StorageVersionMigrationSpecFluent.this.withResource(builder.build());
    }
    
    public N endResource() {
      return and();
    }
    
  
  }

}