package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StepBuilder extends StepFluentImpl<StepBuilder> implements VisitableBuilder<Step,StepBuilder>{
  public StepBuilder() {
    this(false);
  }
  public StepBuilder(Boolean validationEnabled) {
    this(new Step(), validationEnabled);
  }
  public StepBuilder(StepFluent<?> fluent) {
    this(fluent, false);
  }
  public StepBuilder(StepFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Step(), validationEnabled);
  }
  public StepBuilder(StepFluent<?> fluent,Step instance) {
    this(fluent, instance, false);
  }
  public StepBuilder(StepFluent<?> fluent,Step instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withResolving(instance.getResolving()); 
    fluent.withResource(instance.getResource()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public StepBuilder(Step instance) {
    this(instance,false);
  }
  public StepBuilder(Step instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withResolving(instance.getResolving()); 
    this.withResource(instance.getResource()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  StepFluent<?> fluent;
  Boolean validationEnabled;
  public Step build() {
    Step buildable = new Step(fluent.getResolving(),fluent.getResource(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}