package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RegistryPollBuilder extends RegistryPollFluentImpl<RegistryPollBuilder> implements VisitableBuilder<RegistryPoll,RegistryPollBuilder>{
  public RegistryPollBuilder() {
    this(false);
  }
  public RegistryPollBuilder(Boolean validationEnabled) {
    this(new RegistryPoll(), validationEnabled);
  }
  public RegistryPollBuilder(RegistryPollFluent<?> fluent) {
    this(fluent, false);
  }
  public RegistryPollBuilder(RegistryPollFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RegistryPoll(), validationEnabled);
  }
  public RegistryPollBuilder(RegistryPollFluent<?> fluent,RegistryPoll instance) {
    this(fluent, instance, false);
  }
  public RegistryPollBuilder(RegistryPollFluent<?> fluent,RegistryPoll instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withInterval(instance.getInterval()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RegistryPollBuilder(RegistryPoll instance) {
    this(instance,false);
  }
  public RegistryPollBuilder(RegistryPoll instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withInterval(instance.getInterval()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  RegistryPollFluent<?> fluent;
  Boolean validationEnabled;
  public RegistryPoll build() {
    RegistryPoll buildable = new RegistryPoll(fluent.getInterval());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}