package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CleanupStatusBuilder extends CleanupStatusFluentImpl<CleanupStatusBuilder> implements VisitableBuilder<CleanupStatus,CleanupStatusBuilder>{
  public CleanupStatusBuilder() {
    this(false);
  }
  public CleanupStatusBuilder(Boolean validationEnabled) {
    this(new CleanupStatus(), validationEnabled);
  }
  public CleanupStatusBuilder(CleanupStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public CleanupStatusBuilder(CleanupStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CleanupStatus(), validationEnabled);
  }
  public CleanupStatusBuilder(CleanupStatusFluent<?> fluent,CleanupStatus instance) {
    this(fluent, instance, false);
  }
  public CleanupStatusBuilder(CleanupStatusFluent<?> fluent,CleanupStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withPendingDeletion(instance.getPendingDeletion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CleanupStatusBuilder(CleanupStatus instance) {
    this(instance,false);
  }
  public CleanupStatusBuilder(CleanupStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withPendingDeletion(instance.getPendingDeletion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CleanupStatusFluent<?> fluent;
  Boolean validationEnabled;
  public CleanupStatus build() {
    CleanupStatus buildable = new CleanupStatus(fluent.getPendingDeletion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}