package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BundleLookupConditionBuilder extends BundleLookupConditionFluentImpl<BundleLookupConditionBuilder> implements VisitableBuilder<BundleLookupCondition,BundleLookupConditionBuilder>{
  public BundleLookupConditionBuilder() {
    this(false);
  }
  public BundleLookupConditionBuilder(Boolean validationEnabled) {
    this(new BundleLookupCondition(), validationEnabled);
  }
  public BundleLookupConditionBuilder(BundleLookupConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public BundleLookupConditionBuilder(BundleLookupConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BundleLookupCondition(), validationEnabled);
  }
  public BundleLookupConditionBuilder(BundleLookupConditionFluent<?> fluent,BundleLookupCondition instance) {
    this(fluent, instance, false);
  }
  public BundleLookupConditionBuilder(BundleLookupConditionFluent<?> fluent,BundleLookupCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withLastUpdateTime(instance.getLastUpdateTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BundleLookupConditionBuilder(BundleLookupCondition instance) {
    this(instance,false);
  }
  public BundleLookupConditionBuilder(BundleLookupCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withLastUpdateTime(instance.getLastUpdateTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  BundleLookupConditionFluent<?> fluent;
  Boolean validationEnabled;
  public BundleLookupCondition build() {
    BundleLookupCondition buildable = new BundleLookupCondition(fluent.getLastTransitionTime(),fluent.getLastUpdateTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}