/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.FeaturesMigration;
import io.fabric8.openshift.api.model.operator.v1.FeaturesMigrationBuilder;
import io.fabric8.openshift.api.model.operator.v1.FeaturesMigrationFluent;
import io.fabric8.openshift.api.model.operator.v1.MTUMigration;
import io.fabric8.openshift.api.model.operator.v1.MTUMigrationBuilder;
import io.fabric8.openshift.api.model.operator.v1.MTUMigrationFluent;
import io.fabric8.openshift.api.model.operator.v1.NetworkMigration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NetworkMigrationFluent<A extends NetworkMigrationFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private FeaturesMigrationBuilder features;
    private String mode;
    private MTUMigrationBuilder mtu;
    private String networkType;

    public NetworkMigrationFluent() {
    }

    public NetworkMigrationFluent(NetworkMigration instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public FeaturesMigration buildFeatures() {
        return this.features != null ? this.features.build() : null;
    }

    public MTUMigration buildMtu() {
        return this.mtu != null ? this.mtu.build() : null;
    }

    protected void copyInstance(NetworkMigration instance) {
        NetworkMigration networkMigration = instance = instance != null ? instance : new NetworkMigration();
        if (instance != null) {
            this.withFeatures(instance.getFeatures());
            this.withMode(instance.getMode());
            this.withMtu(instance.getMtu());
            this.withNetworkType(instance.getNetworkType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public FeaturesNested<A> editFeatures() {
        return this.withNewFeaturesLike(Optional.ofNullable(this.buildFeatures()).orElse(null));
    }

    public MtuNested<A> editMtu() {
        return this.withNewMtuLike(Optional.ofNullable(this.buildMtu()).orElse(null));
    }

    public FeaturesNested<A> editOrNewFeatures() {
        return this.withNewFeaturesLike(Optional.ofNullable(this.buildFeatures()).orElse(new FeaturesMigrationBuilder().build()));
    }

    public FeaturesNested<A> editOrNewFeaturesLike(FeaturesMigration item) {
        return this.withNewFeaturesLike(Optional.ofNullable(this.buildFeatures()).orElse(item));
    }

    public MtuNested<A> editOrNewMtu() {
        return this.withNewMtuLike(Optional.ofNullable(this.buildMtu()).orElse(new MTUMigrationBuilder().build()));
    }

    public MtuNested<A> editOrNewMtuLike(MTUMigration item) {
        return this.withNewMtuLike(Optional.ofNullable(this.buildMtu()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkMigrationFluent that = (NetworkMigrationFluent)((Object)o);
        if (!Objects.equals((Object)this.features, (Object)that.features)) {
            return false;
        }
        if (!Objects.equals(this.mode, that.mode)) {
            return false;
        }
        if (!Objects.equals((Object)this.mtu, (Object)that.mtu)) {
            return false;
        }
        if (!Objects.equals(this.networkType, that.networkType)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getMode() {
        return this.mode;
    }

    public String getNetworkType() {
        return this.networkType;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasFeatures() {
        return this.features != null;
    }

    public boolean hasMode() {
        return this.mode != null;
    }

    public boolean hasMtu() {
        return this.mtu != null;
    }

    public boolean hasNetworkType() {
        return this.networkType != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.features, this.mode, this.mtu, this.networkType, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.features != null) {
            sb.append("features:");
            sb.append((Object)this.features);
            sb.append(",");
        }
        if (this.mode != null) {
            sb.append("mode:");
            sb.append(this.mode);
            sb.append(",");
        }
        if (this.mtu != null) {
            sb.append("mtu:");
            sb.append((Object)this.mtu);
            sb.append(",");
        }
        if (this.networkType != null) {
            sb.append("networkType:");
            sb.append(this.networkType);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withFeatures(FeaturesMigration features) {
        this._visitables.remove((Object)"features");
        if (features != null) {
            this.features = new FeaturesMigrationBuilder(features);
            this._visitables.get((Object)"features").add(this.features);
        } else {
            this.features = null;
            this._visitables.get((Object)"features").remove((Object)this.features);
        }
        return (A)((Object)this);
    }

    public A withMode(String mode) {
        this.mode = mode;
        return (A)((Object)this);
    }

    public A withMtu(MTUMigration mtu) {
        this._visitables.remove((Object)"mtu");
        if (mtu != null) {
            this.mtu = new MTUMigrationBuilder(mtu);
            this._visitables.get((Object)"mtu").add(this.mtu);
        } else {
            this.mtu = null;
            this._visitables.get((Object)"mtu").remove((Object)this.mtu);
        }
        return (A)((Object)this);
    }

    public A withNetworkType(String networkType) {
        this.networkType = networkType;
        return (A)((Object)this);
    }

    public FeaturesNested<A> withNewFeatures() {
        return new FeaturesNested(null);
    }

    public A withNewFeatures(Boolean egressFirewall, Boolean egressIP, Boolean multicast) {
        return this.withFeatures(new FeaturesMigration(egressFirewall, egressIP, multicast));
    }

    public FeaturesNested<A> withNewFeaturesLike(FeaturesMigration item) {
        return new FeaturesNested(item);
    }

    public MtuNested<A> withNewMtu() {
        return new MtuNested(null);
    }

    public MtuNested<A> withNewMtuLike(MTUMigration item) {
        return new MtuNested(item);
    }

    public class MtuNested<N>
    extends MTUMigrationFluent<MtuNested<N>>
    implements Nested<N> {
        MTUMigrationBuilder builder;

        MtuNested(MTUMigration item) {
            this.builder = new MTUMigrationBuilder(this, item);
        }

        public N and() {
            return (N)NetworkMigrationFluent.this.withMtu(this.builder.build());
        }

        public N endMtu() {
            return this.and();
        }
    }

    public class FeaturesNested<N>
    extends FeaturesMigrationFluent<FeaturesNested<N>>
    implements Nested<N> {
        FeaturesMigrationBuilder builder;

        FeaturesNested(FeaturesMigration item) {
            this.builder = new FeaturesMigrationBuilder(this, item);
        }

        public N and() {
            return (N)NetworkMigrationFluent.this.withFeatures(this.builder.build());
        }

        public N endFeatures() {
            return this.and();
        }
    }
}

