/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.ConfigMapFileReference;
import io.fabric8.openshift.api.model.operator.v1.ConfigMapFileReferenceBuilder;
import io.fabric8.openshift.api.model.operator.v1.ConfigMapFileReferenceFluent;
import io.fabric8.openshift.api.model.operator.v1.FileReferenceSource;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class FileReferenceSourceFluent<A extends FileReferenceSourceFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ConfigMapFileReferenceBuilder configMap;
    private String from;

    public FileReferenceSourceFluent() {
    }

    public FileReferenceSourceFluent(FileReferenceSource instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public ConfigMapFileReference buildConfigMap() {
        return this.configMap != null ? this.configMap.build() : null;
    }

    protected void copyInstance(FileReferenceSource instance) {
        FileReferenceSource fileReferenceSource = instance = instance != null ? instance : new FileReferenceSource();
        if (instance != null) {
            this.withConfigMap(instance.getConfigMap());
            this.withFrom(instance.getFrom());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConfigMapNested<A> editConfigMap() {
        return this.withNewConfigMapLike(Optional.ofNullable(this.buildConfigMap()).orElse(null));
    }

    public ConfigMapNested<A> editOrNewConfigMap() {
        return this.withNewConfigMapLike(Optional.ofNullable(this.buildConfigMap()).orElse(new ConfigMapFileReferenceBuilder().build()));
    }

    public ConfigMapNested<A> editOrNewConfigMapLike(ConfigMapFileReference item) {
        return this.withNewConfigMapLike(Optional.ofNullable(this.buildConfigMap()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileReferenceSourceFluent that = (FileReferenceSourceFluent)((Object)o);
        if (!Objects.equals((Object)this.configMap, (Object)that.configMap)) {
            return false;
        }
        if (!Objects.equals(this.from, that.from)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getFrom() {
        return this.from;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasConfigMap() {
        return this.configMap != null;
    }

    public boolean hasFrom() {
        return this.from != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.configMap, this.from, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configMap != null) {
            sb.append("configMap:");
            sb.append((Object)this.configMap);
            sb.append(",");
        }
        if (this.from != null) {
            sb.append("from:");
            sb.append(this.from);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withConfigMap(ConfigMapFileReference configMap) {
        this._visitables.remove((Object)"configMap");
        if (configMap != null) {
            this.configMap = new ConfigMapFileReferenceBuilder(configMap);
            this._visitables.get((Object)"configMap").add(this.configMap);
        } else {
            this.configMap = null;
            this._visitables.get((Object)"configMap").remove((Object)this.configMap);
        }
        return (A)((Object)this);
    }

    public A withFrom(String from) {
        this.from = from;
        return (A)((Object)this);
    }

    public ConfigMapNested<A> withNewConfigMap() {
        return new ConfigMapNested(null);
    }

    public A withNewConfigMap(String key, String name) {
        return this.withConfigMap(new ConfigMapFileReference(key, name));
    }

    public ConfigMapNested<A> withNewConfigMapLike(ConfigMapFileReference item) {
        return new ConfigMapNested(item);
    }

    public class ConfigMapNested<N>
    extends ConfigMapFileReferenceFluent<ConfigMapNested<N>>
    implements Nested<N> {
        ConfigMapFileReferenceBuilder builder;

        ConfigMapNested(ConfigMapFileReference item) {
            this.builder = new ConfigMapFileReferenceBuilder(this, item);
        }

        public N and() {
            return (N)FileReferenceSourceFluent.this.withConfigMap(this.builder.build());
        }

        public N endConfigMap() {
            return this.and();
        }
    }
}

