/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.AWSClassicLoadBalancerParameters;
import io.fabric8.openshift.api.model.operator.v1.AWSSubnets;
import io.fabric8.openshift.api.model.operator.v1.AWSSubnetsBuilder;
import io.fabric8.openshift.api.model.operator.v1.AWSSubnetsFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AWSClassicLoadBalancerParametersFluent<A extends AWSClassicLoadBalancerParametersFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String connectionIdleTimeout;
    private AWSSubnetsBuilder subnets;

    public AWSClassicLoadBalancerParametersFluent() {
    }

    public AWSClassicLoadBalancerParametersFluent(AWSClassicLoadBalancerParameters instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public AWSSubnets buildSubnets() {
        return this.subnets != null ? this.subnets.build() : null;
    }

    protected void copyInstance(AWSClassicLoadBalancerParameters instance) {
        AWSClassicLoadBalancerParameters aWSClassicLoadBalancerParameters = instance = instance != null ? instance : new AWSClassicLoadBalancerParameters();
        if (instance != null) {
            this.withConnectionIdleTimeout(instance.getConnectionIdleTimeout());
            this.withSubnets(instance.getSubnets());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public SubnetsNested<A> editOrNewSubnets() {
        return this.withNewSubnetsLike(Optional.ofNullable(this.buildSubnets()).orElse(new AWSSubnetsBuilder().build()));
    }

    public SubnetsNested<A> editOrNewSubnetsLike(AWSSubnets item) {
        return this.withNewSubnetsLike(Optional.ofNullable(this.buildSubnets()).orElse(item));
    }

    public SubnetsNested<A> editSubnets() {
        return this.withNewSubnetsLike(Optional.ofNullable(this.buildSubnets()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AWSClassicLoadBalancerParametersFluent that = (AWSClassicLoadBalancerParametersFluent)((Object)o);
        if (!Objects.equals(this.connectionIdleTimeout, that.connectionIdleTimeout)) {
            return false;
        }
        if (!Objects.equals((Object)this.subnets, (Object)that.subnets)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getConnectionIdleTimeout() {
        return this.connectionIdleTimeout;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasConnectionIdleTimeout() {
        return this.connectionIdleTimeout != null;
    }

    public boolean hasSubnets() {
        return this.subnets != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.connectionIdleTimeout, this.subnets, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.connectionIdleTimeout != null) {
            sb.append("connectionIdleTimeout:");
            sb.append(this.connectionIdleTimeout);
            sb.append(",");
        }
        if (this.subnets != null) {
            sb.append("subnets:");
            sb.append((Object)this.subnets);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withConnectionIdleTimeout(String connectionIdleTimeout) {
        this.connectionIdleTimeout = connectionIdleTimeout;
        return (A)((Object)this);
    }

    public SubnetsNested<A> withNewSubnets() {
        return new SubnetsNested(null);
    }

    public SubnetsNested<A> withNewSubnetsLike(AWSSubnets item) {
        return new SubnetsNested(item);
    }

    public A withSubnets(AWSSubnets subnets) {
        this._visitables.remove((Object)"subnets");
        if (subnets != null) {
            this.subnets = new AWSSubnetsBuilder(subnets);
            this._visitables.get((Object)"subnets").add(this.subnets);
        } else {
            this.subnets = null;
            this._visitables.get((Object)"subnets").remove((Object)this.subnets);
        }
        return (A)((Object)this);
    }

    public class SubnetsNested<N>
    extends AWSSubnetsFluent<SubnetsNested<N>>
    implements Nested<N> {
        AWSSubnetsBuilder builder;

        SubnetsNested(AWSSubnets item) {
            this.builder = new AWSSubnetsBuilder(this, item);
        }

        public N and() {
            return (N)AWSClassicLoadBalancerParametersFluent.this.withSubnets(this.builder.build());
        }

        public N endSubnets() {
            return this.and();
        }
    }
}

