package io.fabric8.openshift.api.model.operator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NodeStatusBuilder extends NodeStatusFluent<NodeStatusBuilder> implements VisitableBuilder<NodeStatus,NodeStatusBuilder>{
  public NodeStatusBuilder() {
    this(new NodeStatus());
  }
  
  public NodeStatusBuilder(NodeStatusFluent<?> fluent) {
    this(fluent, new NodeStatus());
  }
  
  public NodeStatusBuilder(NodeStatusFluent<?> fluent,NodeStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NodeStatusBuilder(NodeStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NodeStatusFluent<?> fluent;
  
  public NodeStatus build() {
    NodeStatus buildable = new NodeStatus(fluent.getCurrentDeploymentGeneration(),fluent.getLastFailedDeploymentErrors(),fluent.getLastFailedDeploymentGeneration(),fluent.getNodeName(),fluent.getTargetDeploymentGeneration());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}