package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class RestartServiceBuilder extends RestartServiceFluent<RestartServiceBuilder> implements VisitableBuilder<RestartService,RestartServiceBuilder>{
  public RestartServiceBuilder() {
    this(new RestartService());
  }
  
  public RestartServiceBuilder(RestartServiceFluent<?> fluent) {
    this(fluent, new RestartService());
  }
  
  public RestartServiceBuilder(RestartServiceFluent<?> fluent,RestartService instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public RestartServiceBuilder(RestartService instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  RestartServiceFluent<?> fluent;
  
  public RestartService build() {
    RestartService buildable = new RestartService(fluent.getServiceName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}