package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class OpenStackLoadBalancerParametersBuilder extends OpenStackLoadBalancerParametersFluent<OpenStackLoadBalancerParametersBuilder> implements VisitableBuilder<OpenStackLoadBalancerParameters,OpenStackLoadBalancerParametersBuilder>{
  public OpenStackLoadBalancerParametersBuilder() {
    this(new OpenStackLoadBalancerParameters());
  }
  
  public OpenStackLoadBalancerParametersBuilder(OpenStackLoadBalancerParametersFluent<?> fluent) {
    this(fluent, new OpenStackLoadBalancerParameters());
  }
  
  public OpenStackLoadBalancerParametersBuilder(OpenStackLoadBalancerParametersFluent<?> fluent,OpenStackLoadBalancerParameters instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public OpenStackLoadBalancerParametersBuilder(OpenStackLoadBalancerParameters instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  OpenStackLoadBalancerParametersFluent<?> fluent;
  
  public OpenStackLoadBalancerParameters build() {
    OpenStackLoadBalancerParameters buildable = new OpenStackLoadBalancerParameters(fluent.getFloatingIP());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}