package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NodeDisruptionPolicyStatusActionFluent<A extends NodeDisruptionPolicyStatusActionFluent<A>> extends BaseFluent<A>{
  public NodeDisruptionPolicyStatusActionFluent() {
  }
  
  public NodeDisruptionPolicyStatusActionFluent(NodeDisruptionPolicyStatusAction instance) {
    this.copyInstance(instance);
  }
  private ReloadServiceBuilder reload;
  private RestartServiceBuilder restart;
  private String type;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NodeDisruptionPolicyStatusAction instance) {
    instance = (instance != null ? instance : new NodeDisruptionPolicyStatusAction());
    if (instance != null) {
          this.withReload(instance.getReload());
          this.withRestart(instance.getRestart());
          this.withType(instance.getType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ReloadService buildReload() {
    return this.reload != null ? this.reload.build() : null;
  }
  
  public A withReload(ReloadService reload) {
    this._visitables.remove("reload");
    if (reload != null) {
        this.reload = new ReloadServiceBuilder(reload);
        this._visitables.get("reload").add(this.reload);
    } else {
        this.reload = null;
        this._visitables.get("reload").remove(this.reload);
    }
    return (A) this;
  }
  
  public boolean hasReload() {
    return this.reload != null;
  }
  
  public A withNewReload(String serviceName) {
    return (A)withReload(new ReloadService(serviceName));
  }
  
  public ReloadNested<A> withNewReload() {
    return new ReloadNested(null);
  }
  
  public ReloadNested<A> withNewReloadLike(ReloadService item) {
    return new ReloadNested(item);
  }
  
  public ReloadNested<A> editReload() {
    return withNewReloadLike(java.util.Optional.ofNullable(buildReload()).orElse(null));
  }
  
  public ReloadNested<A> editOrNewReload() {
    return withNewReloadLike(java.util.Optional.ofNullable(buildReload()).orElse(new ReloadServiceBuilder().build()));
  }
  
  public ReloadNested<A> editOrNewReloadLike(ReloadService item) {
    return withNewReloadLike(java.util.Optional.ofNullable(buildReload()).orElse(item));
  }
  
  public RestartService buildRestart() {
    return this.restart != null ? this.restart.build() : null;
  }
  
  public A withRestart(RestartService restart) {
    this._visitables.remove("restart");
    if (restart != null) {
        this.restart = new RestartServiceBuilder(restart);
        this._visitables.get("restart").add(this.restart);
    } else {
        this.restart = null;
        this._visitables.get("restart").remove(this.restart);
    }
    return (A) this;
  }
  
  public boolean hasRestart() {
    return this.restart != null;
  }
  
  public A withNewRestart(String serviceName) {
    return (A)withRestart(new RestartService(serviceName));
  }
  
  public RestartNested<A> withNewRestart() {
    return new RestartNested(null);
  }
  
  public RestartNested<A> withNewRestartLike(RestartService item) {
    return new RestartNested(item);
  }
  
  public RestartNested<A> editRestart() {
    return withNewRestartLike(java.util.Optional.ofNullable(buildRestart()).orElse(null));
  }
  
  public RestartNested<A> editOrNewRestart() {
    return withNewRestartLike(java.util.Optional.ofNullable(buildRestart()).orElse(new RestartServiceBuilder().build()));
  }
  
  public RestartNested<A> editOrNewRestartLike(RestartService item) {
    return withNewRestartLike(java.util.Optional.ofNullable(buildRestart()).orElse(item));
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NodeDisruptionPolicyStatusActionFluent that = (NodeDisruptionPolicyStatusActionFluent) o;
    if (!java.util.Objects.equals(reload, that.reload)) return false;
    if (!java.util.Objects.equals(restart, that.restart)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(reload,  restart,  type,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (reload != null) { sb.append("reload:"); sb.append(reload + ","); }
    if (restart != null) { sb.append("restart:"); sb.append(restart + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ReloadNested<N> extends ReloadServiceFluent<ReloadNested<N>> implements Nested<N>{
    ReloadNested(ReloadService item) {
      this.builder = new ReloadServiceBuilder(this, item);
    }
    ReloadServiceBuilder builder;
    
    public N and() {
      return (N) NodeDisruptionPolicyStatusActionFluent.this.withReload(builder.build());
    }
    
    public N endReload() {
      return and();
    }
    
  
  }
  public class RestartNested<N> extends RestartServiceFluent<RestartNested<N>> implements Nested<N>{
    RestartNested(RestartService item) {
      this.builder = new RestartServiceBuilder(this, item);
    }
    RestartServiceBuilder builder;
    
    public N and() {
      return (N) NodeDisruptionPolicyStatusActionFluent.this.withRestart(builder.build());
    }
    
    public N endRestart() {
      return and();
    }
    
  
  }

}