package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Iterator;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NetworkSpecFluent<A extends NetworkSpecFluent<A>> extends BaseFluent<A>{
  public NetworkSpecFluent() {
  }
  
  public NetworkSpecFluent(NetworkSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<AdditionalNetworkDefinitionBuilder> additionalNetworks = new ArrayList<AdditionalNetworkDefinitionBuilder>();
  private AdditionalRoutingCapabilitiesBuilder additionalRoutingCapabilities;
  private ArrayList<ClusterNetworkEntryBuilder> clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
  private DefaultNetworkDefinitionBuilder defaultNetwork;
  private Boolean deployKubeProxy;
  private Boolean disableMultiNetwork;
  private Boolean disableNetworkDiagnostics;
  private ExportNetworkFlowsBuilder exportNetworkFlows;
  private ProxyConfigBuilder kubeProxyConfig;
  private String logLevel;
  private String managementState;
  private NetworkMigrationBuilder migration;
  private Object observedConfig;
  private String operatorLogLevel;
  private List<String> serviceNetwork = new ArrayList<String>();
  private Object unsupportedConfigOverrides;
  private Boolean useMultiNetworkPolicy;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NetworkSpec instance) {
    instance = (instance != null ? instance : new NetworkSpec());
    if (instance != null) {
          this.withAdditionalNetworks(instance.getAdditionalNetworks());
          this.withAdditionalRoutingCapabilities(instance.getAdditionalRoutingCapabilities());
          this.withClusterNetwork(instance.getClusterNetwork());
          this.withDefaultNetwork(instance.getDefaultNetwork());
          this.withDeployKubeProxy(instance.getDeployKubeProxy());
          this.withDisableMultiNetwork(instance.getDisableMultiNetwork());
          this.withDisableNetworkDiagnostics(instance.getDisableNetworkDiagnostics());
          this.withExportNetworkFlows(instance.getExportNetworkFlows());
          this.withKubeProxyConfig(instance.getKubeProxyConfig());
          this.withLogLevel(instance.getLogLevel());
          this.withManagementState(instance.getManagementState());
          this.withMigration(instance.getMigration());
          this.withObservedConfig(instance.getObservedConfig());
          this.withOperatorLogLevel(instance.getOperatorLogLevel());
          this.withServiceNetwork(instance.getServiceNetwork());
          this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
          this.withUseMultiNetworkPolicy(instance.getUseMultiNetworkPolicy());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToAdditionalNetworks(int index,AdditionalNetworkDefinition item) {
    if (this.additionalNetworks == null) {this.additionalNetworks = new ArrayList<AdditionalNetworkDefinitionBuilder>();}
    AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);
    if (index < 0 || index >= additionalNetworks.size()) {
        _visitables.get("additionalNetworks").add(builder);
        additionalNetworks.add(builder);
    } else {
        _visitables.get("additionalNetworks").add(builder);
        additionalNetworks.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToAdditionalNetworks(int index,AdditionalNetworkDefinition item) {
    if (this.additionalNetworks == null) {this.additionalNetworks = new ArrayList<AdditionalNetworkDefinitionBuilder>();}
    AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);
    if (index < 0 || index >= additionalNetworks.size()) {
        _visitables.get("additionalNetworks").add(builder);
        additionalNetworks.add(builder);
    } else {
        _visitables.get("additionalNetworks").add(builder);
        additionalNetworks.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToAdditionalNetworks(io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition... items) {
    if (this.additionalNetworks == null) {this.additionalNetworks = new ArrayList<AdditionalNetworkDefinitionBuilder>();}
    for (AdditionalNetworkDefinition item : items) {AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);_visitables.get("additionalNetworks").add(builder);this.additionalNetworks.add(builder);} return (A)this;
  }
  
  public A addAllToAdditionalNetworks(Collection<AdditionalNetworkDefinition> items) {
    if (this.additionalNetworks == null) {this.additionalNetworks = new ArrayList<AdditionalNetworkDefinitionBuilder>();}
    for (AdditionalNetworkDefinition item : items) {AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);_visitables.get("additionalNetworks").add(builder);this.additionalNetworks.add(builder);} return (A)this;
  }
  
  public A removeFromAdditionalNetworks(io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition... items) {
    if (this.additionalNetworks == null) return (A)this;
    for (AdditionalNetworkDefinition item : items) {AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);_visitables.get("additionalNetworks").remove(builder); this.additionalNetworks.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAdditionalNetworks(Collection<AdditionalNetworkDefinition> items) {
    if (this.additionalNetworks == null) return (A)this;
    for (AdditionalNetworkDefinition item : items) {AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);_visitables.get("additionalNetworks").remove(builder); this.additionalNetworks.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAdditionalNetworks(Predicate<AdditionalNetworkDefinitionBuilder> predicate) {
    if (additionalNetworks == null) return (A) this;
    final Iterator<AdditionalNetworkDefinitionBuilder> each = additionalNetworks.iterator();
    final List visitables = _visitables.get("additionalNetworks");
    while (each.hasNext()) {
      AdditionalNetworkDefinitionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<AdditionalNetworkDefinition> buildAdditionalNetworks() {
    return this.additionalNetworks != null ? build(additionalNetworks) : null;
  }
  
  public AdditionalNetworkDefinition buildAdditionalNetwork(int index) {
    return this.additionalNetworks.get(index).build();
  }
  
  public AdditionalNetworkDefinition buildFirstAdditionalNetwork() {
    return this.additionalNetworks.get(0).build();
  }
  
  public AdditionalNetworkDefinition buildLastAdditionalNetwork() {
    return this.additionalNetworks.get(additionalNetworks.size() - 1).build();
  }
  
  public AdditionalNetworkDefinition buildMatchingAdditionalNetwork(Predicate<AdditionalNetworkDefinitionBuilder> predicate) {
      for (AdditionalNetworkDefinitionBuilder item : additionalNetworks) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAdditionalNetwork(Predicate<AdditionalNetworkDefinitionBuilder> predicate) {
      for (AdditionalNetworkDefinitionBuilder item : additionalNetworks) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAdditionalNetworks(List<AdditionalNetworkDefinition> additionalNetworks) {
    if (this.additionalNetworks != null) {
      this._visitables.get("additionalNetworks").clear();
    }
    if (additionalNetworks != null) {
        this.additionalNetworks = new ArrayList();
        for (AdditionalNetworkDefinition item : additionalNetworks) {
          this.addToAdditionalNetworks(item);
        }
    } else {
      this.additionalNetworks = null;
    }
    return (A) this;
  }
  
  public A withAdditionalNetworks(io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition... additionalNetworks) {
    if (this.additionalNetworks != null) {
        this.additionalNetworks.clear();
        _visitables.remove("additionalNetworks");
    }
    if (additionalNetworks != null) {
      for (AdditionalNetworkDefinition item : additionalNetworks) {
        this.addToAdditionalNetworks(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAdditionalNetworks() {
    return this.additionalNetworks != null && !this.additionalNetworks.isEmpty();
  }
  
  public AdditionalNetworksNested<A> addNewAdditionalNetwork() {
    return new AdditionalNetworksNested(-1, null);
  }
  
  public AdditionalNetworksNested<A> addNewAdditionalNetworkLike(AdditionalNetworkDefinition item) {
    return new AdditionalNetworksNested(-1, item);
  }
  
  public AdditionalNetworksNested<A> setNewAdditionalNetworkLike(int index,AdditionalNetworkDefinition item) {
    return new AdditionalNetworksNested(index, item);
  }
  
  public AdditionalNetworksNested<A> editAdditionalNetwork(int index) {
    if (additionalNetworks.size() <= index) throw new RuntimeException("Can't edit additionalNetworks. Index exceeds size.");
    return setNewAdditionalNetworkLike(index, buildAdditionalNetwork(index));
  }
  
  public AdditionalNetworksNested<A> editFirstAdditionalNetwork() {
    if (additionalNetworks.size() == 0) throw new RuntimeException("Can't edit first additionalNetworks. The list is empty.");
    return setNewAdditionalNetworkLike(0, buildAdditionalNetwork(0));
  }
  
  public AdditionalNetworksNested<A> editLastAdditionalNetwork() {
    int index = additionalNetworks.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last additionalNetworks. The list is empty.");
    return setNewAdditionalNetworkLike(index, buildAdditionalNetwork(index));
  }
  
  public AdditionalNetworksNested<A> editMatchingAdditionalNetwork(Predicate<AdditionalNetworkDefinitionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<additionalNetworks.size();i++) { 
    if (predicate.test(additionalNetworks.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching additionalNetworks. No match found.");
    return setNewAdditionalNetworkLike(index, buildAdditionalNetwork(index));
  }
  
  public AdditionalRoutingCapabilities buildAdditionalRoutingCapabilities() {
    return this.additionalRoutingCapabilities != null ? this.additionalRoutingCapabilities.build() : null;
  }
  
  public A withAdditionalRoutingCapabilities(AdditionalRoutingCapabilities additionalRoutingCapabilities) {
    this._visitables.remove("additionalRoutingCapabilities");
    if (additionalRoutingCapabilities != null) {
        this.additionalRoutingCapabilities = new AdditionalRoutingCapabilitiesBuilder(additionalRoutingCapabilities);
        this._visitables.get("additionalRoutingCapabilities").add(this.additionalRoutingCapabilities);
    } else {
        this.additionalRoutingCapabilities = null;
        this._visitables.get("additionalRoutingCapabilities").remove(this.additionalRoutingCapabilities);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalRoutingCapabilities() {
    return this.additionalRoutingCapabilities != null;
  }
  
  public AdditionalRoutingCapabilitiesNested<A> withNewAdditionalRoutingCapabilities() {
    return new AdditionalRoutingCapabilitiesNested(null);
  }
  
  public AdditionalRoutingCapabilitiesNested<A> withNewAdditionalRoutingCapabilitiesLike(AdditionalRoutingCapabilities item) {
    return new AdditionalRoutingCapabilitiesNested(item);
  }
  
  public AdditionalRoutingCapabilitiesNested<A> editAdditionalRoutingCapabilities() {
    return withNewAdditionalRoutingCapabilitiesLike(java.util.Optional.ofNullable(buildAdditionalRoutingCapabilities()).orElse(null));
  }
  
  public AdditionalRoutingCapabilitiesNested<A> editOrNewAdditionalRoutingCapabilities() {
    return withNewAdditionalRoutingCapabilitiesLike(java.util.Optional.ofNullable(buildAdditionalRoutingCapabilities()).orElse(new AdditionalRoutingCapabilitiesBuilder().build()));
  }
  
  public AdditionalRoutingCapabilitiesNested<A> editOrNewAdditionalRoutingCapabilitiesLike(AdditionalRoutingCapabilities item) {
    return withNewAdditionalRoutingCapabilitiesLike(java.util.Optional.ofNullable(buildAdditionalRoutingCapabilities()).orElse(item));
  }
  
  public A addToClusterNetwork(int index,ClusterNetworkEntry item) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
    if (index < 0 || index >= clusterNetwork.size()) {
        _visitables.get("clusterNetwork").add(builder);
        clusterNetwork.add(builder);
    } else {
        _visitables.get("clusterNetwork").add(builder);
        clusterNetwork.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToClusterNetwork(int index,ClusterNetworkEntry item) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
    if (index < 0 || index >= clusterNetwork.size()) {
        _visitables.get("clusterNetwork").add(builder);
        clusterNetwork.add(builder);
    } else {
        _visitables.get("clusterNetwork").add(builder);
        clusterNetwork.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToClusterNetwork(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry... items) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(builder);this.clusterNetwork.add(builder);} return (A)this;
  }
  
  public A addAllToClusterNetwork(Collection<ClusterNetworkEntry> items) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(builder);this.clusterNetwork.add(builder);} return (A)this;
  }
  
  public A removeFromClusterNetwork(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry... items) {
    if (this.clusterNetwork == null) return (A)this;
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").remove(builder); this.clusterNetwork.remove(builder);} return (A)this;
  }
  
  public A removeAllFromClusterNetwork(Collection<ClusterNetworkEntry> items) {
    if (this.clusterNetwork == null) return (A)this;
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").remove(builder); this.clusterNetwork.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    if (clusterNetwork == null) return (A) this;
    final Iterator<ClusterNetworkEntryBuilder> each = clusterNetwork.iterator();
    final List visitables = _visitables.get("clusterNetwork");
    while (each.hasNext()) {
      ClusterNetworkEntryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ClusterNetworkEntry> buildClusterNetwork() {
    return this.clusterNetwork != null ? build(clusterNetwork) : null;
  }
  
  public ClusterNetworkEntry buildClusterNetwork(int index) {
    return this.clusterNetwork.get(index).build();
  }
  
  public ClusterNetworkEntry buildFirstClusterNetwork() {
    return this.clusterNetwork.get(0).build();
  }
  
  public ClusterNetworkEntry buildLastClusterNetwork() {
    return this.clusterNetwork.get(clusterNetwork.size() - 1).build();
  }
  
  public ClusterNetworkEntry buildMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
      for (ClusterNetworkEntryBuilder item : clusterNetwork) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
      for (ClusterNetworkEntryBuilder item : clusterNetwork) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withClusterNetwork(List<ClusterNetworkEntry> clusterNetwork) {
    if (this.clusterNetwork != null) {
      this._visitables.get("clusterNetwork").clear();
    }
    if (clusterNetwork != null) {
        this.clusterNetwork = new ArrayList();
        for (ClusterNetworkEntry item : clusterNetwork) {
          this.addToClusterNetwork(item);
        }
    } else {
      this.clusterNetwork = null;
    }
    return (A) this;
  }
  
  public A withClusterNetwork(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry... clusterNetwork) {
    if (this.clusterNetwork != null) {
        this.clusterNetwork.clear();
        _visitables.remove("clusterNetwork");
    }
    if (clusterNetwork != null) {
      for (ClusterNetworkEntry item : clusterNetwork) {
        this.addToClusterNetwork(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasClusterNetwork() {
    return this.clusterNetwork != null && !this.clusterNetwork.isEmpty();
  }
  
  public A addNewClusterNetwork(String cidr,Long hostPrefix) {
    return (A)addToClusterNetwork(new ClusterNetworkEntry(cidr, hostPrefix));
  }
  
  public ClusterNetworkNested<A> addNewClusterNetwork() {
    return new ClusterNetworkNested(-1, null);
  }
  
  public ClusterNetworkNested<A> addNewClusterNetworkLike(ClusterNetworkEntry item) {
    return new ClusterNetworkNested(-1, item);
  }
  
  public ClusterNetworkNested<A> setNewClusterNetworkLike(int index,ClusterNetworkEntry item) {
    return new ClusterNetworkNested(index, item);
  }
  
  public ClusterNetworkNested<A> editClusterNetwork(int index) {
    if (clusterNetwork.size() <= index) throw new RuntimeException("Can't edit clusterNetwork. Index exceeds size.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  
  public ClusterNetworkNested<A> editFirstClusterNetwork() {
    if (clusterNetwork.size() == 0) throw new RuntimeException("Can't edit first clusterNetwork. The list is empty.");
    return setNewClusterNetworkLike(0, buildClusterNetwork(0));
  }
  
  public ClusterNetworkNested<A> editLastClusterNetwork() {
    int index = clusterNetwork.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusterNetwork. The list is empty.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  
  public ClusterNetworkNested<A> editMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusterNetwork.size();i++) { 
    if (predicate.test(clusterNetwork.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusterNetwork. No match found.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  
  public DefaultNetworkDefinition buildDefaultNetwork() {
    return this.defaultNetwork != null ? this.defaultNetwork.build() : null;
  }
  
  public A withDefaultNetwork(DefaultNetworkDefinition defaultNetwork) {
    this._visitables.remove("defaultNetwork");
    if (defaultNetwork != null) {
        this.defaultNetwork = new DefaultNetworkDefinitionBuilder(defaultNetwork);
        this._visitables.get("defaultNetwork").add(this.defaultNetwork);
    } else {
        this.defaultNetwork = null;
        this._visitables.get("defaultNetwork").remove(this.defaultNetwork);
    }
    return (A) this;
  }
  
  public boolean hasDefaultNetwork() {
    return this.defaultNetwork != null;
  }
  
  public DefaultNetworkNested<A> withNewDefaultNetwork() {
    return new DefaultNetworkNested(null);
  }
  
  public DefaultNetworkNested<A> withNewDefaultNetworkLike(DefaultNetworkDefinition item) {
    return new DefaultNetworkNested(item);
  }
  
  public DefaultNetworkNested<A> editDefaultNetwork() {
    return withNewDefaultNetworkLike(java.util.Optional.ofNullable(buildDefaultNetwork()).orElse(null));
  }
  
  public DefaultNetworkNested<A> editOrNewDefaultNetwork() {
    return withNewDefaultNetworkLike(java.util.Optional.ofNullable(buildDefaultNetwork()).orElse(new DefaultNetworkDefinitionBuilder().build()));
  }
  
  public DefaultNetworkNested<A> editOrNewDefaultNetworkLike(DefaultNetworkDefinition item) {
    return withNewDefaultNetworkLike(java.util.Optional.ofNullable(buildDefaultNetwork()).orElse(item));
  }
  
  public Boolean getDeployKubeProxy() {
    return this.deployKubeProxy;
  }
  
  public A withDeployKubeProxy(Boolean deployKubeProxy) {
    this.deployKubeProxy = deployKubeProxy;
    return (A) this;
  }
  
  public boolean hasDeployKubeProxy() {
    return this.deployKubeProxy != null;
  }
  
  public Boolean getDisableMultiNetwork() {
    return this.disableMultiNetwork;
  }
  
  public A withDisableMultiNetwork(Boolean disableMultiNetwork) {
    this.disableMultiNetwork = disableMultiNetwork;
    return (A) this;
  }
  
  public boolean hasDisableMultiNetwork() {
    return this.disableMultiNetwork != null;
  }
  
  public Boolean getDisableNetworkDiagnostics() {
    return this.disableNetworkDiagnostics;
  }
  
  public A withDisableNetworkDiagnostics(Boolean disableNetworkDiagnostics) {
    this.disableNetworkDiagnostics = disableNetworkDiagnostics;
    return (A) this;
  }
  
  public boolean hasDisableNetworkDiagnostics() {
    return this.disableNetworkDiagnostics != null;
  }
  
  public ExportNetworkFlows buildExportNetworkFlows() {
    return this.exportNetworkFlows != null ? this.exportNetworkFlows.build() : null;
  }
  
  public A withExportNetworkFlows(ExportNetworkFlows exportNetworkFlows) {
    this._visitables.remove("exportNetworkFlows");
    if (exportNetworkFlows != null) {
        this.exportNetworkFlows = new ExportNetworkFlowsBuilder(exportNetworkFlows);
        this._visitables.get("exportNetworkFlows").add(this.exportNetworkFlows);
    } else {
        this.exportNetworkFlows = null;
        this._visitables.get("exportNetworkFlows").remove(this.exportNetworkFlows);
    }
    return (A) this;
  }
  
  public boolean hasExportNetworkFlows() {
    return this.exportNetworkFlows != null;
  }
  
  public ExportNetworkFlowsNested<A> withNewExportNetworkFlows() {
    return new ExportNetworkFlowsNested(null);
  }
  
  public ExportNetworkFlowsNested<A> withNewExportNetworkFlowsLike(ExportNetworkFlows item) {
    return new ExportNetworkFlowsNested(item);
  }
  
  public ExportNetworkFlowsNested<A> editExportNetworkFlows() {
    return withNewExportNetworkFlowsLike(java.util.Optional.ofNullable(buildExportNetworkFlows()).orElse(null));
  }
  
  public ExportNetworkFlowsNested<A> editOrNewExportNetworkFlows() {
    return withNewExportNetworkFlowsLike(java.util.Optional.ofNullable(buildExportNetworkFlows()).orElse(new ExportNetworkFlowsBuilder().build()));
  }
  
  public ExportNetworkFlowsNested<A> editOrNewExportNetworkFlowsLike(ExportNetworkFlows item) {
    return withNewExportNetworkFlowsLike(java.util.Optional.ofNullable(buildExportNetworkFlows()).orElse(item));
  }
  
  public ProxyConfig buildKubeProxyConfig() {
    return this.kubeProxyConfig != null ? this.kubeProxyConfig.build() : null;
  }
  
  public A withKubeProxyConfig(ProxyConfig kubeProxyConfig) {
    this._visitables.remove("kubeProxyConfig");
    if (kubeProxyConfig != null) {
        this.kubeProxyConfig = new ProxyConfigBuilder(kubeProxyConfig);
        this._visitables.get("kubeProxyConfig").add(this.kubeProxyConfig);
    } else {
        this.kubeProxyConfig = null;
        this._visitables.get("kubeProxyConfig").remove(this.kubeProxyConfig);
    }
    return (A) this;
  }
  
  public boolean hasKubeProxyConfig() {
    return this.kubeProxyConfig != null;
  }
  
  public KubeProxyConfigNested<A> withNewKubeProxyConfig() {
    return new KubeProxyConfigNested(null);
  }
  
  public KubeProxyConfigNested<A> withNewKubeProxyConfigLike(ProxyConfig item) {
    return new KubeProxyConfigNested(item);
  }
  
  public KubeProxyConfigNested<A> editKubeProxyConfig() {
    return withNewKubeProxyConfigLike(java.util.Optional.ofNullable(buildKubeProxyConfig()).orElse(null));
  }
  
  public KubeProxyConfigNested<A> editOrNewKubeProxyConfig() {
    return withNewKubeProxyConfigLike(java.util.Optional.ofNullable(buildKubeProxyConfig()).orElse(new ProxyConfigBuilder().build()));
  }
  
  public KubeProxyConfigNested<A> editOrNewKubeProxyConfigLike(ProxyConfig item) {
    return withNewKubeProxyConfigLike(java.util.Optional.ofNullable(buildKubeProxyConfig()).orElse(item));
  }
  
  public String getLogLevel() {
    return this.logLevel;
  }
  
  public A withLogLevel(String logLevel) {
    this.logLevel = logLevel;
    return (A) this;
  }
  
  public boolean hasLogLevel() {
    return this.logLevel != null;
  }
  
  public String getManagementState() {
    return this.managementState;
  }
  
  public A withManagementState(String managementState) {
    this.managementState = managementState;
    return (A) this;
  }
  
  public boolean hasManagementState() {
    return this.managementState != null;
  }
  
  public NetworkMigration buildMigration() {
    return this.migration != null ? this.migration.build() : null;
  }
  
  public A withMigration(NetworkMigration migration) {
    this._visitables.remove("migration");
    if (migration != null) {
        this.migration = new NetworkMigrationBuilder(migration);
        this._visitables.get("migration").add(this.migration);
    } else {
        this.migration = null;
        this._visitables.get("migration").remove(this.migration);
    }
    return (A) this;
  }
  
  public boolean hasMigration() {
    return this.migration != null;
  }
  
  public MigrationNested<A> withNewMigration() {
    return new MigrationNested(null);
  }
  
  public MigrationNested<A> withNewMigrationLike(NetworkMigration item) {
    return new MigrationNested(item);
  }
  
  public MigrationNested<A> editMigration() {
    return withNewMigrationLike(java.util.Optional.ofNullable(buildMigration()).orElse(null));
  }
  
  public MigrationNested<A> editOrNewMigration() {
    return withNewMigrationLike(java.util.Optional.ofNullable(buildMigration()).orElse(new NetworkMigrationBuilder().build()));
  }
  
  public MigrationNested<A> editOrNewMigrationLike(NetworkMigration item) {
    return withNewMigrationLike(java.util.Optional.ofNullable(buildMigration()).orElse(item));
  }
  
  public Object getObservedConfig() {
    return this.observedConfig;
  }
  
  public A withObservedConfig(Object observedConfig) {
    this.observedConfig = observedConfig;
    return (A) this;
  }
  
  public boolean hasObservedConfig() {
    return this.observedConfig != null;
  }
  
  public String getOperatorLogLevel() {
    return this.operatorLogLevel;
  }
  
  public A withOperatorLogLevel(String operatorLogLevel) {
    this.operatorLogLevel = operatorLogLevel;
    return (A) this;
  }
  
  public boolean hasOperatorLogLevel() {
    return this.operatorLogLevel != null;
  }
  
  public A addToServiceNetwork(int index,String item) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
    this.serviceNetwork.add(index, item);
    return (A)this;
  }
  
  public A setToServiceNetwork(int index,String item) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
    this.serviceNetwork.set(index, item); return (A)this;
  }
  
  public A addToServiceNetwork(java.lang.String... items) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
    for (String item : items) {this.serviceNetwork.add(item);} return (A)this;
  }
  
  public A addAllToServiceNetwork(Collection<String> items) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
    for (String item : items) {this.serviceNetwork.add(item);} return (A)this;
  }
  
  public A removeFromServiceNetwork(java.lang.String... items) {
    if (this.serviceNetwork == null) return (A)this;
    for (String item : items) { this.serviceNetwork.remove(item);} return (A)this;
  }
  
  public A removeAllFromServiceNetwork(Collection<String> items) {
    if (this.serviceNetwork == null) return (A)this;
    for (String item : items) { this.serviceNetwork.remove(item);} return (A)this;
  }
  
  public List<String> getServiceNetwork() {
    return this.serviceNetwork;
  }
  
  public String getServiceNetwork(int index) {
    return this.serviceNetwork.get(index);
  }
  
  public String getFirstServiceNetwork() {
    return this.serviceNetwork.get(0);
  }
  
  public String getLastServiceNetwork() {
    return this.serviceNetwork.get(serviceNetwork.size() - 1);
  }
  
  public String getMatchingServiceNetwork(Predicate<String> predicate) {
      for (String item : serviceNetwork) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingServiceNetwork(Predicate<String> predicate) {
      for (String item : serviceNetwork) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withServiceNetwork(List<String> serviceNetwork) {
    if (serviceNetwork != null) {
        this.serviceNetwork = new ArrayList();
        for (String item : serviceNetwork) {
          this.addToServiceNetwork(item);
        }
    } else {
      this.serviceNetwork = null;
    }
    return (A) this;
  }
  
  public A withServiceNetwork(java.lang.String... serviceNetwork) {
    if (this.serviceNetwork != null) {
        this.serviceNetwork.clear();
        _visitables.remove("serviceNetwork");
    }
    if (serviceNetwork != null) {
      for (String item : serviceNetwork) {
        this.addToServiceNetwork(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasServiceNetwork() {
    return this.serviceNetwork != null && !this.serviceNetwork.isEmpty();
  }
  
  public Object getUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides;
  }
  
  public A withUnsupportedConfigOverrides(Object unsupportedConfigOverrides) {
    this.unsupportedConfigOverrides = unsupportedConfigOverrides;
    return (A) this;
  }
  
  public boolean hasUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides != null;
  }
  
  public Boolean getUseMultiNetworkPolicy() {
    return this.useMultiNetworkPolicy;
  }
  
  public A withUseMultiNetworkPolicy(Boolean useMultiNetworkPolicy) {
    this.useMultiNetworkPolicy = useMultiNetworkPolicy;
    return (A) this;
  }
  
  public boolean hasUseMultiNetworkPolicy() {
    return this.useMultiNetworkPolicy != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkSpecFluent that = (NetworkSpecFluent) o;
    if (!java.util.Objects.equals(additionalNetworks, that.additionalNetworks)) return false;
    if (!java.util.Objects.equals(additionalRoutingCapabilities, that.additionalRoutingCapabilities)) return false;
    if (!java.util.Objects.equals(clusterNetwork, that.clusterNetwork)) return false;
    if (!java.util.Objects.equals(defaultNetwork, that.defaultNetwork)) return false;
    if (!java.util.Objects.equals(deployKubeProxy, that.deployKubeProxy)) return false;
    if (!java.util.Objects.equals(disableMultiNetwork, that.disableMultiNetwork)) return false;
    if (!java.util.Objects.equals(disableNetworkDiagnostics, that.disableNetworkDiagnostics)) return false;
    if (!java.util.Objects.equals(exportNetworkFlows, that.exportNetworkFlows)) return false;
    if (!java.util.Objects.equals(kubeProxyConfig, that.kubeProxyConfig)) return false;
    if (!java.util.Objects.equals(logLevel, that.logLevel)) return false;
    if (!java.util.Objects.equals(managementState, that.managementState)) return false;
    if (!java.util.Objects.equals(migration, that.migration)) return false;
    if (!java.util.Objects.equals(observedConfig, that.observedConfig)) return false;
    if (!java.util.Objects.equals(operatorLogLevel, that.operatorLogLevel)) return false;
    if (!java.util.Objects.equals(serviceNetwork, that.serviceNetwork)) return false;
    if (!java.util.Objects.equals(unsupportedConfigOverrides, that.unsupportedConfigOverrides)) return false;
    if (!java.util.Objects.equals(useMultiNetworkPolicy, that.useMultiNetworkPolicy)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(additionalNetworks,  additionalRoutingCapabilities,  clusterNetwork,  defaultNetwork,  deployKubeProxy,  disableMultiNetwork,  disableNetworkDiagnostics,  exportNetworkFlows,  kubeProxyConfig,  logLevel,  managementState,  migration,  observedConfig,  operatorLogLevel,  serviceNetwork,  unsupportedConfigOverrides,  useMultiNetworkPolicy,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalNetworks != null && !additionalNetworks.isEmpty()) { sb.append("additionalNetworks:"); sb.append(additionalNetworks + ","); }
    if (additionalRoutingCapabilities != null) { sb.append("additionalRoutingCapabilities:"); sb.append(additionalRoutingCapabilities + ","); }
    if (clusterNetwork != null && !clusterNetwork.isEmpty()) { sb.append("clusterNetwork:"); sb.append(clusterNetwork + ","); }
    if (defaultNetwork != null) { sb.append("defaultNetwork:"); sb.append(defaultNetwork + ","); }
    if (deployKubeProxy != null) { sb.append("deployKubeProxy:"); sb.append(deployKubeProxy + ","); }
    if (disableMultiNetwork != null) { sb.append("disableMultiNetwork:"); sb.append(disableMultiNetwork + ","); }
    if (disableNetworkDiagnostics != null) { sb.append("disableNetworkDiagnostics:"); sb.append(disableNetworkDiagnostics + ","); }
    if (exportNetworkFlows != null) { sb.append("exportNetworkFlows:"); sb.append(exportNetworkFlows + ","); }
    if (kubeProxyConfig != null) { sb.append("kubeProxyConfig:"); sb.append(kubeProxyConfig + ","); }
    if (logLevel != null) { sb.append("logLevel:"); sb.append(logLevel + ","); }
    if (managementState != null) { sb.append("managementState:"); sb.append(managementState + ","); }
    if (migration != null) { sb.append("migration:"); sb.append(migration + ","); }
    if (observedConfig != null) { sb.append("observedConfig:"); sb.append(observedConfig + ","); }
    if (operatorLogLevel != null) { sb.append("operatorLogLevel:"); sb.append(operatorLogLevel + ","); }
    if (serviceNetwork != null && !serviceNetwork.isEmpty()) { sb.append("serviceNetwork:"); sb.append(serviceNetwork + ","); }
    if (unsupportedConfigOverrides != null) { sb.append("unsupportedConfigOverrides:"); sb.append(unsupportedConfigOverrides + ","); }
    if (useMultiNetworkPolicy != null) { sb.append("useMultiNetworkPolicy:"); sb.append(useMultiNetworkPolicy + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withDeployKubeProxy() {
    return withDeployKubeProxy(true);
  }
  
  public A withDisableMultiNetwork() {
    return withDisableMultiNetwork(true);
  }
  
  public A withDisableNetworkDiagnostics() {
    return withDisableNetworkDiagnostics(true);
  }
  
  public A withUseMultiNetworkPolicy() {
    return withUseMultiNetworkPolicy(true);
  }
  public class AdditionalNetworksNested<N> extends AdditionalNetworkDefinitionFluent<AdditionalNetworksNested<N>> implements Nested<N>{
    AdditionalNetworksNested(int index,AdditionalNetworkDefinition item) {
      this.index = index;
      this.builder = new AdditionalNetworkDefinitionBuilder(this, item);
    }
    AdditionalNetworkDefinitionBuilder builder;
    int index;
    
    public N and() {
      return (N) NetworkSpecFluent.this.setToAdditionalNetworks(index,builder.build());
    }
    
    public N endAdditionalNetwork() {
      return and();
    }
    
  
  }
  public class AdditionalRoutingCapabilitiesNested<N> extends AdditionalRoutingCapabilitiesFluent<AdditionalRoutingCapabilitiesNested<N>> implements Nested<N>{
    AdditionalRoutingCapabilitiesNested(AdditionalRoutingCapabilities item) {
      this.builder = new AdditionalRoutingCapabilitiesBuilder(this, item);
    }
    AdditionalRoutingCapabilitiesBuilder builder;
    
    public N and() {
      return (N) NetworkSpecFluent.this.withAdditionalRoutingCapabilities(builder.build());
    }
    
    public N endAdditionalRoutingCapabilities() {
      return and();
    }
    
  
  }
  public class ClusterNetworkNested<N> extends ClusterNetworkEntryFluent<ClusterNetworkNested<N>> implements Nested<N>{
    ClusterNetworkNested(int index,ClusterNetworkEntry item) {
      this.index = index;
      this.builder = new ClusterNetworkEntryBuilder(this, item);
    }
    ClusterNetworkEntryBuilder builder;
    int index;
    
    public N and() {
      return (N) NetworkSpecFluent.this.setToClusterNetwork(index,builder.build());
    }
    
    public N endClusterNetwork() {
      return and();
    }
    
  
  }
  public class DefaultNetworkNested<N> extends DefaultNetworkDefinitionFluent<DefaultNetworkNested<N>> implements Nested<N>{
    DefaultNetworkNested(DefaultNetworkDefinition item) {
      this.builder = new DefaultNetworkDefinitionBuilder(this, item);
    }
    DefaultNetworkDefinitionBuilder builder;
    
    public N and() {
      return (N) NetworkSpecFluent.this.withDefaultNetwork(builder.build());
    }
    
    public N endDefaultNetwork() {
      return and();
    }
    
  
  }
  public class ExportNetworkFlowsNested<N> extends ExportNetworkFlowsFluent<ExportNetworkFlowsNested<N>> implements Nested<N>{
    ExportNetworkFlowsNested(ExportNetworkFlows item) {
      this.builder = new ExportNetworkFlowsBuilder(this, item);
    }
    ExportNetworkFlowsBuilder builder;
    
    public N and() {
      return (N) NetworkSpecFluent.this.withExportNetworkFlows(builder.build());
    }
    
    public N endExportNetworkFlows() {
      return and();
    }
    
  
  }
  public class KubeProxyConfigNested<N> extends ProxyConfigFluent<KubeProxyConfigNested<N>> implements Nested<N>{
    KubeProxyConfigNested(ProxyConfig item) {
      this.builder = new ProxyConfigBuilder(this, item);
    }
    ProxyConfigBuilder builder;
    
    public N and() {
      return (N) NetworkSpecFluent.this.withKubeProxyConfig(builder.build());
    }
    
    public N endKubeProxyConfig() {
      return and();
    }
    
  
  }
  public class MigrationNested<N> extends NetworkMigrationFluent<MigrationNested<N>> implements Nested<N>{
    MigrationNested(NetworkMigration item) {
      this.builder = new NetworkMigrationBuilder(this, item);
    }
    NetworkMigrationBuilder builder;
    
    public N and() {
      return (N) NetworkSpecFluent.this.withMigration(builder.build());
    }
    
    public N endMigration() {
      return and();
    }
    
  
  }

}