package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class GatherStatusFluent<A extends GatherStatusFluent<A>> extends BaseFluent<A>{
  public GatherStatusFluent() {
  }
  
  public GatherStatusFluent(GatherStatus instance) {
    this.copyInstance(instance);
  }
  private ArrayList<GathererStatusBuilder> gatherers = new ArrayList<GathererStatusBuilder>();
  private String lastGatherDuration;
  private String lastGatherTime;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(GatherStatus instance) {
    instance = (instance != null ? instance : new GatherStatus());
    if (instance != null) {
          this.withGatherers(instance.getGatherers());
          this.withLastGatherDuration(instance.getLastGatherDuration());
          this.withLastGatherTime(instance.getLastGatherTime());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToGatherers(int index,GathererStatus item) {
    if (this.gatherers == null) {this.gatherers = new ArrayList<GathererStatusBuilder>();}
    GathererStatusBuilder builder = new GathererStatusBuilder(item);
    if (index < 0 || index >= gatherers.size()) {
        _visitables.get("gatherers").add(builder);
        gatherers.add(builder);
    } else {
        _visitables.get("gatherers").add(builder);
        gatherers.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToGatherers(int index,GathererStatus item) {
    if (this.gatherers == null) {this.gatherers = new ArrayList<GathererStatusBuilder>();}
    GathererStatusBuilder builder = new GathererStatusBuilder(item);
    if (index < 0 || index >= gatherers.size()) {
        _visitables.get("gatherers").add(builder);
        gatherers.add(builder);
    } else {
        _visitables.get("gatherers").add(builder);
        gatherers.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToGatherers(io.fabric8.openshift.api.model.operator.v1.GathererStatus... items) {
    if (this.gatherers == null) {this.gatherers = new ArrayList<GathererStatusBuilder>();}
    for (GathererStatus item : items) {GathererStatusBuilder builder = new GathererStatusBuilder(item);_visitables.get("gatherers").add(builder);this.gatherers.add(builder);} return (A)this;
  }
  
  public A addAllToGatherers(Collection<GathererStatus> items) {
    if (this.gatherers == null) {this.gatherers = new ArrayList<GathererStatusBuilder>();}
    for (GathererStatus item : items) {GathererStatusBuilder builder = new GathererStatusBuilder(item);_visitables.get("gatherers").add(builder);this.gatherers.add(builder);} return (A)this;
  }
  
  public A removeFromGatherers(io.fabric8.openshift.api.model.operator.v1.GathererStatus... items) {
    if (this.gatherers == null) return (A)this;
    for (GathererStatus item : items) {GathererStatusBuilder builder = new GathererStatusBuilder(item);_visitables.get("gatherers").remove(builder); this.gatherers.remove(builder);} return (A)this;
  }
  
  public A removeAllFromGatherers(Collection<GathererStatus> items) {
    if (this.gatherers == null) return (A)this;
    for (GathererStatus item : items) {GathererStatusBuilder builder = new GathererStatusBuilder(item);_visitables.get("gatherers").remove(builder); this.gatherers.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromGatherers(Predicate<GathererStatusBuilder> predicate) {
    if (gatherers == null) return (A) this;
    final Iterator<GathererStatusBuilder> each = gatherers.iterator();
    final List visitables = _visitables.get("gatherers");
    while (each.hasNext()) {
      GathererStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<GathererStatus> buildGatherers() {
    return this.gatherers != null ? build(gatherers) : null;
  }
  
  public GathererStatus buildGatherer(int index) {
    return this.gatherers.get(index).build();
  }
  
  public GathererStatus buildFirstGatherer() {
    return this.gatherers.get(0).build();
  }
  
  public GathererStatus buildLastGatherer() {
    return this.gatherers.get(gatherers.size() - 1).build();
  }
  
  public GathererStatus buildMatchingGatherer(Predicate<GathererStatusBuilder> predicate) {
      for (GathererStatusBuilder item : gatherers) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingGatherer(Predicate<GathererStatusBuilder> predicate) {
      for (GathererStatusBuilder item : gatherers) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withGatherers(List<GathererStatus> gatherers) {
    if (this.gatherers != null) {
      this._visitables.get("gatherers").clear();
    }
    if (gatherers != null) {
        this.gatherers = new ArrayList();
        for (GathererStatus item : gatherers) {
          this.addToGatherers(item);
        }
    } else {
      this.gatherers = null;
    }
    return (A) this;
  }
  
  public A withGatherers(io.fabric8.openshift.api.model.operator.v1.GathererStatus... gatherers) {
    if (this.gatherers != null) {
        this.gatherers.clear();
        _visitables.remove("gatherers");
    }
    if (gatherers != null) {
      for (GathererStatus item : gatherers) {
        this.addToGatherers(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasGatherers() {
    return this.gatherers != null && !this.gatherers.isEmpty();
  }
  
  public GatherersNested<A> addNewGatherer() {
    return new GatherersNested(-1, null);
  }
  
  public GatherersNested<A> addNewGathererLike(GathererStatus item) {
    return new GatherersNested(-1, item);
  }
  
  public GatherersNested<A> setNewGathererLike(int index,GathererStatus item) {
    return new GatherersNested(index, item);
  }
  
  public GatherersNested<A> editGatherer(int index) {
    if (gatherers.size() <= index) throw new RuntimeException("Can't edit gatherers. Index exceeds size.");
    return setNewGathererLike(index, buildGatherer(index));
  }
  
  public GatherersNested<A> editFirstGatherer() {
    if (gatherers.size() == 0) throw new RuntimeException("Can't edit first gatherers. The list is empty.");
    return setNewGathererLike(0, buildGatherer(0));
  }
  
  public GatherersNested<A> editLastGatherer() {
    int index = gatherers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last gatherers. The list is empty.");
    return setNewGathererLike(index, buildGatherer(index));
  }
  
  public GatherersNested<A> editMatchingGatherer(Predicate<GathererStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<gatherers.size();i++) { 
    if (predicate.test(gatherers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching gatherers. No match found.");
    return setNewGathererLike(index, buildGatherer(index));
  }
  
  public String getLastGatherDuration() {
    return this.lastGatherDuration;
  }
  
  public A withLastGatherDuration(String lastGatherDuration) {
    this.lastGatherDuration = lastGatherDuration;
    return (A) this;
  }
  
  public boolean hasLastGatherDuration() {
    return this.lastGatherDuration != null;
  }
  
  public String getLastGatherTime() {
    return this.lastGatherTime;
  }
  
  public A withLastGatherTime(String lastGatherTime) {
    this.lastGatherTime = lastGatherTime;
    return (A) this;
  }
  
  public boolean hasLastGatherTime() {
    return this.lastGatherTime != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GatherStatusFluent that = (GatherStatusFluent) o;
    if (!java.util.Objects.equals(gatherers, that.gatherers)) return false;
    if (!java.util.Objects.equals(lastGatherDuration, that.lastGatherDuration)) return false;
    if (!java.util.Objects.equals(lastGatherTime, that.lastGatherTime)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(gatherers,  lastGatherDuration,  lastGatherTime,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (gatherers != null && !gatherers.isEmpty()) { sb.append("gatherers:"); sb.append(gatherers + ","); }
    if (lastGatherDuration != null) { sb.append("lastGatherDuration:"); sb.append(lastGatherDuration + ","); }
    if (lastGatherTime != null) { sb.append("lastGatherTime:"); sb.append(lastGatherTime + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class GatherersNested<N> extends GathererStatusFluent<GatherersNested<N>> implements Nested<N>{
    GatherersNested(int index,GathererStatus item) {
      this.index = index;
      this.builder = new GathererStatusBuilder(this, item);
    }
    GathererStatusBuilder builder;
    int index;
    
    public N and() {
      return (N) GatherStatusFluent.this.setToGatherers(index,builder.build());
    }
    
    public N endGatherer() {
      return and();
    }
    
  
  }

}