package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GatherStatusBuilder extends GatherStatusFluent<GatherStatusBuilder> implements VisitableBuilder<GatherStatus,GatherStatusBuilder>{
  public GatherStatusBuilder() {
    this(new GatherStatus());
  }
  
  public GatherStatusBuilder(GatherStatusFluent<?> fluent) {
    this(fluent, new GatherStatus());
  }
  
  public GatherStatusBuilder(GatherStatusFluent<?> fluent,GatherStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GatherStatusBuilder(GatherStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GatherStatusFluent<?> fluent;
  
  public GatherStatus build() {
    GatherStatus buildable = new GatherStatus(fluent.buildGatherers(),fluent.getLastGatherDuration(),fluent.getLastGatherTime());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}