package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ConsoleSpecFluent<A extends ConsoleSpecFluent<A>> extends BaseFluent<A>{
  public ConsoleSpecFluent() {
  }
  
  public ConsoleSpecFluent(ConsoleSpec instance) {
    this.copyInstance(instance);
  }
  private ConsoleCustomizationBuilder customization;
  private IngressBuilder ingress;
  private String logLevel;
  private String managementState;
  private Object observedConfig;
  private String operatorLogLevel;
  private List<String> plugins = new ArrayList<String>();
  private ConsoleProvidersBuilder providers;
  private ConsoleConfigRouteBuilder route;
  private Object unsupportedConfigOverrides;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ConsoleSpec instance) {
    instance = (instance != null ? instance : new ConsoleSpec());
    if (instance != null) {
          this.withCustomization(instance.getCustomization());
          this.withIngress(instance.getIngress());
          this.withLogLevel(instance.getLogLevel());
          this.withManagementState(instance.getManagementState());
          this.withObservedConfig(instance.getObservedConfig());
          this.withOperatorLogLevel(instance.getOperatorLogLevel());
          this.withPlugins(instance.getPlugins());
          this.withProviders(instance.getProviders());
          this.withRoute(instance.getRoute());
          this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ConsoleCustomization buildCustomization() {
    return this.customization != null ? this.customization.build() : null;
  }
  
  public A withCustomization(ConsoleCustomization customization) {
    this._visitables.remove("customization");
    if (customization != null) {
        this.customization = new ConsoleCustomizationBuilder(customization);
        this._visitables.get("customization").add(this.customization);
    } else {
        this.customization = null;
        this._visitables.get("customization").remove(this.customization);
    }
    return (A) this;
  }
  
  public boolean hasCustomization() {
    return this.customization != null;
  }
  
  public CustomizationNested<A> withNewCustomization() {
    return new CustomizationNested(null);
  }
  
  public CustomizationNested<A> withNewCustomizationLike(ConsoleCustomization item) {
    return new CustomizationNested(item);
  }
  
  public CustomizationNested<A> editCustomization() {
    return withNewCustomizationLike(java.util.Optional.ofNullable(buildCustomization()).orElse(null));
  }
  
  public CustomizationNested<A> editOrNewCustomization() {
    return withNewCustomizationLike(java.util.Optional.ofNullable(buildCustomization()).orElse(new ConsoleCustomizationBuilder().build()));
  }
  
  public CustomizationNested<A> editOrNewCustomizationLike(ConsoleCustomization item) {
    return withNewCustomizationLike(java.util.Optional.ofNullable(buildCustomization()).orElse(item));
  }
  
  public Ingress buildIngress() {
    return this.ingress != null ? this.ingress.build() : null;
  }
  
  public A withIngress(Ingress ingress) {
    this._visitables.remove("ingress");
    if (ingress != null) {
        this.ingress = new IngressBuilder(ingress);
        this._visitables.get("ingress").add(this.ingress);
    } else {
        this.ingress = null;
        this._visitables.get("ingress").remove(this.ingress);
    }
    return (A) this;
  }
  
  public boolean hasIngress() {
    return this.ingress != null;
  }
  
  public A withNewIngress(String clientDownloadsURL,String consoleURL) {
    return (A)withIngress(new Ingress(clientDownloadsURL, consoleURL));
  }
  
  public IngressNested<A> withNewIngress() {
    return new IngressNested(null);
  }
  
  public IngressNested<A> withNewIngressLike(Ingress item) {
    return new IngressNested(item);
  }
  
  public IngressNested<A> editIngress() {
    return withNewIngressLike(java.util.Optional.ofNullable(buildIngress()).orElse(null));
  }
  
  public IngressNested<A> editOrNewIngress() {
    return withNewIngressLike(java.util.Optional.ofNullable(buildIngress()).orElse(new IngressBuilder().build()));
  }
  
  public IngressNested<A> editOrNewIngressLike(Ingress item) {
    return withNewIngressLike(java.util.Optional.ofNullable(buildIngress()).orElse(item));
  }
  
  public String getLogLevel() {
    return this.logLevel;
  }
  
  public A withLogLevel(String logLevel) {
    this.logLevel = logLevel;
    return (A) this;
  }
  
  public boolean hasLogLevel() {
    return this.logLevel != null;
  }
  
  public String getManagementState() {
    return this.managementState;
  }
  
  public A withManagementState(String managementState) {
    this.managementState = managementState;
    return (A) this;
  }
  
  public boolean hasManagementState() {
    return this.managementState != null;
  }
  
  public Object getObservedConfig() {
    return this.observedConfig;
  }
  
  public A withObservedConfig(Object observedConfig) {
    this.observedConfig = observedConfig;
    return (A) this;
  }
  
  public boolean hasObservedConfig() {
    return this.observedConfig != null;
  }
  
  public String getOperatorLogLevel() {
    return this.operatorLogLevel;
  }
  
  public A withOperatorLogLevel(String operatorLogLevel) {
    this.operatorLogLevel = operatorLogLevel;
    return (A) this;
  }
  
  public boolean hasOperatorLogLevel() {
    return this.operatorLogLevel != null;
  }
  
  public A addToPlugins(int index,String item) {
    if (this.plugins == null) {this.plugins = new ArrayList<String>();}
    this.plugins.add(index, item);
    return (A)this;
  }
  
  public A setToPlugins(int index,String item) {
    if (this.plugins == null) {this.plugins = new ArrayList<String>();}
    this.plugins.set(index, item); return (A)this;
  }
  
  public A addToPlugins(java.lang.String... items) {
    if (this.plugins == null) {this.plugins = new ArrayList<String>();}
    for (String item : items) {this.plugins.add(item);} return (A)this;
  }
  
  public A addAllToPlugins(Collection<String> items) {
    if (this.plugins == null) {this.plugins = new ArrayList<String>();}
    for (String item : items) {this.plugins.add(item);} return (A)this;
  }
  
  public A removeFromPlugins(java.lang.String... items) {
    if (this.plugins == null) return (A)this;
    for (String item : items) { this.plugins.remove(item);} return (A)this;
  }
  
  public A removeAllFromPlugins(Collection<String> items) {
    if (this.plugins == null) return (A)this;
    for (String item : items) { this.plugins.remove(item);} return (A)this;
  }
  
  public List<String> getPlugins() {
    return this.plugins;
  }
  
  public String getPlugin(int index) {
    return this.plugins.get(index);
  }
  
  public String getFirstPlugin() {
    return this.plugins.get(0);
  }
  
  public String getLastPlugin() {
    return this.plugins.get(plugins.size() - 1);
  }
  
  public String getMatchingPlugin(Predicate<String> predicate) {
      for (String item : plugins) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingPlugin(Predicate<String> predicate) {
      for (String item : plugins) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withPlugins(List<String> plugins) {
    if (plugins != null) {
        this.plugins = new ArrayList();
        for (String item : plugins) {
          this.addToPlugins(item);
        }
    } else {
      this.plugins = null;
    }
    return (A) this;
  }
  
  public A withPlugins(java.lang.String... plugins) {
    if (this.plugins != null) {
        this.plugins.clear();
        _visitables.remove("plugins");
    }
    if (plugins != null) {
      for (String item : plugins) {
        this.addToPlugins(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasPlugins() {
    return this.plugins != null && !this.plugins.isEmpty();
  }
  
  public ConsoleProviders buildProviders() {
    return this.providers != null ? this.providers.build() : null;
  }
  
  public A withProviders(ConsoleProviders providers) {
    this._visitables.remove("providers");
    if (providers != null) {
        this.providers = new ConsoleProvidersBuilder(providers);
        this._visitables.get("providers").add(this.providers);
    } else {
        this.providers = null;
        this._visitables.get("providers").remove(this.providers);
    }
    return (A) this;
  }
  
  public boolean hasProviders() {
    return this.providers != null;
  }
  
  public ProvidersNested<A> withNewProviders() {
    return new ProvidersNested(null);
  }
  
  public ProvidersNested<A> withNewProvidersLike(ConsoleProviders item) {
    return new ProvidersNested(item);
  }
  
  public ProvidersNested<A> editProviders() {
    return withNewProvidersLike(java.util.Optional.ofNullable(buildProviders()).orElse(null));
  }
  
  public ProvidersNested<A> editOrNewProviders() {
    return withNewProvidersLike(java.util.Optional.ofNullable(buildProviders()).orElse(new ConsoleProvidersBuilder().build()));
  }
  
  public ProvidersNested<A> editOrNewProvidersLike(ConsoleProviders item) {
    return withNewProvidersLike(java.util.Optional.ofNullable(buildProviders()).orElse(item));
  }
  
  public ConsoleConfigRoute buildRoute() {
    return this.route != null ? this.route.build() : null;
  }
  
  public A withRoute(ConsoleConfigRoute route) {
    this._visitables.remove("route");
    if (route != null) {
        this.route = new ConsoleConfigRouteBuilder(route);
        this._visitables.get("route").add(this.route);
    } else {
        this.route = null;
        this._visitables.get("route").remove(this.route);
    }
    return (A) this;
  }
  
  public boolean hasRoute() {
    return this.route != null;
  }
  
  public RouteNested<A> withNewRoute() {
    return new RouteNested(null);
  }
  
  public RouteNested<A> withNewRouteLike(ConsoleConfigRoute item) {
    return new RouteNested(item);
  }
  
  public RouteNested<A> editRoute() {
    return withNewRouteLike(java.util.Optional.ofNullable(buildRoute()).orElse(null));
  }
  
  public RouteNested<A> editOrNewRoute() {
    return withNewRouteLike(java.util.Optional.ofNullable(buildRoute()).orElse(new ConsoleConfigRouteBuilder().build()));
  }
  
  public RouteNested<A> editOrNewRouteLike(ConsoleConfigRoute item) {
    return withNewRouteLike(java.util.Optional.ofNullable(buildRoute()).orElse(item));
  }
  
  public Object getUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides;
  }
  
  public A withUnsupportedConfigOverrides(Object unsupportedConfigOverrides) {
    this.unsupportedConfigOverrides = unsupportedConfigOverrides;
    return (A) this;
  }
  
  public boolean hasUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConsoleSpecFluent that = (ConsoleSpecFluent) o;
    if (!java.util.Objects.equals(customization, that.customization)) return false;
    if (!java.util.Objects.equals(ingress, that.ingress)) return false;
    if (!java.util.Objects.equals(logLevel, that.logLevel)) return false;
    if (!java.util.Objects.equals(managementState, that.managementState)) return false;
    if (!java.util.Objects.equals(observedConfig, that.observedConfig)) return false;
    if (!java.util.Objects.equals(operatorLogLevel, that.operatorLogLevel)) return false;
    if (!java.util.Objects.equals(plugins, that.plugins)) return false;
    if (!java.util.Objects.equals(providers, that.providers)) return false;
    if (!java.util.Objects.equals(route, that.route)) return false;
    if (!java.util.Objects.equals(unsupportedConfigOverrides, that.unsupportedConfigOverrides)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(customization,  ingress,  logLevel,  managementState,  observedConfig,  operatorLogLevel,  plugins,  providers,  route,  unsupportedConfigOverrides,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (customization != null) { sb.append("customization:"); sb.append(customization + ","); }
    if (ingress != null) { sb.append("ingress:"); sb.append(ingress + ","); }
    if (logLevel != null) { sb.append("logLevel:"); sb.append(logLevel + ","); }
    if (managementState != null) { sb.append("managementState:"); sb.append(managementState + ","); }
    if (observedConfig != null) { sb.append("observedConfig:"); sb.append(observedConfig + ","); }
    if (operatorLogLevel != null) { sb.append("operatorLogLevel:"); sb.append(operatorLogLevel + ","); }
    if (plugins != null && !plugins.isEmpty()) { sb.append("plugins:"); sb.append(plugins + ","); }
    if (providers != null) { sb.append("providers:"); sb.append(providers + ","); }
    if (route != null) { sb.append("route:"); sb.append(route + ","); }
    if (unsupportedConfigOverrides != null) { sb.append("unsupportedConfigOverrides:"); sb.append(unsupportedConfigOverrides + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CustomizationNested<N> extends ConsoleCustomizationFluent<CustomizationNested<N>> implements Nested<N>{
    CustomizationNested(ConsoleCustomization item) {
      this.builder = new ConsoleCustomizationBuilder(this, item);
    }
    ConsoleCustomizationBuilder builder;
    
    public N and() {
      return (N) ConsoleSpecFluent.this.withCustomization(builder.build());
    }
    
    public N endCustomization() {
      return and();
    }
    
  
  }
  public class IngressNested<N> extends IngressFluent<IngressNested<N>> implements Nested<N>{
    IngressNested(Ingress item) {
      this.builder = new IngressBuilder(this, item);
    }
    IngressBuilder builder;
    
    public N and() {
      return (N) ConsoleSpecFluent.this.withIngress(builder.build());
    }
    
    public N endIngress() {
      return and();
    }
    
  
  }
  public class ProvidersNested<N> extends ConsoleProvidersFluent<ProvidersNested<N>> implements Nested<N>{
    ProvidersNested(ConsoleProviders item) {
      this.builder = new ConsoleProvidersBuilder(this, item);
    }
    ConsoleProvidersBuilder builder;
    
    public N and() {
      return (N) ConsoleSpecFluent.this.withProviders(builder.build());
    }
    
    public N endProviders() {
      return and();
    }
    
  
  }
  public class RouteNested<N> extends ConsoleConfigRouteFluent<RouteNested<N>> implements Nested<N>{
    RouteNested(ConsoleConfigRoute item) {
      this.builder = new ConsoleConfigRouteBuilder(this, item);
    }
    ConsoleConfigRouteBuilder builder;
    
    public N and() {
      return (N) ConsoleSpecFluent.this.withRoute(builder.build());
    }
    
    public N endRoute() {
      return and();
    }
    
  
  }

}