package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AWSCSIDriverConfigSpecFluent<A extends AWSCSIDriverConfigSpecFluent<A>> extends BaseFluent<A>{
  public AWSCSIDriverConfigSpecFluent() {
  }
  
  public AWSCSIDriverConfigSpecFluent(AWSCSIDriverConfigSpec instance) {
    this.copyInstance(instance);
  }
  private AWSEFSVolumeMetricsBuilder efsVolumeMetrics;
  private String kmsKeyARN;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AWSCSIDriverConfigSpec instance) {
    instance = (instance != null ? instance : new AWSCSIDriverConfigSpec());
    if (instance != null) {
          this.withEfsVolumeMetrics(instance.getEfsVolumeMetrics());
          this.withKmsKeyARN(instance.getKmsKeyARN());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public AWSEFSVolumeMetrics buildEfsVolumeMetrics() {
    return this.efsVolumeMetrics != null ? this.efsVolumeMetrics.build() : null;
  }
  
  public A withEfsVolumeMetrics(AWSEFSVolumeMetrics efsVolumeMetrics) {
    this._visitables.remove("efsVolumeMetrics");
    if (efsVolumeMetrics != null) {
        this.efsVolumeMetrics = new AWSEFSVolumeMetricsBuilder(efsVolumeMetrics);
        this._visitables.get("efsVolumeMetrics").add(this.efsVolumeMetrics);
    } else {
        this.efsVolumeMetrics = null;
        this._visitables.get("efsVolumeMetrics").remove(this.efsVolumeMetrics);
    }
    return (A) this;
  }
  
  public boolean hasEfsVolumeMetrics() {
    return this.efsVolumeMetrics != null;
  }
  
  public EfsVolumeMetricsNested<A> withNewEfsVolumeMetrics() {
    return new EfsVolumeMetricsNested(null);
  }
  
  public EfsVolumeMetricsNested<A> withNewEfsVolumeMetricsLike(AWSEFSVolumeMetrics item) {
    return new EfsVolumeMetricsNested(item);
  }
  
  public EfsVolumeMetricsNested<A> editEfsVolumeMetrics() {
    return withNewEfsVolumeMetricsLike(java.util.Optional.ofNullable(buildEfsVolumeMetrics()).orElse(null));
  }
  
  public EfsVolumeMetricsNested<A> editOrNewEfsVolumeMetrics() {
    return withNewEfsVolumeMetricsLike(java.util.Optional.ofNullable(buildEfsVolumeMetrics()).orElse(new AWSEFSVolumeMetricsBuilder().build()));
  }
  
  public EfsVolumeMetricsNested<A> editOrNewEfsVolumeMetricsLike(AWSEFSVolumeMetrics item) {
    return withNewEfsVolumeMetricsLike(java.util.Optional.ofNullable(buildEfsVolumeMetrics()).orElse(item));
  }
  
  public String getKmsKeyARN() {
    return this.kmsKeyARN;
  }
  
  public A withKmsKeyARN(String kmsKeyARN) {
    this.kmsKeyARN = kmsKeyARN;
    return (A) this;
  }
  
  public boolean hasKmsKeyARN() {
    return this.kmsKeyARN != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AWSCSIDriverConfigSpecFluent that = (AWSCSIDriverConfigSpecFluent) o;
    if (!java.util.Objects.equals(efsVolumeMetrics, that.efsVolumeMetrics)) return false;
    if (!java.util.Objects.equals(kmsKeyARN, that.kmsKeyARN)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(efsVolumeMetrics,  kmsKeyARN,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (efsVolumeMetrics != null) { sb.append("efsVolumeMetrics:"); sb.append(efsVolumeMetrics + ","); }
    if (kmsKeyARN != null) { sb.append("kmsKeyARN:"); sb.append(kmsKeyARN + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class EfsVolumeMetricsNested<N> extends AWSEFSVolumeMetricsFluent<EfsVolumeMetricsNested<N>> implements Nested<N>{
    EfsVolumeMetricsNested(AWSEFSVolumeMetrics item) {
      this.builder = new AWSEFSVolumeMetricsBuilder(this, item);
    }
    AWSEFSVolumeMetricsBuilder builder;
    
    public N and() {
      return (N) AWSCSIDriverConfigSpecFluent.this.withEfsVolumeMetrics(builder.build());
    }
    
    public N endEfsVolumeMetrics() {
      return and();
    }
    
  
  }

}