package io.fabric8.openshift.api.model.operator.imageregistry.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ImageRegistryConfigStorageAzureFluent<A extends ImageRegistryConfigStorageAzureFluent<A>> extends BaseFluent<A>{
  public ImageRegistryConfigStorageAzureFluent() {
  }
  
  public ImageRegistryConfigStorageAzureFluent(ImageRegistryConfigStorageAzure instance) {
    this.copyInstance(instance);
  }
  private String accountName;
  private String cloudName;
  private String container;
  private AzureNetworkAccessBuilder networkAccess;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ImageRegistryConfigStorageAzure instance) {
    instance = (instance != null ? instance : new ImageRegistryConfigStorageAzure());
    if (instance != null) {
          this.withAccountName(instance.getAccountName());
          this.withCloudName(instance.getCloudName());
          this.withContainer(instance.getContainer());
          this.withNetworkAccess(instance.getNetworkAccess());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getAccountName() {
    return this.accountName;
  }
  
  public A withAccountName(String accountName) {
    this.accountName = accountName;
    return (A) this;
  }
  
  public boolean hasAccountName() {
    return this.accountName != null;
  }
  
  public String getCloudName() {
    return this.cloudName;
  }
  
  public A withCloudName(String cloudName) {
    this.cloudName = cloudName;
    return (A) this;
  }
  
  public boolean hasCloudName() {
    return this.cloudName != null;
  }
  
  public String getContainer() {
    return this.container;
  }
  
  public A withContainer(String container) {
    this.container = container;
    return (A) this;
  }
  
  public boolean hasContainer() {
    return this.container != null;
  }
  
  public AzureNetworkAccess buildNetworkAccess() {
    return this.networkAccess != null ? this.networkAccess.build() : null;
  }
  
  public A withNetworkAccess(AzureNetworkAccess networkAccess) {
    this._visitables.remove("networkAccess");
    if (networkAccess != null) {
        this.networkAccess = new AzureNetworkAccessBuilder(networkAccess);
        this._visitables.get("networkAccess").add(this.networkAccess);
    } else {
        this.networkAccess = null;
        this._visitables.get("networkAccess").remove(this.networkAccess);
    }
    return (A) this;
  }
  
  public boolean hasNetworkAccess() {
    return this.networkAccess != null;
  }
  
  public NetworkAccessNested<A> withNewNetworkAccess() {
    return new NetworkAccessNested(null);
  }
  
  public NetworkAccessNested<A> withNewNetworkAccessLike(AzureNetworkAccess item) {
    return new NetworkAccessNested(item);
  }
  
  public NetworkAccessNested<A> editNetworkAccess() {
    return withNewNetworkAccessLike(java.util.Optional.ofNullable(buildNetworkAccess()).orElse(null));
  }
  
  public NetworkAccessNested<A> editOrNewNetworkAccess() {
    return withNewNetworkAccessLike(java.util.Optional.ofNullable(buildNetworkAccess()).orElse(new AzureNetworkAccessBuilder().build()));
  }
  
  public NetworkAccessNested<A> editOrNewNetworkAccessLike(AzureNetworkAccess item) {
    return withNewNetworkAccessLike(java.util.Optional.ofNullable(buildNetworkAccess()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageRegistryConfigStorageAzureFluent that = (ImageRegistryConfigStorageAzureFluent) o;
    if (!java.util.Objects.equals(accountName, that.accountName)) return false;
    if (!java.util.Objects.equals(cloudName, that.cloudName)) return false;
    if (!java.util.Objects.equals(container, that.container)) return false;
    if (!java.util.Objects.equals(networkAccess, that.networkAccess)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(accountName,  cloudName,  container,  networkAccess,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (accountName != null) { sb.append("accountName:"); sb.append(accountName + ","); }
    if (cloudName != null) { sb.append("cloudName:"); sb.append(cloudName + ","); }
    if (container != null) { sb.append("container:"); sb.append(container + ","); }
    if (networkAccess != null) { sb.append("networkAccess:"); sb.append(networkAccess + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class NetworkAccessNested<N> extends AzureNetworkAccessFluent<NetworkAccessNested<N>> implements Nested<N>{
    NetworkAccessNested(AzureNetworkAccess item) {
      this.builder = new AzureNetworkAccessBuilder(this, item);
    }
    AzureNetworkAccessBuilder builder;
    
    public N and() {
      return (N) ImageRegistryConfigStorageAzureFluent.this.withNetworkAccess(builder.build());
    }
    
    public N endNetworkAccess() {
      return and();
    }
    
  
  }

}