/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.NodeDisruptionPolicyConfig;
import io.fabric8.openshift.api.model.operator.v1.NodeDisruptionPolicySpecFile;
import io.fabric8.openshift.api.model.operator.v1.NodeDisruptionPolicySpecFileBuilder;
import io.fabric8.openshift.api.model.operator.v1.NodeDisruptionPolicySpecFileFluent;
import io.fabric8.openshift.api.model.operator.v1.NodeDisruptionPolicySpecSSHKey;
import io.fabric8.openshift.api.model.operator.v1.NodeDisruptionPolicySpecSSHKeyBuilder;
import io.fabric8.openshift.api.model.operator.v1.NodeDisruptionPolicySpecSSHKeyFluent;
import io.fabric8.openshift.api.model.operator.v1.NodeDisruptionPolicySpecUnit;
import io.fabric8.openshift.api.model.operator.v1.NodeDisruptionPolicySpecUnitBuilder;
import io.fabric8.openshift.api.model.operator.v1.NodeDisruptionPolicySpecUnitFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class NodeDisruptionPolicyConfigFluent<A extends NodeDisruptionPolicyConfigFluent<A>>
extends BaseFluent<A> {
    private ArrayList<NodeDisruptionPolicySpecFileBuilder> files = new ArrayList();
    private NodeDisruptionPolicySpecSSHKeyBuilder sshkey;
    private ArrayList<NodeDisruptionPolicySpecUnitBuilder> units = new ArrayList();
    private Map<String, Object> additionalProperties;

    public NodeDisruptionPolicyConfigFluent() {
    }

    public NodeDisruptionPolicyConfigFluent(NodeDisruptionPolicyConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NodeDisruptionPolicyConfig instance) {
        NodeDisruptionPolicyConfig nodeDisruptionPolicyConfig = instance = instance != null ? instance : new NodeDisruptionPolicyConfig();
        if (instance != null) {
            this.withFiles(instance.getFiles());
            this.withSshkey(instance.getSshkey());
            this.withUnits(instance.getUnits());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToFiles(int index, NodeDisruptionPolicySpecFile item) {
        if (this.files == null) {
            this.files = new ArrayList();
        }
        NodeDisruptionPolicySpecFileBuilder builder = new NodeDisruptionPolicySpecFileBuilder(item);
        if (index < 0 || index >= this.files.size()) {
            this._visitables.get((Object)"files").add(builder);
            this.files.add(builder);
        } else {
            this._visitables.get((Object)"files").add(index, builder);
            this.files.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToFiles(int index, NodeDisruptionPolicySpecFile item) {
        if (this.files == null) {
            this.files = new ArrayList();
        }
        NodeDisruptionPolicySpecFileBuilder builder = new NodeDisruptionPolicySpecFileBuilder(item);
        if (index < 0 || index >= this.files.size()) {
            this._visitables.get((Object)"files").add(builder);
            this.files.add(builder);
        } else {
            this._visitables.get((Object)"files").set(index, builder);
            this.files.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToFiles(NodeDisruptionPolicySpecFile ... items) {
        if (this.files == null) {
            this.files = new ArrayList();
        }
        for (NodeDisruptionPolicySpecFile item : items) {
            NodeDisruptionPolicySpecFileBuilder builder = new NodeDisruptionPolicySpecFileBuilder(item);
            this._visitables.get((Object)"files").add(builder);
            this.files.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToFiles(Collection<NodeDisruptionPolicySpecFile> items) {
        if (this.files == null) {
            this.files = new ArrayList();
        }
        for (NodeDisruptionPolicySpecFile item : items) {
            NodeDisruptionPolicySpecFileBuilder builder = new NodeDisruptionPolicySpecFileBuilder(item);
            this._visitables.get((Object)"files").add(builder);
            this.files.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromFiles(NodeDisruptionPolicySpecFile ... items) {
        if (this.files == null) {
            return (A)((Object)this);
        }
        for (NodeDisruptionPolicySpecFile item : items) {
            NodeDisruptionPolicySpecFileBuilder builder = new NodeDisruptionPolicySpecFileBuilder(item);
            this._visitables.get((Object)"files").remove((Object)builder);
            this.files.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromFiles(Collection<NodeDisruptionPolicySpecFile> items) {
        if (this.files == null) {
            return (A)((Object)this);
        }
        for (NodeDisruptionPolicySpecFile item : items) {
            NodeDisruptionPolicySpecFileBuilder builder = new NodeDisruptionPolicySpecFileBuilder(item);
            this._visitables.get((Object)"files").remove((Object)builder);
            this.files.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromFiles(Predicate<NodeDisruptionPolicySpecFileBuilder> predicate) {
        if (this.files == null) {
            return (A)((Object)this);
        }
        Iterator<NodeDisruptionPolicySpecFileBuilder> each = this.files.iterator();
        List visitables = this._visitables.get((Object)"files");
        while (each.hasNext()) {
            NodeDisruptionPolicySpecFileBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<NodeDisruptionPolicySpecFile> buildFiles() {
        return this.files != null ? NodeDisruptionPolicyConfigFluent.build(this.files) : null;
    }

    public NodeDisruptionPolicySpecFile buildFile(int index) {
        return this.files.get(index).build();
    }

    public NodeDisruptionPolicySpecFile buildFirstFile() {
        return this.files.get(0).build();
    }

    public NodeDisruptionPolicySpecFile buildLastFile() {
        return this.files.get(this.files.size() - 1).build();
    }

    public NodeDisruptionPolicySpecFile buildMatchingFile(Predicate<NodeDisruptionPolicySpecFileBuilder> predicate) {
        for (NodeDisruptionPolicySpecFileBuilder item : this.files) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingFile(Predicate<NodeDisruptionPolicySpecFileBuilder> predicate) {
        for (NodeDisruptionPolicySpecFileBuilder item : this.files) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFiles(List<NodeDisruptionPolicySpecFile> files) {
        if (this.files != null) {
            this._visitables.get((Object)"files").clear();
        }
        if (files != null) {
            this.files = new ArrayList();
            for (NodeDisruptionPolicySpecFile item : files) {
                this.addToFiles(item);
            }
        } else {
            this.files = null;
        }
        return (A)((Object)this);
    }

    public A withFiles(NodeDisruptionPolicySpecFile ... files) {
        if (this.files != null) {
            this.files.clear();
            this._visitables.remove((Object)"files");
        }
        if (files != null) {
            for (NodeDisruptionPolicySpecFile item : files) {
                this.addToFiles(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasFiles() {
        return this.files != null && !this.files.isEmpty();
    }

    public FilesNested<A> addNewFile() {
        return new FilesNested(-1, null);
    }

    public FilesNested<A> addNewFileLike(NodeDisruptionPolicySpecFile item) {
        return new FilesNested(-1, item);
    }

    public FilesNested<A> setNewFileLike(int index, NodeDisruptionPolicySpecFile item) {
        return new FilesNested(index, item);
    }

    public FilesNested<A> editFile(int index) {
        if (this.files.size() <= index) {
            throw new RuntimeException("Can't edit files. Index exceeds size.");
        }
        return this.setNewFileLike(index, this.buildFile(index));
    }

    public FilesNested<A> editFirstFile() {
        if (this.files.size() == 0) {
            throw new RuntimeException("Can't edit first files. The list is empty.");
        }
        return this.setNewFileLike(0, this.buildFile(0));
    }

    public FilesNested<A> editLastFile() {
        int index = this.files.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last files. The list is empty.");
        }
        return this.setNewFileLike(index, this.buildFile(index));
    }

    public FilesNested<A> editMatchingFile(Predicate<NodeDisruptionPolicySpecFileBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.files.size(); ++i) {
            if (!predicate.test(this.files.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching files. No match found.");
        }
        return this.setNewFileLike(index, this.buildFile(index));
    }

    public NodeDisruptionPolicySpecSSHKey buildSshkey() {
        return this.sshkey != null ? this.sshkey.build() : null;
    }

    public A withSshkey(NodeDisruptionPolicySpecSSHKey sshkey) {
        this._visitables.remove((Object)"sshkey");
        if (sshkey != null) {
            this.sshkey = new NodeDisruptionPolicySpecSSHKeyBuilder(sshkey);
            this._visitables.get((Object)"sshkey").add(this.sshkey);
        } else {
            this.sshkey = null;
            this._visitables.get((Object)"sshkey").remove((Object)this.sshkey);
        }
        return (A)((Object)this);
    }

    public boolean hasSshkey() {
        return this.sshkey != null;
    }

    public SshkeyNested<A> withNewSshkey() {
        return new SshkeyNested(null);
    }

    public SshkeyNested<A> withNewSshkeyLike(NodeDisruptionPolicySpecSSHKey item) {
        return new SshkeyNested(item);
    }

    public SshkeyNested<A> editSshkey() {
        return this.withNewSshkeyLike(Optional.ofNullable(this.buildSshkey()).orElse(null));
    }

    public SshkeyNested<A> editOrNewSshkey() {
        return this.withNewSshkeyLike(Optional.ofNullable(this.buildSshkey()).orElse(new NodeDisruptionPolicySpecSSHKeyBuilder().build()));
    }

    public SshkeyNested<A> editOrNewSshkeyLike(NodeDisruptionPolicySpecSSHKey item) {
        return this.withNewSshkeyLike(Optional.ofNullable(this.buildSshkey()).orElse(item));
    }

    public A addToUnits(int index, NodeDisruptionPolicySpecUnit item) {
        if (this.units == null) {
            this.units = new ArrayList();
        }
        NodeDisruptionPolicySpecUnitBuilder builder = new NodeDisruptionPolicySpecUnitBuilder(item);
        if (index < 0 || index >= this.units.size()) {
            this._visitables.get((Object)"units").add(builder);
            this.units.add(builder);
        } else {
            this._visitables.get((Object)"units").add(index, builder);
            this.units.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToUnits(int index, NodeDisruptionPolicySpecUnit item) {
        if (this.units == null) {
            this.units = new ArrayList();
        }
        NodeDisruptionPolicySpecUnitBuilder builder = new NodeDisruptionPolicySpecUnitBuilder(item);
        if (index < 0 || index >= this.units.size()) {
            this._visitables.get((Object)"units").add(builder);
            this.units.add(builder);
        } else {
            this._visitables.get((Object)"units").set(index, builder);
            this.units.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToUnits(NodeDisruptionPolicySpecUnit ... items) {
        if (this.units == null) {
            this.units = new ArrayList();
        }
        for (NodeDisruptionPolicySpecUnit item : items) {
            NodeDisruptionPolicySpecUnitBuilder builder = new NodeDisruptionPolicySpecUnitBuilder(item);
            this._visitables.get((Object)"units").add(builder);
            this.units.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToUnits(Collection<NodeDisruptionPolicySpecUnit> items) {
        if (this.units == null) {
            this.units = new ArrayList();
        }
        for (NodeDisruptionPolicySpecUnit item : items) {
            NodeDisruptionPolicySpecUnitBuilder builder = new NodeDisruptionPolicySpecUnitBuilder(item);
            this._visitables.get((Object)"units").add(builder);
            this.units.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromUnits(NodeDisruptionPolicySpecUnit ... items) {
        if (this.units == null) {
            return (A)((Object)this);
        }
        for (NodeDisruptionPolicySpecUnit item : items) {
            NodeDisruptionPolicySpecUnitBuilder builder = new NodeDisruptionPolicySpecUnitBuilder(item);
            this._visitables.get((Object)"units").remove((Object)builder);
            this.units.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromUnits(Collection<NodeDisruptionPolicySpecUnit> items) {
        if (this.units == null) {
            return (A)((Object)this);
        }
        for (NodeDisruptionPolicySpecUnit item : items) {
            NodeDisruptionPolicySpecUnitBuilder builder = new NodeDisruptionPolicySpecUnitBuilder(item);
            this._visitables.get((Object)"units").remove((Object)builder);
            this.units.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromUnits(Predicate<NodeDisruptionPolicySpecUnitBuilder> predicate) {
        if (this.units == null) {
            return (A)((Object)this);
        }
        Iterator<NodeDisruptionPolicySpecUnitBuilder> each = this.units.iterator();
        List visitables = this._visitables.get((Object)"units");
        while (each.hasNext()) {
            NodeDisruptionPolicySpecUnitBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<NodeDisruptionPolicySpecUnit> buildUnits() {
        return this.units != null ? NodeDisruptionPolicyConfigFluent.build(this.units) : null;
    }

    public NodeDisruptionPolicySpecUnit buildUnit(int index) {
        return this.units.get(index).build();
    }

    public NodeDisruptionPolicySpecUnit buildFirstUnit() {
        return this.units.get(0).build();
    }

    public NodeDisruptionPolicySpecUnit buildLastUnit() {
        return this.units.get(this.units.size() - 1).build();
    }

    public NodeDisruptionPolicySpecUnit buildMatchingUnit(Predicate<NodeDisruptionPolicySpecUnitBuilder> predicate) {
        for (NodeDisruptionPolicySpecUnitBuilder item : this.units) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingUnit(Predicate<NodeDisruptionPolicySpecUnitBuilder> predicate) {
        for (NodeDisruptionPolicySpecUnitBuilder item : this.units) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withUnits(List<NodeDisruptionPolicySpecUnit> units) {
        if (this.units != null) {
            this._visitables.get((Object)"units").clear();
        }
        if (units != null) {
            this.units = new ArrayList();
            for (NodeDisruptionPolicySpecUnit item : units) {
                this.addToUnits(item);
            }
        } else {
            this.units = null;
        }
        return (A)((Object)this);
    }

    public A withUnits(NodeDisruptionPolicySpecUnit ... units) {
        if (this.units != null) {
            this.units.clear();
            this._visitables.remove((Object)"units");
        }
        if (units != null) {
            for (NodeDisruptionPolicySpecUnit item : units) {
                this.addToUnits(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasUnits() {
        return this.units != null && !this.units.isEmpty();
    }

    public UnitsNested<A> addNewUnit() {
        return new UnitsNested(-1, null);
    }

    public UnitsNested<A> addNewUnitLike(NodeDisruptionPolicySpecUnit item) {
        return new UnitsNested(-1, item);
    }

    public UnitsNested<A> setNewUnitLike(int index, NodeDisruptionPolicySpecUnit item) {
        return new UnitsNested(index, item);
    }

    public UnitsNested<A> editUnit(int index) {
        if (this.units.size() <= index) {
            throw new RuntimeException("Can't edit units. Index exceeds size.");
        }
        return this.setNewUnitLike(index, this.buildUnit(index));
    }

    public UnitsNested<A> editFirstUnit() {
        if (this.units.size() == 0) {
            throw new RuntimeException("Can't edit first units. The list is empty.");
        }
        return this.setNewUnitLike(0, this.buildUnit(0));
    }

    public UnitsNested<A> editLastUnit() {
        int index = this.units.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last units. The list is empty.");
        }
        return this.setNewUnitLike(index, this.buildUnit(index));
    }

    public UnitsNested<A> editMatchingUnit(Predicate<NodeDisruptionPolicySpecUnitBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.units.size(); ++i) {
            if (!predicate.test(this.units.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching units. No match found.");
        }
        return this.setNewUnitLike(index, this.buildUnit(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeDisruptionPolicyConfigFluent that = (NodeDisruptionPolicyConfigFluent)((Object)o);
        if (!Objects.equals(this.files, that.files)) {
            return false;
        }
        if (!Objects.equals((Object)this.sshkey, (Object)that.sshkey)) {
            return false;
        }
        if (!Objects.equals(this.units, that.units)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.files, this.sshkey, this.units, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.files != null && !this.files.isEmpty()) {
            sb.append("files:");
            sb.append(this.files + ",");
        }
        if (this.sshkey != null) {
            sb.append("sshkey:");
            sb.append(this.sshkey + ",");
        }
        if (this.units != null && !this.units.isEmpty()) {
            sb.append("units:");
            sb.append(this.units + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class UnitsNested<N>
    extends NodeDisruptionPolicySpecUnitFluent<UnitsNested<N>>
    implements Nested<N> {
        NodeDisruptionPolicySpecUnitBuilder builder;
        int index;

        UnitsNested(int index, NodeDisruptionPolicySpecUnit item) {
            this.index = index;
            this.builder = new NodeDisruptionPolicySpecUnitBuilder(this, item);
        }

        public N and() {
            return (N)NodeDisruptionPolicyConfigFluent.this.setToUnits(this.index, this.builder.build());
        }

        public N endUnit() {
            return this.and();
        }
    }

    public class SshkeyNested<N>
    extends NodeDisruptionPolicySpecSSHKeyFluent<SshkeyNested<N>>
    implements Nested<N> {
        NodeDisruptionPolicySpecSSHKeyBuilder builder;

        SshkeyNested(NodeDisruptionPolicySpecSSHKey item) {
            this.builder = new NodeDisruptionPolicySpecSSHKeyBuilder(this, item);
        }

        public N and() {
            return (N)NodeDisruptionPolicyConfigFluent.this.withSshkey(this.builder.build());
        }

        public N endSshkey() {
            return this.and();
        }
    }

    public class FilesNested<N>
    extends NodeDisruptionPolicySpecFileFluent<FilesNested<N>>
    implements Nested<N> {
        NodeDisruptionPolicySpecFileBuilder builder;
        int index;

        FilesNested(int index, NodeDisruptionPolicySpecFile item) {
            this.index = index;
            this.builder = new NodeDisruptionPolicySpecFileBuilder(this, item);
        }

        public N and() {
            return (N)NodeDisruptionPolicyConfigFluent.this.setToFiles(this.index, this.builder.build());
        }

        public N endFile() {
            return this.and();
        }
    }
}

