package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NodeStatusBuilder extends NodeStatusFluent<NodeStatusBuilder> implements VisitableBuilder<NodeStatus,NodeStatusBuilder>{
  public NodeStatusBuilder() {
    this(new NodeStatus());
  }
  
  public NodeStatusBuilder(NodeStatusFluent<?> fluent) {
    this(fluent, new NodeStatus());
  }
  
  public NodeStatusBuilder(NodeStatusFluent<?> fluent,NodeStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NodeStatusBuilder(NodeStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NodeStatusFluent<?> fluent;
  
  public NodeStatus build() {
    NodeStatus buildable = new NodeStatus(fluent.getCurrentRevision(),fluent.getLastFailedCount(),fluent.getLastFailedReason(),fluent.getLastFailedRevision(),fluent.getLastFailedRevisionErrors(),fluent.getLastFailedTime(),fluent.getLastFallbackCount(),fluent.getNodeName(),fluent.getTargetRevision());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}