package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class LoggingDestinationFluent<A extends LoggingDestinationFluent<A>> extends BaseFluent<A>{
  public LoggingDestinationFluent() {
  }
  
  public LoggingDestinationFluent(LoggingDestination instance) {
    this.copyInstance(instance);
  }
  private ContainerLoggingDestinationParametersBuilder container;
  private SyslogLoggingDestinationParametersBuilder syslog;
  private String type;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(LoggingDestination instance) {
    instance = (instance != null ? instance : new LoggingDestination());
    if (instance != null) {
          this.withContainer(instance.getContainer());
          this.withSyslog(instance.getSyslog());
          this.withType(instance.getType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ContainerLoggingDestinationParameters buildContainer() {
    return this.container != null ? this.container.build() : null;
  }
  
  public A withContainer(ContainerLoggingDestinationParameters container) {
    this._visitables.remove("container");
    if (container != null) {
        this.container = new ContainerLoggingDestinationParametersBuilder(container);
        this._visitables.get("container").add(this.container);
    } else {
        this.container = null;
        this._visitables.get("container").remove(this.container);
    }
    return (A) this;
  }
  
  public boolean hasContainer() {
    return this.container != null;
  }
  
  public A withNewContainer(Integer maxLength) {
    return (A)withContainer(new ContainerLoggingDestinationParameters(maxLength));
  }
  
  public ContainerNested<A> withNewContainer() {
    return new ContainerNested(null);
  }
  
  public ContainerNested<A> withNewContainerLike(ContainerLoggingDestinationParameters item) {
    return new ContainerNested(item);
  }
  
  public ContainerNested<A> editContainer() {
    return withNewContainerLike(java.util.Optional.ofNullable(buildContainer()).orElse(null));
  }
  
  public ContainerNested<A> editOrNewContainer() {
    return withNewContainerLike(java.util.Optional.ofNullable(buildContainer()).orElse(new ContainerLoggingDestinationParametersBuilder().build()));
  }
  
  public ContainerNested<A> editOrNewContainerLike(ContainerLoggingDestinationParameters item) {
    return withNewContainerLike(java.util.Optional.ofNullable(buildContainer()).orElse(item));
  }
  
  public SyslogLoggingDestinationParameters buildSyslog() {
    return this.syslog != null ? this.syslog.build() : null;
  }
  
  public A withSyslog(SyslogLoggingDestinationParameters syslog) {
    this._visitables.remove("syslog");
    if (syslog != null) {
        this.syslog = new SyslogLoggingDestinationParametersBuilder(syslog);
        this._visitables.get("syslog").add(this.syslog);
    } else {
        this.syslog = null;
        this._visitables.get("syslog").remove(this.syslog);
    }
    return (A) this;
  }
  
  public boolean hasSyslog() {
    return this.syslog != null;
  }
  
  public A withNewSyslog(String address,String facility,Integer maxLength,Integer port) {
    return (A)withSyslog(new SyslogLoggingDestinationParameters(address, facility, maxLength, port));
  }
  
  public SyslogNested<A> withNewSyslog() {
    return new SyslogNested(null);
  }
  
  public SyslogNested<A> withNewSyslogLike(SyslogLoggingDestinationParameters item) {
    return new SyslogNested(item);
  }
  
  public SyslogNested<A> editSyslog() {
    return withNewSyslogLike(java.util.Optional.ofNullable(buildSyslog()).orElse(null));
  }
  
  public SyslogNested<A> editOrNewSyslog() {
    return withNewSyslogLike(java.util.Optional.ofNullable(buildSyslog()).orElse(new SyslogLoggingDestinationParametersBuilder().build()));
  }
  
  public SyslogNested<A> editOrNewSyslogLike(SyslogLoggingDestinationParameters item) {
    return withNewSyslogLike(java.util.Optional.ofNullable(buildSyslog()).orElse(item));
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    LoggingDestinationFluent that = (LoggingDestinationFluent) o;
    if (!java.util.Objects.equals(container, that.container)) return false;
    if (!java.util.Objects.equals(syslog, that.syslog)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(container,  syslog,  type,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (container != null) { sb.append("container:"); sb.append(container + ","); }
    if (syslog != null) { sb.append("syslog:"); sb.append(syslog + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ContainerNested<N> extends ContainerLoggingDestinationParametersFluent<ContainerNested<N>> implements Nested<N>{
    ContainerNested(ContainerLoggingDestinationParameters item) {
      this.builder = new ContainerLoggingDestinationParametersBuilder(this, item);
    }
    ContainerLoggingDestinationParametersBuilder builder;
    
    public N and() {
      return (N) LoggingDestinationFluent.this.withContainer(builder.build());
    }
    
    public N endContainer() {
      return and();
    }
    
  
  }
  public class SyslogNested<N> extends SyslogLoggingDestinationParametersFluent<SyslogNested<N>> implements Nested<N>{
    SyslogNested(SyslogLoggingDestinationParameters item) {
      this.builder = new SyslogLoggingDestinationParametersBuilder(this, item);
    }
    SyslogLoggingDestinationParametersBuilder builder;
    
    public N and() {
      return (N) LoggingDestinationFluent.this.withSyslog(builder.build());
    }
    
    public N endSyslog() {
      return and();
    }
    
  
  }

}