/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.operator.v1.DNSCache;
import io.fabric8.openshift.api.model.operator.v1.DNSCacheFluent;

public class DNSCacheBuilder
extends DNSCacheFluent<DNSCacheBuilder>
implements VisitableBuilder<DNSCache, DNSCacheBuilder> {
    DNSCacheFluent<?> fluent;
    Boolean validationEnabled;

    public DNSCacheBuilder() {
        this(false);
    }

    public DNSCacheBuilder(Boolean validationEnabled) {
        this(new DNSCache(), validationEnabled);
    }

    public DNSCacheBuilder(DNSCacheFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public DNSCacheBuilder(DNSCacheFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new DNSCache(), validationEnabled);
    }

    public DNSCacheBuilder(DNSCacheFluent<?> fluent, DNSCache instance) {
        this(fluent, instance, false);
    }

    public DNSCacheBuilder(DNSCacheFluent<?> fluent, DNSCache instance, Boolean validationEnabled) {
        this.fluent = fluent;
        DNSCache dNSCache = instance = instance != null ? instance : new DNSCache();
        if (instance != null) {
            fluent.withNegativeTTL(instance.getNegativeTTL());
            fluent.withPositiveTTL(instance.getPositiveTTL());
            fluent.withNegativeTTL(instance.getNegativeTTL());
            fluent.withPositiveTTL(instance.getPositiveTTL());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public DNSCacheBuilder(DNSCache instance) {
        this(instance, (Boolean)false);
    }

    public DNSCacheBuilder(DNSCache instance, Boolean validationEnabled) {
        this.fluent = this;
        DNSCache dNSCache = instance = instance != null ? instance : new DNSCache();
        if (instance != null) {
            this.withNegativeTTL(instance.getNegativeTTL());
            this.withPositiveTTL(instance.getPositiveTTL());
            this.withNegativeTTL(instance.getNegativeTTL());
            this.withPositiveTTL(instance.getPositiveTTL());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public DNSCache build() {
        DNSCache buildable = new DNSCache(this.fluent.getNegativeTTL(), this.fluent.getPositiveTTL());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

