/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.DNSNodePlacement;
import io.fabric8.openshift.api.model.operator.v1.DNSNodePlacementBuilder;
import io.fabric8.openshift.api.model.operator.v1.DNSNodePlacementFluentImpl;
import io.fabric8.openshift.api.model.operator.v1.DNSSpec;
import io.fabric8.openshift.api.model.operator.v1.DNSSpecFluent;
import io.fabric8.openshift.api.model.operator.v1.Server;
import io.fabric8.openshift.api.model.operator.v1.ServerBuilder;
import io.fabric8.openshift.api.model.operator.v1.ServerFluentImpl;
import io.fabric8.openshift.api.model.operator.v1.UpstreamResolvers;
import io.fabric8.openshift.api.model.operator.v1.UpstreamResolversBuilder;
import io.fabric8.openshift.api.model.operator.v1.UpstreamResolversFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DNSSpecFluentImpl<A extends DNSSpecFluent<A>>
extends BaseFluent<A>
implements DNSSpecFluent<A> {
    private String logLevel;
    private String managementState;
    private DNSNodePlacementBuilder nodePlacement;
    private String operatorLogLevel;
    private ArrayList<ServerBuilder> servers = new ArrayList();
    private UpstreamResolversBuilder upstreamResolvers;
    private Map<String, Object> additionalProperties;

    public DNSSpecFluentImpl() {
    }

    public DNSSpecFluentImpl(DNSSpec instance) {
        this.withLogLevel(instance.getLogLevel());
        this.withManagementState(instance.getManagementState());
        this.withNodePlacement(instance.getNodePlacement());
        this.withOperatorLogLevel(instance.getOperatorLogLevel());
        this.withServers(instance.getServers());
        this.withUpstreamResolvers(instance.getUpstreamResolvers());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getLogLevel() {
        return this.logLevel;
    }

    @Override
    public A withLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return (A)this;
    }

    @Override
    public Boolean hasLogLevel() {
        return this.logLevel != null;
    }

    @Override
    public String getManagementState() {
        return this.managementState;
    }

    @Override
    public A withManagementState(String managementState) {
        this.managementState = managementState;
        return (A)this;
    }

    @Override
    public Boolean hasManagementState() {
        return this.managementState != null;
    }

    @Override
    @Deprecated
    public DNSNodePlacement getNodePlacement() {
        return this.nodePlacement != null ? this.nodePlacement.build() : null;
    }

    @Override
    public DNSNodePlacement buildNodePlacement() {
        return this.nodePlacement != null ? this.nodePlacement.build() : null;
    }

    @Override
    public A withNodePlacement(DNSNodePlacement nodePlacement) {
        this._visitables.get((Object)"nodePlacement").remove(this.nodePlacement);
        if (nodePlacement != null) {
            this.nodePlacement = new DNSNodePlacementBuilder(nodePlacement);
            this._visitables.get((Object)"nodePlacement").add(this.nodePlacement);
        } else {
            this.nodePlacement = null;
            this._visitables.get((Object)"nodePlacement").remove(this.nodePlacement);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNodePlacement() {
        return this.nodePlacement != null;
    }

    @Override
    public DNSSpecFluent.NodePlacementNested<A> withNewNodePlacement() {
        return new NodePlacementNestedImpl();
    }

    @Override
    public DNSSpecFluent.NodePlacementNested<A> withNewNodePlacementLike(DNSNodePlacement item) {
        return new NodePlacementNestedImpl(item);
    }

    @Override
    public DNSSpecFluent.NodePlacementNested<A> editNodePlacement() {
        return this.withNewNodePlacementLike(this.getNodePlacement());
    }

    @Override
    public DNSSpecFluent.NodePlacementNested<A> editOrNewNodePlacement() {
        return this.withNewNodePlacementLike(this.getNodePlacement() != null ? this.getNodePlacement() : new DNSNodePlacementBuilder().build());
    }

    @Override
    public DNSSpecFluent.NodePlacementNested<A> editOrNewNodePlacementLike(DNSNodePlacement item) {
        return this.withNewNodePlacementLike(this.getNodePlacement() != null ? this.getNodePlacement() : item);
    }

    @Override
    public String getOperatorLogLevel() {
        return this.operatorLogLevel;
    }

    @Override
    public A withOperatorLogLevel(String operatorLogLevel) {
        this.operatorLogLevel = operatorLogLevel;
        return (A)this;
    }

    @Override
    public Boolean hasOperatorLogLevel() {
        return this.operatorLogLevel != null;
    }

    @Override
    public A addToServers(Integer index, Server item) {
        if (this.servers == null) {
            this.servers = new ArrayList();
        }
        ServerBuilder builder = new ServerBuilder(item);
        this._visitables.get((Object)"servers").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"servers").size(), builder);
        this.servers.add(index >= 0 ? index.intValue() : this.servers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToServers(Integer index, Server item) {
        if (this.servers == null) {
            this.servers = new ArrayList();
        }
        ServerBuilder builder = new ServerBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"servers").size()) {
            this._visitables.get((Object)"servers").add(builder);
        } else {
            this._visitables.get((Object)"servers").set(index, builder);
        }
        if (index < 0 || index >= this.servers.size()) {
            this.servers.add(builder);
        } else {
            this.servers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToServers(Server ... items) {
        if (this.servers == null) {
            this.servers = new ArrayList();
        }
        for (Server item : items) {
            ServerBuilder builder = new ServerBuilder(item);
            this._visitables.get((Object)"servers").add(builder);
            this.servers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToServers(Collection<Server> items) {
        if (this.servers == null) {
            this.servers = new ArrayList();
        }
        for (Server item : items) {
            ServerBuilder builder = new ServerBuilder(item);
            this._visitables.get((Object)"servers").add(builder);
            this.servers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromServers(Server ... items) {
        for (Server item : items) {
            ServerBuilder builder = new ServerBuilder(item);
            this._visitables.get((Object)"servers").remove(builder);
            if (this.servers == null) continue;
            this.servers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromServers(Collection<Server> items) {
        for (Server item : items) {
            ServerBuilder builder = new ServerBuilder(item);
            this._visitables.get((Object)"servers").remove(builder);
            if (this.servers == null) continue;
            this.servers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromServers(Predicate<ServerBuilder> predicate) {
        if (this.servers == null) {
            return (A)this;
        }
        Iterator<ServerBuilder> each = this.servers.iterator();
        List visitables = this._visitables.get((Object)"servers");
        while (each.hasNext()) {
            ServerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Server> getServers() {
        return this.servers != null ? DNSSpecFluentImpl.build(this.servers) : null;
    }

    @Override
    public List<Server> buildServers() {
        return this.servers != null ? DNSSpecFluentImpl.build(this.servers) : null;
    }

    @Override
    public Server buildServer(Integer index) {
        return this.servers.get(index).build();
    }

    @Override
    public Server buildFirstServer() {
        return this.servers.get(0).build();
    }

    @Override
    public Server buildLastServer() {
        return this.servers.get(this.servers.size() - 1).build();
    }

    @Override
    public Server buildMatchingServer(Predicate<ServerBuilder> predicate) {
        for (ServerBuilder item : this.servers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingServer(Predicate<ServerBuilder> predicate) {
        for (ServerBuilder item : this.servers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withServers(List<Server> servers) {
        if (this.servers != null) {
            this._visitables.get((Object)"servers").removeAll(this.servers);
        }
        if (servers != null) {
            this.servers = new ArrayList();
            for (Server item : servers) {
                this.addToServers(item);
            }
        } else {
            this.servers = null;
        }
        return (A)this;
    }

    @Override
    public A withServers(Server ... servers) {
        if (this.servers != null) {
            this.servers.clear();
        }
        if (servers != null) {
            for (Server item : servers) {
                this.addToServers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasServers() {
        return this.servers != null && !this.servers.isEmpty();
    }

    @Override
    public DNSSpecFluent.ServersNested<A> addNewServer() {
        return new ServersNestedImpl();
    }

    @Override
    public DNSSpecFluent.ServersNested<A> addNewServerLike(Server item) {
        return new ServersNestedImpl(-1, item);
    }

    @Override
    public DNSSpecFluent.ServersNested<A> setNewServerLike(Integer index, Server item) {
        return new ServersNestedImpl(index, item);
    }

    @Override
    public DNSSpecFluent.ServersNested<A> editServer(Integer index) {
        if (this.servers.size() <= index) {
            throw new RuntimeException("Can't edit servers. Index exceeds size.");
        }
        return this.setNewServerLike(index, this.buildServer(index));
    }

    @Override
    public DNSSpecFluent.ServersNested<A> editFirstServer() {
        if (this.servers.size() == 0) {
            throw new RuntimeException("Can't edit first servers. The list is empty.");
        }
        return this.setNewServerLike(0, this.buildServer(0));
    }

    @Override
    public DNSSpecFluent.ServersNested<A> editLastServer() {
        int index = this.servers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last servers. The list is empty.");
        }
        return this.setNewServerLike(index, this.buildServer(index));
    }

    @Override
    public DNSSpecFluent.ServersNested<A> editMatchingServer(Predicate<ServerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.servers.size(); ++i) {
            if (!predicate.test(this.servers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching servers. No match found.");
        }
        return this.setNewServerLike(index, this.buildServer(index));
    }

    @Override
    @Deprecated
    public UpstreamResolvers getUpstreamResolvers() {
        return this.upstreamResolvers != null ? this.upstreamResolvers.build() : null;
    }

    @Override
    public UpstreamResolvers buildUpstreamResolvers() {
        return this.upstreamResolvers != null ? this.upstreamResolvers.build() : null;
    }

    @Override
    public A withUpstreamResolvers(UpstreamResolvers upstreamResolvers) {
        this._visitables.get((Object)"upstreamResolvers").remove(this.upstreamResolvers);
        if (upstreamResolvers != null) {
            this.upstreamResolvers = new UpstreamResolversBuilder(upstreamResolvers);
            this._visitables.get((Object)"upstreamResolvers").add(this.upstreamResolvers);
        } else {
            this.upstreamResolvers = null;
            this._visitables.get((Object)"upstreamResolvers").remove(this.upstreamResolvers);
        }
        return (A)this;
    }

    @Override
    public Boolean hasUpstreamResolvers() {
        return this.upstreamResolvers != null;
    }

    @Override
    public DNSSpecFluent.UpstreamResolversNested<A> withNewUpstreamResolvers() {
        return new UpstreamResolversNestedImpl();
    }

    @Override
    public DNSSpecFluent.UpstreamResolversNested<A> withNewUpstreamResolversLike(UpstreamResolvers item) {
        return new UpstreamResolversNestedImpl(item);
    }

    @Override
    public DNSSpecFluent.UpstreamResolversNested<A> editUpstreamResolvers() {
        return this.withNewUpstreamResolversLike(this.getUpstreamResolvers());
    }

    @Override
    public DNSSpecFluent.UpstreamResolversNested<A> editOrNewUpstreamResolvers() {
        return this.withNewUpstreamResolversLike(this.getUpstreamResolvers() != null ? this.getUpstreamResolvers() : new UpstreamResolversBuilder().build());
    }

    @Override
    public DNSSpecFluent.UpstreamResolversNested<A> editOrNewUpstreamResolversLike(UpstreamResolvers item) {
        return this.withNewUpstreamResolversLike(this.getUpstreamResolvers() != null ? this.getUpstreamResolvers() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DNSSpecFluentImpl that = (DNSSpecFluentImpl)o;
        if (this.logLevel != null ? !this.logLevel.equals(that.logLevel) : that.logLevel != null) {
            return false;
        }
        if (this.managementState != null ? !this.managementState.equals(that.managementState) : that.managementState != null) {
            return false;
        }
        if (this.nodePlacement != null ? !this.nodePlacement.equals(that.nodePlacement) : that.nodePlacement != null) {
            return false;
        }
        if (this.operatorLogLevel != null ? !this.operatorLogLevel.equals(that.operatorLogLevel) : that.operatorLogLevel != null) {
            return false;
        }
        if (this.servers != null ? !this.servers.equals(that.servers) : that.servers != null) {
            return false;
        }
        if (this.upstreamResolvers != null ? !this.upstreamResolvers.equals(that.upstreamResolvers) : that.upstreamResolvers != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.logLevel, this.managementState, this.nodePlacement, this.operatorLogLevel, this.servers, this.upstreamResolvers, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.logLevel != null) {
            sb.append("logLevel:");
            sb.append(this.logLevel + ",");
        }
        if (this.managementState != null) {
            sb.append("managementState:");
            sb.append(this.managementState + ",");
        }
        if (this.nodePlacement != null) {
            sb.append("nodePlacement:");
            sb.append(this.nodePlacement + ",");
        }
        if (this.operatorLogLevel != null) {
            sb.append("operatorLogLevel:");
            sb.append(this.operatorLogLevel + ",");
        }
        if (this.servers != null && !this.servers.isEmpty()) {
            sb.append("servers:");
            sb.append(this.servers + ",");
        }
        if (this.upstreamResolvers != null) {
            sb.append("upstreamResolvers:");
            sb.append(this.upstreamResolvers + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class UpstreamResolversNestedImpl<N>
    extends UpstreamResolversFluentImpl<DNSSpecFluent.UpstreamResolversNested<N>>
    implements DNSSpecFluent.UpstreamResolversNested<N>,
    Nested<N> {
        UpstreamResolversBuilder builder;

        UpstreamResolversNestedImpl(UpstreamResolvers item) {
            this.builder = new UpstreamResolversBuilder(this, item);
        }

        UpstreamResolversNestedImpl() {
            this.builder = new UpstreamResolversBuilder(this);
        }

        @Override
        public N and() {
            return (N)DNSSpecFluentImpl.this.withUpstreamResolvers(this.builder.build());
        }

        @Override
        public N endUpstreamResolvers() {
            return this.and();
        }
    }

    class ServersNestedImpl<N>
    extends ServerFluentImpl<DNSSpecFluent.ServersNested<N>>
    implements DNSSpecFluent.ServersNested<N>,
    Nested<N> {
        ServerBuilder builder;
        Integer index;

        ServersNestedImpl(Integer index, Server item) {
            this.index = index;
            this.builder = new ServerBuilder(this, item);
        }

        ServersNestedImpl() {
            this.index = -1;
            this.builder = new ServerBuilder(this);
        }

        @Override
        public N and() {
            return (N)DNSSpecFluentImpl.this.setToServers(this.index, this.builder.build());
        }

        @Override
        public N endServer() {
            return this.and();
        }
    }

    class NodePlacementNestedImpl<N>
    extends DNSNodePlacementFluentImpl<DNSSpecFluent.NodePlacementNested<N>>
    implements DNSSpecFluent.NodePlacementNested<N>,
    Nested<N> {
        DNSNodePlacementBuilder builder;

        NodePlacementNestedImpl(DNSNodePlacement item) {
            this.builder = new DNSNodePlacementBuilder(this, item);
        }

        NodePlacementNestedImpl() {
            this.builder = new DNSNodePlacementBuilder(this);
        }

        @Override
        public N and() {
            return (N)DNSSpecFluentImpl.this.withNodePlacement(this.builder.build());
        }

        @Override
        public N endNodePlacement() {
            return this.and();
        }
    }
}

