package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class UpstreamBuilder extends UpstreamFluentImpl<UpstreamBuilder> implements VisitableBuilder<Upstream,UpstreamBuilder>{
  public UpstreamBuilder() {
    this(false);
  }
  public UpstreamBuilder(Boolean validationEnabled) {
    this(new Upstream(), validationEnabled);
  }
  public UpstreamBuilder(UpstreamFluent<?> fluent) {
    this(fluent, false);
  }
  public UpstreamBuilder(UpstreamFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Upstream(), validationEnabled);
  }
  public UpstreamBuilder(UpstreamFluent<?> fluent,Upstream instance) {
    this(fluent, instance, false);
  }
  public UpstreamBuilder(UpstreamFluent<?> fluent,Upstream instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAddress(instance.getAddress()); 
    fluent.withPort(instance.getPort()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public UpstreamBuilder(Upstream instance) {
    this(instance,false);
  }
  public UpstreamBuilder(Upstream instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAddress(instance.getAddress()); 
    this.withPort(instance.getPort()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  UpstreamFluent<?> fluent;
  Boolean validationEnabled;
  public Upstream build() {
    Upstream buildable = new Upstream(fluent.getAddress(),fluent.getPort(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}