package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KubeAPIServerSpecBuilder extends KubeAPIServerSpecFluentImpl<KubeAPIServerSpecBuilder> implements VisitableBuilder<KubeAPIServerSpec,KubeAPIServerSpecBuilder>{
  public KubeAPIServerSpecBuilder() {
    this(false);
  }
  public KubeAPIServerSpecBuilder(Boolean validationEnabled) {
    this(new KubeAPIServerSpec(), validationEnabled);
  }
  public KubeAPIServerSpecBuilder(KubeAPIServerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KubeAPIServerSpecBuilder(KubeAPIServerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KubeAPIServerSpec(), validationEnabled);
  }
  public KubeAPIServerSpecBuilder(KubeAPIServerSpecFluent<?> fluent,KubeAPIServerSpec instance) {
    this(fluent, instance, false);
  }
  public KubeAPIServerSpecBuilder(KubeAPIServerSpecFluent<?> fluent,KubeAPIServerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFailedRevisionLimit(instance.getFailedRevisionLimit()); 
    fluent.withForceRedeploymentReason(instance.getForceRedeploymentReason()); 
    fluent.withLogLevel(instance.getLogLevel()); 
    fluent.withManagementState(instance.getManagementState()); 
    fluent.withObservedConfig(instance.getObservedConfig()); 
    fluent.withOperatorLogLevel(instance.getOperatorLogLevel()); 
    fluent.withSucceededRevisionLimit(instance.getSucceededRevisionLimit()); 
    fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public KubeAPIServerSpecBuilder(KubeAPIServerSpec instance) {
    this(instance,false);
  }
  public KubeAPIServerSpecBuilder(KubeAPIServerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withFailedRevisionLimit(instance.getFailedRevisionLimit()); 
    this.withForceRedeploymentReason(instance.getForceRedeploymentReason()); 
    this.withLogLevel(instance.getLogLevel()); 
    this.withManagementState(instance.getManagementState()); 
    this.withObservedConfig(instance.getObservedConfig()); 
    this.withOperatorLogLevel(instance.getOperatorLogLevel()); 
    this.withSucceededRevisionLimit(instance.getSucceededRevisionLimit()); 
    this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  KubeAPIServerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KubeAPIServerSpec build() {
    KubeAPIServerSpec buildable = new KubeAPIServerSpec(fluent.getFailedRevisionLimit(),fluent.getForceRedeploymentReason(),fluent.getLogLevel(),fluent.getManagementState(),fluent.getObservedConfig(),fluent.getOperatorLogLevel(),fluent.getSucceededRevisionLimit(),fluent.getUnsupportedConfigOverrides());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}