package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImagePrunerListBuilder extends ImagePrunerListFluentImpl<ImagePrunerListBuilder> implements VisitableBuilder<ImagePrunerList,ImagePrunerListBuilder>{
  public ImagePrunerListBuilder() {
    this(false);
  }
  public ImagePrunerListBuilder(Boolean validationEnabled) {
    this(new ImagePrunerList(), validationEnabled);
  }
  public ImagePrunerListBuilder(ImagePrunerListFluent<?> fluent) {
    this(fluent, false);
  }
  public ImagePrunerListBuilder(ImagePrunerListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImagePrunerList(), validationEnabled);
  }
  public ImagePrunerListBuilder(ImagePrunerListFluent<?> fluent,ImagePrunerList instance) {
    this(fluent, instance, false);
  }
  public ImagePrunerListBuilder(ImagePrunerListFluent<?> fluent,ImagePrunerList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImagePrunerListBuilder(ImagePrunerList instance) {
    this(instance,false);
  }
  public ImagePrunerListBuilder(ImagePrunerList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ImagePrunerListFluent<?> fluent;
  Boolean validationEnabled;
  public ImagePrunerList build() {
    ImagePrunerList buildable = new ImagePrunerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}